/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.tableformat;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.common.HoodieTableFormat;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.TimelineFactory;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.metadata.TableMetadataFactory;
import org.apache.hudi.tableformat.TestTableMetadataFactory;
import org.apache.hudi.tableformat.TestTimelineFactory;

public class TestTableFormat
implements HoodieTableFormat {
    private static final Map<String, List<HoodieInstant>> RECORDED_INSTANTS = new ConcurrentHashMap<String, List<HoodieInstant>>();

    public static List<HoodieInstant> getRecordedInstants(String basePath) {
        return RECORDED_INSTANTS.getOrDefault(basePath, Collections.emptyList());
    }

    public static void tearDown() {
        RECORDED_INSTANTS.clear();
    }

    public String getName() {
        return "test-format";
    }

    public void commit(HoodieCommitMetadata commitMetadata, HoodieInstant completedInstant, HoodieEngineContext engineContext, HoodieTableMetaClient metaClient, FileSystemViewManager viewManager) {
        RECORDED_INSTANTS.putIfAbsent(metaClient.getBasePath().toString(), new CopyOnWriteArrayList());
        RECORDED_INSTANTS.get(metaClient.getBasePath().toString()).add(completedInstant);
    }

    public void clean(HoodieCleanMetadata cleanMetadata, HoodieInstant completedInstant, HoodieEngineContext engineContext, HoodieTableMetaClient metaClient, FileSystemViewManager viewManager) {
        RECORDED_INSTANTS.get(metaClient.getBasePath().toString()).add(completedInstant);
    }

    public void archive(Supplier<List<HoodieInstant>> archivedInstants, HoodieEngineContext engineContext, HoodieTableMetaClient metaClient, FileSystemViewManager viewManager) {
        RECORDED_INSTANTS.get(metaClient.getBasePath().toString()).removeAll((Collection)archivedInstants.get());
    }

    public void rollback(HoodieInstant instantToRollback, HoodieEngineContext engineContext, HoodieTableMetaClient metaClient, FileSystemViewManager viewManager) {
        RECORDED_INSTANTS.get(metaClient.getBasePath().toString()).remove(instantToRollback);
    }

    public void completedRollback(HoodieInstant rollbackInstant, HoodieEngineContext engineContext, HoodieTableMetaClient metaClient, FileSystemViewManager viewManager) {
        RECORDED_INSTANTS.putIfAbsent(metaClient.getBasePath().toString(), new CopyOnWriteArrayList());
        RECORDED_INSTANTS.get(metaClient.getBasePath().toString()).add(rollbackInstant);
    }

    public void savepoint(HoodieInstant savepointInstant, HoodieEngineContext engineContext, HoodieTableMetaClient metaClient, FileSystemViewManager viewManager) {
        RECORDED_INSTANTS.get(metaClient.getBasePath().toString()).add(savepointInstant);
    }

    public void restore(HoodieInstant restoreCompletedInstant, HoodieEngineContext engineContext, HoodieTableMetaClient metaClient, FileSystemViewManager viewManager) {
        RECORDED_INSTANTS.get(metaClient.getBasePath().toString()).add(restoreCompletedInstant);
    }

    public TimelineFactory getTimelineFactory() {
        return new TestTimelineFactory(null);
    }

    public TableMetadataFactory getMetadataFactory() {
        return TestTableMetadataFactory.getInstance();
    }
}

