/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.schema;

import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.parquet.schema.AvroSchemaRepair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAvroSchemaRepair {
    @Test
    public void testNoRepairNeededIdenticalSchemas() {
        Schema requestedSchema = Schema.create((Schema.Type)Schema.Type.LONG);
        Schema tableSchema = Schema.create((Schema.Type)Schema.Type.LONG);
        Schema result = AvroSchemaRepair.repairLogicalTypes((Schema)requestedSchema, (Schema)tableSchema);
        Assertions.assertSame((Object)requestedSchema, (Object)result, (String)"When schemas are identical, should return same instance");
    }

    @Test
    public void testNoRepairNeededDifferentPrimitiveTypes() {
        Schema requestedSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        Schema tableSchema = Schema.create((Schema.Type)Schema.Type.INT);
        Schema result = AvroSchemaRepair.repairLogicalTypes((Schema)requestedSchema, (Schema)tableSchema);
        Assertions.assertSame((Object)requestedSchema, (Object)result, (String)"When types differ, should return original schema");
    }

    @Test
    public void testRepairLongWithoutLogicalTypeToLocalTimestampMillis() {
        Schema requestedSchema = Schema.create((Schema.Type)Schema.Type.LONG);
        Schema tableSchema = LogicalTypes.localTimestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        Schema result = AvroSchemaRepair.repairLogicalTypes((Schema)requestedSchema, (Schema)tableSchema);
        Assertions.assertNotSame((Object)requestedSchema, (Object)result, (String)"Should create a new schema with logical type");
        Assertions.assertEquals((Object)Schema.Type.LONG, (Object)result.getType());
        Assertions.assertEquals((Object)LogicalTypes.localTimestampMillis(), (Object)result.getLogicalType());
    }

    @Test
    public void testRepairLongWithoutLogicalTypeToLocalTimestampMicros() {
        Schema requestedSchema = Schema.create((Schema.Type)Schema.Type.LONG);
        Schema tableSchema = LogicalTypes.localTimestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        Schema result = AvroSchemaRepair.repairLogicalTypes((Schema)requestedSchema, (Schema)tableSchema);
        Assertions.assertNotSame((Object)requestedSchema, (Object)result, (String)"Should create a new schema with logical type");
        Assertions.assertEquals((Object)Schema.Type.LONG, (Object)result.getType());
        Assertions.assertEquals((Object)LogicalTypes.localTimestampMicros(), (Object)result.getLogicalType());
    }

    @Test
    public void testRepairTimestampMicrosToTimestampMillis() {
        Schema requestedSchema = LogicalTypes.timestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        Schema tableSchema = LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        Schema result = AvroSchemaRepair.repairLogicalTypes((Schema)requestedSchema, (Schema)tableSchema);
        Assertions.assertNotSame((Object)requestedSchema, (Object)result, (String)"Should create a new schema with timestamp-millis");
        Assertions.assertEquals((Object)Schema.Type.LONG, (Object)result.getType());
        Assertions.assertEquals((Object)LogicalTypes.timestampMillis(), (Object)result.getLogicalType());
    }

    @Test
    public void testNoRepairNeededTimestampMillisToTimestampMicros() {
        Schema requestedSchema = LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        Schema tableSchema = LogicalTypes.timestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        Schema result = AvroSchemaRepair.repairLogicalTypes((Schema)requestedSchema, (Schema)tableSchema);
        Assertions.assertSame((Object)requestedSchema, (Object)result, (String)"Should not repair timestamp-millis to timestamp-micros");
    }

    @Test
    public void testNoRepairNeededNonLongTypes() {
        Schema requestedSchema = Schema.create((Schema.Type)Schema.Type.INT);
        Schema tableSchema = LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
        Schema result = AvroSchemaRepair.repairLogicalTypes((Schema)requestedSchema, (Schema)tableSchema);
        Assertions.assertSame((Object)requestedSchema, (Object)result, (String)"Should not repair non-LONG types");
    }

    @Test
    public void testRepairNullableSchemaLongToLocalTimestampMillis() {
        Schema requestedSchema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.LONG)});
        Schema tableSchema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), LogicalTypes.localTimestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))});
        Schema result = AvroSchemaRepair.repairLogicalTypes((Schema)requestedSchema, (Schema)tableSchema);
        Assertions.assertNotSame((Object)requestedSchema, (Object)result, (String)"Should create new nullable schema with repaired type");
        Assertions.assertEquals((Object)Schema.Type.UNION, (Object)result.getType());
        Assertions.assertEquals((int)2, (int)result.getTypes().size());
        Schema nonNullType = AvroSchemaUtils.getNonNullTypeFromUnion((Schema)result);
        Assertions.assertEquals((Object)LogicalTypes.localTimestampMillis(), (Object)nonNullType.getLogicalType());
    }

    @Test
    public void testRepairNullableSchemaTimestampMicrosToMillis() {
        Schema requestedSchema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), LogicalTypes.timestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))});
        Schema tableSchema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))});
        Schema result = AvroSchemaRepair.repairLogicalTypes((Schema)requestedSchema, (Schema)tableSchema);
        Assertions.assertNotSame((Object)requestedSchema, (Object)result, (String)"Should create new nullable schema");
        Assertions.assertEquals((Object)Schema.Type.UNION, (Object)result.getType());
        Schema nonNullType = AvroSchemaUtils.getNonNullTypeFromUnion((Schema)result);
        Assertions.assertEquals((Object)LogicalTypes.timestampMillis(), (Object)nonNullType.getLogicalType());
    }

    @Test
    public void testRepairRecordSingleField() {
        Schema requestedSchema = (Schema)SchemaBuilder.record((String)"TestRecord").fields().name("timestamp").type().longType().noDefault().endRecord();
        Schema tableSchema = (Schema)SchemaBuilder.record((String)"TestRecord").fields().name("timestamp").type(LogicalTypes.localTimestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().endRecord();
        Schema result = AvroSchemaRepair.repairLogicalTypes((Schema)requestedSchema, (Schema)tableSchema);
        Assertions.assertNotSame((Object)requestedSchema, (Object)result, (String)"Should create new record schema");
        Assertions.assertEquals((Object)Schema.Type.RECORD, (Object)result.getType());
        Assertions.assertEquals((Object)"TestRecord", (Object)result.getName());
        Assertions.assertEquals((int)1, (int)result.getFields().size());
        Schema.Field field = result.getField("timestamp");
        Assertions.assertEquals((Object)LogicalTypes.localTimestampMillis(), (Object)field.schema().getLogicalType());
    }

    @Test
    public void testRepairRecordMultipleFieldsOnlyOneNeedsRepair() {
        Schema requestedSchema = (Schema)SchemaBuilder.record((String)"TestRecord").fields().name("id").type().intType().noDefault().name("timestamp").type().longType().noDefault().name("name").type().stringType().noDefault().endRecord();
        Schema tableSchema = (Schema)SchemaBuilder.record((String)"TestRecord").fields().name("id").type().intType().noDefault().name("timestamp").type(LogicalTypes.localTimestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().name("name").type().stringType().noDefault().endRecord();
        Schema result = AvroSchemaRepair.repairLogicalTypes((Schema)requestedSchema, (Schema)tableSchema);
        Assertions.assertNotSame((Object)requestedSchema, (Object)result, (String)"Should create new record schema");
        Assertions.assertEquals((int)3, (int)result.getFields().size());
        Assertions.assertSame((Object)requestedSchema.getField("id").schema(), (Object)result.getField("id").schema());
        Assertions.assertEquals((Object)LogicalTypes.localTimestampMicros(), (Object)result.getField("timestamp").schema().getLogicalType());
        Assertions.assertSame((Object)requestedSchema.getField("name").schema(), (Object)result.getField("name").schema());
    }

    @Test
    public void testRepairRecordNestedRecord() {
        Schema nestedRequestedSchema = (Schema)SchemaBuilder.record((String)"NestedRecord").fields().name("timestamp").type().longType().noDefault().endRecord();
        Schema nestedTableSchema = (Schema)SchemaBuilder.record((String)"NestedRecord").fields().name("timestamp").type(LogicalTypes.localTimestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().endRecord();
        Schema requestedSchema = (Schema)SchemaBuilder.record((String)"OuterRecord").fields().name("id").type().intType().noDefault().name("nested").type(nestedRequestedSchema).noDefault().endRecord();
        Schema tableSchema = (Schema)SchemaBuilder.record((String)"OuterRecord").fields().name("id").type().intType().noDefault().name("nested").type(nestedTableSchema).noDefault().endRecord();
        Schema result = AvroSchemaRepair.repairLogicalTypes((Schema)requestedSchema, (Schema)tableSchema);
        Assertions.assertNotSame((Object)requestedSchema, (Object)result, (String)"Should create new schema for nested record");
        Assertions.assertSame((Object)requestedSchema.getField("id").schema(), (Object)result.getField("id").schema());
        Schema nestedResult = result.getField("nested").schema();
        Assertions.assertEquals((Object)Schema.Type.RECORD, (Object)nestedResult.getType());
        Assertions.assertEquals((Object)LogicalTypes.localTimestampMillis(), (Object)nestedResult.getField("timestamp").schema().getLogicalType());
    }

    @Test
    public void testRepairRecordNullableNestedField() {
        Schema requestedSchema = (Schema)((SchemaBuilder.FieldAssembler)SchemaBuilder.record((String)"TestRecord").fields().name("timestamp").type().optional().longType()).endRecord();
        Schema tableSchema = (Schema)((SchemaBuilder.FieldAssembler)SchemaBuilder.record((String)"TestRecord").fields().name("timestamp").type().optional().type(LogicalTypes.localTimestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG)))).endRecord();
        Schema result = AvroSchemaRepair.repairLogicalTypes((Schema)requestedSchema, (Schema)tableSchema);
        Assertions.assertNotSame((Object)requestedSchema, (Object)result, (String)"Should create new schema");
        Schema fieldSchema = result.getField("timestamp").schema();
        Assertions.assertEquals((Object)Schema.Type.UNION, (Object)fieldSchema.getType());
        Schema nonNullType = AvroSchemaUtils.getNonNullTypeFromUnion((Schema)fieldSchema);
        Assertions.assertEquals((Object)LogicalTypes.localTimestampMillis(), (Object)nonNullType.getLogicalType());
    }

    @Test
    public void testRepairArrayElementNeedsRepair() {
        Schema requestedSchema = Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.LONG));
        Schema tableSchema = Schema.createArray((Schema)LogicalTypes.localTimestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG)));
        Schema result = AvroSchemaRepair.repairLogicalTypes((Schema)requestedSchema, (Schema)tableSchema);
        Assertions.assertNotSame((Object)requestedSchema, (Object)result, (String)"Should create new array schema");
        Assertions.assertEquals((Object)Schema.Type.ARRAY, (Object)result.getType());
        Assertions.assertEquals((Object)LogicalTypes.localTimestampMillis(), (Object)result.getElementType().getLogicalType());
    }

    @Test
    public void testRepairArrayNoRepairNeeded() {
        Schema elementSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        Schema requestedSchema = Schema.createArray((Schema)elementSchema);
        Schema tableSchema = Schema.createArray((Schema)elementSchema);
        Schema result = AvroSchemaRepair.repairLogicalTypes((Schema)requestedSchema, (Schema)tableSchema);
        Assertions.assertSame((Object)requestedSchema, (Object)result, (String)"Should return same array when no repair needed");
    }

    @Test
    public void testRepairArrayNullableElements() {
        Schema requestedSchema = Schema.createArray((Schema)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.LONG)}));
        Schema tableSchema = Schema.createArray((Schema)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), LogicalTypes.localTimestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))}));
        Schema result = AvroSchemaRepair.repairLogicalTypes((Schema)requestedSchema, (Schema)tableSchema);
        Assertions.assertNotSame((Object)requestedSchema, (Object)result, (String)"Should create new array schema");
        Schema elementSchema = result.getElementType();
        Assertions.assertEquals((Object)Schema.Type.UNION, (Object)elementSchema.getType());
        Schema nonNullType = AvroSchemaUtils.getNonNullTypeFromUnion((Schema)elementSchema);
        Assertions.assertEquals((Object)LogicalTypes.localTimestampMicros(), (Object)nonNullType.getLogicalType());
    }

    @Test
    public void testRepairMapValueNeedsRepair() {
        Schema requestedSchema = Schema.createMap((Schema)Schema.create((Schema.Type)Schema.Type.LONG));
        Schema tableSchema = Schema.createMap((Schema)LogicalTypes.localTimestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG)));
        Schema result = AvroSchemaRepair.repairLogicalTypes((Schema)requestedSchema, (Schema)tableSchema);
        Assertions.assertNotSame((Object)requestedSchema, (Object)result, (String)"Should create new map schema");
        Assertions.assertEquals((Object)Schema.Type.MAP, (Object)result.getType());
        Assertions.assertEquals((Object)LogicalTypes.localTimestampMillis(), (Object)result.getValueType().getLogicalType());
    }

    @Test
    public void testRepairMapNoRepairNeeded() {
        Schema valueSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        Schema requestedSchema = Schema.createMap((Schema)valueSchema);
        Schema tableSchema = Schema.createMap((Schema)valueSchema);
        Schema result = AvroSchemaRepair.repairLogicalTypes((Schema)requestedSchema, (Schema)tableSchema);
        Assertions.assertSame((Object)requestedSchema, (Object)result, (String)"Should return same map when no repair needed");
    }

    @Test
    public void testRepairMapNullableValues() {
        Schema requestedSchema = Schema.createMap((Schema)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.LONG)}));
        Schema tableSchema = Schema.createMap((Schema)Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), LogicalTypes.localTimestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))}));
        Schema result = AvroSchemaRepair.repairLogicalTypes((Schema)requestedSchema, (Schema)tableSchema);
        Assertions.assertNotSame((Object)requestedSchema, (Object)result, (String)"Should create new map schema");
        Schema valueSchema = result.getValueType();
        Assertions.assertEquals((Object)Schema.Type.UNION, (Object)valueSchema.getType());
        Schema nonNullType = AvroSchemaUtils.getNonNullTypeFromUnion((Schema)valueSchema);
        Assertions.assertEquals((Object)LogicalTypes.localTimestampMillis(), (Object)nonNullType.getLogicalType());
    }

    @Test
    public void testComplexSchemaMultiLevelNesting() {
        Schema innerRecordRequested = (Schema)SchemaBuilder.record((String)"Inner").fields().name("timestamp").type().longType().noDefault().endRecord();
        Schema innerRecordTable = (Schema)SchemaBuilder.record((String)"Inner").fields().name("timestamp").type(LogicalTypes.localTimestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().endRecord();
        Schema requestedSchema = (Schema)((SchemaBuilder.MapDefault)((SchemaBuilder.ArrayDefault)SchemaBuilder.record((String)"Outer").fields().name("id").type().intType().noDefault().name("records").type().array().items(innerRecordRequested)).noDefault().name("mapping").type().map().values(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().endRecord();
        Schema tableSchema = (Schema)((SchemaBuilder.MapDefault)((SchemaBuilder.ArrayDefault)SchemaBuilder.record((String)"Outer").fields().name("id").type().intType().noDefault().name("records").type().array().items(innerRecordTable)).noDefault().name("mapping").type().map().values(LogicalTypes.localTimestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG)))).noDefault().endRecord();
        Schema result = AvroSchemaRepair.repairLogicalTypes((Schema)requestedSchema, (Schema)tableSchema);
        Assertions.assertNotSame((Object)requestedSchema, (Object)result, (String)"Should create new complex schema");
        Assertions.assertSame((Object)requestedSchema.getField("id").schema(), (Object)result.getField("id").schema());
        Schema arrayElementSchema = result.getField("records").schema().getElementType();
        Assertions.assertEquals((Object)LogicalTypes.localTimestampMillis(), (Object)arrayElementSchema.getField("timestamp").schema().getLogicalType());
        Schema mapValueSchema = result.getField("mapping").schema().getValueType();
        Assertions.assertEquals((Object)LogicalTypes.localTimestampMicros(), (Object)mapValueSchema.getLogicalType());
    }

    @Test
    public void testRepairRecordMissingFieldInTableSchema() {
        Schema requestedSchema = (Schema)SchemaBuilder.record((String)"TestRecord").fields().name("id").type().intType().noDefault().name("newField").type().longType().noDefault().endRecord();
        Schema tableSchema = (Schema)SchemaBuilder.record((String)"TestRecord").fields().name("id").type().intType().noDefault().endRecord();
        Schema result = AvroSchemaRepair.repairLogicalTypes((Schema)requestedSchema, (Schema)tableSchema);
        Assertions.assertSame((Object)requestedSchema, (Object)result, (String)"Should return original when field missing in table schema");
    }

    @Test
    public void testRepairRecordMultipleFieldsMissingInTableSchema() {
        Schema requestedSchema = (Schema)SchemaBuilder.record((String)"TestRecord").fields().name("id").type().intType().noDefault().name("newField1").type().longType().noDefault().name("name").type().stringType().noDefault().name("newField2").type().longType().noDefault().endRecord();
        Schema tableSchema = (Schema)SchemaBuilder.record((String)"TestRecord").fields().name("id").type().intType().noDefault().name("name").type().stringType().noDefault().endRecord();
        Schema result = AvroSchemaRepair.repairLogicalTypes((Schema)requestedSchema, (Schema)tableSchema);
        Assertions.assertSame((Object)requestedSchema, (Object)result, (String)"Should return original when multiple fields missing in table schema");
    }

    @Test
    public void testRepairRecordMixedMissingAndRepairableFields() {
        Schema requestedSchema = (Schema)SchemaBuilder.record((String)"TestRecord").fields().name("id").type().intType().noDefault().name("timestamp").type().longType().noDefault().name("newField").type().longType().noDefault().name("name").type().stringType().noDefault().endRecord();
        Schema tableSchema = (Schema)SchemaBuilder.record((String)"TestRecord").fields().name("id").type().intType().noDefault().name("timestamp").type(LogicalTypes.localTimestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().name("name").type().stringType().noDefault().endRecord();
        Schema result = AvroSchemaRepair.repairLogicalTypes((Schema)requestedSchema, (Schema)tableSchema);
        Assertions.assertNotSame((Object)requestedSchema, (Object)result, (String)"Should create new schema");
        Assertions.assertEquals((int)4, (int)result.getFields().size());
        Assertions.assertSame((Object)requestedSchema.getField("id").schema(), (Object)result.getField("id").schema());
        Assertions.assertEquals((Object)LogicalTypes.localTimestampMillis(), (Object)result.getField("timestamp").schema().getLogicalType());
        Assertions.assertSame((Object)requestedSchema.getField("newField").schema(), (Object)result.getField("newField").schema());
        Assertions.assertSame((Object)requestedSchema.getField("name").schema(), (Object)result.getField("name").schema());
    }

    @Test
    public void testRepairNestedRecordFieldMissingInTableSchema() {
        Schema nestedRequestedSchema = (Schema)SchemaBuilder.record((String)"NestedRecord").fields().name("timestamp").type().longType().noDefault().name("extraField").type().stringType().noDefault().endRecord();
        Schema nestedTableSchema = (Schema)SchemaBuilder.record((String)"NestedRecord").fields().name("timestamp").type(LogicalTypes.localTimestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().endRecord();
        Schema requestedSchema = (Schema)SchemaBuilder.record((String)"OuterRecord").fields().name("id").type().intType().noDefault().name("nested").type(nestedRequestedSchema).noDefault().endRecord();
        Schema tableSchema = (Schema)SchemaBuilder.record((String)"OuterRecord").fields().name("id").type().intType().noDefault().name("nested").type(nestedTableSchema).noDefault().endRecord();
        Schema result = AvroSchemaRepair.repairLogicalTypes((Schema)requestedSchema, (Schema)tableSchema);
        Assertions.assertNotSame((Object)requestedSchema, (Object)result, (String)"Should create new schema");
        Assertions.assertSame((Object)requestedSchema.getField("id").schema(), (Object)result.getField("id").schema());
        Schema nestedResult = result.getField("nested").schema();
        Assertions.assertEquals((Object)Schema.Type.RECORD, (Object)nestedResult.getType());
        Assertions.assertEquals((int)2, (int)nestedResult.getFields().size());
        Assertions.assertEquals((Object)LogicalTypes.localTimestampMillis(), (Object)nestedResult.getField("timestamp").schema().getLogicalType());
        Assertions.assertSame((Object)nestedRequestedSchema.getField("extraField").schema(), (Object)nestedResult.getField("extraField").schema());
    }

    @Test
    public void testRepairRecordWholeNestedRecordMissingInTableSchema() {
        Schema nestedRequestedSchema = (Schema)SchemaBuilder.record((String)"NestedRecord").fields().name("timestamp").type().longType().noDefault().endRecord();
        Schema requestedSchema = (Schema)SchemaBuilder.record((String)"OuterRecord").fields().name("id").type().intType().noDefault().name("newNested").type(nestedRequestedSchema).noDefault().endRecord();
        Schema tableSchema = (Schema)SchemaBuilder.record((String)"OuterRecord").fields().name("id").type().intType().noDefault().endRecord();
        Schema result = AvroSchemaRepair.repairLogicalTypes((Schema)requestedSchema, (Schema)tableSchema);
        Assertions.assertSame((Object)requestedSchema, (Object)result, (String)"Should return original when nested field missing in table schema");
    }

    @Test
    public void testRepairRecordPreservesFieldMetadata() {
        Schema requestedSchema = (Schema)((SchemaBuilder.FieldBuilder)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"TestRecord").doc("Test documentation")).fields().name("timestamp").doc("Timestamp field")).type().longType().noDefault().endRecord();
        Schema tableSchema = (Schema)SchemaBuilder.record((String)"TestRecord").fields().name("timestamp").type(LogicalTypes.localTimestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().endRecord();
        Schema result = AvroSchemaRepair.repairLogicalTypes((Schema)requestedSchema, (Schema)tableSchema);
        Assertions.assertNotSame((Object)requestedSchema, (Object)result);
        Assertions.assertEquals((Object)"TestRecord", (Object)result.getName());
        Assertions.assertEquals((Object)"Test documentation", (Object)result.getDoc());
        Assertions.assertEquals((Object)"Timestamp field", (Object)result.getField("timestamp").doc());
    }

    @Test
    public void testEdgeCaseEmptyRecord() {
        Schema requestedSchema = (Schema)SchemaBuilder.record((String)"EmptyRecord").fields().endRecord();
        Schema tableSchema = (Schema)SchemaBuilder.record((String)"EmptyRecord").fields().endRecord();
        Schema result = AvroSchemaRepair.repairLogicalTypes((Schema)requestedSchema, (Schema)tableSchema);
        Assertions.assertSame((Object)requestedSchema, (Object)result, (String)"Empty records should return same instance");
    }

    @Test
    public void testRepairRecordFirstFieldChanged() {
        Schema requestedSchema = (Schema)SchemaBuilder.record((String)"TestRecord").fields().name("timestamp1").type().longType().noDefault().name("timestamp2").type().longType().noDefault().endRecord();
        Schema tableSchema = (Schema)SchemaBuilder.record((String)"TestRecord").fields().name("timestamp1").type(LogicalTypes.localTimestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().name("timestamp2").type(LogicalTypes.localTimestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().endRecord();
        Schema result = AvroSchemaRepair.repairLogicalTypes((Schema)requestedSchema, (Schema)tableSchema);
        Assertions.assertNotSame((Object)requestedSchema, (Object)result);
        Assertions.assertEquals((Object)LogicalTypes.localTimestampMillis(), (Object)result.getField("timestamp1").schema().getLogicalType());
        Assertions.assertEquals((Object)LogicalTypes.localTimestampMicros(), (Object)result.getField("timestamp2").schema().getLogicalType());
    }

    @Test
    public void testRepairRecordLastFieldChanged() {
        Schema requestedSchema = (Schema)SchemaBuilder.record((String)"TestRecord").fields().name("id").type().intType().noDefault().name("name").type().stringType().noDefault().name("timestamp").type().longType().noDefault().endRecord();
        Schema tableSchema = (Schema)SchemaBuilder.record((String)"TestRecord").fields().name("id").type().intType().noDefault().name("name").type().stringType().noDefault().name("timestamp").type(LogicalTypes.localTimestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().endRecord();
        Schema result = AvroSchemaRepair.repairLogicalTypes((Schema)requestedSchema, (Schema)tableSchema);
        Assertions.assertNotSame((Object)requestedSchema, (Object)result);
        Assertions.assertSame((Object)requestedSchema.getField("id").schema(), (Object)result.getField("id").schema());
        Assertions.assertSame((Object)requestedSchema.getField("name").schema(), (Object)result.getField("name").schema());
        Assertions.assertEquals((Object)LogicalTypes.localTimestampMillis(), (Object)result.getField("timestamp").schema().getLogicalType());
    }

    @Test
    public void testHasTimestampMillisFieldPrimitiveLongWithTimestampMillis() {
        Schema schema = LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        Assertions.assertTrue((boolean)AvroSchemaRepair.hasTimestampMillisField((Schema)schema), (String)"Should return true for LONG with timestamp-millis logical type");
    }

    @Test
    public void testHasTimestampMillisFieldPrimitiveLongWithoutLogicalType() {
        Schema schema = Schema.create((Schema.Type)Schema.Type.LONG);
        Assertions.assertFalse((boolean)AvroSchemaRepair.hasTimestampMillisField((Schema)schema), (String)"Should return false for LONG without logical type");
    }

    @Test
    public void testHasTimestampMillisFieldPrimitiveLongWithTimestampMicros() {
        Schema schema = LogicalTypes.timestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        Assertions.assertFalse((boolean)AvroSchemaRepair.hasTimestampMillisField((Schema)schema), (String)"Should return false for LONG with timestamp-micros logical type");
    }

    @Test
    public void testHasTimestampMillisFieldPrimitiveLongWithLocalTimestampMillis() {
        Schema schema = LogicalTypes.localTimestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        Assertions.assertTrue((boolean)AvroSchemaRepair.hasTimestampMillisField((Schema)schema), (String)"Should return true for LONG with local-timestamp-millis logical type");
    }

    @Test
    public void testHasTimestampMillisFieldPrimitiveLongWithLocalTimestampMicros() {
        Schema schema = LogicalTypes.localTimestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        Assertions.assertFalse((boolean)AvroSchemaRepair.hasTimestampMillisField((Schema)schema), (String)"Should return false for LONG with local-timestamp-micros logical type");
    }

    @Test
    public void testHasTimestampMillisFieldOtherPrimitiveTypes() {
        Assertions.assertFalse((boolean)AvroSchemaRepair.hasTimestampMillisField((Schema)Schema.create((Schema.Type)Schema.Type.STRING)), (String)"Should return false for STRING type");
        Assertions.assertFalse((boolean)AvroSchemaRepair.hasTimestampMillisField((Schema)Schema.create((Schema.Type)Schema.Type.INT)), (String)"Should return false for INT type");
        Assertions.assertFalse((boolean)AvroSchemaRepair.hasTimestampMillisField((Schema)Schema.create((Schema.Type)Schema.Type.FLOAT)), (String)"Should return false for FLOAT type");
        Assertions.assertFalse((boolean)AvroSchemaRepair.hasTimestampMillisField((Schema)Schema.create((Schema.Type)Schema.Type.DOUBLE)), (String)"Should return false for DOUBLE type");
        Assertions.assertFalse((boolean)AvroSchemaRepair.hasTimestampMillisField((Schema)Schema.create((Schema.Type)Schema.Type.BOOLEAN)), (String)"Should return false for BOOLEAN type");
    }

    @Test
    public void testHasTimestampMillisFieldRecordWithTimestampMillis() {
        Schema schema = (Schema)SchemaBuilder.record((String)"TestRecord").fields().name("id").type().intType().noDefault().name("timestamp").type(LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().name("name").type().stringType().noDefault().endRecord();
        Assertions.assertTrue((boolean)AvroSchemaRepair.hasTimestampMillisField((Schema)schema), (String)"Should return true for record containing timestamp-millis field");
    }

    @Test
    public void testHasTimestampMillisFieldRecordWithoutTimestampMillis() {
        Schema schema = (Schema)SchemaBuilder.record((String)"TestRecord").fields().name("id").type().intType().noDefault().name("timestamp").type(LogicalTypes.timestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().name("name").type().stringType().noDefault().endRecord();
        Assertions.assertFalse((boolean)AvroSchemaRepair.hasTimestampMillisField((Schema)schema), (String)"Should return false for record without timestamp-millis field");
    }

    @Test
    public void testHasTimestampMillisFieldRecordEmpty() {
        Schema schema = (Schema)SchemaBuilder.record((String)"EmptyRecord").fields().endRecord();
        Assertions.assertFalse((boolean)AvroSchemaRepair.hasTimestampMillisField((Schema)schema), (String)"Should return false for empty record");
    }

    @Test
    public void testHasTimestampMillisFieldNestedRecord() {
        Schema innerSchema = (Schema)SchemaBuilder.record((String)"InnerRecord").fields().name("timestamp").type(LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().endRecord();
        Schema outerSchema = (Schema)SchemaBuilder.record((String)"OuterRecord").fields().name("id").type().intType().noDefault().name("inner").type(innerSchema).noDefault().endRecord();
        Assertions.assertTrue((boolean)AvroSchemaRepair.hasTimestampMillisField((Schema)outerSchema), (String)"Should return true for nested record containing timestamp-millis field");
    }

    @Test
    public void testHasTimestampMillisFieldDeeplyNestedRecord() {
        Schema level3 = (Schema)SchemaBuilder.record((String)"Level3").fields().name("timestamp").type(LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().endRecord();
        Schema level2 = (Schema)SchemaBuilder.record((String)"Level2").fields().name("data").type(level3).noDefault().endRecord();
        Schema level1 = (Schema)SchemaBuilder.record((String)"Level1").fields().name("nested").type(level2).noDefault().endRecord();
        Assertions.assertTrue((boolean)AvroSchemaRepair.hasTimestampMillisField((Schema)level1), (String)"Should return true for deeply nested record containing timestamp-millis field");
    }

    @Test
    public void testHasTimestampMillisFieldArrayWithTimestampMillis() {
        Schema schema = Schema.createArray((Schema)LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG)));
        Assertions.assertTrue((boolean)AvroSchemaRepair.hasTimestampMillisField((Schema)schema), (String)"Should return true for array with timestamp-millis elements");
    }

    @Test
    public void testHasTimestampMillisFieldArrayWithoutTimestampMillis() {
        Schema schema = Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.STRING));
        Assertions.assertFalse((boolean)AvroSchemaRepair.hasTimestampMillisField((Schema)schema), (String)"Should return false for array without timestamp-millis elements");
    }

    @Test
    public void testHasTimestampMillisFieldArrayOfRecordsWithTimestampMillis() {
        Schema elementSchema = (Schema)SchemaBuilder.record((String)"Element").fields().name("timestamp").type(LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().endRecord();
        Schema schema = Schema.createArray((Schema)elementSchema);
        Assertions.assertTrue((boolean)AvroSchemaRepair.hasTimestampMillisField((Schema)schema), (String)"Should return true for array of records containing timestamp-millis field");
    }

    @Test
    public void testHasTimestampMillisFieldMapWithTimestampMillis() {
        Schema schema = Schema.createMap((Schema)LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG)));
        Assertions.assertTrue((boolean)AvroSchemaRepair.hasTimestampMillisField((Schema)schema), (String)"Should return true for map with timestamp-millis values");
    }

    @Test
    public void testHasTimestampMillisFieldMapWithoutTimestampMillis() {
        Schema schema = Schema.createMap((Schema)Schema.create((Schema.Type)Schema.Type.STRING));
        Assertions.assertFalse((boolean)AvroSchemaRepair.hasTimestampMillisField((Schema)schema), (String)"Should return false for map without timestamp-millis values");
    }

    @Test
    public void testHasTimestampMillisFieldMapOfRecordsWithTimestampMillis() {
        Schema valueSchema = (Schema)SchemaBuilder.record((String)"Value").fields().name("timestamp").type(LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().endRecord();
        Schema schema = Schema.createMap((Schema)valueSchema);
        Assertions.assertTrue((boolean)AvroSchemaRepair.hasTimestampMillisField((Schema)schema), (String)"Should return true for map of records containing timestamp-millis field");
    }

    @Test
    public void testHasTimestampMillisFieldUnionWithTimestampMillis() {
        Schema schema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))});
        Assertions.assertTrue((boolean)AvroSchemaRepair.hasTimestampMillisField((Schema)schema), (String)"Should return true for nullable union with timestamp-millis");
    }

    @Test
    public void testHasTimestampMillisFieldUnionWithoutTimestampMillis() {
        Schema schema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.LONG)});
        Assertions.assertFalse((boolean)AvroSchemaRepair.hasTimestampMillisField((Schema)schema), (String)"Should return false for nullable union without timestamp-millis");
    }

    @Test
    public void testHasTimestampMillisFieldUnionWithRecordContainingTimestampMillis() {
        Schema recordSchema = (Schema)SchemaBuilder.record((String)"Record").fields().name("timestamp").type(LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().endRecord();
        Schema schema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), recordSchema});
        Assertions.assertTrue((boolean)AvroSchemaRepair.hasTimestampMillisField((Schema)schema), (String)"Should return true for nullable union with record containing timestamp-millis");
    }

    @Test
    public void testHasTimestampMillisFieldComplexNestedStructure() {
        Schema innerRecordSchema = (Schema)SchemaBuilder.record((String)"InnerRecord").fields().name("timestamp").type(LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().endRecord();
        Schema complexSchema = (Schema)((SchemaBuilder.MapDefault)((SchemaBuilder.ArrayDefault)SchemaBuilder.record((String)"ComplexRecord").fields().name("id").type().intType().noDefault().name("arrayOfRecords").type().array().items(innerRecordSchema)).noDefault().name("mapOfStrings").type().map().values().stringType()).noDefault().endRecord();
        Assertions.assertTrue((boolean)AvroSchemaRepair.hasTimestampMillisField((Schema)complexSchema), (String)"Should return true for complex nested structure containing timestamp-millis field");
    }

    @Test
    public void testHasTimestampMillisFieldComplexStructureWithoutTimestampMillis() {
        Schema innerRecordSchema = (Schema)SchemaBuilder.record((String)"InnerRecord").fields().name("value").type().longType().noDefault().endRecord();
        Schema complexSchema = (Schema)((SchemaBuilder.MapDefault)((SchemaBuilder.ArrayDefault)SchemaBuilder.record((String)"ComplexRecord").fields().name("id").type().intType().noDefault().name("arrayOfRecords").type().array().items(innerRecordSchema)).noDefault().name("mapOfLongs").type().map().values(LogicalTypes.timestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG)))).noDefault().endRecord();
        Assertions.assertFalse((boolean)AvroSchemaRepair.hasTimestampMillisField((Schema)complexSchema), (String)"Should return false for complex structure without timestamp-millis field");
    }

    @Test
    public void testHasTimestampMillisFieldFirstFieldMatches() {
        Schema schema = (Schema)SchemaBuilder.record((String)"TestRecord").fields().name("timestamp").type(LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().name("id").type().intType().noDefault().name("name").type().stringType().noDefault().endRecord();
        Assertions.assertTrue((boolean)AvroSchemaRepair.hasTimestampMillisField((Schema)schema), (String)"Should return true when first field is timestamp-millis");
    }

    @Test
    public void testHasTimestampMillisFieldLastFieldMatches() {
        Schema schema = (Schema)SchemaBuilder.record((String)"TestRecord").fields().name("id").type().intType().noDefault().name("name").type().stringType().noDefault().name("timestamp").type(LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().endRecord();
        Assertions.assertTrue((boolean)AvroSchemaRepair.hasTimestampMillisField((Schema)schema), (String)"Should return true when last field is timestamp-millis");
    }

    @Test
    public void testHasTimestampMillisFieldMultipleTimestampMillisFields() {
        Schema schema = (Schema)SchemaBuilder.record((String)"TestRecord").fields().name("createdAt").type(LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().name("id").type().intType().noDefault().name("updatedAt").type(LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))).noDefault().endRecord();
        Assertions.assertTrue((boolean)AvroSchemaRepair.hasTimestampMillisField((Schema)schema), (String)"Should return true when multiple timestamp-millis fields exist");
    }

    @Test
    public void testHasTimestampMillisFieldNullableFieldWithTimestampMillis() {
        Schema schema = (Schema)((SchemaBuilder.FieldAssembler)SchemaBuilder.record((String)"TestRecord").fields().name("id").type().intType().noDefault().name("timestamp").type().optional().type(LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG)))).endRecord();
        Assertions.assertTrue((boolean)AvroSchemaRepair.hasTimestampMillisField((Schema)schema), (String)"Should return true for nullable field with timestamp-millis");
    }

    @Test
    public void testHasTimestampMillisFieldArrayOfNullableTimestampMillis() {
        Schema elementSchema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))});
        Schema schema = Schema.createArray((Schema)elementSchema);
        Assertions.assertTrue((boolean)AvroSchemaRepair.hasTimestampMillisField((Schema)schema), (String)"Should return true for array of nullable timestamp-millis elements");
    }

    @Test
    public void testHasTimestampMillisFieldMapOfNullableTimestampMillis() {
        Schema valueSchema = Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG))});
        Schema schema = Schema.createMap((Schema)valueSchema);
        Assertions.assertTrue((boolean)AvroSchemaRepair.hasTimestampMillisField((Schema)schema), (String)"Should return true for map of nullable timestamp-millis values");
    }
}

