/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.function.UnaryOperator;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.util.Utf8;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.engine.RecordContext;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieEmptyRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.util.AvroJavaTypeConverter;
import org.apache.hudi.common.util.HoodieRecordUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;

public class AvroRecordContext
extends RecordContext<IndexedRecord> {
    private static final AvroRecordContext FIELD_ACCESSOR_INSTANCE = new AvroRecordContext();
    private final String payloadClass;

    public static AvroRecordContext getFieldAccessorInstance() {
        return FIELD_ACCESSOR_INSTANCE;
    }

    public AvroRecordContext(HoodieTableConfig tableConfig, String payloadClass) {
        super(tableConfig, new AvroJavaTypeConverter());
        this.payloadClass = payloadClass;
    }

    public AvroRecordContext() {
        super(new AvroJavaTypeConverter());
        this.payloadClass = null;
    }

    public static Object getFieldValueFromIndexedRecord(IndexedRecord record, String fieldName) {
        Schema currentSchema = record.getSchema();
        IndexedRecord currentRecord = record;
        String[] path = fieldName.split("\\.");
        for (int i = 0; i < path.length; ++i) {
            Schema.Field field;
            if (currentSchema.isUnion()) {
                currentSchema = AvroSchemaUtils.getNonNullTypeFromUnion(currentSchema);
            }
            if ((field = currentSchema.getField(path[i])) == null) {
                return null;
            }
            Object value = currentRecord.get(field.pos());
            if (i == path.length - 1) {
                return value;
            }
            currentSchema = field.schema();
            currentRecord = (IndexedRecord)value;
        }
        return null;
    }

    @Override
    public Object getValue(IndexedRecord record, Schema schema, String fieldName) {
        return AvroRecordContext.getFieldValueFromIndexedRecord(record, fieldName);
    }

    @Override
    public String getMetaFieldValue(IndexedRecord record, int pos) {
        return record.get(pos).toString();
    }

    @Override
    public HoodieRecord constructHoodieRecord(BufferedRecord<IndexedRecord> bufferedRecord, String partitionPath) {
        HoodieKey hoodieKey = new HoodieKey(bufferedRecord.getRecordKey(), partitionPath);
        if (bufferedRecord.getRecord() == null && bufferedRecord.isDelete()) {
            return HoodieRecordUtils.generateEmptyAvroRecord(hoodieKey, bufferedRecord.getOrderingValue(), this.payloadClass, bufferedRecord.getHoodieOperation());
        }
        return HoodieRecordUtils.createHoodieRecord((GenericRecord)bufferedRecord.getRecord(), bufferedRecord.getOrderingValue(), hoodieKey, this.payloadClass, bufferedRecord.getHoodieOperation(), (Option<HoodieRecordLocation>)Option.empty(), false, bufferedRecord.isDelete());
    }

    @Override
    public HoodieRecord<IndexedRecord> constructFinalHoodieRecord(BufferedRecord<IndexedRecord> bufferedRecord) {
        HoodieKey hoodieKey = new HoodieKey(bufferedRecord.getRecordKey(), this.partitionPath);
        if (bufferedRecord.isDelete()) {
            return new HoodieEmptyRecord<IndexedRecord>(hoodieKey, bufferedRecord.getHoodieOperation(), bufferedRecord.getOrderingValue(), HoodieRecord.HoodieRecordType.AVRO);
        }
        return new HoodieAvroIndexedRecord(hoodieKey, bufferedRecord.getRecord(), bufferedRecord.getOrderingValue(), bufferedRecord.getHoodieOperation(), bufferedRecord.isDelete());
    }

    @Override
    public IndexedRecord extractDataFromRecord(HoodieRecord record, Schema schema, Properties properties) {
        try {
            return (IndexedRecord)record.toIndexedRecord(schema, properties).map(HoodieAvroIndexedRecord::getData).orElse(null);
        }
        catch (IOException e) {
            throw new HoodieException("Failed to extract data from record: " + record, (Throwable)e);
        }
    }

    @Override
    public IndexedRecord constructEngineRecord(Schema recordSchema, Object[] fieldValues) {
        GenericData.Record record = new GenericData.Record(recordSchema);
        for (int i = 0; i < fieldValues.length; ++i) {
            record.put(i, fieldValues[i]);
        }
        return record;
    }

    @Override
    public IndexedRecord mergeWithEngineRecord(Schema schema, Map<Integer, Object> updateValues, BufferedRecord<IndexedRecord> baseRecord) {
        IndexedRecord engineRecord = baseRecord.getRecord();
        for (Map.Entry<Integer, Object> value : updateValues.entrySet()) {
            engineRecord.put(value.getKey().intValue(), value.getValue());
        }
        return engineRecord;
    }

    @Override
    public IndexedRecord convertAvroRecord(IndexedRecord record) {
        return record;
    }

    @Override
    public GenericRecord convertToAvroRecord(IndexedRecord record, Schema schema) {
        return (GenericRecord)record;
    }

    @Override
    public IndexedRecord getDeleteRow(String recordKey) {
        throw new UnsupportedOperationException("Not supported for " + this.getClass().getSimpleName());
    }

    @Override
    public IndexedRecord seal(IndexedRecord record) {
        return record;
    }

    @Override
    public IndexedRecord toBinaryRow(Schema avroSchema, IndexedRecord record) {
        return record;
    }

    @Override
    public UnaryOperator<IndexedRecord> projectRecord(Schema from, Schema to, Map<String, String> renamedColumns) {
        return record -> HoodieAvroUtils.rewriteRecordWithNewSchema(record, to, renamedColumns);
    }

    @Override
    public Comparable convertValueToEngineType(Comparable value) {
        if (value instanceof String) {
            return new Utf8((String)((Object)value));
        }
        return value;
    }
}

