/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import java.io.IOException;
import java.util.function.Function;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.serialization.RecordSerializer;
import org.apache.hudi.exception.HoodieException;

public class AvroRecordSerializer
implements RecordSerializer<IndexedRecord> {
    private final Function<Integer, Schema> schemaFunc;

    public AvroRecordSerializer(Function<Integer, Schema> schemaFunc) {
        this.schemaFunc = schemaFunc;
    }

    @Override
    public byte[] serialize(IndexedRecord input) {
        return HoodieAvroUtils.avroToBytes(input);
    }

    @Override
    public IndexedRecord deserialize(byte[] bytes, int schemaId) {
        try {
            return HoodieAvroUtils.bytesToAvro(bytes, this.schemaFunc.apply(schemaId));
        }
        catch (IOException e) {
            throw new HoodieException("Failed to deserialize Avro record bytes.", (Throwable)e);
        }
    }
}

