/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.specific.SpecificRecord;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.util.ObjectSizeCalculator;
import org.apache.hudi.common.util.SizeEstimator;

public class AvroRecordSizeEstimator
implements SizeEstimator<BufferedRecord<IndexedRecord>> {
    private final long sizeOfSchema;

    public AvroRecordSizeEstimator(Schema recordSchema) {
        this.sizeOfSchema = ObjectSizeCalculator.getObjectSize(recordSchema);
    }

    @Override
    public long sizeEstimate(BufferedRecord<IndexedRecord> record) {
        long sizeOfRecord = ObjectSizeCalculator.getObjectSize(record);
        if (record.getRecord() instanceof SpecificRecord) {
            return sizeOfRecord;
        }
        return sizeOfRecord - this.sizeOfSchema + 8L;
    }
}

