/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import java.util.List;
import org.apache.avro.Schema;
import org.apache.hudi.avro.AvroSchemaComparatorForSchemaEvolution;
import org.apache.hudi.avro.AvroSchemaUtils;

public class AvroSchemaComparatorForRecordProjection
extends AvroSchemaComparatorForSchemaEvolution {
    private static final AvroSchemaComparatorForRecordProjection INSTANCE = new AvroSchemaComparatorForRecordProjection();

    public static boolean areSchemasProjectionEquivalent(Schema s1, Schema s2) {
        return INSTANCE.schemaEqualsInternal(s1, s2);
    }

    @Override
    protected boolean schemaEqualsInternal(Schema s1, Schema s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return super.schemaEqualsInternal(AvroSchemaUtils.getNonNullTypeFromUnion(s1), AvroSchemaUtils.getNonNullTypeFromUnion(s2));
    }

    @Override
    protected boolean validateRecord(Schema s1, Schema s2) {
        return true;
    }

    @Override
    protected boolean validateField(Schema.Field f1, Schema.Field f2) {
        return f1.name().equalsIgnoreCase(f2.name());
    }

    @Override
    protected boolean enumSchemaEquals(Schema s1, Schema s2) {
        List symbols1 = s1.getEnumSymbols();
        List symbols2 = s2.getEnumSymbols();
        if (symbols1.size() > symbols2.size()) {
            return false;
        }
        for (int i = 0; i < symbols1.size(); ++i) {
            if (((String)symbols1.get(i)).equalsIgnoreCase((String)symbols2.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean unionSchemaEquals(Schema s1, Schema s2) {
        throw new UnsupportedOperationException("union not supported for projection equivalence");
    }

    @Override
    protected boolean validateFixed(Schema s1, Schema s2) {
        return s1.getFixedSize() == s2.getFixedSize();
    }
}

