/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.AvroRecordContext;
import org.apache.hudi.avro.AvroRecordSerializer;
import org.apache.hudi.avro.AvroRecordSizeEstimator;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieAvroRecordMerger;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.model.OverwriteWithLatestMerger;
import org.apache.hudi.common.serialization.CustomSerializer;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.log.InstantRange;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.table.read.BufferedRecordSerializer;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.HoodieRecordUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.SizeEstimator;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.expression.Predicate;
import org.apache.hudi.io.storage.HoodieAvroFileReader;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;

public class HoodieAvroReaderContext
extends HoodieReaderContext<IndexedRecord> {
    private final Map<StoragePath, HoodieAvroFileReader> reusableFileReaders;
    private final boolean isMultiFormat;

    public HoodieAvroReaderContext(StorageConfiguration<?> storageConfiguration, HoodieTableConfig tableConfig, Option<InstantRange> instantRangeOpt, Option<Predicate> filterOpt, TypedProperties props) {
        this(storageConfiguration, tableConfig, instantRangeOpt, filterOpt, Collections.emptyMap(), tableConfig.getPayloadClass(), new HoodieConfig(props));
    }

    public HoodieAvroReaderContext(StorageConfiguration<?> storageConfiguration, HoodieTableConfig tableConfig, Option<InstantRange> instantRangeOpt, Option<Predicate> filterOpt) {
        this(storageConfiguration, tableConfig, instantRangeOpt, filterOpt, Collections.emptyMap(), tableConfig.getPayloadClass(), ConfigUtils.DEFAULT_HUDI_CONFIG_FOR_READER);
    }

    public HoodieAvroReaderContext(StorageConfiguration<?> storageConfiguration, HoodieTableConfig tableConfig, Option<InstantRange> instantRangeOpt, Option<Predicate> filterOpt, Map<StoragePath, HoodieAvroFileReader> reusableFileReaders, TypedProperties props) {
        this(storageConfiguration, tableConfig, instantRangeOpt, filterOpt, reusableFileReaders, tableConfig.getPayloadClass(), new HoodieConfig(props));
    }

    public HoodieAvroReaderContext(StorageConfiguration<?> storageConfiguration, HoodieTableConfig tableConfig, String payloadClassName, TypedProperties props) {
        this(storageConfiguration, tableConfig, (Option<InstantRange>)Option.empty(), (Option<Predicate>)Option.empty(), Collections.emptyMap(), payloadClassName, new HoodieConfig(props));
    }

    private HoodieAvroReaderContext(StorageConfiguration<?> storageConfiguration, HoodieTableConfig tableConfig, Option<InstantRange> instantRangeOpt, Option<Predicate> filterOpt, Map<StoragePath, HoodieAvroFileReader> reusableFileReaders, String payloadClassName, HoodieConfig hoodieReaderConfig) {
        super(storageConfiguration, tableConfig, instantRangeOpt, filterOpt, new AvroRecordContext(tableConfig, payloadClassName), hoodieReaderConfig);
        this.reusableFileReaders = reusableFileReaders;
        this.isMultiFormat = tableConfig.isMultipleBaseFileFormatsEnabled();
    }

    @Override
    public ClosableIterator<IndexedRecord> getFileRecordIterator(StoragePathInfo storagePathInfo, long start, long length, Schema dataSchema, Schema requiredSchema, HoodieStorage storage) throws IOException {
        boolean isLogFile = FSUtils.isLogFile(storagePathInfo.getPath());
        HoodieAvroFileReader reader = this.getOrCreateFileReader(storagePathInfo.getPath(), isLogFile, format -> {
            try {
                return (HoodieAvroFileReader)HoodieIOFactory.getIOFactory(storage).getReaderFactory(HoodieRecord.HoodieRecordType.AVRO).getFileReader(this.hoodieReaderConfig, storagePathInfo, (HoodieFileFormat)((Object)format), (Option<Schema>)Option.empty());
            }
            catch (IOException e) {
                throw new HoodieIOException("Failed to create avro records iterator from file path " + storagePathInfo.getPath(), e);
            }
        });
        return this.getFileRecordIterator(reader, storagePathInfo.getPath(), isLogFile, dataSchema, requiredSchema);
    }

    @Override
    public ClosableIterator<IndexedRecord> getFileRecordIterator(StoragePath filePath, long start, long length, Schema dataSchema, Schema requiredSchema, HoodieStorage storage) throws IOException {
        boolean isLogFile = FSUtils.isLogFile(filePath);
        HoodieAvroFileReader reader = this.getOrCreateFileReader(filePath, isLogFile, format -> {
            try {
                return (HoodieAvroFileReader)HoodieIOFactory.getIOFactory(storage).getReaderFactory(HoodieRecord.HoodieRecordType.AVRO).getFileReader(this.hoodieReaderConfig, filePath, (HoodieFileFormat)((Object)format), (Option<Schema>)Option.empty());
            }
            catch (IOException e) {
                throw new HoodieIOException("Failed to create avro records iterator from file path " + filePath, e);
            }
        });
        return this.getFileRecordIterator(reader, filePath, isLogFile, dataSchema, requiredSchema);
    }

    private HoodieAvroFileReader getOrCreateFileReader(StoragePath path, boolean isLogFile, Function<HoodieFileFormat, HoodieAvroFileReader> func) throws IOException {
        if (this.reusableFileReaders.containsKey(path)) {
            return this.reusableFileReaders.get(path);
        }
        HoodieFileFormat fileFormat = this.isMultiFormat && !isLogFile ? HoodieFileFormat.fromFileExtension(path.getFileExtension()) : this.baseFileFormat;
        try {
            return func.apply(fileFormat);
        }
        catch (HoodieIOException e) {
            throw e.getIOException();
        }
    }

    public ClosableIterator<IndexedRecord> getFileRecordIterator(HoodieAvroFileReader reader, StoragePath filePath, boolean isLogFile, Schema dataSchema, Schema requiredSchema) throws IOException {
        List<String> keyPrefixes;
        List<String> keys;
        Map<String, String> renamedColumns;
        Schema fileOutputSchema;
        if (isLogFile) {
            fileOutputSchema = requiredSchema;
            renamedColumns = Collections.emptyMap();
        } else {
            Pair<Schema, Map<String, String>> requiredSchemaForFileAndRenamedColumns = this.getSchemaHandler().getRequiredSchemaForFileAndRenamedColumns(filePath);
            fileOutputSchema = requiredSchemaForFileAndRenamedColumns.getLeft();
            renamedColumns = requiredSchemaForFileAndRenamedColumns.getRight();
        }
        if (this.keyFilterOpt.isEmpty()) {
            return reader.getIndexedRecordIterator(dataSchema, fileOutputSchema, renamedColumns);
        }
        if (reader.supportKeyPredicate() && !(keys = reader.extractKeys((Option<Predicate>)this.keyFilterOpt)).isEmpty()) {
            return reader.getIndexedRecordsByKeysIterator(keys, requiredSchema);
        }
        if (reader.supportKeyPrefixPredicate() && !(keyPrefixes = reader.extractKeyPrefixes((Option<Predicate>)this.keyFilterOpt)).isEmpty()) {
            return reader.getIndexedRecordsByKeyPrefixIterator(keyPrefixes, requiredSchema);
        }
        return reader.getIndexedRecordIterator(dataSchema, fileOutputSchema, renamedColumns);
    }

    @Override
    public Option<HoodieRecordMerger> getRecordMerger(RecordMergeMode mergeMode, String mergeStrategyId, String mergeImplClasses) {
        switch (mergeMode) {
            case EVENT_TIME_ORDERING: {
                return Option.of((Object)new HoodieAvroRecordMerger());
            }
            case COMMIT_TIME_ORDERING: {
                return Option.of((Object)new OverwriteWithLatestMerger());
            }
        }
        Option<HoodieRecordMerger> recordMerger = HoodieRecordUtils.createValidRecordMerger(EngineType.JAVA, mergeImplClasses, mergeStrategyId);
        if (recordMerger.isEmpty()) {
            throw new IllegalArgumentException("No valid merger implementation set for `hoodie.write.record.merge.custom.implementation.classes`");
        }
        return recordMerger;
    }

    @Override
    public SizeEstimator<BufferedRecord<IndexedRecord>> getRecordSizeEstimator() {
        return new AvroRecordSizeEstimator(this.getSchemaHandler().getSchemaForUpdates());
    }

    @Override
    public CustomSerializer<BufferedRecord<IndexedRecord>> getRecordSerializer() {
        return new BufferedRecordSerializer<IndexedRecord>(new AvroRecordSerializer(versionId -> this.getRecordContext().decodeAvroSchema(versionId)));
    }

    @Override
    public ClosableIterator<IndexedRecord> mergeBootstrapReaders(ClosableIterator<IndexedRecord> skeletonFileIterator, Schema skeletonRequiredSchema, ClosableIterator<IndexedRecord> dataFileIterator, Schema dataRequiredSchema, List<Pair<String, Object>> partitionFieldAndValues) {
        return new BootstrapIterator(skeletonFileIterator, skeletonRequiredSchema, dataFileIterator, dataRequiredSchema, partitionFieldAndValues);
    }

    private static class BootstrapIterator
    implements ClosableIterator<IndexedRecord> {
        private final ClosableIterator<IndexedRecord> skeletonFileIterator;
        private final Schema skeletonRequiredSchema;
        private final ClosableIterator<IndexedRecord> dataFileIterator;
        private final Schema dataRequiredSchema;
        private final Schema mergedSchema;
        private final int skeletonFields;
        private final int[] partitionFieldPositions;
        private final Object[] partitionValues;

        public BootstrapIterator(ClosableIterator<IndexedRecord> skeletonFileIterator, Schema skeletonRequiredSchema, ClosableIterator<IndexedRecord> dataFileIterator, Schema dataRequiredSchema, List<Pair<String, Object>> partitionFieldAndValues) {
            this.skeletonFileIterator = skeletonFileIterator;
            this.skeletonRequiredSchema = skeletonRequiredSchema;
            this.dataFileIterator = dataFileIterator;
            this.dataRequiredSchema = dataRequiredSchema;
            this.mergedSchema = AvroSchemaUtils.mergeSchemas(skeletonRequiredSchema, dataRequiredSchema);
            this.skeletonFields = skeletonRequiredSchema.getFields().size();
            this.partitionFieldPositions = partitionFieldAndValues.stream().map(Pair::getLeft).map(field -> this.mergedSchema.getField(field).pos()).mapToInt(Integer::intValue).toArray();
            this.partitionValues = partitionFieldAndValues.stream().map(Pair::getValue).toArray();
        }

        @Override
        public void close() {
            this.skeletonFileIterator.close();
            this.dataFileIterator.close();
        }

        @Override
        public boolean hasNext() {
            ValidationUtils.checkState((this.dataFileIterator.hasNext() == this.skeletonFileIterator.hasNext() ? 1 : 0) != 0, (String)"Bootstrap data-file iterator and skeleton-file iterator have to be in-sync!");
            return this.skeletonFileIterator.hasNext();
        }

        @Override
        public IndexedRecord next() {
            Schema.Field sourceField;
            IndexedRecord skeletonRecord = (IndexedRecord)this.skeletonFileIterator.next();
            IndexedRecord dataRecord = (IndexedRecord)this.dataFileIterator.next();
            GenericData.Record mergedRecord = new GenericData.Record(this.mergedSchema);
            for (Schema.Field skeletonField : this.skeletonRequiredSchema.getFields()) {
                sourceField = skeletonRecord.getSchema().getField(skeletonField.name());
                mergedRecord.put(skeletonField.pos(), skeletonRecord.get(sourceField.pos()));
            }
            for (Schema.Field dataField : this.dataRequiredSchema.getFields()) {
                sourceField = dataRecord.getSchema().getField(dataField.name());
                mergedRecord.put(dataField.pos() + this.skeletonFields, dataRecord.get(sourceField.pos()));
            }
            for (int i = 0; i < this.partitionFieldPositions.length; ++i) {
                if (mergedRecord.get(this.partitionFieldPositions[i]) != null) continue;
                mergedRecord.put(this.partitionFieldPositions[i], this.partitionValues[i]);
            }
            return mergedRecord;
        }
    }
}

