/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.apache.hudi.avro.model.ArrayWrapper;
import org.apache.hudi.avro.model.BooleanWrapper;
import org.apache.hudi.avro.model.BytesWrapper;
import org.apache.hudi.avro.model.DateWrapper;
import org.apache.hudi.avro.model.DecimalWrapper;
import org.apache.hudi.avro.model.DoubleWrapper;
import org.apache.hudi.avro.model.FloatWrapper;
import org.apache.hudi.avro.model.IntWrapper;
import org.apache.hudi.avro.model.LocalDateWrapper;
import org.apache.hudi.avro.model.LongWrapper;
import org.apache.hudi.avro.model.StringWrapper;
import org.apache.hudi.avro.model.TimestampMicrosWrapper;
import org.apache.hudi.common.util.DateTimeUtils;
import org.apache.hudi.common.util.OrderingValues;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ArrayComparable;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.util.Lazy;

public class HoodieAvroWrapperUtils {
    private static final Conversions.DecimalConversion AVRO_DECIMAL_CONVERSION = new Conversions.DecimalConversion();
    private static final Lazy<StringWrapper.Builder> STRING_WRAPPER_BUILDER_STUB = Lazy.lazily(StringWrapper::newBuilder);
    private static final Lazy<BytesWrapper.Builder> BYTES_WRAPPER_BUILDER_STUB = Lazy.lazily(BytesWrapper::newBuilder);
    private static final Lazy<DoubleWrapper.Builder> DOUBLE_WRAPPER_BUILDER_STUB = Lazy.lazily(DoubleWrapper::newBuilder);
    private static final Lazy<FloatWrapper.Builder> FLOAT_WRAPPER_BUILDER_STUB = Lazy.lazily(FloatWrapper::newBuilder);
    private static final Lazy<LongWrapper.Builder> LONG_WRAPPER_BUILDER_STUB = Lazy.lazily(LongWrapper::newBuilder);
    private static final Lazy<IntWrapper.Builder> INT_WRAPPER_BUILDER_STUB = Lazy.lazily(IntWrapper::newBuilder);
    private static final Lazy<BooleanWrapper.Builder> BOOLEAN_WRAPPER_BUILDER_STUB = Lazy.lazily(BooleanWrapper::newBuilder);
    private static final Lazy<TimestampMicrosWrapper.Builder> TIMESTAMP_MICROS_WRAPPER_BUILDER_STUB = Lazy.lazily(TimestampMicrosWrapper::newBuilder);
    private static final Lazy<DecimalWrapper.Builder> DECIMAL_WRAPPER_BUILDER_STUB = Lazy.lazily(DecimalWrapper::newBuilder);
    private static final Lazy<DateWrapper.Builder> DATE_WRAPPER_BUILDER_STUB = Lazy.lazily(DateWrapper::newBuilder);
    private static final Lazy<LocalDateWrapper.Builder> LOCAL_DATE_WRAPPER_BUILDER_STUB = Lazy.lazily(LocalDateWrapper::newBuilder);
    private static final Lazy<ArrayWrapper.Builder> ARRAY_WRAPPER_BUILDER_STUB = Lazy.lazily(ArrayWrapper::newBuilder);

    public static Object wrapValueIntoAvro(Comparable<?> value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            LocalDate localDate = ((Date)value).toLocalDate();
            return DateWrapper.newBuilder(DATE_WRAPPER_BUILDER_STUB.get()).setValue((int)localDate.toEpochDay()).build();
        }
        if (value instanceof LocalDate) {
            LocalDate localDate = (LocalDate)value;
            return LocalDateWrapper.newBuilder(LOCAL_DATE_WRAPPER_BUILDER_STUB.get()).setValue((int)localDate.toEpochDay()).build();
        }
        if (value instanceof BigDecimal) {
            Schema valueSchema = DecimalWrapper.SCHEMA$.getField("value").schema();
            BigDecimal upcastDecimal = HoodieTableMetadataUtil.tryUpcastDecimal((BigDecimal)value, (LogicalTypes.Decimal)valueSchema.getLogicalType());
            return DecimalWrapper.newBuilder(DECIMAL_WRAPPER_BUILDER_STUB.get()).setValue(AVRO_DECIMAL_CONVERSION.toBytes(upcastDecimal, valueSchema, valueSchema.getLogicalType())).build();
        }
        if (value instanceof Timestamp) {
            Instant instant = ((Timestamp)value).toInstant();
            return TimestampMicrosWrapper.newBuilder(TIMESTAMP_MICROS_WRAPPER_BUILDER_STUB.get()).setValue(DateTimeUtils.instantToMicros(instant)).build();
        }
        if (value instanceof Boolean) {
            return HoodieAvroWrapperUtils.wrapBoolean(value);
        }
        if (value instanceof Integer) {
            return HoodieAvroWrapperUtils.wrapInt(value);
        }
        if (value instanceof Long) {
            return HoodieAvroWrapperUtils.wrapLong(value);
        }
        if (value instanceof Float) {
            return HoodieAvroWrapperUtils.wrapFloat(value);
        }
        if (value instanceof Double) {
            return HoodieAvroWrapperUtils.wrapDouble(value);
        }
        if (value instanceof ByteBuffer) {
            return HoodieAvroWrapperUtils.wrapBytes(value);
        }
        if (value instanceof String || value instanceof Utf8) {
            return HoodieAvroWrapperUtils.wrapString(value.toString());
        }
        if (value instanceof ArrayComparable) {
            return HoodieAvroWrapperUtils.wrapArray(value, HoodieAvroWrapperUtils::wrapValueIntoAvro);
        }
        throw new UnsupportedOperationException(String.format("Unsupported type of the value (%s)", value.getClass()));
    }

    public static Comparable<?> unwrapAvroValueWrapper(Object avroValueWrapper) {
        if (avroValueWrapper == null) {
            return null;
        }
        Pair<Boolean, String> isValueWrapperObfuscated = HoodieAvroWrapperUtils.getIsValueWrapperObfuscated(avroValueWrapper);
        if (isValueWrapperObfuscated.getKey().booleanValue()) {
            return HoodieAvroWrapperUtils.unwrapAvroValueWrapper(avroValueWrapper, isValueWrapperObfuscated.getValue());
        }
        if (avroValueWrapper instanceof DateWrapper) {
            return Date.valueOf(LocalDate.ofEpochDay(((DateWrapper)((Object)avroValueWrapper)).getValue()));
        }
        if (avroValueWrapper instanceof LocalDateWrapper) {
            return LocalDate.ofEpochDay(((LocalDateWrapper)((Object)avroValueWrapper)).getValue());
        }
        if (avroValueWrapper instanceof DecimalWrapper) {
            Schema valueSchema = DecimalWrapper.SCHEMA$.getField("value").schema();
            return AVRO_DECIMAL_CONVERSION.fromBytes(((DecimalWrapper)((Object)avroValueWrapper)).getValue(), valueSchema, valueSchema.getLogicalType());
        }
        if (avroValueWrapper instanceof TimestampMicrosWrapper) {
            return DateTimeUtils.microsToInstant(((TimestampMicrosWrapper)((Object)avroValueWrapper)).getValue());
        }
        if (avroValueWrapper instanceof BooleanWrapper) {
            return HoodieAvroWrapperUtils.unwrapBoolean(avroValueWrapper);
        }
        if (avroValueWrapper instanceof IntWrapper) {
            return HoodieAvroWrapperUtils.unwrapInt(avroValueWrapper);
        }
        if (avroValueWrapper instanceof LongWrapper) {
            return HoodieAvroWrapperUtils.unwrapLong(avroValueWrapper);
        }
        if (avroValueWrapper instanceof FloatWrapper) {
            return HoodieAvroWrapperUtils.unwrapFloat(avroValueWrapper);
        }
        if (avroValueWrapper instanceof DoubleWrapper) {
            return HoodieAvroWrapperUtils.unwrapDouble(avroValueWrapper);
        }
        if (avroValueWrapper instanceof BytesWrapper) {
            return HoodieAvroWrapperUtils.unwrapBytes(avroValueWrapper);
        }
        if (avroValueWrapper instanceof StringWrapper) {
            return HoodieAvroWrapperUtils.unwrapString(avroValueWrapper);
        }
        if (avroValueWrapper instanceof ArrayWrapper) {
            ArrayWrapper arrayWrapper = (ArrayWrapper)((Object)avroValueWrapper);
            return OrderingValues.create((Comparable[])arrayWrapper.getWrappedValues().stream().map(HoodieAvroWrapperUtils::unwrapAvroValueWrapper).toArray(Comparable[]::new));
        }
        if (avroValueWrapper instanceof GenericRecord) {
            return HoodieAvroWrapperUtils.unwrapGenericRecord(avroValueWrapper);
        }
        throw new UnsupportedOperationException(String.format("Unsupported type of the value (%s)", avroValueWrapper.getClass()));
    }

    public static Comparable<?> unwrapAvroValueWrapper(Object avroValueWrapper, String wrapperClassName) {
        if (avroValueWrapper == null) {
            return null;
        }
        if (DateWrapper.class.getSimpleName().equals(wrapperClassName)) {
            ValidationUtils.checkArgument((boolean)(avroValueWrapper instanceof GenericRecord));
            return Date.valueOf(LocalDate.ofEpochDay(((Integer)((GenericRecord)avroValueWrapper).get(0)).intValue()));
        }
        if (LocalDateWrapper.class.getSimpleName().equals(wrapperClassName)) {
            ValidationUtils.checkArgument((boolean)(avroValueWrapper instanceof GenericRecord));
            return LocalDate.ofEpochDay(((Integer)((GenericRecord)avroValueWrapper).get(0)).intValue());
        }
        if (TimestampMicrosWrapper.class.getSimpleName().equals(wrapperClassName)) {
            ValidationUtils.checkArgument((boolean)(avroValueWrapper instanceof GenericRecord));
            Instant instant = DateTimeUtils.microsToInstant((Long)((GenericRecord)avroValueWrapper).get(0));
            return Timestamp.from(instant);
        }
        if (DecimalWrapper.class.getSimpleName().equals(wrapperClassName)) {
            Schema valueSchema = DecimalWrapper.SCHEMA$.getField("value").schema();
            ValidationUtils.checkArgument((boolean)(avroValueWrapper instanceof GenericRecord));
            return AVRO_DECIMAL_CONVERSION.fromBytes((ByteBuffer)((GenericRecord)avroValueWrapper).get(0), valueSchema, valueSchema.getLogicalType());
        }
        throw new UnsupportedOperationException(String.format("Unsupported type of the value (%s)", avroValueWrapper.getClass()));
    }

    private static Pair<Boolean, String> getIsValueWrapperObfuscated(Object statsValue) {
        if (statsValue != null) {
            boolean toReturn;
            String statsValueSchemaClassName = ((GenericRecord)statsValue).getSchema().getName();
            boolean bl = toReturn = statsValueSchemaClassName.equals(DateWrapper.class.getSimpleName()) || statsValueSchemaClassName.equals(LocalDateWrapper.class.getSimpleName()) || statsValueSchemaClassName.equals(TimestampMicrosWrapper.class.getSimpleName()) || statsValueSchemaClassName.equals(DecimalWrapper.class.getSimpleName());
            if (toReturn) {
                return Pair.of(true, ((GenericRecord)statsValue).getSchema().getName());
            }
        }
        return Pair.of(false, null);
    }

    private static Object wrapNull(Comparable<?> value) {
        return value;
    }

    private static Object wrapBoolean(Comparable<?> value) {
        return BooleanWrapper.newBuilder(BOOLEAN_WRAPPER_BUILDER_STUB.get()).setValue((Boolean)value).build();
    }

    private static Object wrapInt(Comparable<?> value) {
        return IntWrapper.newBuilder(INT_WRAPPER_BUILDER_STUB.get()).setValue((Integer)value).build();
    }

    private static Object wrapLong(Comparable<?> value) {
        return LongWrapper.newBuilder(LONG_WRAPPER_BUILDER_STUB.get()).setValue((Long)value).build();
    }

    private static Object wrapFloat(Comparable<?> value) {
        return FloatWrapper.newBuilder(FLOAT_WRAPPER_BUILDER_STUB.get()).setValue(((Float)value).floatValue()).build();
    }

    private static Object wrapDouble(Comparable<?> value) {
        return DoubleWrapper.newBuilder(DOUBLE_WRAPPER_BUILDER_STUB.get()).setValue((Double)value).build();
    }

    private static Object wrapString(Comparable<?> value) {
        return StringWrapper.newBuilder(STRING_WRAPPER_BUILDER_STUB.get()).setValue((String)((Object)value)).build();
    }

    private static Object wrapBytes(Comparable<?> value) {
        return BytesWrapper.newBuilder(BYTES_WRAPPER_BUILDER_STUB.get()).setValue((ByteBuffer)value).build();
    }

    public static Object wrapArray(Comparable<?> value, Function<Comparable<?>, Object> wrapper) {
        List<Object> avroValues = OrderingValues.getValues((ArrayComparable)value).stream().map(wrapper::apply).collect(Collectors.toList());
        return ArrayWrapper.newBuilder(ARRAY_WRAPPER_BUILDER_STUB.get()).setWrappedValues(avroValues).build();
    }

    private static Comparable<?> unwrapNull(Object val) {
        return (Comparable)val;
    }

    private static Comparable<?> unwrapBoolean(Object val) {
        return ((BooleanWrapper)((Object)val)).getValue();
    }

    private static Comparable<?> unwrapInt(Object val) {
        return ((IntWrapper)((Object)val)).getValue();
    }

    private static Comparable<?> unwrapLong(Object val) {
        return ((LongWrapper)((Object)val)).getValue();
    }

    private static Comparable<?> unwrapFloat(Object val) {
        return Float.valueOf(((FloatWrapper)((Object)val)).getValue());
    }

    private static Comparable<?> unwrapDouble(Object val) {
        return ((DoubleWrapper)((Object)val)).getValue();
    }

    private static Comparable<?> unwrapString(Object val) {
        return ((StringWrapper)((Object)val)).getValue();
    }

    private static Comparable<?> unwrapBytes(Object val) {
        return ((BytesWrapper)((Object)val)).getValue();
    }

    public static Comparable<?> unwrapGenericRecord(Object val) {
        GenericRecord genRec = (GenericRecord)val;
        return (Comparable)genRec.get("value");
    }

    public static enum PrimitiveWrapperType {
        V1(Object.class, HoodieAvroWrapperUtils::wrapValueIntoAvro, HoodieAvroWrapperUtils::unwrapAvroValueWrapper, GenericRecord.class),
        NULL(Void.class, x$0 -> HoodieAvroWrapperUtils.access$1500(x$0), x$0 -> HoodieAvroWrapperUtils.access$1400(x$0), Void.class),
        BOOLEAN(Boolean.class, x$0 -> HoodieAvroWrapperUtils.access$1300(x$0), x$0 -> HoodieAvroWrapperUtils.access$1200(x$0), BooleanWrapper.class),
        INT(Integer.class, x$0 -> HoodieAvroWrapperUtils.access$1100(x$0), x$0 -> HoodieAvroWrapperUtils.access$1000(x$0), IntWrapper.class),
        LONG(Long.class, x$0 -> HoodieAvroWrapperUtils.access$900(x$0), x$0 -> HoodieAvroWrapperUtils.access$800(x$0), LongWrapper.class),
        FLOAT(Float.class, x$0 -> HoodieAvroWrapperUtils.access$700(x$0), x$0 -> HoodieAvroWrapperUtils.access$600(x$0), FloatWrapper.class),
        DOUBLE(Double.class, x$0 -> HoodieAvroWrapperUtils.access$500(x$0), x$0 -> HoodieAvroWrapperUtils.access$400(x$0), DoubleWrapper.class),
        STRING(String.class, x$0 -> HoodieAvroWrapperUtils.access$300(x$0), x$0 -> HoodieAvroWrapperUtils.access$200(x$0), StringWrapper.class),
        BYTES(ByteBuffer.class, x$0 -> HoodieAvroWrapperUtils.access$100(x$0), x$0 -> HoodieAvroWrapperUtils.access$000(x$0), BytesWrapper.class);

        private final Class<?> clazz;
        private final Function<Comparable<?>, Object> wrapper;
        private final Function<Object, Comparable<?>> unwrapper;
        private final Class<?> wrapperClass;

        private PrimitiveWrapperType(Class<?> clazz, Function<Comparable<?>, Object> wrapper, Function<Object, Comparable<?>> unwrapper, Class<?> wrapperClass) {
            this.clazz = clazz;
            this.wrapper = wrapper;
            this.unwrapper = unwrapper;
            this.wrapperClass = wrapperClass;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public Object wrap(Comparable<?> value) {
            return this.wrapper.apply(value);
        }

        public Comparable<?> unwrap(Object value) {
            return this.unwrapper.apply(value);
        }

        public Class<?> getWrapperClass() {
            return this.wrapperClass;
        }
    }
}

