/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.model.HoodieRecord;

public class JoinedGenericRecord
implements GenericRecord {
    private final GenericRecord dataRecord;
    private final Object[] metaFields;
    private final Schema schema;

    public JoinedGenericRecord(GenericRecord dataRecord, int metaFieldsSize, Schema schema) {
        this.dataRecord = dataRecord;
        this.metaFields = new Object[metaFieldsSize];
        this.schema = schema;
    }

    public void put(String key, Object v) {
        Integer metaFieldPos = this.getMetaFieldPos(key);
        if (metaFieldPos != null) {
            this.metaFields[metaFieldPos.intValue()] = v;
        } else {
            this.dataRecord.put(key, v);
        }
    }

    public Object get(String key) {
        Integer metaFieldPos = this.getMetaFieldPos(key);
        if (metaFieldPos != null) {
            return this.metaFields[metaFieldPos];
        }
        return this.dataRecord.get(key);
    }

    public void put(int i, Object v) {
        if (i < this.metaFields.length) {
            this.metaFields[i] = v;
        } else {
            this.dataRecord.put(i - this.metaFields.length, v);
        }
    }

    public Object get(int i) {
        if (i < this.metaFields.length) {
            return this.metaFields[i];
        }
        return this.dataRecord.get(i - this.metaFields.length);
    }

    private Integer getMetaFieldPos(String fieldName) {
        Integer pos = HoodieRecord.HOODIE_META_COLUMNS_NAME_TO_POS.get(fieldName);
        if (pos == null && fieldName.equals(HoodieRecord.OPERATION_METADATA_FIELD)) {
            return HoodieRecord.HOODIE_META_COLUMNS_NAME_TO_POS.size();
        }
        return pos;
    }

    public Schema getSchema() {
        return this.schema;
    }
}

