/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.ResolvingDecoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class HoodieValueTypeInfo
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 4095930097240468943L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"HoodieValueTypeInfo\",\"namespace\":\"org.apache.hudi.avro.model\",\"fields\":[{\"name\":\"typeOrdinal\",\"type\":\"int\",\"doc\":\"Enum type ordinal representing the value type\"},{\"name\":\"additionalInfo\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Optional additional information about the value type\",\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<HoodieValueTypeInfo> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<HoodieValueTypeInfo> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    private int typeOrdinal;
    private String additionalInfo;
    private static final DatumWriter<HoodieValueTypeInfo> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<HoodieValueTypeInfo> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<HoodieValueTypeInfo> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<HoodieValueTypeInfo> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<HoodieValueTypeInfo> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static HoodieValueTypeInfo fromByteBuffer(ByteBuffer b) throws IOException {
        return (HoodieValueTypeInfo)((Object)DECODER.decode(b));
    }

    public HoodieValueTypeInfo() {
    }

    public HoodieValueTypeInfo(Integer typeOrdinal, String additionalInfo) {
        this.typeOrdinal = typeOrdinal;
        this.additionalInfo = additionalInfo;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.typeOrdinal;
            }
            case 1: {
                return this.additionalInfo;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.typeOrdinal = (Integer)value$;
                break;
            }
            case 1: {
                this.additionalInfo = value$ != null ? value$.toString() : null;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public int getTypeOrdinal() {
        return this.typeOrdinal;
    }

    public void setTypeOrdinal(int value) {
        this.typeOrdinal = value;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(String value) {
        this.additionalInfo = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(HoodieValueTypeInfo other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    protected boolean hasCustomCoders() {
        return true;
    }

    public void customEncode(Encoder out) throws IOException {
        out.writeInt(this.typeOrdinal);
        if (this.additionalInfo == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.additionalInfo);
        }
    }

    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            this.typeOrdinal = in.readInt();
            if (in.readIndex() != 1) {
                in.readNull();
                this.additionalInfo = null;
            } else {
                this.additionalInfo = in.readString();
            }
        } else {
            block4: for (int i = 0; i < 2; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        this.typeOrdinal = in.readInt();
                        continue block4;
                    }
                    case 1: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.additionalInfo = null;
                            continue block4;
                        }
                        this.additionalInfo = in.readString();
                        continue block4;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<HoodieValueTypeInfo>
    implements RecordBuilder<HoodieValueTypeInfo> {
        private int typeOrdinal;
        private String additionalInfo;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.typeOrdinal)) {
                this.typeOrdinal = (Integer)this.data().deepCopy(this.fields()[0].schema(), (Object)other.typeOrdinal);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.additionalInfo)) {
                this.additionalInfo = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.additionalInfo);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
        }

        private Builder(HoodieValueTypeInfo other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.typeOrdinal)) {
                this.typeOrdinal = (Integer)this.data().deepCopy(this.fields()[0].schema(), (Object)other.typeOrdinal);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.additionalInfo)) {
                this.additionalInfo = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.additionalInfo);
                this.fieldSetFlags()[1] = true;
            }
        }

        public int getTypeOrdinal() {
            return this.typeOrdinal;
        }

        public Builder setTypeOrdinal(int value) {
            this.validate(this.fields()[0], value);
            this.typeOrdinal = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasTypeOrdinal() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearTypeOrdinal() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public String getAdditionalInfo() {
            return this.additionalInfo;
        }

        public Builder setAdditionalInfo(String value) {
            this.validate(this.fields()[1], value);
            this.additionalInfo = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasAdditionalInfo() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearAdditionalInfo() {
            this.additionalInfo = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public HoodieValueTypeInfo build() {
            try {
                HoodieValueTypeInfo record = new HoodieValueTypeInfo();
                record.typeOrdinal = this.fieldSetFlags()[0] ? this.typeOrdinal : (Integer)this.defaultValue(this.fields()[0]);
                record.additionalInfo = this.fieldSetFlags()[1] ? this.additionalInfo : (String)this.defaultValue(this.fields()[1]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

