/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.bloom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.apache.hudi.common.bloom.BloomFilterUtils;
import org.apache.hudi.common.bloom.InternalDynamicBloomFilter;
import org.apache.hudi.common.bloom.Key;
import org.apache.hudi.common.util.Base64CodecUtil;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.io.util.IOUtils;

public class HoodieDynamicBoundedBloomFilter
implements BloomFilter {
    public static final String TYPE_CODE_PREFIX = "DYNAMIC";
    private InternalDynamicBloomFilter internalDynamicBloomFilter;

    HoodieDynamicBoundedBloomFilter(int numEntries, double errorRate, int hashType, int maxNoOfEntries) {
        int bitSize = BloomFilterUtils.getBitSize(numEntries, errorRate);
        int numHashs = BloomFilterUtils.getNumHashes(bitSize, numEntries);
        this.internalDynamicBloomFilter = new InternalDynamicBloomFilter(bitSize, numHashs, hashType, numEntries, maxNoOfEntries);
    }

    public HoodieDynamicBoundedBloomFilter(String serString) {
        byte[] bytes = Base64CodecUtil.decode(serString);
        try (DataInputStream stream = new DataInputStream(new ByteArrayInputStream(bytes));){
            this.extractAndSetInternalBloomFilter(stream);
        }
        catch (IOException e) {
            throw new HoodieIndexException("Could not deserialize BloomFilter from string", e);
        }
    }

    public HoodieDynamicBoundedBloomFilter(ByteBuffer byteBuffer) {
        try (DataInputStream stream = IOUtils.getDataInputStream((ByteBuffer)Base64CodecUtil.decode(byteBuffer));){
            this.extractAndSetInternalBloomFilter(stream);
        }
        catch (IOException e) {
            throw new HoodieIndexException("Could not deserialize BloomFilter from byte buffer", e);
        }
    }

    @Override
    public void add(String key) {
        this.add(StringUtils.getUTF8Bytes((String)key));
    }

    @Override
    public void add(byte[] keyBytes) {
        this.internalDynamicBloomFilter.add(new Key(keyBytes));
    }

    @Override
    public boolean mightContain(String key) {
        return this.internalDynamicBloomFilter.membershipTest(new Key(StringUtils.getUTF8Bytes((String)key)));
    }

    @Override
    public String serializeToString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            this.internalDynamicBloomFilter.write(dos);
            byte[] bytes = baos.toByteArray();
            dos.close();
            return Base64CodecUtil.encode(bytes);
        }
        catch (IOException e) {
            throw new HoodieIndexException("Could not serialize BloomFilter instance", e);
        }
    }

    @Override
    public BloomFilterTypeCode getBloomFilterTypeCode() {
        return BloomFilterTypeCode.DYNAMIC_V0;
    }

    private void extractAndSetInternalBloomFilter(DataInputStream dis) throws IOException {
        this.internalDynamicBloomFilter = new InternalDynamicBloomFilter();
        this.internalDynamicBloomFilter.readFields(dis);
    }

    @Override
    public void or(BloomFilter other) {
        if (other != null) {
            ValidationUtils.checkArgument((boolean)(other instanceof HoodieDynamicBoundedBloomFilter), (String)"HoodieDynamicBoundedBloomFilter can only perform OR operations with other HoodieDynamicBoundedBloomFilter.");
            HoodieDynamicBoundedBloomFilter otherFilter = (HoodieDynamicBoundedBloomFilter)other;
            int sourceMatrixLength = this.getMatrixLength();
            int targetMatrixLength = otherFilter.getMatrixLength();
            if (targetMatrixLength > sourceMatrixLength) {
                this.rescaleFromTarget(targetMatrixLength);
            } else {
                otherFilter.rescaleFromTarget(sourceMatrixLength);
            }
            this.internalDynamicBloomFilter.or(otherFilter.internalDynamicBloomFilter);
        }
    }

    @VisibleForTesting
    protected HoodieDynamicBoundedBloomFilter rescaleFromTarget(int targetMatrixLength) {
        int initMatrixLength = this.internalDynamicBloomFilter.getMatrixLength();
        int needAddRowNum = targetMatrixLength - initMatrixLength;
        this.internalDynamicBloomFilter.addRows(needAddRowNum);
        return this;
    }

    @VisibleForTesting
    protected int getMatrixLength() {
        return this.internalDynamicBloomFilter.getMatrixLength();
    }
}

