/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.bloom;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hudi.common.bloom.InternalBloomFilter;
import org.apache.hudi.common.bloom.InternalFilter;
import org.apache.hudi.common.bloom.Key;

class InternalDynamicBloomFilter
extends InternalFilter {
    private int nr;
    private int currentNbRecord;
    private int maxNr;
    private boolean reachedMax = false;
    private int curMatrixIndex = 0;
    private InternalBloomFilter[] matrix;

    public InternalDynamicBloomFilter() {
    }

    public InternalDynamicBloomFilter(int vectorSize, int nbHash, int hashType, int nr, int maxNr) {
        super(vectorSize, nbHash, hashType);
        this.nr = nr;
        this.currentNbRecord = 0;
        this.maxNr = maxNr;
        this.matrix = new InternalBloomFilter[1];
        this.matrix[0] = new InternalBloomFilter(this.vectorSize, this.nbHash, this.hashType);
    }

    @Override
    public void add(Key key) {
        if (key == null) {
            throw new NullPointerException("Key can not be null");
        }
        InternalBloomFilter bf = this.getActiveStandardBF();
        if (bf == null) {
            this.addRow();
            bf = this.matrix[this.matrix.length - 1];
            this.currentNbRecord = 0;
        }
        bf.add(key);
        ++this.currentNbRecord;
    }

    @Override
    public void and(InternalFilter filter) {
        if (!(filter instanceof InternalDynamicBloomFilter) || filter.vectorSize != this.vectorSize || filter.nbHash != this.nbHash) {
            throw new IllegalArgumentException("filters cannot be and-ed");
        }
        InternalDynamicBloomFilter dbf = (InternalDynamicBloomFilter)filter;
        if (dbf.matrix.length != this.matrix.length || dbf.nr != this.nr) {
            throw new IllegalArgumentException("filters cannot be and-ed");
        }
        for (int i = 0; i < this.matrix.length; ++i) {
            this.matrix[i].and(dbf.matrix[i]);
        }
    }

    @Override
    public boolean membershipTest(Key key) {
        if (key == null) {
            return true;
        }
        for (InternalBloomFilter bloomFilter : this.matrix) {
            if (!bloomFilter.membershipTest(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void not() {
        for (InternalBloomFilter bloomFilter : this.matrix) {
            bloomFilter.not();
        }
    }

    @Override
    public void or(InternalFilter filter) {
        if (!(filter instanceof InternalDynamicBloomFilter) || filter.vectorSize != this.vectorSize || filter.nbHash != this.nbHash) {
            throw new IllegalArgumentException("filters cannot be or-ed");
        }
        InternalDynamicBloomFilter dbf = (InternalDynamicBloomFilter)filter;
        if (dbf.matrix.length != this.matrix.length || dbf.nr != this.nr) {
            throw new IllegalArgumentException("filters cannot be or-ed");
        }
        for (int i = 0; i < this.matrix.length; ++i) {
            this.matrix[i].or(dbf.matrix[i]);
        }
    }

    @Override
    public void xor(InternalFilter filter) {
        if (!(filter instanceof InternalDynamicBloomFilter) || filter.vectorSize != this.vectorSize || filter.nbHash != this.nbHash) {
            throw new IllegalArgumentException("filters cannot be xor-ed");
        }
        InternalDynamicBloomFilter dbf = (InternalDynamicBloomFilter)filter;
        if (dbf.matrix.length != this.matrix.length || dbf.nr != this.nr) {
            throw new IllegalArgumentException("filters cannot be xor-ed");
        }
        for (int i = 0; i < this.matrix.length; ++i) {
            this.matrix[i].xor(dbf.matrix[i]);
        }
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        for (InternalBloomFilter bloomFilter : this.matrix) {
            res.append(bloomFilter);
            res.append(13);
        }
        return res.toString();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.nr);
        out.writeInt(this.currentNbRecord);
        out.writeInt(this.matrix.length);
        for (InternalBloomFilter bloomFilter : this.matrix) {
            bloomFilter.write(out);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.nr = in.readInt();
        this.currentNbRecord = in.readInt();
        int len = in.readInt();
        this.matrix = new InternalBloomFilter[len];
        for (int i = 0; i < this.matrix.length; ++i) {
            this.matrix[i] = new InternalBloomFilter();
            this.matrix[i].readFields(in);
        }
    }

    protected void addRow() {
        InternalBloomFilter[] tmp = new InternalBloomFilter[this.matrix.length + 1];
        System.arraycopy(this.matrix, 0, tmp, 0, this.matrix.length);
        tmp[tmp.length - 1] = new InternalBloomFilter(this.vectorSize, this.nbHash, this.hashType);
        this.matrix = tmp;
    }

    protected void addRows(int size) {
        if (size <= 0) {
            return;
        }
        if (size == 1) {
            this.addRow();
            return;
        }
        InternalBloomFilter[] tmp = new InternalBloomFilter[this.matrix.length + size];
        System.arraycopy(this.matrix, 0, tmp, 0, this.matrix.length);
        for (int i = this.matrix.length; i < tmp.length; ++i) {
            tmp[i] = new InternalBloomFilter(this.vectorSize, this.nbHash, this.hashType);
        }
        this.matrix = tmp;
    }

    private InternalBloomFilter getActiveStandardBF() {
        if (this.reachedMax) {
            return this.matrix[this.curMatrixIndex++ % this.matrix.length];
        }
        if (this.currentNbRecord >= this.nr && this.matrix.length * this.nr < this.maxNr) {
            return null;
        }
        if (this.currentNbRecord >= this.nr && this.matrix.length * this.nr >= this.maxNr) {
            this.reachedMax = true;
            return this.matrix[0];
        }
        return this.matrix[this.matrix.length - 1];
    }

    public int getMatrixLength() {
        return this.matrix.length;
    }
}

