/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.bootstrap.index.hfile;

import java.io.IOException;
import org.apache.hudi.common.bootstrap.index.BootstrapIndex;
import org.apache.hudi.common.bootstrap.index.hfile.HFileBootstrapIndexReader;
import org.apache.hudi.common.bootstrap.index.hfile.HFileBootstrapIndexWriter;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HFileBootstrapIndex
extends BootstrapIndex {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(HFileBootstrapIndex.class);
    public static final String BOOTSTRAP_INDEX_FILE_ID = "00000000-0000-0000-0000-000000000000-0";
    private static final String PARTITION_KEY_PREFIX = "part";
    private static final String FILE_ID_KEY_PREFIX = "fileid";
    private static final String KEY_VALUE_SEPARATOR = "=";
    private static final String KEY_PARTS_SEPARATOR = ";";
    public static final String HFILE_CELL_KEY_SUFFIX_PART = "//LATEST_TIMESTAMP/Put/vlen";
    public static final String INDEX_INFO_KEY_STRING = "INDEX_INFO";
    public static final byte[] INDEX_INFO_KEY = StringUtils.getUTF8Bytes((String)"INDEX_INFO");
    private final boolean isPresent;

    public HFileBootstrapIndex(HoodieTableMetaClient metaClient) {
        super(metaClient);
        StoragePath indexByPartitionPath = HFileBootstrapIndex.partitionIndexPath(metaClient);
        StoragePath indexByFilePath = HFileBootstrapIndex.fileIdIndexPath(metaClient);
        try {
            HoodieStorage storage = metaClient.getStorage();
            this.isPresent = !metaClient.isMetadataTable() && storage.exists(indexByPartitionPath) && storage.exists(indexByFilePath);
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
    }

    static String getPartitionKey(String partition) {
        return HFileBootstrapIndex.getKeyValueString(PARTITION_KEY_PREFIX, partition);
    }

    static String getFileGroupKey(HoodieFileGroupId fileGroupId) {
        return HFileBootstrapIndex.getPartitionKey(fileGroupId.getPartitionPath()) + KEY_PARTS_SEPARATOR + HFileBootstrapIndex.getKeyValueString(FILE_ID_KEY_PREFIX, fileGroupId.getFileId());
    }

    static String getPartitionFromKey(String key) {
        String[] parts = key.split(KEY_VALUE_SEPARATOR, 2);
        ValidationUtils.checkArgument((boolean)parts[0].equals(PARTITION_KEY_PREFIX));
        return parts[1];
    }

    private static String getFileIdFromKey(String key) {
        String[] parts = key.split(KEY_VALUE_SEPARATOR, 2);
        ValidationUtils.checkArgument((boolean)parts[0].equals(FILE_ID_KEY_PREFIX));
        return parts[1];
    }

    static HoodieFileGroupId getFileGroupFromKey(String key) {
        String[] parts = key.split(KEY_PARTS_SEPARATOR, 2);
        return new HoodieFileGroupId(HFileBootstrapIndex.getPartitionFromKey(parts[0]), HFileBootstrapIndex.getFileIdFromKey(parts[1]));
    }

    private static String getKeyValueString(String key, String value) {
        return key + KEY_VALUE_SEPARATOR + value;
    }

    static StoragePath partitionIndexPath(HoodieTableMetaClient metaClient) {
        return new StoragePath(metaClient.getBootstrapIndexByPartitionFolderPath(), FSUtils.makeBootstrapIndexFileName("00000000000001", BOOTSTRAP_INDEX_FILE_ID, HoodieFileFormat.HFILE.getFileExtension()));
    }

    static StoragePath fileIdIndexPath(HoodieTableMetaClient metaClient) {
        return new StoragePath(metaClient.getBootstrapIndexByFileIdFolderNameFolderPath(), FSUtils.makeBootstrapIndexFileName("00000000000001", BOOTSTRAP_INDEX_FILE_ID, HoodieFileFormat.HFILE.getFileExtension()));
    }

    @Override
    public BootstrapIndex.IndexReader createReader() {
        return new HFileBootstrapIndexReader(this.metaClient);
    }

    @Override
    public BootstrapIndex.IndexWriter createWriter(String bootstrapBasePath) {
        return new HFileBootstrapIndexWriter(bootstrapBasePath, this.metaClient);
    }

    @Override
    public void dropIndex() {
        try {
            StoragePath[] indexPaths;
            for (StoragePath indexPath : indexPaths = new StoragePath[]{HFileBootstrapIndex.partitionIndexPath(this.metaClient), HFileBootstrapIndex.fileIdIndexPath(this.metaClient)}) {
                if (!this.metaClient.getStorage().exists(indexPath)) continue;
                LOG.info("Dropping bootstrap index. Deleting file: {}", (Object)indexPath);
                this.metaClient.getStorage().deleteDirectory(indexPath);
            }
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
    }

    @Override
    public boolean isPresent() {
        return this.isPresent;
    }
}

