/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.bootstrap.index.hfile;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieBootstrapFilePartitionInfo;
import org.apache.hudi.avro.model.HoodieBootstrapIndexInfo;
import org.apache.hudi.avro.model.HoodieBootstrapPartitionMetadata;
import org.apache.hudi.common.bootstrap.index.BootstrapIndex;
import org.apache.hudi.common.bootstrap.index.hfile.HFileBootstrapIndex;
import org.apache.hudi.common.model.BootstrapFileMapping;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.hfile.HFileContext;
import org.apache.hudi.io.hfile.HFileWriter;
import org.apache.hudi.io.hfile.HFileWriterImpl;
import org.apache.hudi.storage.StoragePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HFileBootstrapIndexWriter
extends BootstrapIndex.IndexWriter {
    private static final Logger LOG = LoggerFactory.getLogger(HFileBootstrapIndexWriter.class);
    private final String bootstrapBasePath;
    private final StoragePath indexByPartitionPath;
    private final StoragePath indexByFileIdPath;
    private HFileWriter indexByPartitionWriter;
    private HFileWriter indexByFileIdWriter;
    private boolean closed = false;
    private int numPartitionKeysAdded = 0;
    private int numFileIdKeysAdded = 0;
    private final Map<String, List<BootstrapFileMapping>> sourceFileMappings = new HashMap<String, List<BootstrapFileMapping>>();

    public HFileBootstrapIndexWriter(String bootstrapBasePath, HoodieTableMetaClient metaClient) {
        super(metaClient);
        try {
            metaClient.initializeBootstrapDirsIfNotExists();
            this.bootstrapBasePath = bootstrapBasePath;
            this.indexByPartitionPath = HFileBootstrapIndex.partitionIndexPath(metaClient);
            this.indexByFileIdPath = HFileBootstrapIndex.fileIdIndexPath(metaClient);
            if (metaClient.getStorage().exists(this.indexByPartitionPath) || metaClient.getStorage().exists(this.indexByFileIdPath)) {
                String errMsg = "Previous version of bootstrap index exists. Partition Index Path :" + this.indexByPartitionPath + ", FileId index Path :" + this.indexByFileIdPath;
                LOG.info(errMsg);
                throw new HoodieException(errMsg);
            }
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
    }

    private void writeNextPartition(String partitionPath, String bootstrapPartitionPath, List<BootstrapFileMapping> bootstrapFileMappings) {
        try {
            LOG.info("Adding bootstrap partition Index entry for partition :" + partitionPath + ", bootstrap Partition :" + bootstrapPartitionPath + ", Num Entries :" + bootstrapFileMappings.size());
            LOG.info("ADDING entries :" + bootstrapFileMappings);
            HoodieBootstrapPartitionMetadata bootstrapPartitionMetadata = new HoodieBootstrapPartitionMetadata();
            bootstrapPartitionMetadata.setBootstrapPartitionPath(bootstrapPartitionPath);
            bootstrapPartitionMetadata.setPartitionPath(partitionPath);
            bootstrapPartitionMetadata.setFileIdToBootstrapFile(bootstrapFileMappings.stream().map(m -> Pair.of(m.getFileId(), m.getBootstrapFileStatus())).collect(Collectors.toMap(Pair::getKey, Pair::getValue)));
            Option<byte[]> bytes = TimelineMetadataUtils.serializeAvroMetadata(bootstrapPartitionMetadata, HoodieBootstrapPartitionMetadata.class);
            if (bytes.isPresent()) {
                this.indexByPartitionWriter.append(HFileBootstrapIndex.getPartitionKey(partitionPath), (byte[])bytes.get());
                ++this.numPartitionKeysAdded;
            }
        }
        catch (IOException e) {
            throw new HoodieIOException(e.getMessage(), e);
        }
    }

    private void writeNextSourceFileMapping(BootstrapFileMapping mapping) {
        try {
            HoodieBootstrapFilePartitionInfo srcFilePartitionInfo = new HoodieBootstrapFilePartitionInfo();
            srcFilePartitionInfo.setPartitionPath(mapping.getPartitionPath());
            srcFilePartitionInfo.setBootstrapPartitionPath(mapping.getBootstrapPartitionPath());
            srcFilePartitionInfo.setBootstrapFileStatus(mapping.getBootstrapFileStatus());
            this.indexByFileIdWriter.append(HFileBootstrapIndex.getFileGroupKey(mapping.getFileGroupId()), (byte[])TimelineMetadataUtils.serializeAvroMetadata(srcFilePartitionInfo, HoodieBootstrapFilePartitionInfo.class).get());
            ++this.numFileIdKeysAdded;
        }
        catch (IOException e) {
            throw new HoodieIOException(e.getMessage(), e);
        }
    }

    private void commit() {
        try {
            if (!this.closed) {
                HoodieBootstrapIndexInfo partitionIndexInfo = HoodieBootstrapIndexInfo.newBuilder().setCreatedTimestamp(new Date().getTime()).setNumKeys(this.numPartitionKeysAdded).setBootstrapBasePath(this.bootstrapBasePath).build();
                LOG.info("Adding Partition FileInfo :" + (Object)((Object)partitionIndexInfo));
                HoodieBootstrapIndexInfo fileIdIndexInfo = HoodieBootstrapIndexInfo.newBuilder().setCreatedTimestamp(new Date().getTime()).setNumKeys(this.numFileIdKeysAdded).setBootstrapBasePath(this.bootstrapBasePath).build();
                LOG.info("Appending FileId FileInfo :" + (Object)((Object)fileIdIndexInfo));
                this.indexByPartitionWriter.appendFileInfo("INDEX_INFO", (byte[])TimelineMetadataUtils.serializeAvroMetadata(partitionIndexInfo, HoodieBootstrapIndexInfo.class).get());
                this.indexByFileIdWriter.appendFileInfo("INDEX_INFO", (byte[])TimelineMetadataUtils.serializeAvroMetadata(fileIdIndexInfo, HoodieBootstrapIndexInfo.class).get());
                this.close();
            }
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
    }

    @Override
    public void close() {
        try {
            if (!this.closed) {
                this.indexByPartitionWriter.close();
                this.indexByFileIdWriter.close();
                this.closed = true;
            }
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
    }

    @Override
    public void begin() {
        try {
            HFileContext context = HFileContext.builder().build();
            OutputStream outputStreamForPartitionWriter = this.metaClient.getStorage().create(this.indexByPartitionPath);
            this.indexByPartitionWriter = new HFileWriterImpl(context, outputStreamForPartitionWriter);
            OutputStream outputStreamForFileIdWriter = this.metaClient.getStorage().create(this.indexByFileIdPath);
            this.indexByFileIdWriter = new HFileWriterImpl(context, outputStreamForFileIdWriter);
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
    }

    @Override
    public void appendNextPartition(String partitionPath, List<BootstrapFileMapping> bootstrapFileMappings) {
        this.sourceFileMappings.put(partitionPath, bootstrapFileMappings);
    }

    @Override
    public void finish() {
        List<String> partitions = this.sourceFileMappings.keySet().stream().sorted().collect(Collectors.toList());
        partitions.forEach(p -> this.writeNextPartition((String)p, this.sourceFileMappings.get(p).get(0).getBootstrapPartitionPath(), this.sourceFileMappings.get(p)));
        this.sourceFileMappings.values().stream().flatMap(Collection::stream).sorted().forEach(this::writeNextSourceFileMapping);
        this.commit();
    }
}

