/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieIndexingConfig;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.metadata.MetadataPartitionType;

@ConfigClassProperty(name="Metadata Configs", groupName=ConfigGroups.Names.WRITE_CLIENT, description="Configurations used by the Hudi Metadata Table. This table maintains the metadata about a given Hudi table (e.g file listings)  to avoid overhead of accessing cloud storage, during queries.")
@Immutable
public final class HoodieMetadataConfig
extends HoodieConfig {
    public static final boolean DEFAULT_METADATA_ASYNC_CLEAN = false;
    public static final boolean DEFAULT_METADATA_ENABLE_FULL_SCAN_LOG_FILES = true;
    public static final boolean DEFAULT_METADATA_POPULATE_META_FIELDS = false;
    public static final int DEFAULT_METADATA_CLEANER_COMMITS_RETAINED = 20;
    public static final String METADATA_PREFIX = "hoodie.metadata";
    public static final String OPTIMIZED_LOG_BLOCKS_SCAN = ".optimized.log.blocks.scan.enable";
    public static final ConfigProperty<Boolean> ENABLE = ConfigProperty.key("hoodie.metadata.enable").defaultValue(true).sinceVersion("0.7.0").withDocumentation("Enable the internal metadata table which serves table metadata like level file listings");
    public static final ConfigProperty<Boolean> STREAMING_WRITE_ENABLED = ConfigProperty.key("hoodie.metadata.streaming.write.enabled").defaultValue(false).markAdvanced().sinceVersion("1.1.0").withDocumentation("Whether to enable streaming writes to metadata table or not. With streaming writes, we execute writes to both data table and metadata table in streaming manner rather than two disjoint writes. By default streaming writes to metadata table is enabled for SPARK engine for incremental operations and disabled for all other cases.");
    public static final ConfigProperty<Integer> STREAMING_WRITE_DATATABLE_WRITE_STATUSES_COALESCE_DIVISOR = ConfigProperty.key("hoodie.metadata.streaming.write.datatable.write.statuses.coalesce.divisor").defaultValue(5000).markAdvanced().sinceVersion("1.1.0").withDocumentation("When streaming writes to metadata table is enabled via hoodie.metadata.streaming.write.enabled, the data table write statuses are unioned with metadata table write statuses before triggering the entire write dag. The data table write statuses will be coalesce down to the number of write statuses divided by the specified divisor to avoid triggering thousands of no-op tasks for the data table writes which have their status cached.");
    public static final boolean DEFAULT_METADATA_ENABLE_FOR_READERS = true;
    public static final ConfigProperty<Boolean> METRICS_ENABLE = ConfigProperty.key("hoodie.metadata.metrics.enable").defaultValue(false).markAdvanced().sinceVersion("0.7.0").withDocumentation("Enable publishing of metrics around metadata table.");
    public static final ConfigProperty<Boolean> ASYNC_INDEX_ENABLE = ConfigProperty.key("hoodie.metadata.index.async").defaultValue(false).markAdvanced().sinceVersion("0.11.0").withDocumentation("Enable asynchronous indexing of metadata table.");
    public static final ConfigProperty<Integer> COMPACT_NUM_DELTA_COMMITS = ConfigProperty.key("hoodie.metadata.compact.max.delta.commits").defaultValue(10).markAdvanced().sinceVersion("0.7.0").withDocumentation("Controls how often the metadata table is compacted.");
    public static final ConfigProperty<String> ENABLE_LOG_COMPACTION_ON_METADATA_TABLE = ConfigProperty.key("hoodie.metadata.log.compaction.enable").defaultValue("false").markAdvanced().sinceVersion("0.14.0").withDocumentation("This configs enables logcompaction for the metadata table.");
    public static final ConfigProperty<Integer> LOG_COMPACT_BLOCKS_THRESHOLD = ConfigProperty.key("hoodie.metadata.log.compaction.blocks.threshold").defaultValue(5).markAdvanced().sinceVersion("0.14.0").withDocumentation("Controls the criteria to log compacted files groups in metadata table.");
    public static final ConfigProperty<String> DIR_FILTER_REGEX = ConfigProperty.key("hoodie.metadata.dir.filter.regex").defaultValue("").markAdvanced().sinceVersion("0.7.0").withDocumentation("Directories matching this regex, will be filtered out when initializing metadata table from lake storage for the first time.");
    public static final ConfigProperty<Integer> FILE_LISTING_PARALLELISM_VALUE = ConfigProperty.key("hoodie.file.listing.parallelism").defaultValue(200).markAdvanced().sinceVersion("0.7.0").withDocumentation("Parallelism to use, when listing the table on lake storage.");
    public static final ConfigProperty<Boolean> ENABLE_METADATA_INDEX_BLOOM_FILTER = ConfigProperty.key("hoodie.metadata.index.bloom.filter.enable").defaultValue(false).sinceVersion("0.11.0").withDocumentation("Enable indexing bloom filters of user data files under metadata table. When enabled, metadata table will have a partition to store the bloom filter index and will be used during the index lookups.");
    public static final ConfigProperty<Integer> METADATA_INDEX_BLOOM_FILTER_FILE_GROUP_COUNT = ConfigProperty.key("hoodie.metadata.index.bloom.filter.file.group.count").defaultValue(4).markAdvanced().sinceVersion("0.11.0").withDocumentation("Metadata bloom filter index partition file group count. This controls the size of the base and log files and read parallelism in the bloom filter index partition. The recommendation is to size the file group count such that the base files are under 1GB.");
    public static final ConfigProperty<Integer> BLOOM_FILTER_INDEX_PARALLELISM = ConfigProperty.key("hoodie.metadata.index.bloom.filter.parallelism").defaultValue(200).markAdvanced().sinceVersion("0.11.0").withDocumentation("Parallelism to use for generating bloom filter index in metadata table.");
    public static final ConfigProperty<Boolean> ENABLE_METADATA_INDEX_COLUMN_STATS = ConfigProperty.key("hoodie.metadata.index.column.stats.enable").defaultValue(false).sinceVersion("0.11.0").withDocumentation("Enable indexing column ranges of user data files under metadata table key lookups. When enabled, metadata table will have a partition to store the column ranges and will be used for pruning files during the index lookups.");
    public static final ConfigProperty<Integer> METADATA_INDEX_COLUMN_STATS_FILE_GROUP_COUNT = ConfigProperty.key("hoodie.metadata.index.column.stats.file.group.count").defaultValue(2).markAdvanced().sinceVersion("0.11.0").withDocumentation("Metadata column stats partition file group count. This controls the size of the base and log files and read parallelism in the column stats index partition. The recommendation is to size the file group count such that the base files are under 1GB.");
    public static final ConfigProperty<Integer> COLUMN_STATS_INDEX_PARALLELISM = ConfigProperty.key("hoodie.metadata.index.column.stats.parallelism").defaultValue(200).markAdvanced().sinceVersion("0.11.0").withDocumentation("Parallelism to use, when generating column stats index.");
    public static final ConfigProperty<String> COLUMN_STATS_INDEX_FOR_COLUMNS = ConfigProperty.key("hoodie.metadata.index.column.stats.column.list").noDefaultValue().markAdvanced().sinceVersion("0.11.0").withDocumentation("Comma-separated list of columns for which column stats index will be built. If not set, all columns will be indexed");
    public static final ConfigProperty<Integer> COLUMN_STATS_INDEX_MAX_COLUMNS = ConfigProperty.key("hoodie.metadata.index.column.stats.max.columns.to.index").defaultValue(32).markAdvanced().sinceVersion("1.0.0").withDocumentation("Maximum number of columns to generate column stats for. If the config `" + COLUMN_STATS_INDEX_FOR_COLUMNS.key() + "` is set, this config will be ignored. If the config `" + COLUMN_STATS_INDEX_FOR_COLUMNS.key() + "` is not set, the column stats of the first `n` columns (`n` defined by this config) in the table schema are generated.");
    public static final String COLUMN_STATS_INDEX_PROCESSING_MODE_IN_MEMORY = "in-memory";
    public static final String COLUMN_STATS_INDEX_PROCESSING_MODE_ENGINE = "engine";
    public static final ConfigProperty<String> COLUMN_STATS_INDEX_PROCESSING_MODE_OVERRIDE = ConfigProperty.key("hoodie.metadata.index.column.stats.processing.mode.override").noDefaultValue().withValidValues("in-memory", "engine").markAdvanced().sinceVersion("0.12.0").withDocumentation("By default Column Stats Index is automatically determining whether it should be read and processed either'in-memory' (w/in executing process) or using Spark (on a cluster), based on some factors like the size of the Index and how many columns are read. This config allows to override this behavior.");
    public static final ConfigProperty<Integer> COLUMN_STATS_INDEX_IN_MEMORY_PROJECTION_THRESHOLD = ConfigProperty.key("hoodie.metadata.index.column.stats.inMemory.projection.threshold").defaultValue(100000).markAdvanced().sinceVersion("0.12.0").withDocumentation("When reading Column Stats Index, if the size of the expected resulting projection is below the in-memory threshold (counted by the # of rows), it will be attempted to be loaded \"in-memory\" (ie not using the execution engine like Spark, Flink, etc). If the value is above the threshold execution engine will be used to compose the projection.");
    public static final ConfigProperty<String> BLOOM_FILTER_INDEX_FOR_COLUMNS = ConfigProperty.key("hoodie.metadata.index.bloom.filter.column.list").noDefaultValue().markAdvanced().sinceVersion("0.11.0").withDocumentation("Comma-separated list of columns for which bloom filter index will be built. If not set, only record key will be indexed.");
    public static final ConfigProperty<Integer> METADATA_INDEX_CHECK_TIMEOUT_SECONDS = ConfigProperty.key("hoodie.metadata.index.check.timeout.seconds").defaultValue(900).markAdvanced().sinceVersion("0.11.0").withDocumentation("After the async indexer has finished indexing upto the base instant, it will ensure that all inflight writers reliably write index updates as well. If this timeout expires, then the indexer will abort itself safely.");
    public static final ConfigProperty<Boolean> IGNORE_SPURIOUS_DELETES = ConfigProperty.key("_hoodie.metadata.ignore.spurious.deletes").defaultValue(true).markAdvanced().sinceVersion("0.10.0").withDocumentation("There are cases when extra files are requested to be deleted from metadata table which are never added before. This config determines how to handle such spurious deletes");
    public static final ConfigProperty<Boolean> ENABLE_OPTIMIZED_LOG_BLOCKS_SCAN = ConfigProperty.key("hoodie.metadata.optimized.log.blocks.scan.enable").defaultValue(false).markAdvanced().sinceVersion("0.13.0").withDocumentation("Optimized log blocks scanner that addresses all the multi-writer use-cases while appending to log files. It also differentiates original blocks written by ingestion writers and compacted blocks written by log compaction.");
    public static final ConfigProperty<Integer> METADATA_MAX_NUM_DELTACOMMITS_WHEN_PENDING = ConfigProperty.key("hoodie.metadata.max.deltacommits.when_pending").defaultValue(1000).markAdvanced().sinceVersion("0.14.0").withDocumentation("When there is a pending instant in data table, this config limits the allowed number of deltacommits in metadata table to prevent the metadata table's timeline from growing unboundedly as compaction won't be triggered due to the pending data table instant.");
    public static final ConfigProperty<Boolean> GLOBAL_RECORD_LEVEL_INDEX_ENABLE_PROP = ConfigProperty.key("hoodie.metadata.global.record.level.index.enable").defaultValue(false).withAlternatives("hoodie.metadata.record.index.enable").markAdvanced().sinceVersion("0.14.0").withDocumentation("Create the HUDI Record Index within the Metadata Table");
    public static final ConfigProperty<Boolean> RECORD_LEVEL_INDEX_ENABLE_PROP = ConfigProperty.key("hoodie.metadata.record.level.index.enable").defaultValue(false).markAdvanced().sinceVersion("1.1.0").withDocumentation("Create the HUDI Record Index within the Metadata Table for a partitioned dataset where a pair of partition path and record key is unique across the entire table");
    public static final ConfigProperty<Integer> GLOBAL_RECORD_LEVEL_INDEX_MIN_FILE_GROUP_COUNT_PROP = ConfigProperty.key("hoodie.metadata.global.record.level.index.min.filegroup.count").defaultValue(10).withAlternatives("hoodie.metadata.record.index.min.filegroup.count").markAdvanced().sinceVersion("0.14.0").withDocumentation("Minimum number of file groups to use for Record Index.");
    public static final ConfigProperty<Integer> GLOBAL_RECORD_LEVEL_INDEX_MAX_FILE_GROUP_COUNT_PROP = ConfigProperty.key("hoodie.metadata.global.record.level.index.max.filegroup.count").defaultValue(10000).withAlternatives("hoodie.metadata.record.index.max.filegroup.count").markAdvanced().sinceVersion("0.14.0").withDocumentation("Maximum number of file groups to use for Record Index.");
    public static final ConfigProperty<Integer> RECORD_LEVEL_INDEX_MIN_FILE_GROUP_COUNT_PROP = ConfigProperty.key("hoodie.metadata.record.level.index.min.filegroup.count").defaultValue(1).withAlternatives("hoodie.metadata.partitioned.record.index.min.filegroup.count").markAdvanced().sinceVersion("1.1.0").withDocumentation("Minimum number of file groups to use for Partitioned Record Index.");
    public static final ConfigProperty<Integer> RECORD_LEVEL_INDEX_MAX_FILE_GROUP_COUNT_PROP = ConfigProperty.key("hoodie.metadata.record.level.index.max.filegroup.count").defaultValue(10).withAlternatives("hoodie.metadata.partitioned.record.index.max.filegroup.count").markAdvanced().sinceVersion("1.1.0").withDocumentation("Maximum number of file groups to use for Partitioned Record Index.");
    public static final ConfigProperty<Integer> RECORD_INDEX_MAX_FILE_GROUP_SIZE_BYTES_PROP = ConfigProperty.key("hoodie.metadata.record.index.max.filegroup.size").defaultValue(0x40000000).markAdvanced().sinceVersion("0.14.0").withDocumentation("Maximum size in bytes of a single file group. Large file group takes longer to compact.");
    public static final ConfigProperty<Float> RECORD_INDEX_GROWTH_FACTOR_PROP = ConfigProperty.key("hoodie.metadata.record.index.growth.factor").defaultValue(Float.valueOf(2.0f)).markAdvanced().sinceVersion("0.14.0").withDocumentation("The current number of records are multiplied by this number when estimating the number of file groups to create automatically. This helps account for growth in the number of records in the dataset.");
    public static final ConfigProperty<Integer> RECORD_INDEX_MAX_PARALLELISM = ConfigProperty.key("hoodie.metadata.max.init.parallelism").defaultValue(100000).markAdvanced().sinceVersion("0.14.0").withDocumentation("Maximum parallelism to use when initializing Record Index.");
    public static final ConfigProperty<Long> MAX_READER_MEMORY_PROP = ConfigProperty.key("hoodie.metadata.max.reader.memory").defaultValue(0x40000000L).markAdvanced().sinceVersion("0.14.0").withDocumentation("Max memory to use for the reader to read from metadata");
    public static final ConfigProperty<Integer> MAX_READER_BUFFER_SIZE_PROP = ConfigProperty.key("hoodie.metadata.max.reader.buffer.size").defaultValue(0xA00000).markAdvanced().sinceVersion("0.14.0").withDocumentation("Max memory to use for the reader buffer while merging log blocks");
    public static final ConfigProperty<String> SPILLABLE_MAP_DIR_PROP = ConfigProperty.key("hoodie.metadata.spillable.map.path").noDefaultValue().withInferFunction(cfg -> Option.of((Object)cfg.getStringOrDefault(FileSystemViewStorageConfig.SPILLABLE_DIR))).markAdvanced().sinceVersion("0.14.0").withDocumentation("Path on local storage to use, when keys read from metadata are held in a spillable map.");
    public static final ConfigProperty<Long> MAX_LOG_FILE_SIZE_BYTES_PROP = ConfigProperty.key("hoodie.metadata.max.logfile.size").defaultValue(0x80000000L).markAdvanced().sinceVersion("0.14.0").withDocumentation("Maximum size in bytes of a single log file. Larger log files can contain larger log blocks thereby reducing the number of blocks to search for keys");
    public static final ConfigProperty<Boolean> AUTO_INITIALIZE = ConfigProperty.key("hoodie.metadata.auto.initialize").defaultValue(true).sinceVersion("0.14.0").markAdvanced().withDocumentation("Initializes the metadata table by reading from the file system when the table is first created. Enabled by default. Warning: This should only be disabled when manually constructing the metadata table outside of typical Hudi writer flows.");
    public static final ConfigProperty<Boolean> EXPRESSION_INDEX_ENABLE_PROP = ConfigProperty.key("hoodie.metadata.index.expression.enable").defaultValue(false).sinceVersion("1.0.0").withDocumentation("Enable expression index within the metadata table.  When this configuration property is enabled (`true`), the Hudi writer automatically  keeps all expression indexes consistent with the data table.  When disabled (`false`), all expression indexes are deleted.  Note that individual expression index can only be created through a `CREATE INDEX`  and deleted through a `DROP INDEX` statement in Spark SQL.");
    public static final ConfigProperty<Integer> EXPRESSION_INDEX_FILE_GROUP_COUNT = ConfigProperty.key("hoodie.metadata.index.expression.file.group.count").defaultValue(2).markAdvanced().sinceVersion("1.0.0").withDocumentation("Metadata expression index partition file group count.");
    public static final ConfigProperty<Integer> EXPRESSION_INDEX_PARALLELISM = ConfigProperty.key("hoodie.metadata.index.expression.parallelism").defaultValue(200).markAdvanced().sinceVersion("1.0.0").withDocumentation("Parallelism to use, when generating expression index.");
    public static final ConfigProperty<String> EXPRESSION_INDEX_COLUMN = ConfigProperty.key("hoodie.metadata.index.expression.column").noDefaultValue().markAdvanced().sinceVersion("1.0.1").withDocumentation("Column for which expression index will be built.");
    public static final ConfigProperty<String> EXPRESSION_INDEX_NAME = HoodieIndexingConfig.INDEX_NAME;
    public static final ConfigProperty<String> EXPRESSION_INDEX_TYPE = HoodieIndexingConfig.INDEX_TYPE;
    public static final ConfigProperty<String> EXPRESSION_INDEX_OPTIONS = ConfigProperty.key("hoodie.metadata.index.expression.options").noDefaultValue().markAdvanced().sinceVersion("1.0.1").withDocumentation("Options for the expression index, e.g. \"expr='from_unixtime', format='yyyy-MM-dd'\"");
    public static final ConfigProperty<Integer> METADATA_INDEX_PARTITION_STATS_FILE_GROUP_COUNT = ConfigProperty.key("hoodie.metadata.index.partition.stats.file.group.count").defaultValue(1).markAdvanced().sinceVersion("1.0.0").withDocumentation("Metadata partition stats file group count. This controls the size of the base and log files and read parallelism in the partition stats index.");
    public static final ConfigProperty<Integer> PARTITION_STATS_INDEX_PARALLELISM = ConfigProperty.key("hoodie.metadata.index.partition.stats.parallelism").defaultValue(200).markAdvanced().sinceVersion("1.0.0").withDocumentation("Parallelism to use, when generating partition stats index.");
    public static final ConfigProperty<Boolean> SECONDARY_INDEX_ENABLE_PROP = ConfigProperty.key("hoodie.metadata.index.secondary.enable").defaultValue(true).sinceVersion("1.0.0").withDocumentation("Enable secondary index within the metadata table.  When this configuration property is enabled (`true`), the Hudi writer automatically  keeps all secondary indexes consistent with the data table.  When disabled (`false`), all secondary indexes are deleted.  Note that individual secondary index can only be created through a `CREATE INDEX`  and deleted through a `DROP INDEX` statement in Spark SQL. ");
    public static final ConfigProperty<Integer> SECONDARY_INDEX_PARALLELISM = ConfigProperty.key("hoodie.metadata.index.secondary.parallelism").defaultValue(200).markAdvanced().sinceVersion("1.0.0").withDocumentation("Parallelism to use, when generating secondary index.");
    public static final ConfigProperty<String> SECONDARY_INDEX_NAME = HoodieIndexingConfig.INDEX_NAME;
    public static final ConfigProperty<String> SECONDARY_INDEX_COLUMN = ConfigProperty.key("hoodie.metadata.index.secondary.column").noDefaultValue().markAdvanced().sinceVersion("1.0.1").withDocumentation("Column for which secondary index will be built.");
    public static final ConfigProperty<String> DROP_METADATA_INDEX = ConfigProperty.key("hoodie.metadata.index.drop").noDefaultValue().sinceVersion("1.0.1").withDocumentation("Drop the specified index. The value should be the name of the index to delete. You can check index names using `SHOW INDEXES` command. The index name either starts with or matches exactly can be one of the following: " + StringUtils.join(Arrays.stream(MetadataPartitionType.values()).map(MetadataPartitionType::getPartitionPath).collect(Collectors.toList()), (String)", "));
    public static final ConfigProperty<Double> RANGE_REPARTITION_SAMPLING_FRACTION = ConfigProperty.key("hoodie.metadata.range.repartition.sampling.fraction").defaultValue(0.01).markAdvanced().sinceVersion("1.1.0").withDocumentation("Sampling fraction used for range-based repartitioning during metadata table lookups. This controls the accuracy vs performance trade-off for key distribution sampling.");
    public static final ConfigProperty<Integer> RANGE_REPARTITION_TARGET_RECORDS_PER_PARTITION = ConfigProperty.key("hoodie.metadata.range.repartition.target.records.per.partition").defaultValue(10000).markAdvanced().sinceVersion("1.1.0").withDocumentation("Target number of records per partition during range-based repartitioning. This helps control the size of each partition for optimal processing.");
    public static final ConfigProperty<Integer> RANGE_REPARTITION_RANDOM_SEED = ConfigProperty.key("hoodie.metadata.range.repartition.random.seed").defaultValue(42).markAdvanced().sinceVersion("1.1.0").withDocumentation("Random seed used for sampling during range-based repartitioning. This ensures reproducible results across runs.");
    public static final ConfigProperty<Integer> REPARTITION_MIN_PARTITIONS_THRESHOLD = ConfigProperty.key("hoodie.metadata.repartition.min.partitions.threshold").defaultValue(100).markAdvanced().sinceVersion("1.1.0").withDocumentation("Minimum number of partitions threshold below which repartitioning is triggered. When the number of partitions is below this threshold, data will be repartitioned for better parallelism.");
    public static final ConfigProperty<Integer> REPARTITION_DEFAULT_PARTITIONS = ConfigProperty.key("hoodie.metadata.repartition.default.partitions").defaultValue(200).markAdvanced().sinceVersion("1.1.0").withDocumentation("Default number of partitions to use when repartitioning is needed. This provides a reasonable level of parallelism for metadata table operations.");
    public static final ConfigProperty<Integer> METADATA_FILE_CACHE_MAX_SIZE_MB = ConfigProperty.key("hoodie.metadata.file.cache.max.size.mb").defaultValue(50).markAdvanced().sinceVersion("1.1.0").withDocumentation("Max size in MB below which metadata file (HFile) will be downloaded and cached entirely for the HFileReader.");
    public static final ConfigProperty<Boolean> BLOOM_FILTER_ENABLE = ConfigProperty.key("hoodie.metadata.bloom.filter.enable").defaultValue(false).markAdvanced().sinceVersion("1.1.0").withDocumentation("Whether to use bloom filter in the files for lookup in the metadata table.");
    public static final ConfigProperty<String> BLOOM_FILTER_TYPE = ConfigProperty.key("hoodie.metadata.bloom.filter.type").defaultValue(BloomFilterTypeCode.DYNAMIC_V0.name()).withValidValues(BloomFilterTypeCode.SIMPLE.name(), BloomFilterTypeCode.DYNAMIC_V0.name()).markAdvanced().sinceVersion("1.1.0").withDocumentation(BloomFilterTypeCode.class, "Bloom filter type for the files in the metadata table");
    public static final ConfigProperty<String> BLOOM_FILTER_NUM_ENTRIES = ConfigProperty.key("hoodie.metadata.bloom.filter.num.entries").defaultValue("10000").markAdvanced().sinceVersion("1.1.0").withDocumentation("This is the number of entries stored in a bloom filter for the files in the metadata table. The rationale for the default: 10000 is chosen to be a good tradeoff between false positive rate and storage size. Warning: Setting this very low generates a lot of false positives and the metadata table reading has to scan a lot more files than it has to and setting this to a very high number increases the size every base file linearly (roughly 4KB for every 50000 entries). This config is also used with DYNAMIC bloom filter which determines the initial size for the bloom.");
    public static final ConfigProperty<String> BLOOM_FILTER_FPP = ConfigProperty.key("hoodie.metadata.bloom.filter.fpp").defaultValue("0.000000001").markAdvanced().sinceVersion("1.1.0").withDocumentation("Expected probability a false positive in a bloom filter for the files in the metadata table. This is used to calculate how many bits should be assigned for the bloom filter and the number of hash functions. This is usually set very low (default: 0.000000001), we like to tradeoff disk space for lower false positives. If the number of entries added to bloom filter exceeds the configured value (hoodie.metadata.bloom.num_entries), then this fpp may not be honored.");
    public static final ConfigProperty<String> BLOOM_FILTER_DYNAMIC_MAX_ENTRIES = ConfigProperty.key("hoodie.metadata.bloom.filter.dynamic.max.entries").defaultValue("100000").markAdvanced().sinceVersion("1.1.0").withDocumentation("The threshold for the maximum number of keys to record in a dynamic bloom filter row for the files in the metadata table. Only applies if the filter type (" + BLOOM_FILTER_TYPE.key() + " ) is BloomFilterTypeCode.DYNAMIC_V0.");
    public static final ConfigProperty<Integer> RECORD_PREPARATION_PARALLELISM = ConfigProperty.key("hoodie.metadata.record.preparation.parallelism").defaultValue(0).markAdvanced().sinceVersion("1.1.0").withDocumentation("when set to positive number, metadata table record preparation stages honor the set value for number of tasks. If not, number of write status's from data table writes will be used for metadata table record preparation");
    @Deprecated
    public static final String ENABLE_METADATA_INDEX_PARTITION_STATS = "hoodie.metadata.index.partition.stats.enable";
    @Deprecated
    public static final String METADATA_ENABLE_PROP = ENABLE.key();
    @Deprecated
    public static final boolean DEFAULT_METADATA_ENABLE = ENABLE.defaultValue();
    @Deprecated
    public static final String METADATA_METRICS_ENABLE_PROP = METRICS_ENABLE.key();
    @Deprecated
    public static final boolean DEFAULT_METADATA_METRICS_ENABLE = METRICS_ENABLE.defaultValue();
    @Deprecated
    public static final String METADATA_COMPACT_NUM_DELTA_COMMITS_PROP = COMPACT_NUM_DELTA_COMMITS.key();
    @Deprecated
    public static final int DEFAULT_METADATA_COMPACT_NUM_DELTA_COMMITS = COMPACT_NUM_DELTA_COMMITS.defaultValue();
    @Deprecated
    public static final String ENABLE_FALLBACK_PROP = "hoodie.metadata.fallback.enable";
    @Deprecated
    public static final String DEFAULT_ENABLE_FALLBACK = "true";
    @Deprecated
    public static final String DIRECTORY_FILTER_REGEX = DIR_FILTER_REGEX.key();
    @Deprecated
    public static final String DEFAULT_DIRECTORY_FILTER_REGEX = DIR_FILTER_REGEX.defaultValue();
    @Deprecated
    public static final String FILE_LISTING_PARALLELISM_PROP = FILE_LISTING_PARALLELISM_VALUE.key();
    @Deprecated
    public static final int DEFAULT_FILE_LISTING_PARALLELISM = FILE_LISTING_PARALLELISM_VALUE.defaultValue();

    public long getMaxLogFileSize() {
        return this.getLong(MAX_LOG_FILE_SIZE_BYTES_PROP);
    }

    private HoodieMetadataConfig() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int getFileListingParallelism() {
        return Math.max(this.getInt(FILE_LISTING_PARALLELISM_VALUE), 1);
    }

    public boolean isEnabled() {
        return this.getBoolean(ENABLE);
    }

    public boolean isStreamingWriteEnabled() {
        return this.getBoolean(STREAMING_WRITE_ENABLED);
    }

    public int getStreamingWritesCoalesceDivisorForDataTableWrites() {
        return this.getInt(STREAMING_WRITE_DATATABLE_WRITE_STATUSES_COALESCE_DIVISOR);
    }

    public boolean isBloomFilterIndexEnabled() {
        return this.getBooleanOrDefault(ENABLE_METADATA_INDEX_BLOOM_FILTER);
    }

    public boolean isColumnStatsIndexEnabled() {
        return this.getBooleanOrDefault(ENABLE_METADATA_INDEX_COLUMN_STATS);
    }

    public boolean isGlobalRecordLevelIndexEnabled() {
        return this.isEnabled() && this.getBooleanOrDefault(GLOBAL_RECORD_LEVEL_INDEX_ENABLE_PROP);
    }

    public boolean isRecordLevelIndexEnabled() {
        return this.isEnabled() && this.getBooleanOrDefault(RECORD_LEVEL_INDEX_ENABLE_PROP);
    }

    public List<String> getColumnsEnabledForColumnStatsIndex() {
        return StringUtils.split((String)this.getString(COLUMN_STATS_INDEX_FOR_COLUMNS), (String)",");
    }

    public Integer maxColumnsToIndexForColStats() {
        return this.getIntOrDefault(COLUMN_STATS_INDEX_MAX_COLUMNS);
    }

    public String getColumnStatsIndexProcessingModeOverride() {
        return this.getString(COLUMN_STATS_INDEX_PROCESSING_MODE_OVERRIDE);
    }

    public Integer getColumnStatsIndexInMemoryProjectionThreshold() {
        return this.getIntOrDefault(COLUMN_STATS_INDEX_IN_MEMORY_PROJECTION_THRESHOLD);
    }

    public List<String> getColumnsEnabledForBloomFilterIndex() {
        return StringUtils.split((String)this.getString(BLOOM_FILTER_INDEX_FOR_COLUMNS), (String)",");
    }

    public int getBloomFilterIndexFileGroupCount() {
        return this.getIntOrDefault(METADATA_INDEX_BLOOM_FILTER_FILE_GROUP_COUNT);
    }

    public int getColumnStatsIndexFileGroupCount() {
        return this.getIntOrDefault(METADATA_INDEX_COLUMN_STATS_FILE_GROUP_COUNT);
    }

    public int getBloomFilterIndexParallelism() {
        return this.getIntOrDefault(BLOOM_FILTER_INDEX_PARALLELISM);
    }

    public int getColumnStatsIndexParallelism() {
        return this.getIntOrDefault(COLUMN_STATS_INDEX_PARALLELISM);
    }

    public int getIndexingCheckTimeoutSeconds() {
        return this.getIntOrDefault(METADATA_INDEX_CHECK_TIMEOUT_SECONDS);
    }

    public boolean isMetricsEnabled() {
        return this.getBoolean(METRICS_ENABLE);
    }

    public String getDirectoryFilterRegex() {
        return this.getString(DIR_FILTER_REGEX);
    }

    public boolean shouldIgnoreSpuriousDeletes() {
        return this.getBoolean(IGNORE_SPURIOUS_DELETES);
    }

    public boolean isOptimizedLogBlocksScanEnabled() {
        return this.getBoolean(ENABLE_OPTIMIZED_LOG_BLOCKS_SCAN);
    }

    public int getMaxNumDeltacommitsWhenPending() {
        return this.getIntOrDefault(METADATA_MAX_NUM_DELTACOMMITS_WHEN_PENDING);
    }

    public int getGlobalRecordLevelIndexMinFileGroupCount() {
        return this.getInt(GLOBAL_RECORD_LEVEL_INDEX_MIN_FILE_GROUP_COUNT_PROP);
    }

    public int getRecordLevelIndexMinFileGroupCount() {
        return this.getInt(RECORD_LEVEL_INDEX_MIN_FILE_GROUP_COUNT_PROP);
    }

    public int getGlobalRecordLevelIndexMaxFileGroupCount() {
        return this.getInt(GLOBAL_RECORD_LEVEL_INDEX_MAX_FILE_GROUP_COUNT_PROP);
    }

    public int getRecordLevelIndexMaxFileGroupCount() {
        return this.getInt(RECORD_LEVEL_INDEX_MAX_FILE_GROUP_COUNT_PROP);
    }

    public float getRecordIndexGrowthFactor() {
        return this.getFloat(RECORD_INDEX_GROWTH_FACTOR_PROP).floatValue();
    }

    public int getRecordIndexMaxFileGroupSizeBytes() {
        return this.getInt(RECORD_INDEX_MAX_FILE_GROUP_SIZE_BYTES_PROP);
    }

    public String getSplliableMapDir() {
        return this.getString(SPILLABLE_MAP_DIR_PROP);
    }

    public long getMaxReaderMemory() {
        return this.getLong(MAX_READER_MEMORY_PROP);
    }

    public int getMaxReaderBufferSize() {
        return this.getInt(MAX_READER_BUFFER_SIZE_PROP);
    }

    public int getRecordIndexMaxParallelism() {
        return this.getInt(RECORD_INDEX_MAX_PARALLELISM);
    }

    public boolean shouldAutoInitialize() {
        return this.getBoolean(AUTO_INITIALIZE);
    }

    public boolean isExpressionIndexEnabled() {
        return this.getBooleanOrDefault(EXPRESSION_INDEX_ENABLE_PROP) && !this.isDropMetadataIndex(MetadataPartitionType.EXPRESSION_INDEX.getPartitionPath());
    }

    public int getExpressionIndexFileGroupCount() {
        return this.getInt(EXPRESSION_INDEX_FILE_GROUP_COUNT);
    }

    public int getExpressionIndexParallelism() {
        return this.getInt(EXPRESSION_INDEX_PARALLELISM);
    }

    public String getExpressionIndexColumn() {
        return this.getString(EXPRESSION_INDEX_COLUMN);
    }

    public String getExpressionIndexName() {
        return this.getString(EXPRESSION_INDEX_NAME);
    }

    public String getExpressionIndexType() {
        return this.getString(EXPRESSION_INDEX_TYPE);
    }

    public Map<String, String> getExpressionIndexOptions() {
        return this.getExpressionIndexOptions(this.getString(EXPRESSION_INDEX_OPTIONS));
    }

    public boolean enableBloomFilter() {
        return this.getBooleanOrDefault(BLOOM_FILTER_ENABLE);
    }

    public String getBloomFilterType() {
        return this.getStringOrDefault(BLOOM_FILTER_TYPE);
    }

    public int getBloomFilterNumEntries() {
        return this.getIntOrDefault(BLOOM_FILTER_NUM_ENTRIES);
    }

    public double getBloomFilterFpp() {
        return this.getDoubleOrDefault(BLOOM_FILTER_FPP);
    }

    public int getDynamicBloomFilterMaxNumEntries() {
        return this.getIntOrDefault(BLOOM_FILTER_DYNAMIC_MAX_ENTRIES);
    }

    private Map<String, String> getExpressionIndexOptions(String configValue) {
        String[] keyValuePairs;
        HashMap<String, String> optionsMap = new HashMap<String, String>();
        if (StringUtils.isNullOrEmpty((String)configValue)) {
            return optionsMap;
        }
        for (String pair : keyValuePairs = configValue.split(",")) {
            String[] keyValue = pair.split("=", 2);
            if (keyValue.length != 2) {
                throw new IllegalArgumentException("Invalid key-value pair: " + pair);
            }
            optionsMap.put(keyValue[0].trim(), keyValue[1].trim());
        }
        return optionsMap;
    }

    public boolean isPartitionStatsIndexEnabled() {
        return this.getBooleanOrDefault(ENABLE_METADATA_INDEX_COLUMN_STATS);
    }

    public int getPartitionStatsIndexFileGroupCount() {
        return this.getInt(METADATA_INDEX_PARTITION_STATS_FILE_GROUP_COUNT);
    }

    public int getPartitionStatsIndexParallelism() {
        return this.getInt(PARTITION_STATS_INDEX_PARALLELISM);
    }

    public boolean isSecondaryIndexEnabled() {
        return this.isGlobalRecordLevelIndexEnabled() && this.getBoolean(SECONDARY_INDEX_ENABLE_PROP) != false && StringUtils.nonEmpty((String)this.getSecondaryIndexColumn()) && !this.isDropMetadataIndex(MetadataPartitionType.SECONDARY_INDEX.getPartitionPath());
    }

    public int getSecondaryIndexParallelism() {
        return this.getInt(SECONDARY_INDEX_PARALLELISM);
    }

    public String getSecondaryIndexColumn() {
        return this.getString(SECONDARY_INDEX_COLUMN);
    }

    public String getSecondaryIndexName() {
        return this.getString(SECONDARY_INDEX_NAME);
    }

    public String getMetadataIndexToDrop() {
        return this.getString(DROP_METADATA_INDEX);
    }

    public double getRangeRepartitionSamplingFraction() {
        return this.getDouble(RANGE_REPARTITION_SAMPLING_FRACTION);
    }

    public int getRangeRepartitionTargetRecordsPerPartition() {
        return this.getInt(RANGE_REPARTITION_TARGET_RECORDS_PER_PARTITION);
    }

    public int getRangeRepartitionRandomSeed() {
        return this.getInt(RANGE_REPARTITION_RANDOM_SEED);
    }

    public int getRepartitionMinPartitionsThreshold() {
        return this.getInt(REPARTITION_MIN_PARTITIONS_THRESHOLD);
    }

    public int getRepartitionDefaultPartitions() {
        return this.getInt(REPARTITION_DEFAULT_PARTITIONS);
    }

    public int getFileCacheMaxSizeMB() {
        return this.getInt(METADATA_FILE_CACHE_MAX_SIZE_MB);
    }

    public int getRecordPreparationParallelism() {
        return this.getIntOrDefault(RECORD_PREPARATION_PARALLELISM);
    }

    public boolean isDropMetadataIndex(String indexName) {
        String subIndexNameToDrop = this.getMetadataIndexToDrop();
        if (StringUtils.isNullOrEmpty((String)subIndexNameToDrop)) {
            return false;
        }
        if (StringUtils.isNullOrEmpty((String)indexName)) {
            return false;
        }
        ValidationUtils.checkArgument((indexName.startsWith("expr_index_") || indexName.startsWith("secondary_index_") ? 1 : 0) != 0, (String)("Unexpected index name to drop: " + indexName));
        return subIndexNameToDrop.contains(indexName);
    }

    public static class Builder {
        private EngineType engineType = EngineType.SPARK;
        private final HoodieMetadataConfig metadataConfig = new HoodieMetadataConfig();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.metadataConfig.getProps().load(reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromProperties(Properties props) {
            this.metadataConfig.getProps().putAll((Map<?, ?>)props);
            return this;
        }

        public Builder enable(boolean enable) {
            this.metadataConfig.setValue(ENABLE, String.valueOf(enable));
            return this;
        }

        public Builder withStreamingWriteEnabled(boolean enabled) {
            this.metadataConfig.setValue(STREAMING_WRITE_ENABLED, String.valueOf(enabled));
            return this;
        }

        public Builder withMetadataIndexBloomFilter(boolean enable) {
            this.metadataConfig.setValue(ENABLE_METADATA_INDEX_BLOOM_FILTER, String.valueOf(enable));
            return this;
        }

        public Builder withMetadataIndexBloomFilterFileGroups(int fileGroupCount) {
            this.metadataConfig.setValue(METADATA_INDEX_BLOOM_FILTER_FILE_GROUP_COUNT, String.valueOf(fileGroupCount));
            return this;
        }

        public Builder withBloomFilterIndexParallelism(int parallelism) {
            this.metadataConfig.setValue(BLOOM_FILTER_INDEX_PARALLELISM, String.valueOf(parallelism));
            return this;
        }

        public Builder withMetadataIndexColumnStats(boolean enable) {
            this.metadataConfig.setValue(ENABLE_METADATA_INDEX_COLUMN_STATS, String.valueOf(enable));
            return this;
        }

        public Builder withMetadataIndexColumnStatsFileGroupCount(int fileGroupCount) {
            this.metadataConfig.setValue(METADATA_INDEX_COLUMN_STATS_FILE_GROUP_COUNT, String.valueOf(fileGroupCount));
            return this;
        }

        public Builder withColumnStatsIndexParallelism(int parallelism) {
            this.metadataConfig.setValue(COLUMN_STATS_INDEX_PARALLELISM, String.valueOf(parallelism));
            return this;
        }

        public Builder withColumnStatsIndexForColumns(String columns) {
            this.metadataConfig.setValue(COLUMN_STATS_INDEX_FOR_COLUMNS, columns);
            return this;
        }

        public Builder withMaxColumnsToIndexForColStats(int maxCols) {
            this.metadataConfig.setValue(COLUMN_STATS_INDEX_MAX_COLUMNS, String.valueOf(maxCols));
            return this;
        }

        public Builder withBloomFilterIndexForColumns(String columns) {
            this.metadataConfig.setValue(BLOOM_FILTER_INDEX_FOR_COLUMNS, columns);
            return this;
        }

        public Builder withIndexingCheckTimeout(int timeoutInSeconds) {
            this.metadataConfig.setValue(METADATA_INDEX_CHECK_TIMEOUT_SECONDS, String.valueOf(timeoutInSeconds));
            return this;
        }

        public Builder enableMetrics(boolean enableMetrics) {
            this.metadataConfig.setValue(METRICS_ENABLE, String.valueOf(enableMetrics));
            return this;
        }

        public Builder withAsyncIndex(boolean asyncIndex) {
            this.metadataConfig.setValue(ASYNC_INDEX_ENABLE, String.valueOf(asyncIndex));
            return this;
        }

        public Builder withMaxNumDeltaCommitsBeforeCompaction(int maxNumDeltaCommitsBeforeCompaction) {
            this.metadataConfig.setValue(COMPACT_NUM_DELTA_COMMITS, String.valueOf(maxNumDeltaCommitsBeforeCompaction));
            return this;
        }

        public Builder withLogCompactionEnabled(boolean enableLogCompaction) {
            this.metadataConfig.setValue(ENABLE_LOG_COMPACTION_ON_METADATA_TABLE, Boolean.toString(enableLogCompaction));
            return this;
        }

        public Builder withLogCompactBlocksThreshold(int logCompactBlocksThreshold) {
            this.metadataConfig.setValue(LOG_COMPACT_BLOCKS_THRESHOLD, Integer.toString(logCompactBlocksThreshold));
            return this;
        }

        public Builder withFileListingParallelism(int parallelism) {
            this.metadataConfig.setValue(FILE_LISTING_PARALLELISM_VALUE, String.valueOf(parallelism));
            return this;
        }

        public Builder withRecordIndexMaxParallelism(int parallelism) {
            this.metadataConfig.setValue(RECORD_INDEX_MAX_PARALLELISM, String.valueOf(parallelism));
            return this;
        }

        public Builder withDirectoryFilterRegex(String regex) {
            this.metadataConfig.setValue(DIR_FILTER_REGEX, regex);
            return this;
        }

        public Builder ignoreSpuriousDeletes(boolean validateMetadataPayloadConsistency) {
            this.metadataConfig.setValue(IGNORE_SPURIOUS_DELETES, String.valueOf(validateMetadataPayloadConsistency));
            return this;
        }

        public Builder withEngineType(EngineType engineType) {
            this.engineType = engineType;
            return this;
        }

        public Builder withProperties(Properties properties) {
            this.metadataConfig.getProps().putAll((Map<?, ?>)properties);
            return this;
        }

        public Builder withOptimizedLogBlocksScan(boolean enableOptimizedLogBlocksScan) {
            this.metadataConfig.setValue(ENABLE_OPTIMIZED_LOG_BLOCKS_SCAN, String.valueOf(enableOptimizedLogBlocksScan));
            return this;
        }

        public Builder withMaxNumDeltacommitsWhenPending(int maxNumDeltaCommitsWhenPending) {
            this.metadataConfig.setValue(METADATA_MAX_NUM_DELTACOMMITS_WHEN_PENDING, String.valueOf(maxNumDeltaCommitsWhenPending));
            return this;
        }

        public Builder withEnableGlobalRecordLevelIndex(boolean enabled) {
            this.metadataConfig.setValue(GLOBAL_RECORD_LEVEL_INDEX_ENABLE_PROP, String.valueOf(enabled));
            return this;
        }

        public Builder withRecordIndexFileGroupCount(int minCount, int maxCount) {
            this.metadataConfig.setValue(GLOBAL_RECORD_LEVEL_INDEX_MIN_FILE_GROUP_COUNT_PROP, String.valueOf(minCount));
            this.metadataConfig.setValue(GLOBAL_RECORD_LEVEL_INDEX_MAX_FILE_GROUP_COUNT_PROP, String.valueOf(maxCount));
            return this;
        }

        public Builder withRecordIndexGrowthFactor(float factor) {
            this.metadataConfig.setValue(RECORD_INDEX_GROWTH_FACTOR_PROP, String.valueOf(factor));
            return this;
        }

        public Builder withRecordIndexMaxFileGroupSizeBytes(long sizeInBytes) {
            this.metadataConfig.setValue(RECORD_INDEX_MAX_FILE_GROUP_SIZE_BYTES_PROP, String.valueOf(sizeInBytes));
            return this;
        }

        public Builder withSpillableMapDir(String dir) {
            this.metadataConfig.setValue(SPILLABLE_MAP_DIR_PROP, dir);
            return this;
        }

        public Builder withMaxReaderMemory(long mem) {
            this.metadataConfig.setValue(MAX_READER_MEMORY_PROP, String.valueOf(mem));
            return this;
        }

        public Builder withMaxReaderBufferSize(long mem) {
            this.metadataConfig.setValue(MAX_READER_BUFFER_SIZE_PROP, String.valueOf(mem));
            return this;
        }

        public Builder withMaxLogFileSizeBytes(long sizeInBytes) {
            this.metadataConfig.setValue(MAX_LOG_FILE_SIZE_BYTES_PROP, String.valueOf(sizeInBytes));
            return this;
        }

        public Builder withExpressionIndexFileGroupCount(int fileGroupCount) {
            this.metadataConfig.setValue(EXPRESSION_INDEX_FILE_GROUP_COUNT, String.valueOf(fileGroupCount));
            return this;
        }

        public Builder withExpressionIndexParallelism(int parallelism) {
            this.metadataConfig.setValue(EXPRESSION_INDEX_PARALLELISM, String.valueOf(parallelism));
            return this;
        }

        public Builder withExpressionIndexColumn(String column) {
            this.metadataConfig.setValue(EXPRESSION_INDEX_COLUMN, column);
            return this;
        }

        public Builder withExpressionIndexName(String name) {
            this.metadataConfig.setValue(EXPRESSION_INDEX_NAME, name);
            return this;
        }

        public Builder withExpressionIndexType(String type) {
            this.metadataConfig.setValue(EXPRESSION_INDEX_TYPE, type);
            return this;
        }

        public Builder withExpressionIndexOptions(Map<String, String> options) {
            this.metadataConfig.setValue(EXPRESSION_INDEX_OPTIONS, options.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(",")));
            return this;
        }

        public Builder withMetadataIndexPartitionStatsFileGroupCount(int fileGroupCount) {
            this.metadataConfig.setValue(METADATA_INDEX_PARTITION_STATS_FILE_GROUP_COUNT, String.valueOf(fileGroupCount));
            return this;
        }

        public Builder withPartitionStatsIndexParallelism(int parallelism) {
            this.metadataConfig.setValue(PARTITION_STATS_INDEX_PARALLELISM, String.valueOf(parallelism));
            return this;
        }

        public Builder withSecondaryIndexEnabled(boolean enabled) {
            this.metadataConfig.setValue(SECONDARY_INDEX_ENABLE_PROP, String.valueOf(enabled));
            return this;
        }

        public Builder withExpressionIndexEnabled(boolean enabled) {
            this.metadataConfig.setValue(EXPRESSION_INDEX_ENABLE_PROP, String.valueOf(enabled));
            return this;
        }

        public Builder withSecondaryIndexForColumn(String column) {
            this.metadataConfig.setValue(SECONDARY_INDEX_COLUMN, column);
            return this;
        }

        public Builder withSecondaryIndexName(String name) {
            this.metadataConfig.setValue(SECONDARY_INDEX_NAME, name);
            return this;
        }

        public Builder withSecondaryIndexParallelism(int parallelism) {
            this.metadataConfig.setValue(SECONDARY_INDEX_PARALLELISM, String.valueOf(parallelism));
            return this;
        }

        public Builder withDropMetadataIndex(String indexName) {
            this.metadataConfig.setValue(DROP_METADATA_INDEX, indexName);
            return this;
        }

        public Builder withRangeRepartitionSamplingFraction(double samplingFraction) {
            this.metadataConfig.setValue(RANGE_REPARTITION_SAMPLING_FRACTION, String.valueOf(samplingFraction));
            return this;
        }

        public Builder withRangeRepartitionTargetRecordsPerPartition(int targetRecordsPerPartition) {
            this.metadataConfig.setValue(RANGE_REPARTITION_TARGET_RECORDS_PER_PARTITION, String.valueOf(targetRecordsPerPartition));
            return this;
        }

        public Builder withRangeRepartitionRandomSeed(int randomSeed) {
            this.metadataConfig.setValue(RANGE_REPARTITION_RANDOM_SEED, String.valueOf(randomSeed));
            return this;
        }

        public Builder withRepartitionMinPartitionsThreshold(int minPartitionsThreshold) {
            this.metadataConfig.setValue(REPARTITION_MIN_PARTITIONS_THRESHOLD, String.valueOf(minPartitionsThreshold));
            return this;
        }

        public Builder withRepartitionDefaultPartitions(int defaultPartitions) {
            this.metadataConfig.setValue(REPARTITION_DEFAULT_PARTITIONS, String.valueOf(defaultPartitions));
            return this;
        }

        public HoodieMetadataConfig build() {
            this.metadataConfig.setDefaultValue(ENABLE, this.getDefaultMetadataEnable(this.engineType));
            this.metadataConfig.setDefaultValue(ENABLE_METADATA_INDEX_COLUMN_STATS, this.getDefaultColStatsEnable(this.engineType));
            this.metadataConfig.setDefaultValue(SECONDARY_INDEX_ENABLE_PROP, this.getDefaultSecondaryIndexEnable(this.engineType));
            this.metadataConfig.setDefaultValue(STREAMING_WRITE_ENABLED, this.getDefaultForStreamingWriteEnabled(this.engineType));
            this.metadataConfig.setDefaults(HoodieMetadataConfig.class.getName());
            return this.metadataConfig;
        }

        private boolean getDefaultMetadataEnable(EngineType engineType) {
            switch (engineType) {
                case FLINK: 
                case SPARK: {
                    return ENABLE.defaultValue();
                }
                case JAVA: {
                    return false;
                }
            }
            throw new HoodieNotSupportedException("Unsupported engine " + (Object)((Object)engineType));
        }

        private boolean getDefaultForStreamingWriteEnabled(EngineType engineType) {
            switch (engineType) {
                case SPARK: {
                    return true;
                }
                case FLINK: 
                case JAVA: {
                    return false;
                }
            }
            throw new HoodieNotSupportedException("Unsupported engine " + (Object)((Object)engineType));
        }

        private boolean getDefaultColStatsEnable(EngineType engineType) {
            switch (engineType) {
                case SPARK: {
                    return true;
                }
                case FLINK: 
                case JAVA: {
                    return false;
                }
            }
            throw new HoodieNotSupportedException("Unsupported engine " + (Object)((Object)engineType));
        }

        private boolean getDefaultSecondaryIndexEnable(EngineType engineType) {
            switch (engineType) {
                case SPARK: 
                case JAVA: {
                    return true;
                }
                case FLINK: {
                    return false;
                }
            }
            throw new HoodieNotSupportedException("Unsupported engine " + (Object)((Object)engineType));
        }
    }
}

