/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.data;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.util.Either;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HoodieBaseListData<T> {
    protected final Either<Stream<T>, List<T>> data;
    protected final boolean lazy;

    protected HoodieBaseListData(List<T> data, boolean lazy) {
        this.data = lazy ? Either.left(data.stream().parallel()) : Either.right(data);
        this.lazy = lazy;
    }

    protected HoodieBaseListData(Stream<T> dataStream, boolean lazy) {
        if (lazy) {
            this.data = Either.left(dataStream);
        } else {
            this.data = Either.right(dataStream.collect(Collectors.toList()));
            dataStream.close();
        }
        this.lazy = lazy;
    }

    protected Stream<T> asStream() {
        return this.lazy ? this.data.asLeft() : this.data.asRight().parallelStream();
    }

    protected boolean isEmpty() {
        if (this.lazy) {
            return !this.data.asLeft().findAny().isPresent();
        }
        return this.data.asRight().isEmpty();
    }

    protected long count() {
        if (this.lazy) {
            return this.data.asLeft().count();
        }
        return this.data.asRight().size();
    }

    protected List<T> collectAsList() {
        if (this.lazy) {
            try (Stream stream = this.data.asLeft();){
                List list = stream.collect(Collectors.toList());
                return list;
            }
        }
        return this.data.asRight();
    }

    static class IteratorCloser
    implements Runnable {
        private static final Logger LOG = LoggerFactory.getLogger(IteratorCloser.class);
        private final Iterator<?> iterator;

        IteratorCloser(Iterator<?> iterator) {
            this.iterator = iterator;
        }

        @Override
        public void run() {
            if (this.iterator instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)((Object)this.iterator)).close();
                }
                catch (Exception ex) {
                    LOG.warn("Failed to properly close iterator", (Throwable)ex);
                }
            }
        }
    }
}

