/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.engine;

import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.HoodieAvroReaderContext;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.engine.ReaderContextFactory;
import org.apache.hudi.common.table.HoodieTableMetaClient;

public class AvroReaderContextFactory
implements ReaderContextFactory<IndexedRecord> {
    private final HoodieTableMetaClient metaClient;
    private final String payloadClassName;
    private final TypedProperties props;

    public AvroReaderContextFactory(HoodieTableMetaClient metaClient, TypedProperties props) {
        this(metaClient, metaClient.getTableConfig().getPayloadClass(), props);
    }

    public AvroReaderContextFactory(HoodieTableMetaClient metaClient, String payloadClassName, TypedProperties props) {
        this.metaClient = metaClient;
        this.payloadClassName = payloadClassName;
        this.props = props;
    }

    @Override
    public HoodieReaderContext<IndexedRecord> getContext() {
        return new HoodieAvroReaderContext(this.metaClient.getStorageConf(), this.metaClient.getTableConfig(), this.payloadClassName, this.props);
    }
}

