/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.engine;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.RecordContext;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.serialization.CustomSerializer;
import org.apache.hudi.common.serialization.DefaultSerializer;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.log.InstantRange;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.table.read.FileGroupReaderSchemaHandler;
import org.apache.hudi.common.table.read.IteratorMode;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.HoodieRecordSizeEstimator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.SizeEstimator;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.CloseableFilterIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.common.util.collection.Triple;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;

public abstract class HoodieReaderContext<T> {
    private final StorageConfiguration<?> storageConfiguration;
    protected final HoodieFileFormat baseFileFormat;
    protected final Option<org.apache.hudi.expression.Predicate> keyFilterOpt;
    protected final HoodieTableConfig tableConfig;
    private String tablePath = null;
    private String latestCommitTime = null;
    private Option<HoodieRecordMerger> recordMerger = null;
    private Boolean hasLogFiles = null;
    private Boolean hasBootstrapBaseFile = null;
    private Boolean needsBootstrapMerge = null;
    private Boolean shouldMergeUseRecordPosition = null;
    protected Option<InstantRange> instantRangeOpt = Option.empty();
    private RecordMergeMode mergeMode;
    protected RecordContext<T> recordContext;
    private FileGroupReaderSchemaHandler<T> schemaHandler = null;
    private IteratorMode iteratorMode = IteratorMode.ENGINE_RECORD;
    protected final HoodieConfig hoodieReaderConfig;
    private boolean enableLogicalTimestampFieldRepair = true;

    protected HoodieReaderContext(StorageConfiguration<?> storageConfiguration, HoodieTableConfig tableConfig, Option<InstantRange> instantRangeOpt, Option<org.apache.hudi.expression.Predicate> keyFilterOpt, RecordContext<T> recordContext) {
        this(storageConfiguration, tableConfig, instantRangeOpt, keyFilterOpt, recordContext, ConfigUtils.DEFAULT_HUDI_CONFIG_FOR_READER);
    }

    protected HoodieReaderContext(StorageConfiguration<?> storageConfiguration, HoodieTableConfig tableConfig, Option<InstantRange> instantRangeOpt, Option<org.apache.hudi.expression.Predicate> keyFilterOpt, RecordContext<T> recordContext, HoodieConfig hoodieReaderConfig) {
        this.tableConfig = tableConfig;
        this.storageConfiguration = storageConfiguration;
        this.baseFileFormat = tableConfig.getBaseFileFormat();
        this.instantRangeOpt = instantRangeOpt;
        this.keyFilterOpt = keyFilterOpt;
        this.recordContext = recordContext;
        this.hoodieReaderConfig = hoodieReaderConfig;
    }

    public FileGroupReaderSchemaHandler<T> getSchemaHandler() {
        return this.schemaHandler;
    }

    public void setSchemaHandler(FileGroupReaderSchemaHandler<T> schemaHandler) {
        this.schemaHandler = schemaHandler;
    }

    public void setIteratorMode(IteratorMode iteratorMode) {
        this.iteratorMode = iteratorMode;
    }

    public IteratorMode getIteratorMode() {
        ValidationUtils.checkArgument((this.iteratorMode != null ? 1 : 0) != 0, (String)"iterator mode should not be null!");
        return this.iteratorMode;
    }

    public String getTablePath() {
        if (this.tablePath == null) {
            throw new IllegalStateException("Table path not set in reader context.");
        }
        return this.tablePath;
    }

    public void setEnableLogicalTimestampFieldRepair(boolean enableLogicalTimestampFieldRepair) {
        this.enableLogicalTimestampFieldRepair = enableLogicalTimestampFieldRepair;
    }

    public void setTablePath(String tablePath) {
        this.tablePath = tablePath;
    }

    public String getLatestCommitTime() {
        return this.latestCommitTime;
    }

    public void setLatestCommitTime(String latestCommitTime) {
        this.latestCommitTime = latestCommitTime;
    }

    public Option<HoodieRecordMerger> getRecordMerger() {
        return this.recordMerger;
    }

    public void setRecordMerger(Option<HoodieRecordMerger> recordMerger) {
        this.recordMerger = recordMerger;
    }

    public boolean getHasLogFiles() {
        return this.hasLogFiles;
    }

    public void setHasLogFiles(boolean hasLogFiles) {
        this.hasLogFiles = hasLogFiles;
    }

    public boolean getHasBootstrapBaseFile() {
        return this.hasBootstrapBaseFile;
    }

    public void setHasBootstrapBaseFile(boolean hasBootstrapBaseFile) {
        this.hasBootstrapBaseFile = hasBootstrapBaseFile;
    }

    public boolean getNeedsBootstrapMerge() {
        return this.needsBootstrapMerge;
    }

    public boolean enableLogicalTimestampFieldRepair() {
        return this.enableLogicalTimestampFieldRepair;
    }

    public void setNeedsBootstrapMerge(boolean needsBootstrapMerge) {
        this.needsBootstrapMerge = needsBootstrapMerge;
    }

    public boolean getShouldMergeUseRecordPosition() {
        return this.shouldMergeUseRecordPosition;
    }

    public void setShouldMergeUseRecordPosition(boolean shouldMergeUseRecordPosition) {
        this.shouldMergeUseRecordPosition = shouldMergeUseRecordPosition;
    }

    public StorageConfiguration<?> getStorageConfiguration() {
        return this.storageConfiguration;
    }

    public TypedProperties getMergeProps(TypedProperties props) {
        return ConfigUtils.getMergeProps(props, this.tableConfig);
    }

    public Option<org.apache.hudi.expression.Predicate> getKeyFilterOpt() {
        return this.keyFilterOpt;
    }

    public SizeEstimator<BufferedRecord<T>> getRecordSizeEstimator() {
        return new HoodieRecordSizeEstimator<BufferedRecord<T>>(this.getSchemaHandler().getSchemaForUpdates());
    }

    public CustomSerializer<BufferedRecord<T>> getRecordSerializer() {
        return new DefaultSerializer<BufferedRecord<T>>();
    }

    public RecordContext<T> getRecordContext() {
        return this.recordContext;
    }

    public HoodieConfig getHoodieReaderConfig() {
        return this.hoodieReaderConfig;
    }

    public abstract ClosableIterator<T> getFileRecordIterator(StoragePath var1, long var2, long var4, Schema var6, Schema var7, HoodieStorage var8) throws IOException;

    public ClosableIterator<T> getFileRecordIterator(StoragePathInfo storagePathInfo, long start, long length, Schema dataSchema, Schema requiredSchema, HoodieStorage storage) throws IOException {
        return this.getFileRecordIterator(storagePathInfo.getPath(), start, length, dataSchema, requiredSchema, storage);
    }

    protected abstract Option<HoodieRecordMerger> getRecordMerger(RecordMergeMode var1, String var2, String var3);

    public void initRecordMerger(TypedProperties properties) {
        this.initRecordMerger(properties, false);
    }

    public void initRecordMergerForIngestion(TypedProperties properties) {
        this.initRecordMerger(properties, true);
    }

    private void initRecordMerger(TypedProperties properties, boolean isIngestion) {
        if (this.recordMerger != null && this.mergeMode != null) {
            return;
        }
        Option<String> writerPayloadClass = HoodieRecordPayload.getWriterPayloadOverride(properties);
        RecordMergeMode recordMergeMode = this.tableConfig.getRecordMergeMode();
        String mergeStrategyId = this.tableConfig.getRecordMergeStrategyId();
        HoodieTableVersion tableVersion = this.tableConfig.getTableVersion();
        if (isIngestion && ((Boolean)writerPayloadClass.map(className -> !className.equals(this.tableConfig.getPayloadClass())).orElse((Object)false)).booleanValue()) {
            if (tableVersion.greaterThanOrEquals(HoodieTableVersion.NINE)) {
                Map<String, String> mergeProperties = HoodieTableConfig.inferMergingConfigsForV9TableCreation(null, (String)writerPayloadClass.get(), null, (String)this.tableConfig.getOrderingFieldsStr().orElse(null), tableVersion);
                recordMergeMode = RecordMergeMode.valueOf(mergeProperties.get(HoodieTableConfig.RECORD_MERGE_MODE.key()));
                mergeStrategyId = mergeProperties.get(HoodieTableConfig.RECORD_MERGE_STRATEGY_ID.key());
            } else {
                Triple<RecordMergeMode, String, String> triple = HoodieTableConfig.inferMergingConfigsForWrites(null, (String)writerPayloadClass.get(), null, (String)this.tableConfig.getOrderingFieldsStr().orElse(null), tableVersion);
                recordMergeMode = triple.getLeft();
                mergeStrategyId = triple.getRight();
            }
        } else if (tableVersion.lesserThan(HoodieTableVersion.EIGHT)) {
            Triple<RecordMergeMode, String, String> triple = HoodieTableConfig.inferMergingConfigsForPreV9Table(recordMergeMode, this.tableConfig.getPayloadClass(), mergeStrategyId, (String)this.tableConfig.getOrderingFieldsStr().orElse(null), tableVersion);
            recordMergeMode = triple.getLeft();
            mergeStrategyId = triple.getRight();
        }
        this.mergeMode = recordMergeMode;
        this.recordMerger = this.getRecordMerger(recordMergeMode, mergeStrategyId, properties.getString("hoodie.write.record.merge.custom.implementation.classes", properties.getString("hoodie.datasource.write.record.merger.impls", "")));
    }

    public RecordMergeMode getMergeMode() {
        return this.mergeMode;
    }

    public Option<InstantRange> getInstantRange() {
        return this.instantRangeOpt;
    }

    public ClosableIterator<T> applyInstantRangeFilter(ClosableIterator<T> fileRecordIterator) {
        if (HoodieTableMetadata.isMetadataTable(this.tablePath)) {
            return fileRecordIterator;
        }
        InstantRange instantRange = (InstantRange)this.getInstantRange().get();
        Schema.Field commitTimeField = this.getSchemaHandler().getRequiredSchema().getField(HoodieRecord.COMMIT_TIME_METADATA_FIELD);
        int commitTimePos = commitTimeField.pos();
        Predicate<Object> instantFilter = row -> instantRange.isInRange(this.recordContext.getMetaFieldValue(row, commitTimePos));
        return new CloseableFilterIterator<Object>(fileRecordIterator, instantFilter);
    }

    public abstract ClosableIterator<T> mergeBootstrapReaders(ClosableIterator<T> var1, Schema var2, ClosableIterator<T> var3, Schema var4, List<Pair<String, Object>> var5);

    public Option<Pair<String, String>> getPayloadClasses(TypedProperties props) {
        return this.getRecordMerger().map(merger -> {
            if (merger.getMergingStrategy().equals("00000000-0000-0000-0000-000000000000")) {
                String incomingPayloadClass = (String)HoodieRecordPayload.getWriterPayloadOverride(props).orElseGet(this.tableConfig::getPayloadClass);
                return Pair.of(this.tableConfig.getPayloadClass(), incomingPayloadClass);
            }
            return null;
        });
    }
}

