/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.engine;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.function.SerializableBiFunction;
import org.apache.hudi.common.model.DeleteRecord;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.table.read.DeleteContext;
import org.apache.hudi.common.util.JavaTypeConverter;
import org.apache.hudi.common.util.LocalAvroSchemaCache;
import org.apache.hudi.common.util.OrderingValues;
import org.apache.hudi.common.util.collection.ArrayComparable;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieKeyException;
import org.apache.hudi.keygen.KeyGenerator;

public abstract class RecordContext<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final SerializableBiFunction<T, Schema, String> recordKeyExtractor;
    private final LocalAvroSchemaCache localAvroSchemaCache = LocalAvroSchemaCache.getInstance();
    protected final JavaTypeConverter typeConverter;
    protected String partitionPath;

    protected RecordContext(HoodieTableConfig tableConfig, JavaTypeConverter typeConverter) {
        this.typeConverter = typeConverter;
        this.recordKeyExtractor = tableConfig.populateMetaFields() ? this.metadataKeyExtractor() : this.virtualKeyExtractor((String[])tableConfig.getRecordKeyFields().orElseThrow(() -> new IllegalArgumentException("No record keys specified and meta fields are not populated")));
    }

    protected RecordContext(JavaTypeConverter typeConverter) {
        this.recordKeyExtractor = (record, schema) -> {
            throw new UnsupportedOperationException("Record key extractor is not initialized");
        };
        this.typeConverter = typeConverter;
    }

    public void setPartitionPath(String partitionPath) {
        this.partitionPath = partitionPath;
    }

    public T extractDataFromRecord(HoodieRecord record, Schema schema, Properties properties) {
        return record.getData();
    }

    public Schema getSchemaFromBufferRecord(BufferedRecord<T> record) {
        return this.decodeAvroSchema(record.getSchemaId());
    }

    public Integer encodeAvroSchema(Schema schema) {
        return this.localAvroSchemaCache.cacheSchema(schema);
    }

    @Nullable
    public Schema decodeAvroSchema(Object versionId) {
        return (Schema)this.localAvroSchemaCache.getSchema((Integer)versionId).orElse(null);
    }

    public abstract HoodieRecord<T> constructHoodieRecord(BufferedRecord<T> var1, String var2);

    public HoodieRecord<T> constructHoodieRecord(BufferedRecord<T> bufferedRecord) {
        return this.constructHoodieRecord(bufferedRecord, this.partitionPath);
    }

    public HoodieRecord<T> constructFinalHoodieRecord(BufferedRecord<T> bufferedRecord) {
        return this.constructHoodieRecord(bufferedRecord, this.partitionPath);
    }

    public abstract T mergeWithEngineRecord(Schema var1, Map<Integer, Object> var2, BufferedRecord<T> var3);

    public abstract T constructEngineRecord(Schema var1, Object[] var2);

    public JavaTypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    public String getRecordKey(T record, Schema schema) {
        return this.recordKeyExtractor.apply(record, schema);
    }

    public abstract Object getValue(T var1, Schema var2, String var3);

    public abstract String getMetaFieldValue(T var1, int var2);

    public Comparable convertValueToEngineType(Comparable value) {
        return value;
    }

    public Comparable convertPartitionValueToEngineType(Comparable value) {
        return this.convertValueToEngineType(value);
    }

    public Comparable convertOrderingValueToEngineType(Comparable value) {
        return value instanceof ArrayComparable ? ((ArrayComparable)value).apply(this::convertValueToEngineType) : this.convertValueToEngineType(value);
    }

    public abstract T convertAvroRecord(IndexedRecord var1);

    public abstract GenericRecord convertToAvroRecord(T var1, Schema var2);

    @Nullable
    public abstract T getDeleteRow(String var1);

    public boolean isDeleteRecord(T record, DeleteContext deleteContext) {
        return this.isBuiltInDeleteRecord(record, deleteContext) || this.isDeleteHoodieOperation(record, deleteContext) || this.isCustomDeleteRecord(record, deleteContext);
    }

    private boolean isBuiltInDeleteRecord(T record, DeleteContext deleteContext) {
        if (!deleteContext.hasBuiltInDeleteField()) {
            return false;
        }
        Object columnValue = this.getValue(record, deleteContext.getReaderSchema(), "_hoodie_is_deleted");
        return columnValue != null && this.getTypeConverter().castToBoolean(columnValue);
    }

    private boolean isDeleteHoodieOperation(T record, DeleteContext deleteContext) {
        int hoodieOperationPos = deleteContext.getHoodieOperationPos();
        if (hoodieOperationPos < 0) {
            return false;
        }
        String operationVal = this.getMetaFieldValue(record, hoodieOperationPos);
        if (operationVal == null) {
            return false;
        }
        HoodieOperation operation = HoodieOperation.fromName(operationVal);
        return HoodieOperation.isDelete(operation) || HoodieOperation.isUpdateBefore(operation);
    }

    private boolean isCustomDeleteRecord(T record, DeleteContext deleteContext) {
        if (deleteContext.getCustomDeleteMarkerKeyValue().isEmpty()) {
            return false;
        }
        Pair markerKeyValue = (Pair)deleteContext.getCustomDeleteMarkerKeyValue().get();
        Object deleteMarkerValue = this.getValue(record, deleteContext.getReaderSchema(), (String)markerKeyValue.getLeft());
        return deleteMarkerValue != null && ((String)markerKeyValue.getRight()).equals(deleteMarkerValue.toString());
    }

    public abstract T seal(T var1);

    public abstract T toBinaryRow(Schema var1, T var2);

    public abstract UnaryOperator<T> projectRecord(Schema var1, Schema var2, Map<String, String> var3);

    public final UnaryOperator<T> projectRecord(Schema from, Schema to) {
        return this.projectRecord(from, to, Collections.emptyMap());
    }

    public Comparable getOrderingValue(T record, Schema schema, List<String> orderingFieldNames) {
        if (orderingFieldNames.isEmpty()) {
            return OrderingValues.getDefault();
        }
        return OrderingValues.create(orderingFieldNames, field -> {
            Object value = this.getValue(record, schema, (String)field);
            return value != null ? this.ensureComparability(value) : OrderingValues.getDefault();
        });
    }

    protected Comparable ensureComparability(Object value) {
        return (Comparable)value;
    }

    public Comparable getOrderingValue(DeleteRecord deleteRecord) {
        Comparable<?> orderingValue = deleteRecord.getOrderingValue();
        return OrderingValues.isCommitTimeOrderingValue(orderingValue) ? OrderingValues.getDefault() : this.convertOrderingValueToEngineType(orderingValue);
    }

    public Comparable getOrderingValue(T record, Schema schema, String[] orderingFieldNames) {
        if (orderingFieldNames == null || orderingFieldNames.length == 0) {
            return OrderingValues.getDefault();
        }
        return OrderingValues.create(orderingFieldNames, field -> {
            Object value = this.getValue(record, schema, (String)field);
            return value != null ? this.ensureComparability(value) : OrderingValues.getDefault();
        });
    }

    public long extractRecordPosition(T record, Schema schema, String fieldName, long providedPositionIfNeeded) {
        if (this.supportsParquetRowIndex()) {
            Object position = this.getValue(record, schema, fieldName);
            if (position != null) {
                return (Long)position;
            }
            throw new IllegalStateException("Record position extraction failed");
        }
        return providedPositionIfNeeded;
    }

    public boolean supportsParquetRowIndex() {
        return false;
    }

    private SerializableBiFunction<T, Schema, String> metadataKeyExtractor() {
        return (record, schema) -> this.getValue((Object)record, (Schema)schema, HoodieRecord.RECORD_KEY_METADATA_FIELD).toString();
    }

    private SerializableBiFunction<T, Schema, String> virtualKeyExtractor(String[] recordKeyFields) {
        if (recordKeyFields.length == 1) {
            return (record, schema) -> {
                Object result = this.getValue((T)record, (Schema)schema, recordKeyFields[0]);
                if (result == null) {
                    throw new HoodieKeyException("recordKey cannot be null");
                }
                return result.toString();
            };
        }
        return (record, schema) -> {
            BiFunction<String, Integer, String> valueFunction = (recordKeyField, index) -> {
                Object result = this.getValue((T)record, (Schema)schema, (String)recordKeyField);
                return result != null ? result.toString() : null;
            };
            return KeyGenerator.constructRecordKey(recordKeyFields, valueFunction);
        };
    }
}

