/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.SerializableIndexedRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;

public abstract class BaseAvroPayload
implements Serializable,
KryoSerializable {
    private byte[] recordBytes;
    protected Comparable orderingVal;
    protected boolean isDeletedRecord;
    private transient GenericRecord record;

    public BaseAvroPayload(GenericRecord record, Comparable orderingVal) {
        this.record = record;
        this.recordBytes = null;
        this.orderingVal = orderingVal;
        boolean bl = this.isDeletedRecord = record == null || this.isDeleteRecord(record);
        if (orderingVal == null) {
            throw new HoodieException("Ordering value is null for record: " + record);
        }
    }

    public Comparable getOrderingVal() {
        return this.orderingVal;
    }

    public boolean isDeleted(Schema schema, Properties props) {
        return this.isDeletedRecord;
    }

    public boolean canProduceSentinel() {
        return false;
    }

    protected boolean isDeleteRecord(GenericRecord genericRecord) {
        String isDeleteKey = "_hoodie_is_deleted";
        if (genericRecord.getSchema().getField("_hoodie_is_deleted") == null) {
            return false;
        }
        Object deleteMarker = genericRecord.get("_hoodie_is_deleted");
        return deleteMarker instanceof Boolean && (Boolean)deleteMarker != false;
    }

    public byte[] getRecordBytes() {
        if (this.recordBytes == null) {
            this.recordBytes = this.record == null ? new byte[0] : HoodieAvroUtils.avroToBytes((IndexedRecord)this.record);
        }
        return this.recordBytes;
    }

    public Option<IndexedRecord> getIndexedRecord(Schema schema, Properties properties) throws IOException {
        return this.getRecord(schema);
    }

    protected boolean isEmptyRecord() {
        if (this.recordBytes == null) {
            return this.record == null;
        }
        return this.recordBytes.length == 0;
    }

    protected Option<IndexedRecord> getRecord(Schema schema) throws IOException {
        if (this.record != null) {
            if (this.record.getSchema() == schema) {
                return Option.of((Object)this.record);
            }
            this.recordBytes = this.getRecordBytes();
        }
        if (this.recordBytes == null || this.recordBytes.length == 0) {
            return Option.empty();
        }
        this.record = SerializableIndexedRecord.fromAvroBytes(schema, this.recordBytes);
        return Option.of((Object)this.record);
    }

    public void write(Kryo kryo, Output output) {
        byte[] bytes = this.getRecordBytes();
        output.writeInt(bytes.length);
        output.writeBytes(bytes);
        kryo.writeClassAndObject(output, (Object)this.orderingVal);
        output.writeBoolean(this.isDeletedRecord);
    }

    public void read(Kryo kryo, Input input) {
        int length = input.readInt();
        this.recordBytes = input.readBytes(length);
        this.orderingVal = (Comparable)kryo.readClassAndObject(input);
        this.isDeletedRecord = input.readBoolean();
    }
}

