/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.storage.StoragePath;

public class CompactionOperation
implements Serializable {
    private String baseInstantTime;
    private Option<String> dataFileCommitTime;
    private List<String> deltaFileNames;
    private Option<String> dataFileName;
    private HoodieFileGroupId id;
    private Map<String, Double> metrics;
    private Option<String> bootstrapFilePath;

    @Deprecated
    public CompactionOperation() {
    }

    public CompactionOperation(String fileId, String partitionPath, String baseInstantTime, Option<String> dataFileCommitTime, List<String> deltaFileNames, Option<String> dataFileName, Option<String> bootstrapFilePath, Map<String, Double> metrics) {
        this.baseInstantTime = baseInstantTime;
        this.dataFileCommitTime = dataFileCommitTime;
        this.deltaFileNames = deltaFileNames;
        this.dataFileName = dataFileName;
        this.bootstrapFilePath = bootstrapFilePath;
        this.id = new HoodieFileGroupId(partitionPath, fileId);
        this.metrics = metrics;
    }

    public CompactionOperation(Option<HoodieBaseFile> dataFile, String partitionPath, List<HoodieLogFile> logFiles, Map<String, Double> metrics) {
        ValidationUtils.checkArgument((!logFiles.isEmpty() ? 1 : 0) != 0, (String)"log files should not be empty.");
        if (dataFile.isPresent()) {
            this.baseInstantTime = ((HoodieBaseFile)dataFile.get()).getCommitTime();
            this.dataFileName = Option.of((Object)((HoodieBaseFile)dataFile.get()).getFileName());
            this.id = new HoodieFileGroupId(partitionPath, ((HoodieBaseFile)dataFile.get()).getFileId());
            this.dataFileCommitTime = Option.of((Object)((HoodieBaseFile)dataFile.get()).getCommitTime());
            this.bootstrapFilePath = ((HoodieBaseFile)dataFile.get()).getBootstrapBaseFile().map(BaseFile::getPath);
        } else {
            this.dataFileName = Option.empty();
            this.baseInstantTime = logFiles.get(0).getDeltaCommitTime();
            this.id = new HoodieFileGroupId(partitionPath, logFiles.get(0).getFileId());
            this.dataFileCommitTime = Option.empty();
            this.bootstrapFilePath = Option.empty();
        }
        this.deltaFileNames = logFiles.stream().map(s -> s.getPath().getName()).collect(Collectors.toList());
        this.metrics = metrics;
    }

    public String getBaseInstantTime() {
        return this.baseInstantTime;
    }

    public Option<String> getDataFileCommitTime() {
        return this.dataFileCommitTime;
    }

    public List<String> getDeltaFileNames() {
        return this.deltaFileNames;
    }

    public Option<String> getDataFileName() {
        return this.dataFileName;
    }

    public String getFileId() {
        return this.id.getFileId();
    }

    public String getPartitionPath() {
        return this.id.getPartitionPath();
    }

    public Map<String, Double> getMetrics() {
        return this.metrics;
    }

    public HoodieFileGroupId getFileGroupId() {
        return this.id;
    }

    public Option<String> getBootstrapFilePath() {
        return this.bootstrapFilePath;
    }

    public Option<HoodieBaseFile> getBaseFile(String basePath, String partitionPath) {
        Option externalBaseFile = this.bootstrapFilePath.map(BaseFile::new);
        StoragePath dirPath = FSUtils.constructAbsolutePath(basePath, partitionPath);
        return this.dataFileName.map(df -> (HoodieBaseFile)externalBaseFile.map(ext -> new HoodieBaseFile(new StoragePath(dirPath, df).toString(), (BaseFile)ext)).orElseGet(() -> new HoodieBaseFile(new StoragePath(dirPath, df).toString())));
    }

    public static CompactionOperation convertFromAvroRecordInstance(HoodieCompactionOperation operation) {
        CompactionOperation op = new CompactionOperation();
        op.baseInstantTime = operation.getBaseInstantTime();
        op.dataFileName = Option.ofNullable((Object)operation.getDataFilePath());
        op.dataFileCommitTime = op.dataFileName.map(p -> FSUtils.getCommitTime(new StoragePath(p).getName()));
        op.deltaFileNames = new ArrayList<String>(operation.getDeltaFilePaths());
        op.id = new HoodieFileGroupId(operation.getPartitionPath(), operation.getFileId());
        op.metrics = operation.getMetrics() == null ? new HashMap<String, Double>() : new HashMap<String, Double>(operation.getMetrics());
        op.bootstrapFilePath = Option.ofNullable((Object)operation.getBootstrapFilePath());
        return op;
    }

    public String toString() {
        return "CompactionOperation{baseInstantTime='" + this.baseInstantTime + '\'' + ", dataFileCommitTime=" + this.dataFileCommitTime + ", deltaFileNames=" + this.deltaFileNames + ", dataFileName=" + this.dataFileName + ", id='" + this.id + '\'' + ", metrics=" + this.metrics + ", bootstrapFilePath=" + this.bootstrapFilePath + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompactionOperation operation = (CompactionOperation)o;
        return Objects.equals(this.baseInstantTime, operation.baseInstantTime) && Objects.equals(this.dataFileCommitTime, operation.dataFileCommitTime) && Objects.equals(this.deltaFileNames, operation.deltaFileNames) && Objects.equals(this.dataFileName, operation.dataFileName) && Objects.equals(this.id, operation.id);
    }

    public int hashCode() {
        return Objects.hash(this.baseInstantTime, this.id);
    }
}

