/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.OrderingValues;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;

public class DefaultHoodieRecordPayload
extends OverwriteWithLatestAvroPayload {
    public static final String METADATA_EVENT_TIME_KEY = "metadata.event_time.key";
    public static final String DELETE_KEY = "hoodie.payload.delete.field";
    public static final String DELETE_MARKER = "hoodie.payload.delete.marker";
    private AtomicBoolean isDeleteComputed = new AtomicBoolean(false);
    private boolean isDefaultRecordPayloadDeleted = false;

    public DefaultHoodieRecordPayload(GenericRecord record, Comparable orderingVal) {
        super(record, orderingVal);
    }

    public DefaultHoodieRecordPayload(Option<GenericRecord> record) {
        this(record.isPresent() ? (GenericRecord)record.get() : null, OrderingValues.getDefault());
    }

    @Override
    public OverwriteWithLatestAvroPayload preCombine(OverwriteWithLatestAvroPayload oldValue) {
        if (oldValue.isEmptyRecord()) {
            return this;
        }
        if (oldValue.orderingVal.compareTo(this.orderingVal) > 0) {
            return oldValue;
        }
        return this;
    }

    @Override
    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord currentValue, Schema schema, Properties properties) throws IOException {
        Option<IndexedRecord> incomingRecord = this.getRecord(schema);
        if (!this.needUpdatingPersistedRecord(currentValue, incomingRecord, properties)) {
            return Option.of((Object)currentValue);
        }
        if (!this.isDeleteComputed.getAndSet(true)) {
            this.isDefaultRecordPayloadDeleted = (Boolean)incomingRecord.map(record -> this.isDeleteRecord((GenericRecord)record, properties)).orElse((Object)true);
        }
        return this.isDefaultRecordPayloadDeleted ? Option.empty() : incomingRecord;
    }

    @Override
    public Option<IndexedRecord> getInsertValue(Schema schema, Properties properties) throws IOException {
        if (this.isEmptyRecord()) {
            return Option.empty();
        }
        GenericRecord incomingRecord = (GenericRecord)this.getRecord(schema).get();
        if (!this.isDeleteComputed.getAndSet(true)) {
            this.isDefaultRecordPayloadDeleted = this.isDeleteRecord(incomingRecord, properties);
        }
        return this.isDefaultRecordPayloadDeleted ? Option.empty() : Option.of((Object)incomingRecord);
    }

    @Override
    public boolean isDeleted(Schema schema, Properties props) {
        if (this.isEmptyRecord()) {
            return true;
        }
        try {
            if (!this.isDeleteComputed.getAndSet(true)) {
                GenericRecord incomingRecord = (GenericRecord)this.getRecord(schema).get();
                this.isDefaultRecordPayloadDeleted = this.isDeleteRecord(incomingRecord, props);
            }
            return this.isDefaultRecordPayloadDeleted;
        }
        catch (IOException e) {
            throw new HoodieIOException("Deserializing bytes to avro failed ", e);
        }
    }

    protected boolean isDeleteRecord(GenericRecord genericRecord, Properties properties) {
        String deleteKey = properties.getProperty(DELETE_KEY);
        if (StringUtils.isNullOrEmpty((String)deleteKey)) {
            return this.isDeleteRecord(genericRecord);
        }
        ValidationUtils.checkArgument((!StringUtils.isNullOrEmpty((String)properties.getProperty(DELETE_MARKER)) ? 1 : 0) != 0, () -> "hoodie.payload.delete.marker should be configured with hoodie.payload.delete.field");
        if (genericRecord.getSchema().getField(deleteKey) == null) {
            return false;
        }
        Object deleteMarker = genericRecord.get(deleteKey);
        return deleteMarker != null && properties.getProperty(DELETE_MARKER).equals(deleteMarker.toString());
    }

    @Override
    public Option<Map<String, String>> getMetadata() {
        return Option.empty();
    }

    protected boolean needUpdatingPersistedRecord(IndexedRecord currentValue, Option<IndexedRecord> incomingRecord, Properties properties) {
        String[] orderingFields = ConfigUtils.getOrderingFields(properties);
        if (orderingFields == null) {
            return true;
        }
        boolean consistentLogicalTimestampEnabled = Boolean.parseBoolean(properties.getProperty(KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.key(), KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.defaultValue()));
        Comparable persistedOrderingVal = OrderingValues.create(orderingFields, field -> (Comparable)HoodieAvroUtils.getNestedFieldVal((GenericRecord)currentValue, field, true, consistentLogicalTimestampEnabled));
        Comparable incomingOrderingVal = (Comparable)incomingRecord.map(record -> OrderingValues.create(orderingFields, field -> (Comparable)HoodieAvroUtils.getNestedFieldVal((GenericRecord)record, field, true, consistentLogicalTimestampEnabled))).orElse((Object)this.orderingVal);
        if (incomingRecord.isEmpty() && OrderingValues.isDefault(incomingOrderingVal)) {
            return true;
        }
        return persistedOrderingVal == null || persistedOrderingVal.compareTo(incomingOrderingVal) <= 0;
    }

    @Override
    public void write(Kryo kryo, Output output) {
        super.write(kryo, output);
        output.writeBoolean(this.isDeleteComputed.get());
        if (this.isDeleteComputed.get()) {
            output.writeBoolean(this.isDefaultRecordPayloadDeleted);
        }
    }

    @Override
    public void read(Kryo kryo, Input input) {
        super.read(kryo, input);
        boolean isDeleteComputedValue = input.readBoolean();
        this.isDeleteComputed = new AtomicBoolean(isDeleteComputedValue);
        if (isDeleteComputedValue) {
            this.isDefaultRecordPayloadDeleted = input.readBoolean();
        }
    }
}

