/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.AvroRecordContext;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.JoinedGenericRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.MetadataValues;
import org.apache.hudi.common.model.SerializableIndexedRecord;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.read.DeleteContext;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.OrderingValues;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;

public class HoodieAvroIndexedRecord
extends HoodieRecord<IndexedRecord> {
    private static final long serialVersionUID = 1L;
    private SerializableIndexedRecord binaryRecord;

    public HoodieAvroIndexedRecord(IndexedRecord data) {
        this(data, (Comparable)null);
    }

    public HoodieAvroIndexedRecord(IndexedRecord data, Comparable orderingValue) {
        this((HoodieKey)null, data);
        this.orderingValue = orderingValue;
    }

    public HoodieAvroIndexedRecord(HoodieKey key, IndexedRecord data) {
        this(key, data, (HoodieOperation)null, (HoodieRecordLocation)null, (HoodieRecordLocation)null);
    }

    public HoodieAvroIndexedRecord(HoodieKey key, IndexedRecord data, HoodieOperation hoodieOperation) {
        this(key, data, hoodieOperation, (Option<Map<String, String>>)Option.empty(), null, null);
    }

    public HoodieAvroIndexedRecord(HoodieKey key, IndexedRecord data, HoodieOperation hoodieOperation, HoodieRecordLocation currentLocation) {
        this(key, data, hoodieOperation, currentLocation, (HoodieRecordLocation)null);
    }

    public HoodieAvroIndexedRecord(HoodieKey key, IndexedRecord data, Comparable<?> orderingValue) {
        this(key, data);
        this.orderingValue = orderingValue;
    }

    public HoodieAvroIndexedRecord(HoodieKey key, IndexedRecord data, Comparable<?> orderingValue, HoodieOperation operation) {
        this(key, data, operation);
        this.orderingValue = orderingValue;
    }

    public HoodieAvroIndexedRecord(HoodieKey key, IndexedRecord data, Comparable<?> orderingValue, HoodieOperation operation, Boolean isDelete) {
        this(key, data, operation);
        this.orderingValue = orderingValue;
        this.isDelete = isDelete;
    }

    public HoodieAvroIndexedRecord(HoodieKey key, IndexedRecord data, HoodieOperation operation, HoodieRecordLocation currentLocation, HoodieRecordLocation newLocation) {
        super(key, SerializableIndexedRecord.createInstance(data), operation, currentLocation, newLocation);
        this.binaryRecord = (SerializableIndexedRecord)this.data;
    }

    public HoodieAvroIndexedRecord(IndexedRecord data, HoodieRecordLocation currentLocation) {
        this((HoodieKey)null, data, (HoodieOperation)null, currentLocation, (HoodieRecordLocation)null);
    }

    public HoodieAvroIndexedRecord(HoodieKey key, IndexedRecord data, HoodieOperation operation, Option<Map<String, String>> metaData, Comparable orderingValue, Boolean isDelete) {
        super(key, SerializableIndexedRecord.createInstance(data), operation, metaData);
        this.binaryRecord = (SerializableIndexedRecord)this.data;
        this.orderingValue = orderingValue;
        this.isDelete = isDelete;
    }

    private HoodieAvroIndexedRecord(HoodieKey key, SerializableIndexedRecord data, HoodieOperation operation, Option<Map<String, String>> metaData, Comparable orderingValue) {
        super(key, data, operation, metaData);
        this.binaryRecord = (SerializableIndexedRecord)this.data;
        this.orderingValue = orderingValue;
    }

    HoodieAvroIndexedRecord(HoodieAvroIndexedRecord record) {
        super(record.getKey(), record.binaryRecord, record.getOperation(), record.getMetadata());
        this.currentLocation = record.getCurrentLocation();
        this.newLocation = record.getNewLocation();
        this.ignoreIndexUpdate = record.getIgnoreIndexUpdate();
        this.binaryRecord = (SerializableIndexedRecord)this.data;
        this.isDelete = record.isDelete;
        this.orderingValue = record.orderingValue;
    }

    public HoodieAvroIndexedRecord() {
        this.binaryRecord = (SerializableIndexedRecord)this.data;
    }

    @Override
    public HoodieRecord newInstance() {
        return new HoodieAvroIndexedRecord(this);
    }

    @Override
    public HoodieRecord<IndexedRecord> newInstance(HoodieKey key, HoodieOperation op) {
        return new HoodieAvroIndexedRecord(key, this.binaryRecord, op, (Option<Map<String, String>>)this.metaData, this.orderingValue);
    }

    @Override
    public HoodieRecord<IndexedRecord> newInstance(HoodieKey key) {
        return new HoodieAvroIndexedRecord(key, this.binaryRecord, this.operation, (Option<Map<String, String>>)this.metaData, this.orderingValue);
    }

    @Override
    public String getRecordKey(Schema recordSchema, Option<BaseKeyGenerator> keyGeneratorOpt) {
        if (this.key != null) {
            return this.key.getRecordKey();
        }
        this.decodeRecord(recordSchema);
        return keyGeneratorOpt.isPresent() ? ((BaseKeyGenerator)keyGeneratorOpt.get()).getRecordKey((GenericRecord)this.data) : ((GenericRecord)this.data).get(HoodieRecord.RECORD_KEY_METADATA_FIELD).toString();
    }

    @Override
    public HoodieRecord.HoodieRecordType getRecordType() {
        return HoodieRecord.HoodieRecordType.AVRO;
    }

    @Override
    public String getRecordKey(Schema recordSchema, String keyFieldName) {
        if (this.key != null) {
            return this.key.getRecordKey();
        }
        this.decodeRecord(recordSchema);
        return (String)Option.ofNullable((Object)((IndexedRecord)this.data).getSchema().getField(keyFieldName)).map(keyField -> ((IndexedRecord)this.data).get(keyField.pos())).map(Object::toString).orElse(null);
    }

    @Override
    public Object[] getColumnValues(Schema recordSchema, String[] columns, boolean consistentLogicalTimestampEnabled) {
        this.decodeRecord(recordSchema);
        Object[] results = new Object[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            results[i] = AvroRecordContext.getFieldValueFromIndexedRecord((IndexedRecord)this.data, columns[i]);
        }
        return results;
    }

    @Override
    public Object getColumnValueAsJava(Schema recordSchema, String column, Properties props) {
        this.decodeRecord(recordSchema);
        return AvroRecordContext.getFieldValueFromIndexedRecord((IndexedRecord)this.data, column);
    }

    @Override
    public HoodieRecord joinWith(HoodieRecord other, Schema targetSchema) {
        this.decodeRecord(targetSchema);
        GenericRecord record = HoodieAvroUtils.stitchRecords((GenericRecord)this.data, (GenericRecord)other.getData(), targetSchema);
        return new HoodieAvroIndexedRecord(this.key, (IndexedRecord)record, this.operation, (Option<Map<String, String>>)this.metaData, this.orderingValue, this.isDelete);
    }

    @Override
    public HoodieRecord prependMetaFields(Schema recordSchema, Schema targetSchema, MetadataValues metadataValues, Properties props) {
        this.decodeRecord(recordSchema);
        GenericRecord genericRecord = (GenericRecord)this.data;
        int metaFieldSize = targetSchema.getFields().size() - genericRecord.getSchema().getFields().size();
        GenericRecord newAvroRecord = metaFieldSize == 0 ? genericRecord : new JoinedGenericRecord(genericRecord, metaFieldSize, targetSchema);
        HoodieAvroIndexedRecord.updateMetadataValuesInternal(newAvroRecord, metadataValues);
        HoodieAvroIndexedRecord newRecord = new HoodieAvroIndexedRecord(this.key, (IndexedRecord)newAvroRecord, this.operation, (Option<Map<String, String>>)this.metaData, this.orderingValue, this.isDelete);
        newRecord.setNewLocation(this.newLocation);
        newRecord.setCurrentLocation(this.currentLocation);
        return newRecord;
    }

    @Override
    public HoodieRecord updateMetaField(Schema recordSchema, int ordinal, String value) {
        this.decodeRecord(recordSchema);
        ((IndexedRecord)this.data).put(ordinal, (Object)value);
        return new HoodieAvroIndexedRecord(this.key, (IndexedRecord)this.data, this.operation, (Option<Map<String, String>>)this.metaData, this.orderingValue, this.isDelete);
    }

    @Override
    public HoodieRecord rewriteRecordWithNewSchema(Schema recordSchema, Properties props, Schema newSchema, Map<String, String> renameCols) {
        this.decodeRecord(recordSchema);
        GenericRecord record = HoodieAvroUtils.rewriteRecordWithNewSchema((IndexedRecord)this.data, newSchema, renameCols);
        return new HoodieAvroIndexedRecord(this.key, (IndexedRecord)record, this.operation, (Option<Map<String, String>>)this.metaData, this.orderingValue, this.isDelete);
    }

    @Override
    public HoodieRecord truncateRecordKey(Schema recordSchema, Properties props, String keyFieldName) {
        this.decodeRecord(recordSchema);
        ((GenericRecord)this.data).put(keyFieldName, (Object)"");
        return this;
    }

    @Override
    protected boolean checkIsDelete(DeleteContext deleteContext, Properties props) {
        if (this.data == null || HoodieOperation.isDelete(this.getOperation())) {
            return true;
        }
        this.decodeRecord(deleteContext.getReaderSchema());
        if (this.getData().equals(SENTINEL)) {
            return false;
        }
        return AvroRecordContext.getFieldAccessorInstance().isDeleteRecord(this.data, deleteContext);
    }

    @Override
    public boolean shouldIgnore(Schema recordSchema, Properties props) throws IOException {
        this.decodeRecord(recordSchema);
        return this.getData().equals(SENTINEL);
    }

    @Override
    public HoodieRecord<IndexedRecord> copy() {
        return this;
    }

    @Override
    public HoodieRecord wrapIntoHoodieRecordPayloadWithParams(Schema recordSchema, Properties props, Option<Pair<String, String>> simpleKeyGenFieldsOpt, Boolean withOperation, Option<String> partitionNameOp, Boolean populateMetaFields, Option<Schema> schemaWithoutMetaFields) {
        String payloadClass = ConfigUtils.getPayloadClass(props);
        String[] orderingFields = ConfigUtils.getOrderingFields(props);
        this.decodeRecord(recordSchema);
        return HoodieAvroUtils.createHoodieRecordFromAvro((IndexedRecord)this.data, payloadClass, orderingFields, simpleKeyGenFieldsOpt, withOperation, partitionNameOp, populateMetaFields, schemaWithoutMetaFields);
    }

    @Override
    public HoodieRecord wrapIntoHoodieRecordPayloadWithKeyGen(Schema recordSchema, Properties props, Option<BaseKeyGenerator> keyGen) {
        String partition;
        String key;
        this.decodeRecord(recordSchema);
        GenericRecord record = (GenericRecord)this.data;
        if (keyGen.isPresent() && !Boolean.parseBoolean(props.getOrDefault((Object)HoodieTableConfig.POPULATE_META_FIELDS.key(), HoodieTableConfig.POPULATE_META_FIELDS.defaultValue().toString()).toString())) {
            BaseKeyGenerator keyGeneratorOpt = (BaseKeyGenerator)keyGen.get();
            key = keyGeneratorOpt.getRecordKey(record);
            partition = keyGeneratorOpt.getPartitionPath(record);
        } else {
            key = record.get(HoodieRecord.RECORD_KEY_METADATA_FIELD).toString();
            partition = record.get(HoodieRecord.PARTITION_PATH_METADATA_FIELD).toString();
        }
        HoodieKey hoodieKey = new HoodieKey(key, partition);
        return new HoodieAvroIndexedRecord(hoodieKey, (IndexedRecord)record);
    }

    @Override
    public Option<Map<String, String>> getMetadata() {
        if (this.metaData == null) {
            return Option.empty();
        }
        return this.metaData;
    }

    @Override
    public Comparable<?> doGetOrderingValue(Schema recordSchema, Properties props, String[] orderingFields) {
        if (orderingFields == null || orderingFields.length == 0) {
            return OrderingValues.getDefault();
        }
        this.decodeRecord(recordSchema);
        boolean consistentLogicalTimestampEnabled = Boolean.parseBoolean(props.getProperty(KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.key(), KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.defaultValue()));
        return OrderingValues.create(orderingFields, field -> (Comparable)HoodieAvroUtils.getNestedFieldVal((GenericRecord)this.data, field, true, consistentLogicalTimestampEnabled));
    }

    private void decodeRecord(Schema recordSchema) {
        this.binaryRecord.decodeRecord(recordSchema);
    }

    @Override
    public Option<HoodieAvroIndexedRecord> toIndexedRecord(Schema recordSchema, Properties props) {
        this.decodeRecord(recordSchema);
        return Option.of((Object)this);
    }

    @Override
    public ByteArrayOutputStream getAvroBytes(Schema recordSchema, Properties props) {
        return HoodieAvroUtils.avroToBytesStream((IndexedRecord)this.data);
    }

    @Override
    protected final void writeRecordPayload(IndexedRecord payload, Kryo kryo, Output output) {
        Serializer avroSerializer = kryo.getSerializer(SerializableIndexedRecord.class);
        kryo.writeObjectOrNull(output, (Object)payload, avroSerializer);
    }

    @Override
    protected final IndexedRecord readRecordPayload(Kryo kryo, Input input) {
        SerializableIndexedRecord data;
        this.binaryRecord = data = (SerializableIndexedRecord)kryo.readObjectOrNull(input, SerializableIndexedRecord.class);
        return data;
    }

    @Override
    public Object convertColumnValueForLogicalType(Schema fieldSchema, Object fieldValue, boolean keepConsistentLogicalTimestamp) {
        return HoodieAvroUtils.convertValueForAvroLogicalTypes(fieldSchema, fieldValue, keepConsistentLogicalTimestamp);
    }

    static void updateMetadataValuesInternal(GenericRecord avroRecord, MetadataValues metadataValues) {
        if (metadataValues.isEmpty()) {
            return;
        }
        String[] values = metadataValues.getValues();
        for (int pos = 0; pos < values.length; ++pos) {
            String value = values[pos];
            if (value == null) continue;
            avroRecord.put(HoodieRecord.HoodieMetadataField.values()[pos].getFieldName(), (Object)value);
        }
    }

    @Override
    public IndexedRecord getData() {
        return this.binaryRecord;
    }
}

