/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.AvroRecordContext;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.BaseAvroPayload;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.MetadataValues;
import org.apache.hudi.common.table.read.DeleteContext;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.metadata.HoodieMetadataPayload;

public class HoodieAvroRecord<T extends HoodieRecordPayload>
extends HoodieRecord<T> {
    public HoodieAvroRecord(HoodieKey key, T data) {
        super(key, data);
    }

    public HoodieAvroRecord(HoodieKey key, T data, HoodieOperation hoodieOperation, Comparable orderingValue, Boolean isDelete) {
        super(key, data, hoodieOperation, isDelete, (Option<Map<String, String>>)Option.empty());
        this.orderingValue = orderingValue;
    }

    public HoodieAvroRecord(HoodieKey key, T data, HoodieOperation operation) {
        super(key, data, operation, (Option<Map<String, String>>)Option.empty());
    }

    public HoodieAvroRecord(HoodieRecord<T> record) {
        super(record);
    }

    public HoodieAvroRecord(HoodieKey key, T data, HoodieOperation operation, HoodieRecordLocation currentLocation, HoodieRecordLocation newLocation) {
        super(key, data, operation, currentLocation, newLocation);
    }

    public HoodieAvroRecord() {
    }

    @Override
    public HoodieRecord<T> newInstance() {
        return new HoodieAvroRecord<T>(this);
    }

    @Override
    public HoodieRecord<T> newInstance(HoodieKey key, HoodieOperation op) {
        return new HoodieAvroRecord<HoodieRecordPayload>(key, (HoodieRecordPayload)this.data, op, this.orderingValue, this.isDelete);
    }

    @Override
    public HoodieRecord<T> newInstance(HoodieKey key) {
        return new HoodieAvroRecord<HoodieRecordPayload>(key, (HoodieRecordPayload)this.data, this.operation, this.orderingValue, this.isDelete);
    }

    @Override
    public T getData() {
        if (this.data == null) {
            throw new IllegalStateException("Payload already deflated for record.");
        }
        return (T)((HoodieRecordPayload)this.data);
    }

    @Override
    public Comparable<?> doGetOrderingValue(Schema recordSchema, Properties props, String[] orderingFields) {
        return this.getData().getOrderingValue();
    }

    @Override
    public String getRecordKey(Schema recordSchema, Option<BaseKeyGenerator> keyGeneratorOpt) {
        return this.getRecordKey();
    }

    @Override
    public String getRecordKey(Schema recordSchema, String keyFieldName) {
        return this.getRecordKey();
    }

    @Override
    public HoodieRecord.HoodieRecordType getRecordType() {
        return HoodieRecord.HoodieRecordType.AVRO;
    }

    @Override
    public Object[] getColumnValues(Schema recordSchema, String[] columns, boolean consistentLogicalTimestampEnabled) {
        return HoodieAvroUtils.getRecordColumnValues((HoodieRecord)this, columns, recordSchema, consistentLogicalTimestampEnabled);
    }

    @Override
    public Object getColumnValueAsJava(Schema recordSchema, String column, Properties props) {
        try {
            Option<IndexedRecord> indexedRecordOpt = this.getData().getInsertValue(recordSchema, props);
            if (indexedRecordOpt.isPresent()) {
                return AvroRecordContext.getFieldValueFromIndexedRecord((IndexedRecord)indexedRecordOpt.get(), column);
            }
            return null;
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not fetch value for column: " + column);
        }
    }

    @Override
    public HoodieRecord joinWith(HoodieRecord other, Schema targetSchema) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HoodieRecord prependMetaFields(Schema recordSchema, Schema targetSchema, MetadataValues metadataValues, Properties props) {
        try {
            Option<IndexedRecord> avroRecordOpt = this.getData().getInsertValue(recordSchema, props);
            GenericRecord newAvroRecord = HoodieAvroUtils.rewriteRecordWithNewSchema((IndexedRecord)avroRecordOpt.get(), targetSchema);
            HoodieAvroIndexedRecord.updateMetadataValuesInternal(newAvroRecord, metadataValues);
            return new HoodieAvroIndexedRecord(this.getKey(), (IndexedRecord)newAvroRecord, this.getOperation(), this.currentLocation, this.newLocation);
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to deserialize record!", e);
        }
    }

    @Override
    public HoodieRecord updateMetaField(Schema recordSchema, int ordinal, String value) {
        try {
            Option<IndexedRecord> avroRecordOpt = this.getData().getInsertValue(recordSchema);
            IndexedRecord avroRecord = (IndexedRecord)avroRecordOpt.orElseThrow(() -> new HoodieIOException("Failed to get insert value for record schema: " + recordSchema));
            avroRecord.put(ordinal, (Object)value);
            return new HoodieAvroIndexedRecord(this.getKey(), avroRecord, this.getOperation(), this.currentLocation, this.newLocation);
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to deserialize record!", e);
        }
    }

    @Override
    public HoodieRecord rewriteRecordWithNewSchema(Schema recordSchema, Properties props, Schema newSchema, Map<String, String> renameCols) {
        try {
            GenericRecord oldRecord = (GenericRecord)this.getData().getInsertValue(recordSchema, props).get();
            GenericRecord rewriteRecord = HoodieAvroUtils.rewriteRecordWithNewSchema((IndexedRecord)oldRecord, newSchema, renameCols);
            return new HoodieAvroIndexedRecord(this.getKey(), (IndexedRecord)rewriteRecord, this.getOperation(), this.currentLocation, this.newLocation);
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to deserialize record!", e);
        }
    }

    @Override
    public HoodieRecord truncateRecordKey(Schema recordSchema, Properties props, String keyFieldName) throws IOException {
        GenericRecord avroRecordPayload = (GenericRecord)this.getData().getInsertValue(recordSchema, props).get();
        avroRecordPayload.put(keyFieldName, (Object)"");
        return new HoodieAvroIndexedRecord(this.getKey(), (IndexedRecord)avroRecordPayload, this.getOperation(), this.currentLocation, this.newLocation);
    }

    @Override
    protected boolean checkIsDelete(DeleteContext deleteContext, Properties props) throws IOException {
        if (HoodieOperation.isDelete(this.getOperation())) {
            return true;
        }
        if (this.data instanceof BaseAvroPayload) {
            return ((BaseAvroPayload)this.data).isDeleted(deleteContext.getReaderSchema(), props);
        }
        if (this.data instanceof HoodieMetadataPayload) {
            return ((HoodieMetadataPayload)this.data).isDeleted();
        }
        return !((HoodieRecordPayload)this.data).getInsertValue(deleteContext.getReaderSchema(), props).isPresent();
    }

    @Override
    public boolean shouldIgnore(Schema recordSchema, Properties props) throws IOException {
        Object recordPayload = this.getData();
        if (recordPayload instanceof BaseAvroPayload && ((BaseAvroPayload)recordPayload).canProduceSentinel()) {
            Option<IndexedRecord> insertRecord = recordPayload.getInsertValue(recordSchema, props);
            return insertRecord.isPresent() && ((IndexedRecord)insertRecord.get()).equals(SENTINEL);
        }
        return false;
    }

    @Override
    public HoodieRecord<T> copy() {
        return this;
    }

    @Override
    public HoodieRecord wrapIntoHoodieRecordPayloadWithParams(Schema recordSchema, Properties props, Option<Pair<String, String>> simpleKeyGenFieldsOpt, Boolean withOperation, Option<String> partitionNameOp, Boolean populateMetaFields, Option<Schema> schemaWithoutMetaFields) throws IOException {
        IndexedRecord indexedRecord = (IndexedRecord)((HoodieRecordPayload)this.data).getInsertValue(recordSchema, props).get();
        String payloadClass = ConfigUtils.getPayloadClass(props);
        String[] orderingFields = ConfigUtils.getOrderingFields(props);
        return HoodieAvroUtils.createHoodieRecordFromAvro(indexedRecord, payloadClass, orderingFields, simpleKeyGenFieldsOpt, withOperation, partitionNameOp, populateMetaFields, schemaWithoutMetaFields);
    }

    @Override
    public HoodieRecord wrapIntoHoodieRecordPayloadWithKeyGen(Schema recordSchema, Properties props, Option<BaseKeyGenerator> keyGen) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Option<Map<String, String>> getMetadata() {
        return this.getData().getMetadata();
    }

    @Override
    public Option<HoodieAvroIndexedRecord> toIndexedRecord(Schema recordSchema, Properties props) throws IOException {
        Option<IndexedRecord> avroData = this.getData().getIndexedRecord(recordSchema, props);
        if (avroData.isPresent()) {
            HoodieAvroIndexedRecord record = new HoodieAvroIndexedRecord(this.key, (IndexedRecord)avroData.get(), this.operation, this.getData().getMetadata(), this.getData().getOrderingValue(), this.isDelete);
            return Option.of((Object)record);
        }
        return Option.empty();
    }

    @Override
    public ByteArrayOutputStream getAvroBytes(Schema recordSchema, Properties props) throws IOException {
        if (this.data instanceof BaseAvroPayload) {
            byte[] data = ((BaseAvroPayload)this.getData()).getRecordBytes();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(data.length);
            baos.write(data);
            return baos;
        }
        Option<IndexedRecord> avroData = this.getData().getInsertValue(recordSchema, props);
        return (ByteArrayOutputStream)avroData.map(HoodieAvroUtils::avroToBytesStream).orElse((Object)new ByteArrayOutputStream(0));
    }

    @Override
    protected final void writeRecordPayload(T payload, Kryo kryo, Output output) {
        kryo.writeClassAndObject(output, payload);
    }

    @Override
    protected final T readRecordPayload(Kryo kryo, Input input) {
        return (T)((HoodieRecordPayload)kryo.readClassAndObject(input));
    }

    @Override
    public Object convertColumnValueForLogicalType(Schema fieldSchema, Object fieldValue, boolean keepConsistentLogicalTimestamp) {
        return HoodieAvroUtils.convertValueForAvroLogicalTypes(fieldSchema, fieldValue, keepConsistentLogicalTimestamp);
    }
}

