/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.RecordContext;
import org.apache.hudi.common.model.HoodiePreCombineAvroRecordMerger;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.model.OperationModeAwareness;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.table.read.BufferedRecords;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.HoodieRecordUtils;
import org.apache.hudi.common.util.Option;

public class HoodieAvroRecordMerger
implements HoodieRecordMerger,
OperationModeAwareness {
    public static final String PAYLOAD_CLASS_PROP = "_hoodie.merger.payload.class";
    protected String payloadClass;
    protected String[] orderingFields;

    @Override
    public String getMergingStrategy() {
        return "00000000-0000-0000-0000-000000000000";
    }

    @Override
    public <T> BufferedRecord<T> merge(BufferedRecord<T> older, BufferedRecord<T> newer, RecordContext<T> recordContext, TypedProperties props) throws IOException {
        if (HoodieRecordMerger.isCommitTimeOrderingDelete(older, newer)) {
            return newer;
        }
        this.init(props);
        GenericRecord previousAvroData = older.getRecord() == null ? null : recordContext.convertToAvroRecord(older.getRecord(), recordContext.getSchemaFromBufferRecord(older));
        Schema newerSchema = recordContext.getSchemaFromBufferRecord(newer);
        GenericRecord newerAvroRecord = newer.getRecord() == null ? null : recordContext.convertToAvroRecord(newer.getRecord(), recordContext.getSchemaFromBufferRecord(newer));
        Object payload = HoodieRecordUtils.loadPayload(this.payloadClass, newerAvroRecord, newer.getOrderingValue());
        if (previousAvroData == null) {
            return newer;
        }
        Option<IndexedRecord> updatedValue = payload.combineAndGetUpdateValue((IndexedRecord)previousAvroData, newerSchema, props);
        if (updatedValue.isPresent()) {
            IndexedRecord updatedRecord = (IndexedRecord)updatedValue.get();
            if (updatedRecord == previousAvroData || updatedRecord == HoodieRecord.SENTINEL) {
                return older;
            }
            if (updatedRecord == newerAvroRecord) {
                return newer;
            }
            T resultRecord = recordContext.convertAvroRecord(updatedRecord);
            return BufferedRecords.fromEngineRecord(resultRecord, (Schema)updatedValue.map(GenericContainer::getSchema).orElseGet(() -> newerSchema), recordContext, this.orderingFields, newer.getRecordKey(), updatedValue.isEmpty());
        }
        if (newer.isDelete()) {
            return newer;
        }
        if (older.isDelete()) {
            return older;
        }
        return BufferedRecords.createDelete(newer.getRecordKey(), HoodieRecordMerger.maxOrderingValue(older, newer));
    }

    protected void init(TypedProperties props) {
        if (this.payloadClass == null) {
            this.payloadClass = (String)Option.ofNullable((Object)props.getString(PAYLOAD_CLASS_PROP, null)).orElseGet(() -> ConfigUtils.getPayloadClass(props));
        }
        if (this.orderingFields == null) {
            this.orderingFields = ConfigUtils.getOrderingFields(props);
            if (this.orderingFields == null) {
                this.orderingFields = new String[0];
            }
        }
    }

    @Override
    public HoodieRecord.HoodieRecordType getRecordType() {
        return HoodieRecord.HoodieRecordType.AVRO;
    }

    @Override
    public HoodieRecordMerger asPreCombiningMode() {
        return new HoodiePreCombineAvroRecordMerger();
    }
}

