/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.metadata.HoodieIndexVersion;
import org.apache.hudi.metadata.MetadataPartitionType;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HoodieIndexDefinition
implements Serializable {
    private String indexName;
    private String indexType;
    private String indexFunction;
    private List<String> sourceFields;
    @JsonIgnore
    private String sourceFieldsKey;
    private Map<String, String> indexOptions;
    private HoodieIndexVersion version;

    public HoodieIndexDefinition() {
    }

    private HoodieIndexDefinition(String indexName, String indexType, String indexFunction, List<String> sourceFields, Map<String, String> indexOptions, HoodieIndexVersion version) {
        this.indexName = indexName;
        this.indexType = indexType;
        this.indexFunction = StringUtils.nonEmpty((String)indexFunction) ? indexFunction : "";
        this.sourceFields = sourceFields;
        this.indexOptions = indexOptions;
        this.version = version;
    }

    public String getIndexFunction() {
        return this.indexFunction;
    }

    public List<String> getSourceFields() {
        return this.sourceFields;
    }

    public String getSourceFieldsKey() {
        if (this.sourceFieldsKey == null) {
            this.sourceFieldsKey = String.join((CharSequence)".", this.sourceFields);
        }
        return this.sourceFieldsKey;
    }

    public Map<String, String> getIndexOptions() {
        return this.indexOptions;
    }

    public HoodieIndexVersion getVersion() {
        return this.version;
    }

    public String getExpressionIndexFormatOption(String defaultValue) {
        return this.indexOptions.getOrDefault("format", defaultValue);
    }

    public String getExpressionIndexFormatOption() {
        return this.indexOptions.get("format");
    }

    public String getExpressionIndexDaysOption() {
        return this.indexOptions.get("days");
    }

    public String getExpressionIndexPositionOption() {
        return this.indexOptions.get("pos");
    }

    public String getExpressionIndexLengthOption() {
        return this.indexOptions.get("len");
    }

    public String getExpressionIndexPatternOption() {
        return this.indexOptions.get("pattern");
    }

    public String getExpressionIndexReplacementOption() {
        return this.indexOptions.get("replacement");
    }

    public String getExpressionIndexIndexOption() {
        return this.indexOptions.get("idx");
    }

    public String getExpressionIndexTrimStringOption() {
        return this.indexOptions.get("trimString");
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.withIndexName(this.indexName).withIndexType(this.indexType).withIndexFunction(this.indexFunction).withSourceFields(new ArrayList<String>(this.sourceFields)).withIndexOptions(new HashMap<String, String>(this.indexOptions)).withVersion(this.version);
        return builder;
    }

    public String toString() {
        return new StringJoiner(", ", HoodieIndexDefinition.class.getSimpleName() + "[", "]").add("indexName='" + this.indexName + "'").add("indexType='" + this.indexType + "'").add("indexFunction='" + this.indexFunction + "'").add("sourceFields=" + this.sourceFields).add("indexOptions=" + this.indexOptions).add("version=" + (Object)((Object)this.version)).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HoodieIndexDefinition)) {
            return false;
        }
        HoodieIndexDefinition that = (HoodieIndexDefinition)o;
        return Objects.equals(this.indexName, that.indexName) && Objects.equals(this.indexType, that.indexType) && Objects.equals(this.indexFunction, that.indexFunction) && Objects.equals(this.sourceFields, that.sourceFields) && Objects.equals(this.indexOptions, that.indexOptions) && Objects.equals((Object)this.version, (Object)that.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.indexName, this.indexType, this.indexFunction, this.sourceFields, this.indexOptions, this.version});
    }

    public static class Builder {
        private String indexName;
        private String indexType;
        private String indexFunction;
        private List<String> sourceFields = new ArrayList<String>();
        private Map<String, String> indexOptions = new HashMap<String, String>();
        private HoodieIndexVersion version = null;

        public Builder withIndexName(String indexName) {
            ValidationUtils.checkArgument((MetadataPartitionType.fromPartitionPath(indexName) != null ? 1 : 0) != 0, (String)"Invalid index name");
            this.indexName = indexName;
            return this;
        }

        public Builder withIndexType(String indexType) {
            this.indexType = indexType;
            return this;
        }

        public Builder withIndexFunction(String indexFunction) {
            this.indexFunction = indexFunction;
            return this;
        }

        public Builder withSourceFields(List<String> sourceFields) {
            this.sourceFields = sourceFields;
            return this;
        }

        public Builder withIndexOptions(Map<String, String> indexOptions) {
            this.indexOptions = indexOptions;
            return this;
        }

        public Builder withVersion(HoodieIndexVersion version) {
            this.version = version;
            return this;
        }

        public HoodieIndexDefinition build() {
            ValidationUtils.checkArgument((this.indexName != null ? 1 : 0) != 0, (String)"Could not build index definition with a null index name");
            ValidationUtils.checkArgument((this.indexType != null ? 1 : 0) != 0, (String)"Could not build index definition with a null index type");
            return new HoodieIndexDefinition(this.indexName, this.indexType, this.indexFunction, this.sourceFields, this.indexOptions, this.version);
        }
    }
}

