/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.util.JsonUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HoodieIndexMetadata
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieIndexMetadata.class);
    private Map<String, HoodieIndexDefinition> indexDefinitions;

    public HoodieIndexMetadata() {
        this.indexDefinitions = new HashMap<String, HoodieIndexDefinition>();
    }

    public HoodieIndexMetadata(Map<String, HoodieIndexDefinition> indexDefinitions) {
        this.indexDefinitions = indexDefinitions;
        HoodieIndexMetadata.validateIndexMetadata(this);
    }

    public Map<String, HoodieIndexDefinition> getIndexDefinitions() {
        return this.indexDefinitions;
    }

    public void setIndexDefinitions(Map<String, HoodieIndexDefinition> indexDefinitions) {
        this.indexDefinitions = indexDefinitions;
        HoodieIndexMetadata.validateIndexMetadata(this);
    }

    public boolean hasIndex(String indexName) {
        return this.indexDefinitions != null && this.indexDefinitions.containsKey(indexName) && this.indexDefinitions.get(indexName) != null;
    }

    public Option<HoodieIndexDefinition> getIndex(String indexName) {
        HoodieIndexDefinition indexDef;
        if (this.indexDefinitions != null && this.indexDefinitions.containsKey(indexName) && (indexDef = this.indexDefinitions.get(indexName)) != null) {
            return Option.of((Object)indexDef);
        }
        return Option.empty();
    }

    public String toJson() throws JsonProcessingException {
        if (this.indexDefinitions.containsKey(null)) {
            LOG.info("null index name for the index definition " + this.indexDefinitions.get(null));
            this.indexDefinitions.remove(null);
        }
        return JsonUtils.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
    }

    public static HoodieIndexMetadata fromJson(String json) throws IOException {
        if (json == null || json.isEmpty()) {
            return new HoodieIndexMetadata();
        }
        return (HoodieIndexMetadata)JsonUtils.getObjectMapper().readValue(json, HoodieIndexMetadata.class);
    }

    public String toString() {
        return new StringJoiner(", ", HoodieIndexMetadata.class.getSimpleName() + "[", "]").add("indexDefinitions=" + this.indexDefinitions).toString();
    }

    public static void validateIndexMetadata(HoodieIndexMetadata indexMetadata) {
        Option<HoodieIndexDefinition> colStatsDef = indexMetadata.getIndex("column_stats");
        Option<HoodieIndexDefinition> partitionStatsDef = indexMetadata.getIndex("partition_stats");
        if (colStatsDef.isPresent() && partitionStatsDef.isPresent()) {
            ValidationUtils.checkArgument((boolean)((HoodieIndexDefinition)colStatsDef.get()).getVersion().equals((Object)((HoodieIndexDefinition)partitionStatsDef.get()).getVersion()), (String)"Column stats and partition stats are not on the same version");
        }
    }
}

