/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import java.util.regex.Matcher;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.exception.InvalidHoodiePathException;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;

public class HoodieLogFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DELTA_EXTENSION = ".log";
    public static final String LOG_FILE_PREFIX = ".";
    public static final Integer LOGFILE_BASE_VERSION = 1;
    private static final Comparator<HoodieLogFile> LOG_FILE_COMPARATOR = new LogFileComparator();
    private static final Comparator<HoodieLogFile> LOG_FILE_COMPARATOR_REVERSED = new LogFileComparator().reversed();
    private transient StoragePathInfo pathInfo;
    private transient StoragePath path;
    private final String pathStr;
    private String fileId;
    private String deltaCommitTime;
    private int logVersion;
    private String logWriteToken;
    private String fileExtension;
    private String suffix;
    private long fileLen;

    public HoodieLogFile(HoodieLogFile logFile) {
        this.pathInfo = logFile.getPathInfo();
        this.path = logFile.getPath();
        this.pathStr = logFile.pathStr;
        this.fileId = logFile.getFileId();
        this.deltaCommitTime = logFile.getDeltaCommitTime();
        this.logVersion = logFile.getLogVersion();
        this.logWriteToken = logFile.getLogWriteToken();
        this.fileExtension = logFile.getFileExtension();
        this.suffix = logFile.getSuffix();
        this.fileLen = logFile.getFileSize();
    }

    public HoodieLogFile(StoragePathInfo pathInfo) {
        this(pathInfo, pathInfo.getPath(), pathInfo.getPath().toString(), pathInfo.getLength());
    }

    public HoodieLogFile(StoragePath logPath) {
        this(null, logPath, logPath.toString(), -1L);
    }

    public HoodieLogFile(StoragePath logPath, long fileLen) {
        this(null, logPath, logPath.toString(), fileLen);
    }

    public HoodieLogFile(String logPathStr) {
        this(null, null, logPathStr, -1L);
    }

    private HoodieLogFile(StoragePathInfo pathInfo, StoragePath logPath, String logPathStr, long fileLen) {
        this.pathInfo = pathInfo;
        this.pathStr = logPathStr;
        this.fileLen = fileLen;
        this.logVersion = -1;
        this.path = logPath;
    }

    private void parseFieldsFromPath() {
        Matcher matcher = FSUtils.LOG_FILE_PATTERN.matcher(this.getPath().getName());
        if (!matcher.matches()) {
            throw new InvalidHoodiePathException(this.path, "LogFile");
        }
        this.fileId = matcher.group(1);
        this.deltaCommitTime = matcher.group(2);
        this.fileExtension = matcher.group(3);
        this.logVersion = Integer.parseInt(matcher.group(4));
        this.logWriteToken = matcher.group(6);
        this.suffix = matcher.group(10) == null ? "" : matcher.group(10);
    }

    public String getFileId() {
        if (this.fileId == null) {
            this.parseFieldsFromPath();
        }
        return this.fileId;
    }

    public String getDeltaCommitTime() {
        if (this.deltaCommitTime == null) {
            this.parseFieldsFromPath();
        }
        return this.deltaCommitTime;
    }

    public int getLogVersion() {
        if (this.logVersion == -1) {
            this.parseFieldsFromPath();
        }
        return this.logVersion;
    }

    public String getLogWriteToken() {
        if (this.logWriteToken == null) {
            this.parseFieldsFromPath();
        }
        return this.logWriteToken;
    }

    public String getFileExtension() {
        if (this.fileExtension == null) {
            this.parseFieldsFromPath();
        }
        return this.fileExtension;
    }

    public boolean isCDC() {
        return this.getSuffix().equals(".cdc");
    }

    public String getSuffix() {
        if (this.suffix == null) {
            this.parseFieldsFromPath();
        }
        return this.suffix;
    }

    public StoragePath getPath() {
        if (this.path == null) {
            this.path = new StoragePath(this.pathStr);
        }
        return this.path;
    }

    public String getFileName() {
        return this.getPath().getName();
    }

    public void setFileLen(long fileLen) {
        this.fileLen = fileLen;
    }

    public long getFileSize() {
        return this.fileLen;
    }

    public StoragePathInfo getPathInfo() {
        return this.pathInfo;
    }

    public void setPathInfo(StoragePathInfo pathInfo) {
        this.pathInfo = pathInfo;
    }

    public HoodieLogFile rollOver(String logWriteToken) {
        String fileId = this.getFileId();
        String deltaCommitTime = this.getDeltaCommitTime();
        StoragePath path = this.getPath();
        String extension = LOG_FILE_PREFIX + this.fileExtension;
        return new HoodieLogFile(new StoragePath(path.getParent(), FSUtils.makeLogFileName(fileId, extension, deltaCommitTime, this.logVersion + 1, logWriteToken)));
    }

    public static Comparator<HoodieLogFile> getLogFileComparator() {
        return LOG_FILE_COMPARATOR;
    }

    public static Comparator<HoodieLogFile> getReverseLogFileComparator() {
        return LOG_FILE_COMPARATOR_REVERSED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HoodieLogFile that = (HoodieLogFile)o;
        return Objects.equals(this.pathStr, that.pathStr);
    }

    public int hashCode() {
        return Objects.hash(this.pathStr);
    }

    public String toString() {
        return "HoodieLogFile{pathStr='" + this.pathStr + '\'' + ", fileLen=" + this.fileLen + '}';
    }

    public static class LogFileComparator
    implements Comparator<HoodieLogFile>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private transient Comparator<String> writeTokenComparator;

        private Comparator<String> getWriteTokenComparator() {
            if (null == this.writeTokenComparator) {
                this.writeTokenComparator = Comparator.nullsFirst(Comparator.naturalOrder());
            }
            return this.writeTokenComparator;
        }

        @Override
        public int compare(HoodieLogFile o1, HoodieLogFile o2) {
            String deltaCommitTime2;
            String deltaCommitTime1 = o1.getDeltaCommitTime();
            if (deltaCommitTime1.equals(deltaCommitTime2 = o2.getDeltaCommitTime())) {
                if (o1.getLogVersion() == o2.getLogVersion()) {
                    int compareWriteToken = this.getWriteTokenComparator().compare(o1.getLogWriteToken(), o2.getLogWriteToken());
                    if (compareWriteToken == 0) {
                        return o1.getSuffix().compareTo(o2.getSuffix());
                    }
                    return compareWriteToken;
                }
                return Integer.compare(o1.getLogVersion(), o2.getLogVersion());
            }
            return deltaCommitTime1.compareTo(deltaCommitTime2);
        }
    }
}

