/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.RecordContext;
import org.apache.hudi.common.model.HoodieAvroRecordMerger;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.table.read.BufferedRecords;
import org.apache.hudi.common.util.HoodieRecordUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieIOException;

public class HoodiePreCombineAvroRecordMerger
extends HoodieAvroRecordMerger {
    @Override
    public <T> BufferedRecord<T> merge(BufferedRecord<T> older, BufferedRecord<T> newer, RecordContext<T> recordContext, TypedProperties props) throws IOException {
        if (HoodieRecordMerger.isCommitTimeOrderingDelete(older, newer)) {
            return newer;
        }
        this.init(props);
        return this.preCombine(older, newer, recordContext, recordContext.getSchemaFromBufferRecord(newer), props);
    }

    private <T> BufferedRecord<T> preCombine(BufferedRecord<T> older, BufferedRecord<T> newer, RecordContext<T> recordContext, Schema newSchema, TypedProperties props) {
        GenericRecord newerAvroRecord = recordContext.convertToAvroRecord(newer.getRecord(), recordContext.getSchemaFromBufferRecord(newer));
        GenericRecord olderAvroRecord = recordContext.convertToAvroRecord(older.getRecord(), recordContext.getSchemaFromBufferRecord(older));
        Object newerPayload = HoodieRecordUtils.loadPayload(this.payloadClass, newerAvroRecord, newer.getOrderingValue());
        Object olderPayload = HoodieRecordUtils.loadPayload(this.payloadClass, olderAvroRecord, older.getOrderingValue());
        Object payload = newerPayload.preCombine(olderPayload, newSchema, props);
        try {
            if (payload == olderPayload) {
                return older;
            }
            if (payload == newerPayload) {
                return newer;
            }
            Option<IndexedRecord> indexedRecord = payload.getIndexedRecord(newSchema, props);
            Object mergedRecord = indexedRecord.map(recordContext::convertAvroRecord).orElse(null);
            return BufferedRecords.fromEngineRecord(mergedRecord, newSchema, recordContext, this.orderingFields, newer.getRecordKey(), indexedRecord.isEmpty());
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to combine records", e);
        }
    }
}

