/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.Serializable;
import java.util.Objects;

public class HoodieRecordLocation
implements Serializable,
KryoSerializable {
    public static final long INVALID_POSITION = -1L;
    protected String instantTime;
    protected String fileId;
    protected long position;

    public HoodieRecordLocation() {
    }

    public HoodieRecordLocation(String instantTime, String fileId) {
        this(instantTime, fileId, -1L);
    }

    public HoodieRecordLocation(String instantTime, String fileId, long position) {
        this.instantTime = instantTime;
        this.fileId = fileId;
        this.position = position;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HoodieRecordLocation otherLoc = (HoodieRecordLocation)o;
        return Objects.equals(this.instantTime, otherLoc.instantTime) && Objects.equals(this.fileId, otherLoc.fileId);
    }

    public int hashCode() {
        return Objects.hash(this.instantTime, this.fileId);
    }

    public String toString() {
        return "HoodieRecordLocation {instantTime=" + this.instantTime + ", fileId=" + this.fileId + ", position=" + this.position + '}';
    }

    public String getInstantTime() {
        return this.instantTime;
    }

    public void setInstantTime(String instantTime) {
        this.instantTime = instantTime;
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public static boolean isPositionValid(long position) {
        return position > -1L;
    }

    public long getPosition() {
        return this.position;
    }

    public void setPosition(long position) {
        this.position = position;
    }

    public void write(Kryo kryo, Output output) {
        output.writeString(this.instantTime);
        output.writeString(this.fileId);
        output.writeLong(this.position);
    }

    public void read(Kryo kryo, Input input) {
        this.instantTime = input.readString();
        this.fileId = input.readString();
        this.position = input.readLong();
    }
}

