/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hudi.ApiMaturityLevel;
import org.apache.hudi.PublicAPIClass;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.RecordContext;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;

@PublicAPIClass(maturity=ApiMaturityLevel.EVOLVING)
public interface HoodieRecordMerger
extends Serializable {
    public static final String EVENT_TIME_BASED_MERGE_STRATEGY_UUID = "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5";
    public static final String COMMIT_TIME_BASED_MERGE_STRATEGY_UUID = "ce9acb64-bde0-424c-9b91-f6ebba25356d";
    public static final String CUSTOM_MERGE_STRATEGY_UUID = "1897ef5f-18bc-4557-939c-9d6a8afd1519";
    public static final String PAYLOAD_BASED_MERGE_STRATEGY_UUID = "00000000-0000-0000-0000-000000000000";

    public <T> BufferedRecord merge(BufferedRecord<T> var1, BufferedRecord<T> var2, RecordContext<T> var3, TypedProperties var4) throws IOException;

    default public <T> BufferedRecord<T> partialMerge(BufferedRecord<T> older, BufferedRecord<T> newer, Schema readerSchema, RecordContext<T> recordContext, TypedProperties props) throws IOException {
        throw new UnsupportedOperationException("Partial merging logic is not implemented by " + this.getClass().getName());
    }

    default public boolean isProjectionCompatible() {
        return false;
    }

    default public String[] getMandatoryFieldsForMerging(Schema dataSchema, HoodieTableConfig cfg, TypedProperties properties) {
        ArrayList<Object> requiredFields = new ArrayList<Object>();
        if (cfg.populateMetaFields()) {
            requiredFields.add(HoodieRecord.RECORD_KEY_METADATA_FIELD);
        } else {
            Option<String[]> fields = cfg.getRecordKeyFields();
            if (fields.isPresent()) {
                requiredFields.addAll(Arrays.asList((Object[])fields.get()));
            }
        }
        List<String> orderingFields = cfg.getOrderingFields();
        requiredFields.addAll(orderingFields);
        return requiredFields.toArray(new String[0]);
    }

    public HoodieRecord.HoodieRecordType getRecordType();

    public String getMergingStrategy();

    public static String getRecordMergeStrategyId(RecordMergeMode mergeMode, String payloadClassName, String recordMergeStrategyId, HoodieTableVersion tableVersion) {
        switch (mergeMode) {
            case COMMIT_TIME_ORDERING: {
                return COMMIT_TIME_BASED_MERGE_STRATEGY_UUID;
            }
            case EVENT_TIME_ORDERING: {
                return EVENT_TIME_BASED_MERGE_STRATEGY_UUID;
            }
        }
        return HoodieRecordMerger.getCustomRecordMergeStrategyId(payloadClassName, recordMergeStrategyId, tableVersion);
    }

    public static String getCustomRecordMergeStrategyId(String payloadClassName, String recordMergeStrategyId, HoodieTableVersion tableVersion) {
        if (tableVersion.greaterThanOrEquals(HoodieTableVersion.EIGHT)) {
            if (StringUtils.nonEmpty((String)recordMergeStrategyId)) {
                return recordMergeStrategyId;
            }
            if (StringUtils.nonEmpty((String)payloadClassName)) {
                return PAYLOAD_BASED_MERGE_STRATEGY_UUID;
            }
            return null;
        }
        if (StringUtils.nonEmpty((String)payloadClassName)) {
            return PAYLOAD_BASED_MERGE_STRATEGY_UUID;
        }
        if (StringUtils.nonEmpty((String)recordMergeStrategyId)) {
            return recordMergeStrategyId;
        }
        return null;
    }

    public static <T> boolean isCommitTimeOrderingDelete(BufferedRecord<T> oldRecord, BufferedRecord<T> newRecord) {
        return newRecord.isCommitTimeOrderingDelete() || oldRecord.isCommitTimeOrderingDelete();
    }

    public static <T> Comparable maxOrderingValue(BufferedRecord<T> oldRecord, BufferedRecord<T> newRecord) {
        Comparable newOrderingVal;
        Comparable oldOrderingVal = oldRecord.getOrderingValue();
        return oldOrderingVal.compareTo(newOrderingVal = newRecord.getOrderingValue()) > 0 ? oldOrderingVal : newOrderingVal;
    }
}

