/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import java.util.Objects;
import org.apache.avro.JsonProperties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.model.BaseAvroPayload;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.OrderingValues;

public class OverwriteWithLatestAvroPayload
extends BaseAvroPayload
implements HoodieRecordPayload<OverwriteWithLatestAvroPayload> {
    public OverwriteWithLatestAvroPayload(GenericRecord record, Comparable orderingVal) {
        super(record, orderingVal);
    }

    public OverwriteWithLatestAvroPayload(Option<GenericRecord> record) {
        this(record.isPresent() ? (GenericRecord)record.get() : null, OrderingValues.getDefault());
    }

    @Override
    public OverwriteWithLatestAvroPayload preCombine(OverwriteWithLatestAvroPayload oldValue) {
        return this;
    }

    @Override
    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord currentValue, Schema schema) throws IOException {
        return this.getInsertValue(schema);
    }

    @Override
    public Option<IndexedRecord> getInsertValue(Schema schema) throws IOException {
        if (this.isEmptyRecord() || this.isDeletedRecord) {
            return Option.empty();
        }
        return this.getRecord(schema);
    }

    public Boolean overwriteField(Object value, Object defaultValue) {
        if (JsonProperties.NULL_VALUE.equals(defaultValue)) {
            return value == null;
        }
        return Objects.equals(value, defaultValue);
    }

    @Override
    public Comparable<?> getOrderingValue() {
        return this.orderingVal;
    }
}

