/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.JsonUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.HoodieInstantWriter;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PartitionBucketIndexHashingConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(PartitionBucketIndexHashingConfig.class);
    public static final String INITIAL_HASHING_CONFIG_INSTANT = "00000000000000";
    public static final String HASHING_CONFIG_FILE_SUFFIX = ".hashing_config";
    public static final Integer CURRENT_VERSION = 1;
    private final String expressions;
    private final int defaultBucketNumber;
    private final String rule;
    private final int version;
    private final String instant;

    @JsonCreator
    public PartitionBucketIndexHashingConfig(@JsonProperty(value="expressions") String expressions, @JsonProperty(value="defaultBucketNumber") int defaultBucketNumber, @JsonProperty(value="rule") String rule, @JsonProperty(value="version") int version, @JsonProperty(value="instant") String instant) {
        this.expressions = expressions;
        this.defaultBucketNumber = defaultBucketNumber;
        this.rule = rule;
        this.version = version;
        this.instant = instant;
    }

    public String getFilename() {
        return this.instant + HASHING_CONFIG_FILE_SUFFIX;
    }

    public String toJsonString() throws IOException {
        return JsonUtils.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
    }

    public String getInstant() {
        return this.instant;
    }

    public static <T> T fromJsonString(String jsonStr, Class<T> clazz) throws Exception {
        if (jsonStr == null || jsonStr.isEmpty()) {
            return clazz.newInstance();
        }
        return (T)JsonUtils.getObjectMapper().readValue(jsonStr, clazz);
    }

    public static PartitionBucketIndexHashingConfig fromBytes(byte[] bytes) throws IOException {
        try {
            return PartitionBucketIndexHashingConfig.fromJsonString(new String(bytes, StandardCharsets.UTF_8), PartitionBucketIndexHashingConfig.class);
        }
        catch (Exception e) {
            throw new IOException("unable to load hashing config", e);
        }
    }

    public int getVersion() {
        return this.version;
    }

    public String getRule() {
        return this.rule;
    }

    public int getDefaultBucketNumber() {
        return this.defaultBucketNumber;
    }

    public String getExpressions() {
        return this.expressions;
    }

    public static StoragePath getHashingConfigStorageFolder(String basePath) {
        StoragePath metaPath = new StoragePath(basePath, ".hoodie");
        return new StoragePath(metaPath, ".bucket_index/partition_bucket_index_meta/configs");
    }

    public static StoragePath getArchiveHashingConfigStorageFolder(String basePath) {
        StoragePath metaPath = new StoragePath(basePath, ".hoodie");
        return new StoragePath(metaPath, ".bucket_index/partition_bucket_index_meta/archive");
    }

    public static StoragePath getHashingConfigPath(String basePath, String instant) {
        StoragePath hashingBase = PartitionBucketIndexHashingConfig.getHashingConfigStorageFolder(basePath);
        return new StoragePath(hashingBase, instant + HASHING_CONFIG_FILE_SUFFIX);
    }

    public static StoragePath getArchiveHashingConfigPath(String basePath, String instant) {
        StoragePath hashingBase = PartitionBucketIndexHashingConfig.getArchiveHashingConfigStorageFolder(basePath);
        return new StoragePath(hashingBase, instant + HASHING_CONFIG_FILE_SUFFIX);
    }

    public static boolean saveHashingConfig(HoodieTableMetaClient metaClient, String expressions, String rule, int defaultBucketNumber, String instant) {
        if (StringUtils.isNullOrEmpty((String)expressions)) {
            return false;
        }
        String hashingInstant = StringUtils.isNullOrEmpty((String)instant) ? INITIAL_HASHING_CONFIG_INSTANT : instant;
        PartitionBucketIndexHashingConfig hashingConfig = new PartitionBucketIndexHashingConfig(expressions, defaultBucketNumber, rule, CURRENT_VERSION, hashingInstant);
        return PartitionBucketIndexHashingConfig.saveHashingConfig(hashingConfig, metaClient);
    }

    public static boolean saveHashingConfig(PartitionBucketIndexHashingConfig hashingConfig, HoodieTableMetaClient metaClient) {
        StoragePath hashingConfigPath = new StoragePath(metaClient.getHashingMetadataConfigPath(), hashingConfig.getFilename());
        HoodieStorage storage = metaClient.getStorage();
        try {
            Option content = Option.of((Object)hashingConfig.toJsonString().getBytes(StandardCharsets.UTF_8));
            storage.createImmutableFileInPath(hashingConfigPath, content.map(HoodieInstantWriter::convertByteArrayToWriter));
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Failed to initHashingConfig ", ioe);
        }
        return true;
    }

    public static Option<PartitionBucketIndexHashingConfig> loadHashingConfig(HoodieStorage storage, StoragePathInfo hashingConfig) {
        return PartitionBucketIndexHashingConfig.loadHashingConfig(storage, hashingConfig.getPath());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Option<PartitionBucketIndexHashingConfig> loadHashingConfig(HoodieStorage storage, StoragePath hashingConfig) {
        if (hashingConfig == null) {
            return Option.empty();
        }
        try (InputStream is = storage.open(hashingConfig);){
            byte[] content = FileIOUtils.readAsByteArray((InputStream)is);
            Option option = Option.of((Object)PartitionBucketIndexHashingConfig.fromBytes(content));
            return option;
        }
        catch (IOException e) {
            LOG.error("Error when loading hashing config, for path: " + hashingConfig.getName(), (Throwable)e);
            throw new HoodieIOException("Error while loading hashing config", e);
        }
    }

    public static Option<StoragePath> getHashingConfigToLoad(HoodieTableMetaClient metaClient, Option<String> instant) {
        try {
            String basePath = metaClient.getBasePath().toString();
            List<String> allCommittedHashingConfig = PartitionBucketIndexHashingConfig.getCommittedHashingConfigInstants(metaClient);
            if (instant.isPresent()) {
                Option res = PartitionBucketIndexHashingConfig.getHashingConfigInstantToLoadBeforeOrOn(allCommittedHashingConfig, (String)instant.get()).map(i -> PartitionBucketIndexHashingConfig.getHashingConfigPath(basePath, i));
                return res.isPresent() ? res : PartitionBucketIndexHashingConfig.getHashingConfigInstantToLoadBeforeOrOn(PartitionBucketIndexHashingConfig.getArchiveHashingConfigInstants(metaClient), (String)instant.get()).map(i -> PartitionBucketIndexHashingConfig.getArchiveHashingConfigPath(basePath, i));
            }
            return Option.of((Object)allCommittedHashingConfig.get(allCommittedHashingConfig.size() - 1)).map(i -> PartitionBucketIndexHashingConfig.getHashingConfigPath(basePath, i));
        }
        catch (Exception e) {
            throw new HoodieException("Failed to get hashing config instant to load.", (Throwable)e);
        }
    }

    public static List<PartitionBucketIndexHashingConfig> getAllHashingConfig(HoodieTableMetaClient metaClient) throws IOException {
        String basePath = metaClient.getBasePath().toString();
        List allHashingConfigPaths = PartitionBucketIndexHashingConfig.getCommittedHashingConfigInstants(metaClient).stream().map(instant -> PartitionBucketIndexHashingConfig.getHashingConfigPath(basePath, instant)).collect(Collectors.toList());
        if (metaClient.getStorage().exists(new StoragePath(metaClient.getArchiveHashingMetadataConfigPath()))) {
            allHashingConfigPaths.addAll(PartitionBucketIndexHashingConfig.getArchiveHashingConfigInstants(metaClient).stream().map(instant -> PartitionBucketIndexHashingConfig.getArchiveHashingConfigPath(basePath, instant)).collect(Collectors.toList()));
        }
        return allHashingConfigPaths.stream().map(hashingConfigPath -> PartitionBucketIndexHashingConfig.loadHashingConfig(metaClient.getStorage(), hashingConfigPath)).filter(Option::isPresent).map(Option::get).collect(Collectors.toList());
    }

    private static Option<String> getHashingConfigInstantToLoadBeforeOrOn(List<String> hashingConfigInstants, String instant) {
        List res = hashingConfigInstants.stream().filter(hashingConfigInstant -> hashingConfigInstant.compareTo(instant) <= 0).collect(Collectors.toList());
        return res.isEmpty() ? Option.empty() : Option.of(res.get(res.size() - 1));
    }

    public static PartitionBucketIndexHashingConfig loadingLatestHashingConfig(HoodieTableMetaClient metaClient) {
        Option<StoragePath> hashingConfigPathToLoad = PartitionBucketIndexHashingConfig.getHashingConfigToLoad(metaClient, (Option<String>)Option.empty());
        ValidationUtils.checkArgument((boolean)hashingConfigPathToLoad.isPresent(), (String)("Can not load latest hashing config " + hashingConfigPathToLoad));
        Option<PartitionBucketIndexHashingConfig> latestHashingConfig = PartitionBucketIndexHashingConfig.loadHashingConfig(metaClient.getStorage(), (StoragePath)hashingConfigPathToLoad.get());
        ValidationUtils.checkArgument((boolean)latestHashingConfig.isPresent(), (String)("Can not load latest hashing config " + hashingConfigPathToLoad));
        return (PartitionBucketIndexHashingConfig)latestHashingConfig.get();
    }

    public static Option<PartitionBucketIndexHashingConfig> loadingLatestHashingConfigBeforeOrOn(HoodieTableMetaClient metaClient, String instant) {
        Option<StoragePath> hashingConfigPathToLoad = PartitionBucketIndexHashingConfig.getHashingConfigToLoad(metaClient, (Option<String>)Option.of((Object)instant));
        if (hashingConfigPathToLoad.isPresent()) {
            Option<PartitionBucketIndexHashingConfig> latestHashingConfig = PartitionBucketIndexHashingConfig.loadHashingConfig(metaClient.getStorage(), (StoragePath)hashingConfigPathToLoad.get());
            ValidationUtils.checkArgument((boolean)latestHashingConfig.isPresent(), (String)("Can not load hashing config " + hashingConfigPathToLoad + " based on " + instant));
            return latestHashingConfig;
        }
        return Option.empty();
    }

    public static boolean archiveHashingConfigIfNecessary(HoodieTableMetaClient metaClient) throws IOException {
        List<String> hashingConfigToArchive = PartitionBucketIndexHashingConfig.getHashingConfigToArchive(metaClient);
        if (hashingConfigToArchive.size() == 0) {
            LOG.info("Nothing to archive " + hashingConfigToArchive);
            return false;
        }
        LOG.info("Start to archive hashing config " + hashingConfigToArchive);
        return PartitionBucketIndexHashingConfig.archiveHashingConfig(hashingConfigToArchive, metaClient);
    }

    private static boolean archiveHashingConfig(List<String> hashingConfigToArchive, HoodieTableMetaClient metaClient) {
        hashingConfigToArchive.forEach(instant -> {
            StoragePath activeHashingPath = PartitionBucketIndexHashingConfig.getHashingConfigPath(metaClient.getBasePath().toString(), instant);
            StoragePath archiveHashingPath = PartitionBucketIndexHashingConfig.getArchiveHashingConfigPath(metaClient.getBasePath().toString(), instant);
            try {
                metaClient.getStorage().rename(activeHashingPath, archiveHashingPath);
            }
            catch (IOException e) {
                throw new HoodieIOException(e.getMessage(), e);
            }
        });
        return true;
    }

    public static List<String> getArchiveHashingConfigInstants(HoodieTableMetaClient metaClient) throws IOException {
        return metaClient.getStorage().listDirectEntries(new StoragePath(metaClient.getArchiveHashingMetadataConfigPath())).stream().map(info -> {
            String instant = PartitionBucketIndexHashingConfig.getHashingConfigInstant(info.getPath().getName());
            if (StringUtils.isNullOrEmpty((String)instant)) {
                throw new HoodieException("Failed to get hashing config instant to load.");
            }
            return instant;
        }).sorted().collect(Collectors.toList());
    }

    public static List<String> getCommittedHashingConfigInstants(HoodieTableMetaClient metaClient) throws IOException {
        List allActiveHashingConfigInstants = metaClient.getStorage().listDirectEntries(new StoragePath(metaClient.getHashingMetadataConfigPath())).stream().map(info -> {
            String instant = PartitionBucketIndexHashingConfig.getHashingConfigInstant(info.getPath().getName());
            if (StringUtils.isNullOrEmpty((String)instant)) {
                throw new HoodieException("Failed to get hashing config instant to load.");
            }
            return instant;
        }).sorted().collect(Collectors.toList());
        HoodieTimeline pendingReplaceTimeline = metaClient.getActiveTimeline().filterPendingReplaceTimeline();
        return allActiveHashingConfigInstants.stream().filter(hashingConfigInstant -> !pendingReplaceTimeline.containsInstant((String)hashingConfigInstant)).collect(Collectors.toList());
    }

    public static List<String> getHashingConfigToArchive(HoodieTableMetaClient metaClient) throws IOException {
        Option<HoodieInstant> activeTimelineStart = metaClient.getActiveTimeline().getCommitsTimeline().firstInstant();
        if (activeTimelineStart.isPresent()) {
            int index;
            String startInstant = ((HoodieInstant)activeTimelineStart.get()).requestedTime();
            List<String> committedHashingConfig = PartitionBucketIndexHashingConfig.getCommittedHashingConfigInstants(metaClient);
            for (index = 0; index < committedHashingConfig.size() && committedHashingConfig.get(index).compareTo(startInstant) < 0; ++index) {
            }
            return index == 0 ? Collections.emptyList() : committedHashingConfig.subList(0, index - 1);
        }
        return Collections.emptyList();
    }

    public static boolean rollbackHashingConfig(HoodieInstant instant, HoodieTableMetaClient metaClient) {
        try {
            StoragePath path = PartitionBucketIndexHashingConfig.getHashingConfigPath(metaClient.getBasePath().toString(), instant.requestedTime());
            HoodieStorage storage = metaClient.getStorage();
            if (storage.exists(path)) {
                boolean res = storage.deleteFile(path);
                ValidationUtils.checkArgument((boolean)res, (String)("Failed to delete hashing_config " + path));
                LOG.info("Deleted hashing config " + path);
                return true;
            }
            LOG.info("Hashing config " + path + " doesn't exist.");
            return false;
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
    }

    public static String getHashingConfigInstant(String hashingConfigName) {
        int dotIndex = hashingConfigName.indexOf(46);
        if (dotIndex == -1) {
            return null;
        }
        return hashingConfigName.substring(0, dotIndex);
    }

    public static boolean isHashingConfigExisted(HoodieInstant instant, HoodieTableMetaClient metaClient) throws IOException {
        StoragePath path = PartitionBucketIndexHashingConfig.getHashingConfigPath(metaClient.getBasePath().toString(), instant.requestedTime());
        HoodieStorage storage = metaClient.getStorage();
        return storage.exists(path);
    }

    public String toString() {
        return "PartitionBucketIndexHashingConfig{expressions='" + this.expressions + '\'' + ", defaultBucketNumber='" + this.defaultBucketNumber + '\'' + ", rule='" + this.rule + '\'' + ", version='" + this.version + '\'' + ", instant=" + this.instant + '}';
    }
}

