/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.exception.HoodieIOException;

public class SerializableIndexedRecord
implements GenericRecord,
KryoSerializable,
Serializable {
    private static final long serialVersionUID = 1L;
    private IndexedRecord record;
    private Schema schema;
    private byte[] recordBytes;

    @VisibleForTesting
    public static SerializableIndexedRecord createInstance(IndexedRecord record) {
        return record == null ? null : new SerializableIndexedRecord(record);
    }

    private SerializableIndexedRecord(IndexedRecord record) {
        this.record = record;
        this.recordBytes = null;
        this.schema = null;
    }

    private SerializableIndexedRecord(Schema schema, byte[] bytes) {
        this.record = null;
        this.recordBytes = bytes;
        this.schema = schema;
    }

    public static SerializableIndexedRecord fromAvroBytes(Schema schema, byte[] bytes) {
        if (bytes.length == 0) {
            return null;
        }
        return new SerializableIndexedRecord(schema, bytes);
    }

    public void put(int i, Object v) {
        this.getData().put(i, v);
    }

    public Object get(int i) {
        return this.getData().get(i);
    }

    public Schema getSchema() {
        return this.schema != null ? this.schema : this.record.getSchema();
    }

    byte[] encodeRecord() {
        if (this.recordBytes == null) {
            this.recordBytes = HoodieAvroUtils.avroToBytes(this.record);
        }
        return this.recordBytes;
    }

    void decodeRecord(Schema schema) {
        if (this.record == null) {
            this.schema = schema;
        }
    }

    @VisibleForTesting
    public IndexedRecord getData() {
        if (this.record == null) {
            try {
                this.record = HoodieAvroUtils.bytesToAvro(this.recordBytes, this.schema);
                this.recordBytes = null;
                this.schema = null;
            }
            catch (IOException e) {
                throw new HoodieIOException("Failed to parse record into provided schema", e);
            }
        }
        return this.record;
    }

    public void write(Kryo kryo, Output output) {
        byte[] bytes = this.encodeRecord();
        output.writeInt(bytes.length, true);
        output.writeBytes(bytes);
    }

    public void read(Kryo kryo, Input input) {
        int length = input.readInt(true);
        this.recordBytes = input.readBytes(length);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        byte[] bytes = this.encodeRecord();
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        int length = ois.readInt();
        this.recordBytes = new byte[length];
        ois.read(this.recordBytes, 0, length);
    }

    public void put(String key, Object v) {
        this.getData();
        Schema.Field field = this.record.getSchema().getField(key);
        this.record.put(field.pos(), v);
    }

    public Object get(String key) {
        this.getData();
        Schema.Field field = this.record.getSchema().getField(key);
        return this.record.get(field.pos());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof SerializableIndexedRecord) {
            SerializableIndexedRecord that = (SerializableIndexedRecord)o;
            this.getData();
            ValidationUtils.checkArgument((this.record != null && that.record != null ? 1 : 0) != 0, (String)"Records must be deserialized before equality check");
            return this.record.equals(that.record);
        }
        if (o instanceof IndexedRecord) {
            IndexedRecord that = (IndexedRecord)o;
            return this.record != null && this.record.equals(that);
        }
        return false;
    }

    IndexedRecord getRecord() {
        ValidationUtils.checkArgument((this.record != null || this.schema != null ? 1 : 0) != 0, (String)"Record must be deserialized before accessing");
        return this.getData();
    }

    public int hashCode() {
        return Objects.hash(this.record);
    }

    public String toString() {
        return this.record == null ? "SERIALIZED: " + new String(this.recordBytes) : this.record.toString();
    }
}

