/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model.debezium;

import java.io.IOException;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.model.debezium.AbstractDebeziumAvroPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.exception.HoodieDebeziumAvroPayloadException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlDebeziumAvroPayload
extends AbstractDebeziumAvroPayload {
    private static final Logger LOG = LoggerFactory.getLogger(MySqlDebeziumAvroPayload.class);
    public static final String ORDERING_FIELDS = "_event_bin_file,_event_pos";

    public MySqlDebeziumAvroPayload(GenericRecord record, Comparable orderingVal) {
        super(record, orderingVal);
    }

    public MySqlDebeziumAvroPayload(Option<GenericRecord> record) {
        super(record);
    }

    private Option<String> extractSeq(IndexedRecord record) {
        Object value = ((GenericRecord)record).get("_event_seq");
        return Option.ofNullable((Object)Objects.toString(value, null));
    }

    @Override
    protected boolean shouldPickCurrentRecord(IndexedRecord currentRecord, IndexedRecord insertRecord, Schema schema) throws IOException {
        String insertSourceSeq = (String)this.extractSeq(insertRecord).orElseThrow(() -> new HoodieDebeziumAvroPayloadException(String.format("%s cannot be null in insert record: %s", "_event_seq", insertRecord)));
        Option<String> currentSourceSeqOpt = this.extractSeq(currentRecord);
        if (!currentSourceSeqOpt.isPresent()) {
            return false;
        }
        return MySqlDebeziumAvroPayload.isCurrentSeqLatest((String)currentSourceSeqOpt.get(), insertSourceSeq);
    }

    @Override
    public OverwriteWithLatestAvroPayload preCombine(OverwriteWithLatestAvroPayload oldValue) {
        if (oldValue.getRecordBytes().length == 0) {
            return this;
        }
        if (MySqlDebeziumAvroPayload.isCurrentSeqLatest(String.valueOf(oldValue.getOrderingValue()), String.valueOf(this.orderingVal))) {
            return oldValue;
        }
        return this;
    }

    @VisibleForTesting
    static boolean isCurrentSeqLatest(String currentSeq, String newSeq) {
        String[] currentFilePos = currentSeq.split("\\.");
        String[] newFilePos = newSeq.split("\\.");
        long currentFileNum = Long.parseLong(currentFilePos[0]);
        long newFileNum = Long.parseLong(newFilePos[0]);
        if (newFileNum < currentFileNum) {
            return true;
        }
        if (newFileNum > currentFileNum) {
            return false;
        }
        long currentPos = Long.parseLong(currentFilePos[1]);
        long newPos = Long.parseLong(newFilePos[1]);
        return newPos < currentPos;
    }
}

