/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.HoodieTableFormat;
import org.apache.hudi.common.NativeTableFormat;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieMetaserverConfig;
import org.apache.hudi.common.config.HoodieTimeGeneratorConfig;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.fs.ConsistencyGuard;
import org.apache.hudi.common.fs.ConsistencyGuardConfig;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.fs.FailSafeConsistencyGuard;
import org.apache.hudi.common.fs.FileSystemRetryConfig;
import org.apache.hudi.common.fs.NoOpConsistencyGuard;
import org.apache.hudi.common.model.BootstrapIndexType;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.model.HoodieIndexMetadata;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieTimelineTimeZone;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.CommitMetadataSerDe;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantFileNameGenerator;
import org.apache.hudi.common.table.timeline.InstantFileNameParser;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.table.timeline.TimeGenerator;
import org.apache.hudi.common.table.timeline.TimeGenerators;
import org.apache.hudi.common.table.timeline.TimelineLayout;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.common.util.collection.Triple;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.TableNotFoundException;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.apache.hudi.metadata.HoodieIndexVersion;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.storage.HoodieInstantWriter;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathFilter;
import org.apache.hudi.storage.StoragePathInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieTableMetaClient
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(HoodieTableMetaClient.class);
    public static final String METADATA_STR = "metadata";
    public static final String METAFOLDER_NAME = ".hoodie";
    public static final String TIMELINEFOLDER_NAME = "timeline";
    public static final String BUCKET_INDEX_METAFOLDER_NAME = ".bucket_index";
    public static final String TEMPFOLDER_NAME = ".hoodie/.temp";
    public static final String AUXILIARYFOLDER_NAME = ".hoodie/.aux";
    public static final String BOOTSTRAP_INDEX_ROOT_FOLDER_PATH = ".hoodie/.aux/.bootstrap";
    public static final String SAMPLE_WRITES_FOLDER_PATH = ".hoodie/.aux/.sample_writes";
    public static final String HEARTBEAT_FOLDER_NAME = ".hoodie/.heartbeat";
    public static final String METADATA_TABLE_FOLDER_PATH = ".hoodie/metadata";
    public static final String HASHING_METADATA_FOLDER_NAME = ".bucket_index/consistent_hashing_metadata";
    public static final String PARTITION_BUCKET_INDEX_HASHING_FOLDER = ".bucket_index/partition_bucket_index_meta";
    public static final String BUCKET_INDEX_METAFOLDER_CONFIG_FOLDER = ".bucket_index/partition_bucket_index_meta/configs";
    public static final String BUCKET_INDEX_METAFOLDER_CONFIG_ARCHIVE_FOLDER = ".bucket_index/partition_bucket_index_meta/archive";
    public static final String BOOTSTRAP_INDEX_BY_PARTITION_FOLDER_PATH = ".hoodie/.aux/.bootstrap/.partitions";
    public static final String BOOTSTRAP_INDEX_BY_FILE_ID_FOLDER_PATH = ".hoodie/.aux/.bootstrap/.fileids";
    public static final String LOCKS_FOLDER_NAME = ".hoodie/.locks";
    public static final String SCHEMA_FOLDER_NAME = ".schema";
    public static final String MARKER_EXTN = ".marker";
    public static final String INDEX_DEFINITION_FOLDER_NAME = ".index_defs";
    public static final String INDEX_DEFINITION_FILE_NAME = "index.json";
    public static final String COMMIT_TIME_KEY = "commitTime";
    private final Map<String, HoodieArchivedTimeline> archivedTimelineMap = new HashMap<String, HoodieArchivedTimeline>();
    protected StoragePath basePath;
    protected StoragePath metaPath;
    private transient HoodieStorage storage;
    private boolean loadActiveTimelineOnLoad;
    protected StorageConfiguration<?> storageConf;
    private HoodieTableType tableType;
    private TimelineLayoutVersion timelineLayoutVersion;
    private TimelineLayout timelineLayout;
    private StoragePath timelinePath;
    private StoragePath timelineHistoryPath;
    protected HoodieTableConfig tableConfig;
    protected HoodieActiveTimeline activeTimeline;
    private ConsistencyGuardConfig consistencyGuardConfig = ConsistencyGuardConfig.newBuilder().build();
    private FileSystemRetryConfig fileSystemRetryConfig = FileSystemRetryConfig.newBuilder().build();
    protected HoodieMetaserverConfig metaserverConfig;
    private HoodieTimeGeneratorConfig timeGeneratorConfig;
    private Option<HoodieIndexMetadata> indexMetadataOpt;
    private HoodieTableFormat tableFormat;

    protected HoodieTableMetaClient(HoodieStorage storage, String basePath, boolean loadActiveTimelineOnLoad, ConsistencyGuardConfig consistencyGuardConfig, Option<TimelineLayoutVersion> layoutVersion, HoodieTimeGeneratorConfig timeGeneratorConfig, FileSystemRetryConfig fileSystemRetryConfig) {
        LOG.debug("Loading HoodieTableMetaClient from " + basePath);
        this.timeGeneratorConfig = timeGeneratorConfig;
        this.consistencyGuardConfig = consistencyGuardConfig;
        this.fileSystemRetryConfig = fileSystemRetryConfig;
        this.storageConf = storage.getConf();
        this.storage = storage;
        this.basePath = new StoragePath(basePath);
        this.metaPath = new StoragePath(basePath, METAFOLDER_NAME);
        this.tableConfig = new HoodieTableConfig(this.storage, this.metaPath);
        this.indexMetadataOpt = HoodieTableMetaClient.readIndexDefFromStorage(this.storage, this.basePath, this.tableConfig);
        this.tableType = this.tableConfig.getTableType();
        Option<TimelineLayoutVersion> tableConfigVersion = this.tableConfig.getTimelineLayoutVersion();
        if (layoutVersion.isPresent() && tableConfigVersion.isPresent()) {
            ValidationUtils.checkArgument((((TimelineLayoutVersion)layoutVersion.get()).compareTo((TimelineLayoutVersion)tableConfigVersion.get()) >= 0 ? 1 : 0) != 0, (String)("Layout Version defined in hoodie properties has higher version (" + tableConfigVersion.get() + ") than the one passed in config (" + layoutVersion.get() + ")"));
        } else if (layoutVersion.isEmpty() && tableConfigVersion.isEmpty()) {
            throw new TableNotFoundException("Table does not exist");
        }
        this.timelineLayoutVersion = (TimelineLayoutVersion)layoutVersion.orElseGet(() -> tableConfigVersion.get());
        this.tableFormat = this.tableConfig.getTableFormat(this.timelineLayoutVersion);
        this.timelineLayout = TimelineLayout.fromVersion(this.timelineLayoutVersion);
        this.timelinePath = this.timelineLayout.getTimelinePathProvider().getTimelinePath(this.tableConfig, this.basePath);
        this.timelineHistoryPath = this.timelineLayout.getTimelinePathProvider().getTimelineHistoryPath(this.tableConfig, this.basePath);
        this.loadActiveTimelineOnLoad = loadActiveTimelineOnLoad;
        LOG.debug("Finished Loading Table of type " + (Object)((Object)this.tableType) + "(version=" + this.timelineLayoutVersion + ") from " + basePath);
        if (loadActiveTimelineOnLoad) {
            LOG.info("Loading Active commit timeline for " + basePath);
            this.getActiveTimeline();
        }
    }

    public HoodieTableMetaClient() {
    }

    public String getIndexDefinitionPath() {
        return (String)this.tableConfig.getRelativeIndexDefinitionPath().map(definitionPath -> new StoragePath(this.basePath, definitionPath).toString()).orElseGet(() -> this.metaPath + "/" + INDEX_DEFINITION_FOLDER_NAME + "/" + INDEX_DEFINITION_FILE_NAME);
    }

    public boolean buildIndexDefinition(HoodieIndexDefinition indexDefinition) {
        String indexName = indexDefinition.getIndexName();
        boolean updateIndexDefn = true;
        if (this.indexMetadataOpt.isPresent()) {
            Option<HoodieIndexDefinition> existingIndexOpt = ((HoodieIndexMetadata)this.indexMetadataOpt.get()).getIndex(indexName);
            if (existingIndexOpt.isPresent()) {
                if (!((HoodieIndexDefinition)existingIndexOpt.get()).getSourceFields().equals(indexDefinition.getSourceFields())) {
                    LOG.info("List of columns to index is changing. Old value {}. New value {}", ((HoodieIndexDefinition)existingIndexOpt.get()).getSourceFields(), indexDefinition.getSourceFields());
                    ((HoodieIndexMetadata)this.indexMetadataOpt.get()).getIndexDefinitions().put(indexName, indexDefinition);
                } else {
                    updateIndexDefn = false;
                }
            } else {
                ((HoodieIndexMetadata)this.indexMetadataOpt.get()).getIndexDefinitions().put(indexName, indexDefinition);
            }
        } else {
            HashMap<String, HoodieIndexDefinition> indexDefinitionMap = new HashMap<String, HoodieIndexDefinition>();
            indexDefinitionMap.put(indexName, indexDefinition);
            this.indexMetadataOpt = Option.of((Object)new HoodieIndexMetadata(indexDefinitionMap));
        }
        if (updateIndexDefn) {
            this.writeIndexMetadataToStorage();
            String indexMetaPath = this.getIndexDefinitionPath();
            if (!this.tableConfig.getProps().containsKey(HoodieTableConfig.RELATIVE_INDEX_DEFINITION_PATH.key()) || !this.tableConfig.getRelativeIndexDefinitionPath().isPresent()) {
                this.tableConfig.setValue(HoodieTableConfig.RELATIVE_INDEX_DEFINITION_PATH, FSUtils.getRelativePartitionPath(this.basePath, new StoragePath(indexMetaPath)));
                HoodieTableConfig.update(this.storage, this.metaPath, this.tableConfig.getProps());
            }
        }
        return updateIndexDefn;
    }

    public void deleteIndexDefinition(String indexName) {
        ValidationUtils.checkState((boolean)this.indexMetadataOpt.isPresent(), (String)"Index metadata is not present");
        ((HoodieIndexMetadata)this.indexMetadataOpt.get()).getIndexDefinitions().remove(indexName);
        this.writeIndexMetadataToStorage();
        if (((HoodieIndexMetadata)this.indexMetadataOpt.get()).getIndexDefinitions().isEmpty()) {
            this.indexMetadataOpt = Option.empty();
        }
    }

    public void writeIndexMetadataToStorage() {
        this.indexMetadataOpt.ifPresent(indexMetadata -> {
            String indexMetaPath = this.getIndexDefinitionPath();
            HoodieTableMetaClient.writeIndexMetadataToStorage(this.storage, indexMetaPath, indexMetadata, this.getTableConfig().getTableVersion());
        });
    }

    public Option<HoodieIndexDefinition> getIndexForMetadataPartition(String partitionName) {
        return this.getIndexMetadata().flatMap(m -> m.getIndex(partitionName));
    }

    public static void writeIndexMetadataToStorage(HoodieStorage storage, String indexDefinitionPath, HoodieIndexMetadata indexMetadata, HoodieTableVersion tableVersion) {
        try {
            indexMetadata.getIndexDefinitions().values().forEach(d -> ValidationUtils.checkArgument((boolean)HoodieIndexVersion.isValidIndexDefinition(tableVersion, d), (String)("Found invalid index definition " + d)));
            HoodieIndexMetadata.validateIndexMetadata(indexMetadata);
            FileIOUtils.createFileInPath((HoodieStorage)storage, (StoragePath)new StoragePath(indexDefinitionPath), (Option)Option.of((Object)HoodieInstantWriter.convertByteArrayToWriter((byte[])StringUtils.getUTF8Bytes((String)indexMetadata.toJson()))));
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not write index metadata at path: " + indexDefinitionPath, e);
        }
    }

    public Option<HoodieIndexMetadata> getIndexMetadata() {
        return this.indexMetadataOpt;
    }

    private static Option<HoodieIndexMetadata> readIndexDefFromStorage(HoodieStorage storage, StoragePath basePath, HoodieTableConfig tableConfig) {
        Option<String> indexDefinitionPathOpt = tableConfig.getRelativeIndexDefinitionPath();
        if (indexDefinitionPathOpt.isEmpty() || StringUtils.isNullOrEmpty((String)((String)indexDefinitionPathOpt.get()))) {
            return Option.empty();
        }
        StoragePath indexDefinitionPath = new StoragePath(basePath, (String)indexDefinitionPathOpt.get());
        try {
            Option bytesOpt = FileIOUtils.readDataFromPath((HoodieStorage)storage, (StoragePath)indexDefinitionPath, (boolean)true);
            if (bytesOpt.isPresent()) {
                return Option.of((Object)HoodieIndexMetadata.fromJson(new String((byte[])bytesOpt.get())));
            }
            return Option.of((Object)new HoodieIndexMetadata());
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not load index definition at path: " + indexDefinitionPath, e);
        }
    }

    public static HoodieTableMetaClient reload(HoodieTableMetaClient oldMetaClient) {
        return HoodieTableMetaClient.builder().setStorage(oldMetaClient.getStorage()).setBasePath(oldMetaClient.basePath.toString()).setLoadActiveTimelineOnLoad(oldMetaClient.loadActiveTimelineOnLoad).setConsistencyGuardConfig(oldMetaClient.consistencyGuardConfig).setLayoutVersion((Option<TimelineLayoutVersion>)Option.of((Object)oldMetaClient.timelineLayoutVersion)).setTimeGeneratorConfig(oldMetaClient.timeGeneratorConfig).setFileSystemRetryConfig(oldMetaClient.fileSystemRetryConfig).build();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.storage = null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    public StoragePath getBasePath() {
        return this.basePath;
    }

    public HoodieTableType getTableType() {
        return this.tableType;
    }

    public StoragePath getMetaPath() {
        return this.metaPath;
    }

    public StoragePath getTimelinePath() {
        return this.timelinePath;
    }

    public HoodieTableFormat getTableFormat() {
        return this.tableFormat;
    }

    public String getSchemaFolderName() {
        return new StoragePath(this.metaPath, SCHEMA_FOLDER_NAME).toString();
    }

    public String getHashingMetadataPath() {
        return new StoragePath(this.metaPath, HASHING_METADATA_FOLDER_NAME).toString();
    }

    public String getHashingMetadataConfigPath() {
        return new StoragePath(this.metaPath, BUCKET_INDEX_METAFOLDER_CONFIG_FOLDER).toString();
    }

    public String getArchiveHashingMetadataConfigPath() {
        return new StoragePath(this.metaPath, BUCKET_INDEX_METAFOLDER_CONFIG_ARCHIVE_FOLDER).toString();
    }

    public String getTempFolderPath() {
        return this.basePath + "/" + TEMPFOLDER_NAME;
    }

    public String getMarkerFolderPath(String instantTs) {
        return String.format("%s%s%s", this.getTempFolderPath(), "/", instantTs);
    }

    public String getMetaAuxiliaryPath() {
        return this.basePath + "/" + AUXILIARYFOLDER_NAME;
    }

    public static String getHeartbeatFolderPath(String basePath) {
        return String.format("%s%s%s", basePath, "/", HEARTBEAT_FOLDER_NAME);
    }

    public String getBootstrapIndexByPartitionFolderPath() {
        return this.basePath + "/" + BOOTSTRAP_INDEX_BY_PARTITION_FOLDER_PATH;
    }

    public String getBootstrapIndexByFileIdFolderNameFolderPath() {
        return this.basePath + "/" + BOOTSTRAP_INDEX_BY_FILE_ID_FOLDER_PATH;
    }

    public StoragePath getArchivePath() {
        return this.timelineHistoryPath;
    }

    public HoodieTableConfig getTableConfig() {
        return this.tableConfig;
    }

    public TimelineLayoutVersion getTimelineLayoutVersion() {
        return this.timelineLayoutVersion;
    }

    public TimelineLayout getTimelineLayout() {
        return this.timelineLayout;
    }

    public boolean isMetadataTable() {
        return HoodieTableMetadata.isMetadataTable(this.getBasePath());
    }

    public HoodieStorage getStorage() {
        if (this.storage == null) {
            this.storage = this.getStorage(this.metaPath);
        }
        return this.storage;
    }

    public HoodieStorage getStorage(StoragePath storagePath) {
        return HoodieTableMetaClient.getStorage(storagePath, this.getStorageConf(), this.consistencyGuardConfig, this.fileSystemRetryConfig);
    }

    private static HoodieStorage getStorage(StoragePath path, StorageConfiguration<?> storageConf, ConsistencyGuardConfig consistencyGuardConfig, FileSystemRetryConfig fileSystemRetryConfig) {
        HoodieStorage newStorage = HoodieStorageUtils.getStorage(path, storageConf);
        Object consistencyGuard = consistencyGuardConfig.isConsistencyCheckEnabled() ? new FailSafeConsistencyGuard(newStorage, consistencyGuardConfig) : new NoOpConsistencyGuard();
        return HoodieIOFactory.getIOFactory(newStorage).getStorage(path, fileSystemRetryConfig.isFileSystemActionRetryEnable(), fileSystemRetryConfig.getMaxRetryIntervalMs(), fileSystemRetryConfig.getMaxRetryNumbers(), fileSystemRetryConfig.getInitialRetryIntervalMs(), fileSystemRetryConfig.getRetryExceptions(), (ConsistencyGuard)consistencyGuard);
    }

    public void setStorage(HoodieStorage storage) {
        this.storage = storage;
    }

    public HoodieStorage getRawStorage() {
        return this.getStorage().getRawStorage();
    }

    public StorageConfiguration<?> getStorageConf() {
        return this.storageConf;
    }

    public synchronized HoodieActiveTimeline getActiveTimeline() {
        if (this.activeTimeline == null) {
            this.activeTimeline = this.tableFormat.getTimelineFactory().createActiveTimeline(this);
        }
        return this.activeTimeline;
    }

    public synchronized void reload() {
        this.reloadActiveTimeline();
        this.reloadTableConfig();
    }

    public synchronized HoodieActiveTimeline getActiveTimelineForNativeFormat() {
        return new NativeTableFormat(this.activeTimeline.getTimelineLayoutVersion()).getTimelineFactory().createActiveTimeline(this);
    }

    public synchronized HoodieActiveTimeline reloadActiveTimeline() {
        this.activeTimeline = this.tableFormat.getTimelineFactory().createActiveTimeline(this);
        return this.activeTimeline;
    }

    public synchronized void reloadTableConfig() {
        this.tableConfig = HoodieTableConfig.loadFromHoodieProps(this.storage, this.metaPath);
        this.reloadTimelineLayoutAndPath();
    }

    private void reloadTimelineLayoutAndPath() {
        this.timelineLayoutVersion = (TimelineLayoutVersion)this.tableConfig.getTimelineLayoutVersion().get();
        this.timelineLayout = TimelineLayout.fromVersion(this.timelineLayoutVersion);
        this.tableFormat = this.tableConfig.getTableFormat(this.timelineLayoutVersion);
        this.timelinePath = this.timelineLayout.getTimelinePathProvider().getTimelinePath(this.tableConfig, this.basePath);
        this.timelineHistoryPath = this.timelineLayout.getTimelinePathProvider().getTimelineHistoryPath(this.tableConfig, this.basePath);
    }

    public String createNewInstantTime(boolean shouldLock) {
        TimeGenerator timeGenerator = TimeGenerators.getTimeGenerator(this.timeGeneratorConfig, this.storageConf);
        return TimelineUtils.generateInstantTime(shouldLock, timeGenerator);
    }

    public HoodieTimeGeneratorConfig getTimeGeneratorConfig() {
        return this.timeGeneratorConfig;
    }

    public ConsistencyGuardConfig getConsistencyGuardConfig() {
        return this.consistencyGuardConfig;
    }

    public FileSystemRetryConfig getFileSystemRetryConfig() {
        return this.fileSystemRetryConfig;
    }

    public synchronized HoodieArchivedTimeline getArchivedTimeline() {
        return this.getArchivedTimeline("");
    }

    public HoodieMetaserverConfig getMetaserverConfig() {
        if (this.metaserverConfig == null) {
            this.metaserverConfig = new HoodieMetaserverConfig();
        }
        return this.metaserverConfig;
    }

    public HoodieArchivedTimeline getArchivedTimeline(String startTs) {
        return this.getArchivedTimeline(startTs, true);
    }

    public HoodieArchivedTimeline getArchivedTimeline(String startTs, boolean useCache) {
        if (useCache) {
            if (!this.archivedTimelineMap.containsKey(startTs)) {
                this.archivedTimelineMap.clear();
                this.archivedTimelineMap.put(startTs, this.instantiateArchivedTimeline(startTs));
            }
            return this.archivedTimelineMap.get(startTs);
        }
        return this.instantiateArchivedTimeline(startTs);
    }

    private HoodieArchivedTimeline instantiateArchivedTimeline(String startTs) {
        return StringUtils.isNullOrEmpty((String)startTs) ? this.tableFormat.getTimelineFactory().createArchivedTimeline(this) : this.tableFormat.getTimelineFactory().createArchivedTimeline(this, startTs);
    }

    public static void createTableLayoutOnStorage(StorageConfiguration<?> storageConf, StoragePath basePath, Properties props, Integer timelineLayout, boolean shouldCreateTableConfig) throws IOException {
        StoragePath auxiliaryFolder;
        StoragePath temporaryFolder;
        StoragePath archiveLogDir;
        String archiveLogPropVal;
        StoragePath schemaPathDir;
        StoragePath metaPathDir;
        LOG.info("Initializing {} as hoodie table", (Object)basePath);
        HoodieStorage storage = HoodieStorageUtils.getStorage(basePath, storageConf);
        if (!storage.exists(basePath)) {
            storage.createDirectory(basePath);
        }
        if (!storage.exists(metaPathDir = new StoragePath(basePath, METAFOLDER_NAME))) {
            storage.createDirectory(metaPathDir);
        }
        if (!storage.exists(schemaPathDir = new StoragePath(metaPathDir, SCHEMA_FOLDER_NAME))) {
            storage.createDirectory(schemaPathDir);
        }
        String timelinePropVal = ConfigUtils.getStringWithAltKeys(props, HoodieTableConfig.TIMELINE_PATH, true);
        StoragePath timelineDir = metaPathDir;
        Integer n = timelineLayout = timelineLayout == null ? TimelineLayoutVersion.CURR_VERSION : timelineLayout;
        if (!StringUtils.isNullOrEmpty((String)timelinePropVal) && TimelineLayoutVersion.VERSION_2.equals(timelineLayout) && !storage.exists(timelineDir = new StoragePath(metaPathDir, timelinePropVal))) {
            storage.createDirectory(timelineDir);
        }
        if (!StringUtils.isNullOrEmpty((String)(archiveLogPropVal = ConfigUtils.getStringWithAltKeys(props, HoodieTableConfig.TIMELINE_HISTORY_PATH, true))) && TimelineLayoutVersion.VERSION_2.equals(timelineLayout) && !storage.exists(archiveLogDir = new StoragePath(timelineDir, archiveLogPropVal))) {
            storage.createDirectory(archiveLogDir);
        }
        if (!storage.exists(temporaryFolder = new StoragePath(basePath, TEMPFOLDER_NAME))) {
            storage.createDirectory(temporaryFolder);
        }
        if (!storage.exists(auxiliaryFolder = new StoragePath(basePath, AUXILIARYFOLDER_NAME))) {
            storage.createDirectory(auxiliaryFolder);
        }
        HoodieTableMetaClient.initializeBootstrapDirsIfNotExists(basePath, storage);
        if (shouldCreateTableConfig) {
            HoodieTableConfig.create(storage, metaPathDir, props);
        }
    }

    public static void initializeBootstrapDirsIfNotExists(StoragePath basePath, HoodieStorage storage) throws IOException {
        StoragePath bootstrap_index_folder_by_fileids;
        StoragePath bootstrap_index_folder_by_partition = new StoragePath(basePath, BOOTSTRAP_INDEX_BY_PARTITION_FOLDER_PATH);
        if (!storage.exists(bootstrap_index_folder_by_partition)) {
            storage.createDirectory(bootstrap_index_folder_by_partition);
        }
        if (!storage.exists(bootstrap_index_folder_by_fileids = new StoragePath(basePath, BOOTSTRAP_INDEX_BY_FILE_ID_FOLDER_PATH))) {
            storage.createDirectory(bootstrap_index_folder_by_fileids);
        }
    }

    public static List<StoragePathInfo> scanFiles(HoodieStorage storage, StoragePath metaPath, StoragePathFilter nameFilter) throws IOException {
        return storage.listDirectEntries(metaPath, nameFilter);
    }

    public boolean isTimelineNonEmpty() {
        return !this.getCommitsTimeline().filterCompletedInstants().empty();
    }

    public HoodieTimeline getCommitsTimeline() {
        switch (this.getTableType()) {
            case COPY_ON_WRITE: {
                return this.getActiveTimeline().getCommitAndReplaceTimeline();
            }
            case MERGE_ON_READ: {
                return this.getActiveTimeline().getCommitsTimeline();
            }
        }
        throw new HoodieException("Unsupported table type :" + (Object)((Object)this.getTableType()));
    }

    public HoodieTimeline getCommitsAndCompactionTimeline() {
        switch (this.getTableType()) {
            case COPY_ON_WRITE: {
                return this.getActiveTimeline().getCommitAndReplaceTimeline();
            }
            case MERGE_ON_READ: {
                return this.getActiveTimeline().getWriteTimeline();
            }
        }
        throw new HoodieException("Unsupported table type :" + (Object)((Object)this.getTableType()));
    }

    public HoodieTimeline getCommitTimeline() {
        switch (this.getTableType()) {
            case COPY_ON_WRITE: 
            case MERGE_ON_READ: {
                return this.getActiveTimeline().getCommitAndReplaceTimeline();
            }
        }
        throw new HoodieException("Unsupported table type :" + (Object)((Object)this.getTableType()));
    }

    public String getCommitActionType() {
        return CommitUtils.getCommitActionType(this.getTableType());
    }

    public List<HoodieInstant> scanHoodieInstantsFromFileSystem(StoragePath timelinePath, Set<String> includedExtensions, boolean applyLayoutVersionFilters) throws IOException {
        InstantGenerator instantGenerator = this.timelineLayout.getInstantGenerator();
        Stream<HoodieInstant> instantStream = HoodieTableMetaClient.scanFiles(this.getStorage(), timelinePath, (StoragePathFilter & Serializable)path -> {
            String extension = this.timelineLayout.getInstantFileNameParser().getTimelineFileExtension(path.getName());
            return includedExtensions.contains(extension);
        }).stream().map(instantGenerator::createNewInstant);
        if (applyLayoutVersionFilters) {
            instantStream = TimelineLayout.fromVersion(this.getTimelineLayoutVersion()).filterHoodieInstants(instantStream);
        }
        return instantStream.sorted().collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HoodieTableMetaClient that = (HoodieTableMetaClient)o;
        return Objects.equals(this.basePath, that.basePath) && this.tableType == that.tableType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.basePath, this.tableType});
    }

    public String toString() {
        return "HoodieTableMetaClient{basePath='" + this.basePath + '\'' + ", metaPath='" + this.metaPath + '\'' + ", tableType=" + (Object)((Object)this.tableType) + '}';
    }

    public void initializeBootstrapDirsIfNotExists() throws IOException {
        HoodieTableMetaClient.initializeBootstrapDirsIfNotExists(this.basePath, this.getStorage());
    }

    private static HoodieTableMetaClient newMetaClient(HoodieStorage storage, String basePath, boolean loadActiveTimelineOnLoad, ConsistencyGuardConfig consistencyGuardConfig, Option<TimelineLayoutVersion> layoutVersion, HoodieTimeGeneratorConfig timeGeneratorConfig, FileSystemRetryConfig fileSystemRetryConfig, HoodieMetaserverConfig metaserverConfig) {
        if (metaserverConfig.isMetaserverEnabled()) {
            return (HoodieTableMetaClient)ReflectionUtils.loadClass((String)"org.apache.hudi.common.table.HoodieTableMetaserverClient", (Class[])new Class[]{HoodieStorage.class, String.class, ConsistencyGuardConfig.class, RecordMergeMode.class, String.class, String.class, HoodieTimeGeneratorConfig.class, FileSystemRetryConfig.class, Option.class, Option.class, HoodieMetaserverConfig.class}, (Object[])new Object[]{storage, basePath, consistencyGuardConfig, timeGeneratorConfig, fileSystemRetryConfig, Option.ofNullable((Object)metaserverConfig.getDatabaseName()), Option.ofNullable((Object)metaserverConfig.getTableName()), metaserverConfig});
        }
        return new HoodieTableMetaClient(storage, basePath, loadActiveTimelineOnLoad, consistencyGuardConfig, layoutVersion, timeGeneratorConfig, fileSystemRetryConfig);
    }

    public static Builder builder() {
        return new Builder();
    }

    public InstantGenerator getInstantGenerator() {
        return this.getTimelineLayout().getInstantGenerator();
    }

    public InstantFileNameGenerator getInstantFileNameGenerator() {
        return this.getTimelineLayout().getInstantFileNameGenerator();
    }

    public HoodieInstant createNewInstant(HoodieInstant.State state, String action, String timestamp) {
        return this.getInstantGenerator().createNewInstant(state, action, timestamp);
    }

    public HoodieInstant createNewInstant(HoodieInstant.State state, String action, String timestamp, String completionTime) {
        return this.getInstantGenerator().createNewInstant(state, action, timestamp, completionTime);
    }

    public HoodieInstant createNewInstant(HoodieInstant.State state, String action, String timestamp, String completionTime, boolean isLegacy) {
        return this.getInstantGenerator().createNewInstant(state, action, timestamp, completionTime, isLegacy);
    }

    public HoodieInstant createNewInstant(StoragePathInfo pathInfo) {
        return this.getInstantGenerator().createNewInstant(pathInfo);
    }

    public InstantFileNameParser getInstantFileNameParser() {
        return this.getTimelineLayout().getInstantFileNameParser();
    }

    public CommitMetadataSerDe getCommitMetadataSerDe() {
        return this.getTimelineLayout().getCommitMetadataSerDe();
    }

    public static TableBuilder newTableBuilder() {
        return new TableBuilder();
    }

    public static class TableBuilder {
        private HoodieTableType tableType;
        private String databaseName;
        private String tableName;
        private String tableCreateSchema;
        private HoodieTableVersion tableVersion;
        private String recordKeyFields;
        private String secondaryKeyFields;
        private String archiveLogFolder;
        private RecordMergeMode recordMergeMode;
        private String payloadClassName;
        private String recordMergerStrategyId;
        private Integer timelineLayoutVersion;
        private String timelinePath;
        private String timelineHistoryPath;
        private String baseFileFormat;
        private String orderingFields;
        private String partitionFields;
        private Boolean cdcEnabled;
        private String cdcSupplementalLoggingMode;
        private String bootstrapIndexClass;
        private String bootstrapBasePath;
        private Boolean bootstrapIndexEnable;
        private Boolean populateMetaFields;
        private String keyGeneratorClassProp;
        private String keyGeneratorType;
        private Boolean hiveStylePartitioningEnable;
        private Boolean urlEncodePartitioning;
        private HoodieTimelineTimeZone commitTimeZone;
        private Boolean partitionMetafileUseBaseFormat;
        private Boolean shouldDropPartitionColumns;
        private String metadataPartitions;
        private String inflightMetadataPartitions;
        private String secondaryIndexesMetadata;
        private Boolean multipleBaseFileFormatsEnabled;
        private String indexDefinitionPath;
        private String tableFormat;
        private Pair<String, String> deleteFieldAndMarker;
        private final Properties others = new Properties();

        TableBuilder() {
        }

        public TableBuilder setTableType(HoodieTableType tableType) {
            this.tableType = tableType;
            return this;
        }

        public TableBuilder setTableType(String tableType) {
            return this.setTableType(HoodieTableType.valueOf(tableType));
        }

        public TableBuilder setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public TableBuilder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public TableBuilder setTableVersion(HoodieTableVersion tableVersion) {
            this.tableVersion = tableVersion;
            this.setTimelineLayoutVersion(tableVersion.getTimelineLayoutVersion().getVersion());
            return this;
        }

        public TableBuilder setTimelinePath(String timelinePath) {
            this.timelinePath = timelinePath;
            return this;
        }

        public TableBuilder setTimelineHistoryPath(String timelineHistoryPath) {
            this.timelineHistoryPath = timelineHistoryPath;
            return this;
        }

        public TableBuilder setTableVersion(int tableVersion) {
            return this.setTableVersion(HoodieTableVersion.fromVersionCode(tableVersion));
        }

        public TableBuilder setTableCreateSchema(String tableCreateSchema) {
            this.tableCreateSchema = tableCreateSchema;
            return this;
        }

        public TableBuilder setRecordKeyFields(String recordKeyFields) {
            this.recordKeyFields = recordKeyFields;
            return this;
        }

        public TableBuilder setSecondaryKeyFields(String secondaryKeyFields) {
            this.secondaryKeyFields = secondaryKeyFields;
            return this;
        }

        public TableBuilder setArchiveLogFolder(String archiveLogFolder) {
            this.archiveLogFolder = archiveLogFolder;
            return this;
        }

        public TableBuilder setRecordMergeMode(RecordMergeMode recordMergeMode) {
            this.recordMergeMode = recordMergeMode;
            return this;
        }

        public TableBuilder setPayloadClassName(String payloadClassName) {
            this.payloadClassName = payloadClassName;
            return this;
        }

        public TableBuilder setRecordMergeStrategyId(String recordMergerStrategyId) {
            this.recordMergerStrategyId = recordMergerStrategyId;
            return this;
        }

        public TableBuilder setPayloadClass(Class<? extends HoodieRecordPayload> payloadClass) {
            return this.setPayloadClassName(payloadClass.getName());
        }

        public TableBuilder setTimelineLayoutVersion(Integer timelineLayoutVersion) {
            this.timelineLayoutVersion = timelineLayoutVersion;
            return this;
        }

        public TableBuilder setBaseFileFormat(String baseFileFormat) {
            this.baseFileFormat = baseFileFormat;
            return this;
        }

        public TableBuilder setOrderingFields(String orderingFieldsAsString) {
            this.orderingFields = orderingFieldsAsString;
            return this;
        }

        public TableBuilder setPartitionFields(String partitionFields) {
            this.partitionFields = partitionFields;
            return this;
        }

        public TableBuilder setCDCEnabled(boolean cdcEnabled) {
            this.cdcEnabled = cdcEnabled;
            return this;
        }

        public TableBuilder setCDCSupplementalLoggingMode(String cdcSupplementalLoggingMode) {
            this.cdcSupplementalLoggingMode = cdcSupplementalLoggingMode.toUpperCase();
            return this;
        }

        public TableBuilder setBootstrapIndexClass(String bootstrapIndexClass) {
            this.bootstrapIndexClass = bootstrapIndexClass;
            return this;
        }

        public TableBuilder setBootstrapBasePath(String bootstrapBasePath) {
            this.bootstrapBasePath = bootstrapBasePath;
            return this;
        }

        public TableBuilder setBootstrapIndexEnable(Boolean bootstrapIndexEnable) {
            this.bootstrapIndexEnable = bootstrapIndexEnable;
            return this;
        }

        public TableBuilder setPopulateMetaFields(boolean populateMetaFields) {
            this.populateMetaFields = populateMetaFields;
            return this;
        }

        public TableBuilder setKeyGeneratorClassProp(String keyGeneratorClassProp) {
            this.keyGeneratorClassProp = keyGeneratorClassProp;
            return this;
        }

        public TableBuilder setKeyGeneratorType(String keyGeneratorType) {
            this.keyGeneratorType = keyGeneratorType;
            return this;
        }

        public TableBuilder setHiveStylePartitioningEnable(Boolean hiveStylePartitioningEnable) {
            this.hiveStylePartitioningEnable = hiveStylePartitioningEnable;
            return this;
        }

        public TableBuilder setUrlEncodePartitioning(Boolean urlEncodePartitioning) {
            this.urlEncodePartitioning = urlEncodePartitioning;
            return this;
        }

        public TableBuilder setCommitTimezone(HoodieTimelineTimeZone timelineTimeZone) {
            this.commitTimeZone = timelineTimeZone;
            return this;
        }

        public TableBuilder setPartitionMetafileUseBaseFormat(Boolean useBaseFormat) {
            this.partitionMetafileUseBaseFormat = useBaseFormat;
            return this;
        }

        public TableBuilder setShouldDropPartitionColumns(Boolean shouldDropPartitionColumns) {
            this.shouldDropPartitionColumns = shouldDropPartitionColumns;
            return this;
        }

        public TableBuilder setMetadataPartitions(String partitions) {
            this.metadataPartitions = partitions;
            return this;
        }

        public TableBuilder setInflightMetadataPartitions(String partitions) {
            this.inflightMetadataPartitions = partitions;
            return this;
        }

        public TableBuilder setSecondaryIndexesMetadata(String secondaryIndexesMetadata) {
            this.secondaryIndexesMetadata = secondaryIndexesMetadata;
            return this;
        }

        public TableBuilder setMultipleBaseFileFormatsEnabled(Boolean multipleBaseFileFormatsEnabled) {
            this.multipleBaseFileFormatsEnabled = multipleBaseFileFormatsEnabled;
            return this;
        }

        public TableBuilder setIndexDefinitionPath(String indexDefinitionPath) {
            this.indexDefinitionPath = indexDefinitionPath;
            return this;
        }

        public TableBuilder setTableFormat(String tableFormat) {
            this.tableFormat = tableFormat;
            return this;
        }

        public TableBuilder setRecordDeleteFieldAndMarker(String deleteFieldName, String markerValue) {
            if (StringUtils.isNullOrEmpty((String)deleteFieldName) || StringUtils.isNullOrEmpty((String)markerValue)) {
                return this;
            }
            this.deleteFieldAndMarker = Pair.of(deleteFieldName, markerValue);
            return this;
        }

        public TableBuilder set(Map<String, Object> props) {
            for (ConfigProperty<String> configProperty : HoodieTableConfig.PERSISTED_CONFIG_LIST) {
                String value;
                if (!ConfigUtils.containsConfigProperty(props, configProperty) || (value = ConfigUtils.getStringWithAltKeys(props, configProperty)) == null) continue;
                this.others.put(configProperty.key(), value);
            }
            return this;
        }

        public TableBuilder fromMetaClient(HoodieTableMetaClient metaClient) {
            return this.setTableType(metaClient.getTableType()).setTableName(metaClient.getTableConfig().getTableName()).setTableVersion(metaClient.getTableConfig().getTableVersion()).setTableFormat(metaClient.getTableConfig().getTableFormat(metaClient.getTimelineLayoutVersion()).getName()).setTimelinePath(metaClient.getTableConfig().getTimelinePath()).setArchiveLogFolder(metaClient.getTableConfig().getTimelineHistoryPath()).setRecordMergeMode(metaClient.getTableConfig().getRecordMergeMode()).setPayloadClassName(metaClient.getTableConfig().getPayloadClass()).setRecordMergeStrategyId(metaClient.getTableConfig().getRecordMergeStrategyId());
        }

        public TableBuilder fromProperties(Properties properties) {
            String markerValue;
            String deleteFieldName;
            HoodieConfig hoodieConfig = HoodieConfig.copy(properties);
            for (ConfigProperty<String> configProperty : HoodieTableConfig.PERSISTED_CONFIG_LIST) {
                String value;
                if (!hoodieConfig.contains(configProperty) || (value = hoodieConfig.getString(configProperty)) == null) continue;
                this.others.put(configProperty.key(), value);
            }
            if (hoodieConfig.contains(HoodieTableConfig.DATABASE_NAME)) {
                this.setDatabaseName(hoodieConfig.getString(HoodieTableConfig.DATABASE_NAME));
            }
            if (hoodieConfig.contains(HoodieTableConfig.NAME)) {
                this.setTableName(hoodieConfig.getString(HoodieTableConfig.NAME));
            }
            if (hoodieConfig.contains(HoodieTableConfig.VERSION)) {
                this.setTableVersion(hoodieConfig.getInt(HoodieTableConfig.VERSION));
            }
            if (hoodieConfig.contains(HoodieTableConfig.TABLE_FORMAT)) {
                this.setTableFormat(hoodieConfig.getString(HoodieTableConfig.TABLE_FORMAT));
            }
            if (hoodieConfig.contains(HoodieTableConfig.TIMELINE_PATH)) {
                this.setTimelinePath(hoodieConfig.getString(HoodieTableConfig.TIMELINE_PATH));
            }
            if (hoodieConfig.contains(HoodieTableConfig.TIMELINE_HISTORY_PATH)) {
                this.setTimelineHistoryPath(hoodieConfig.getString(HoodieTableConfig.TIMELINE_HISTORY_PATH));
            }
            if (hoodieConfig.contains(HoodieTableConfig.TYPE)) {
                this.setTableType(hoodieConfig.getString(HoodieTableConfig.TYPE));
            }
            if (hoodieConfig.contains(HoodieTableConfig.ARCHIVELOG_FOLDER)) {
                this.setArchiveLogFolder(hoodieConfig.getString(HoodieTableConfig.ARCHIVELOG_FOLDER));
            }
            if (hoodieConfig.contains(HoodieTableConfig.RECORD_MERGE_MODE)) {
                this.setRecordMergeMode(RecordMergeMode.getValue(hoodieConfig.getString(HoodieTableConfig.RECORD_MERGE_MODE)));
            }
            if (hoodieConfig.contains(HoodieTableConfig.PAYLOAD_CLASS_NAME)) {
                this.setPayloadClassName(hoodieConfig.getString(HoodieTableConfig.PAYLOAD_CLASS_NAME));
            }
            if (hoodieConfig.contains(HoodieTableConfig.RECORD_MERGE_STRATEGY_ID)) {
                this.setRecordMergeStrategyId(hoodieConfig.getString(HoodieTableConfig.RECORD_MERGE_STRATEGY_ID));
            }
            if (hoodieConfig.contains(HoodieTableConfig.TIMELINE_LAYOUT_VERSION)) {
                this.setTimelineLayoutVersion(hoodieConfig.getInt(HoodieTableConfig.TIMELINE_LAYOUT_VERSION));
            }
            if (hoodieConfig.contains(HoodieTableConfig.BASE_FILE_FORMAT)) {
                this.setBaseFileFormat(hoodieConfig.getString(HoodieTableConfig.BASE_FILE_FORMAT));
            }
            if (hoodieConfig.contains(HoodieTableConfig.BOOTSTRAP_INDEX_CLASS_NAME)) {
                this.setBootstrapIndexClass(hoodieConfig.getString(HoodieTableConfig.BOOTSTRAP_INDEX_CLASS_NAME));
            }
            if (hoodieConfig.contains(HoodieTableConfig.BOOTSTRAP_INDEX_TYPE)) {
                this.setBootstrapIndexClass(BootstrapIndexType.valueOf(hoodieConfig.getString(HoodieTableConfig.BOOTSTRAP_INDEX_TYPE)).getClassName());
            }
            if (hoodieConfig.contains(HoodieTableConfig.BOOTSTRAP_BASE_PATH)) {
                this.setBootstrapBasePath(hoodieConfig.getString(HoodieTableConfig.BOOTSTRAP_BASE_PATH));
            }
            if (hoodieConfig.contains(HoodieTableConfig.BOOTSTRAP_INDEX_ENABLE)) {
                this.setBootstrapIndexEnable(hoodieConfig.getBoolean(HoodieTableConfig.BOOTSTRAP_INDEX_ENABLE));
            }
            if (hoodieConfig.contains(HoodieTableConfig.ORDERING_FIELDS)) {
                this.setOrderingFields(hoodieConfig.getString(HoodieTableConfig.ORDERING_FIELDS));
            }
            if (hoodieConfig.contains(HoodieTableConfig.PARTITION_FIELDS)) {
                this.setPartitionFields(hoodieConfig.getString(HoodieTableConfig.PARTITION_FIELDS));
            }
            if (hoodieConfig.contains(HoodieTableConfig.RECORDKEY_FIELDS)) {
                this.setRecordKeyFields(hoodieConfig.getString(HoodieTableConfig.RECORDKEY_FIELDS));
            }
            if (hoodieConfig.contains(HoodieTableConfig.TIMELINE_TIMEZONE)) {
                this.setCommitTimezone(HoodieTimelineTimeZone.valueOf(hoodieConfig.getStringOrDefault(HoodieTableConfig.TIMELINE_TIMEZONE)));
            }
            if (hoodieConfig.contains(HoodieTableConfig.CDC_ENABLED)) {
                this.setCDCEnabled(hoodieConfig.getBoolean(HoodieTableConfig.CDC_ENABLED));
            }
            if (hoodieConfig.contains(HoodieTableConfig.CDC_SUPPLEMENTAL_LOGGING_MODE)) {
                this.setCDCSupplementalLoggingMode(hoodieConfig.getString(HoodieTableConfig.CDC_SUPPLEMENTAL_LOGGING_MODE));
            }
            if (hoodieConfig.contains(HoodieTableConfig.CREATE_SCHEMA)) {
                this.setTableCreateSchema(hoodieConfig.getString(HoodieTableConfig.CREATE_SCHEMA));
            }
            if (hoodieConfig.contains(HoodieTableConfig.POPULATE_META_FIELDS)) {
                this.setPopulateMetaFields(hoodieConfig.getBoolean(HoodieTableConfig.POPULATE_META_FIELDS));
            }
            if (hoodieConfig.contains(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME)) {
                this.setKeyGeneratorClassProp(hoodieConfig.getString(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME));
            } else if (hoodieConfig.contains(HoodieTableConfig.KEY_GENERATOR_TYPE)) {
                this.setKeyGeneratorClassProp(KeyGeneratorType.valueOf(hoodieConfig.getString(HoodieTableConfig.KEY_GENERATOR_TYPE)).getClassName());
            }
            if (hoodieConfig.contains(HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE)) {
                this.setHiveStylePartitioningEnable(hoodieConfig.getBoolean(HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE));
            }
            if (hoodieConfig.contains(HoodieTableConfig.URL_ENCODE_PARTITIONING)) {
                this.setUrlEncodePartitioning(hoodieConfig.getBoolean(HoodieTableConfig.URL_ENCODE_PARTITIONING));
            }
            if (hoodieConfig.contains(HoodieTableConfig.PARTITION_METAFILE_USE_BASE_FORMAT)) {
                this.setPartitionMetafileUseBaseFormat(hoodieConfig.getBoolean(HoodieTableConfig.PARTITION_METAFILE_USE_BASE_FORMAT));
            }
            if (hoodieConfig.contains(HoodieTableConfig.DROP_PARTITION_COLUMNS)) {
                this.setShouldDropPartitionColumns(hoodieConfig.getBoolean(HoodieTableConfig.DROP_PARTITION_COLUMNS));
            }
            if (hoodieConfig.contains(HoodieTableConfig.TABLE_METADATA_PARTITIONS)) {
                this.setMetadataPartitions(hoodieConfig.getString(HoodieTableConfig.TABLE_METADATA_PARTITIONS));
            }
            if (hoodieConfig.contains(HoodieTableConfig.TABLE_METADATA_PARTITIONS_INFLIGHT)) {
                this.setInflightMetadataPartitions(hoodieConfig.getString(HoodieTableConfig.TABLE_METADATA_PARTITIONS_INFLIGHT));
            }
            if (hoodieConfig.contains(HoodieTableConfig.SECONDARY_INDEXES_METADATA)) {
                this.setSecondaryIndexesMetadata(hoodieConfig.getString(HoodieTableConfig.SECONDARY_INDEXES_METADATA));
            }
            if (hoodieConfig.contains(HoodieTableConfig.MULTIPLE_BASE_FILE_FORMATS_ENABLE)) {
                this.setMultipleBaseFileFormatsEnabled(hoodieConfig.getBoolean(HoodieTableConfig.MULTIPLE_BASE_FILE_FORMATS_ENABLE));
            }
            if (hoodieConfig.contains(HoodieTableConfig.RELATIVE_INDEX_DEFINITION_PATH)) {
                this.setIndexDefinitionPath(hoodieConfig.getString(HoodieTableConfig.RELATIVE_INDEX_DEFINITION_PATH));
            }
            if (hoodieConfig.contains("hoodie.record.merge.property.hoodie.payload.delete.field")) {
                deleteFieldName = hoodieConfig.getString("hoodie.record.merge.property.hoodie.payload.delete.field");
                markerValue = hoodieConfig.getString("hoodie.record.merge.property.hoodie.payload.delete.marker");
                this.setRecordDeleteFieldAndMarker(deleteFieldName, markerValue);
            }
            if (hoodieConfig.getStringOrDefault(HoodieTableConfig.PAYLOAD_CLASS_NAME, "").equals(DefaultHoodieRecordPayload.class.getName()) && hoodieConfig.contains("hoodie.payload.delete.field")) {
                deleteFieldName = hoodieConfig.getString("hoodie.payload.delete.field");
                markerValue = hoodieConfig.getString("hoodie.payload.delete.marker");
                this.setRecordDeleteFieldAndMarker(deleteFieldName, markerValue);
            }
            return this;
        }

        @VisibleForTesting
        public Properties build() {
            Object mergeConfigs;
            KeyGeneratorType type;
            ValidationUtils.checkArgument((this.tableType != null ? 1 : 0) != 0, (String)"tableType is null");
            ValidationUtils.checkArgument((this.tableName != null ? 1 : 0) != 0, (String)"tableName is null");
            HoodieTableConfig tableConfig = new HoodieTableConfig();
            tableConfig.setAll(this.others);
            if (!StringUtils.isNullOrEmpty((String)this.databaseName)) {
                tableConfig.setValue(HoodieTableConfig.DATABASE_NAME, this.databaseName);
            }
            tableConfig.setValue(HoodieTableConfig.NAME, this.tableName);
            tableConfig.setValue(HoodieTableConfig.TYPE, this.tableType.name());
            if (null == this.tableVersion) {
                this.tableVersion = HoodieTableVersion.current();
            }
            tableConfig.setTableVersion(this.tableVersion);
            tableConfig.setInitialVersion(this.tableVersion);
            if (null != this.tableCreateSchema) {
                tableConfig.setValue(HoodieTableConfig.CREATE_SCHEMA, this.tableCreateSchema);
            }
            if (!StringUtils.isNullOrEmpty((String)this.archiveLogFolder)) {
                tableConfig.setValue(HoodieTableConfig.ARCHIVELOG_FOLDER, this.archiveLogFolder);
            } else {
                tableConfig.setDefaultValue(HoodieTableConfig.ARCHIVELOG_FOLDER);
            }
            if (!StringUtils.isNullOrEmpty((String)this.timelinePath)) {
                tableConfig.setValue(HoodieTableConfig.TIMELINE_PATH, this.timelinePath);
            } else {
                tableConfig.setDefaultValue(HoodieTableConfig.TIMELINE_PATH);
            }
            if (!StringUtils.isNullOrEmpty((String)this.timelineHistoryPath)) {
                tableConfig.setValue(HoodieTableConfig.TIMELINE_HISTORY_PATH, this.timelineHistoryPath);
            } else {
                tableConfig.setDefaultValue(HoodieTableConfig.TIMELINE_HISTORY_PATH);
            }
            if (null != this.timelineLayoutVersion) {
                tableConfig.setValue(HoodieTableConfig.TIMELINE_LAYOUT_VERSION, String.valueOf(this.timelineLayoutVersion));
            }
            if (null != this.baseFileFormat) {
                tableConfig.setValue(HoodieTableConfig.BASE_FILE_FORMAT, this.baseFileFormat.toUpperCase());
            }
            if (null != this.bootstrapIndexClass) {
                tableConfig.setValue(HoodieTableConfig.BOOTSTRAP_INDEX_TYPE, BootstrapIndexType.fromClassName(this.bootstrapIndexClass).name());
            }
            if (null != this.bootstrapIndexEnable) {
                tableConfig.setValue(HoodieTableConfig.BOOTSTRAP_INDEX_ENABLE, Boolean.toString(this.bootstrapIndexEnable));
            }
            if (null != this.bootstrapBasePath) {
                tableConfig.setValue(HoodieTableConfig.BOOTSTRAP_BASE_PATH, this.bootstrapBasePath);
            }
            if (StringUtils.nonEmpty((String)this.orderingFields)) {
                tableConfig.setValue(HoodieTableConfig.ORDERING_FIELDS, this.orderingFields);
            }
            if (null != this.partitionFields) {
                tableConfig.setValue(HoodieTableConfig.PARTITION_FIELDS, this.partitionFields);
            }
            if (null != this.recordKeyFields) {
                tableConfig.setValue(HoodieTableConfig.RECORDKEY_FIELDS, this.recordKeyFields);
            }
            if (null != this.cdcEnabled) {
                tableConfig.setValue(HoodieTableConfig.CDC_ENABLED, Boolean.toString(this.cdcEnabled));
                if (this.cdcEnabled.booleanValue() && null != this.cdcSupplementalLoggingMode) {
                    tableConfig.setValue(HoodieTableConfig.CDC_SUPPLEMENTAL_LOGGING_MODE, this.cdcSupplementalLoggingMode);
                }
            }
            if (null != this.populateMetaFields) {
                tableConfig.setValue(HoodieTableConfig.POPULATE_META_FIELDS, Boolean.toString(this.populateMetaFields));
            }
            if (null != this.keyGeneratorClassProp) {
                type = KeyGeneratorType.fromClassName(this.keyGeneratorClassProp);
                tableConfig.setValue(HoodieTableConfig.KEY_GENERATOR_TYPE, type.name());
                if (KeyGeneratorType.USER_PROVIDED == type) {
                    tableConfig.setValue(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME, this.keyGeneratorClassProp);
                }
            } else if (null != this.keyGeneratorType) {
                ValidationUtils.checkArgument((!this.keyGeneratorType.equals(KeyGeneratorType.USER_PROVIDED.name()) ? 1 : 0) != 0, (String)String.format("When key generator type is %s, the key generator class must be set properly", KeyGeneratorType.USER_PROVIDED.name()));
                type = KeyGeneratorType.valueOf(this.keyGeneratorType);
                tableConfig.setValue(HoodieTableConfig.KEY_GENERATOR_TYPE, type.name());
            }
            if (null != this.hiveStylePartitioningEnable) {
                tableConfig.setValue(HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE, Boolean.toString(this.hiveStylePartitioningEnable));
            }
            if (null != this.urlEncodePartitioning) {
                tableConfig.setValue(HoodieTableConfig.URL_ENCODE_PARTITIONING, Boolean.toString(this.urlEncodePartitioning));
            }
            if (null != this.commitTimeZone) {
                tableConfig.setValue(HoodieTableConfig.TIMELINE_TIMEZONE, this.commitTimeZone.toString());
            }
            if (null != this.partitionMetafileUseBaseFormat) {
                tableConfig.setValue(HoodieTableConfig.PARTITION_METAFILE_USE_BASE_FORMAT, this.partitionMetafileUseBaseFormat.toString());
            }
            if (null != this.shouldDropPartitionColumns) {
                tableConfig.setValue(HoodieTableConfig.DROP_PARTITION_COLUMNS, Boolean.toString(this.shouldDropPartitionColumns));
            }
            if (null != this.metadataPartitions) {
                tableConfig.setValue(HoodieTableConfig.TABLE_METADATA_PARTITIONS, this.metadataPartitions);
            }
            if (null != this.inflightMetadataPartitions) {
                tableConfig.setValue(HoodieTableConfig.TABLE_METADATA_PARTITIONS_INFLIGHT, this.inflightMetadataPartitions);
            }
            if (null != this.secondaryIndexesMetadata) {
                tableConfig.setValue(HoodieTableConfig.SECONDARY_INDEXES_METADATA, this.secondaryIndexesMetadata);
            }
            if (null != this.multipleBaseFileFormatsEnabled) {
                tableConfig.setValue(HoodieTableConfig.MULTIPLE_BASE_FILE_FORMATS_ENABLE, Boolean.toString(this.multipleBaseFileFormatsEnabled));
            }
            if (null != this.indexDefinitionPath) {
                tableConfig.setValue(HoodieTableConfig.RELATIVE_INDEX_DEFINITION_PATH, this.indexDefinitionPath);
            }
            if (null != this.tableFormat) {
                tableConfig.setValue(HoodieTableConfig.TABLE_FORMAT, this.tableFormat);
            }
            if (this.tableVersion.lesserThan(HoodieTableVersion.NINE)) {
                mergeConfigs = HoodieTableConfig.inferMergingConfigsForPreV9Table(this.recordMergeMode, this.payloadClassName, this.recordMergerStrategyId, this.orderingFields, this.tableVersion);
                tableConfig.setValue(HoodieTableConfig.RECORD_MERGE_MODE, ((RecordMergeMode)((Object)((Triple)mergeConfigs).getLeft())).name());
                tableConfig.setValue(HoodieTableConfig.PAYLOAD_CLASS_NAME.key(), (String)((Triple)mergeConfigs).getMiddle());
                tableConfig.setValue(HoodieTableConfig.RECORD_MERGE_STRATEGY_ID, (String)((Triple)mergeConfigs).getRight());
            } else {
                mergeConfigs = HoodieTableConfig.inferMergingConfigsForV9TableCreation(this.recordMergeMode, this.payloadClassName, this.recordMergerStrategyId, this.orderingFields, this.tableVersion);
                for (Map.Entry config : mergeConfigs.entrySet()) {
                    tableConfig.setValue((String)config.getKey(), (String)config.getValue());
                }
            }
            if (null != this.deleteFieldAndMarker) {
                tableConfig.setValue("hoodie.record.merge.property.hoodie.payload.delete.field", this.deleteFieldAndMarker.getLeft());
                tableConfig.setValue("hoodie.record.merge.property.hoodie.payload.delete.marker", this.deleteFieldAndMarker.getRight());
            }
            return tableConfig.getProps();
        }

        public HoodieTableMetaClient initTable(StorageConfiguration<?> configuration, String basePath) throws IOException {
            return this.initTable(configuration, new StoragePath(basePath));
        }

        public HoodieTableMetaClient initTable(StorageConfiguration<?> storageConf, StoragePath basePath) throws IOException {
            Properties props = this.build();
            HoodieTableMetaClient.createTableLayoutOnStorage(storageConf, basePath, props, this.timelineLayoutVersion, true);
            HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(storageConf).setBasePath(basePath).setMetaserverConfig(props).build();
            LOG.info("Finished initializing Table of type {} from {}", (Object)metaClient.getTableConfig().getTableType(), (Object)basePath);
            return metaClient;
        }
    }

    public static class Builder {
        private StorageConfiguration<?> conf;
        private HoodieStorage storage;
        private String basePath;
        private boolean loadActiveTimelineOnLoad = false;
        private HoodieTimeGeneratorConfig timeGeneratorConfig = null;
        private ConsistencyGuardConfig consistencyGuardConfig = ConsistencyGuardConfig.newBuilder().build();
        private FileSystemRetryConfig fileSystemRetryConfig = FileSystemRetryConfig.newBuilder().build();
        private HoodieMetaserverConfig metaserverConfig = HoodieMetaserverConfig.newBuilder().build();
        private Option<TimelineLayoutVersion> layoutVersion = Option.empty();

        public Builder setConf(StorageConfiguration<?> conf) {
            this.conf = conf;
            return this;
        }

        public Builder setStorage(HoodieStorage storage) {
            this.storage = storage;
            return this;
        }

        public Builder setBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public Builder setBasePath(StoragePath basePath) {
            this.basePath = basePath.toString();
            return this;
        }

        public Builder setLoadActiveTimelineOnLoad(boolean loadActiveTimelineOnLoad) {
            this.loadActiveTimelineOnLoad = loadActiveTimelineOnLoad;
            return this;
        }

        public Builder setTimeGeneratorConfig(HoodieTimeGeneratorConfig timeGeneratorConfig) {
            this.timeGeneratorConfig = timeGeneratorConfig;
            return this;
        }

        public Builder setConsistencyGuardConfig(ConsistencyGuardConfig consistencyGuardConfig) {
            this.consistencyGuardConfig = consistencyGuardConfig;
            return this;
        }

        public Builder setFileSystemRetryConfig(FileSystemRetryConfig fileSystemRetryConfig) {
            this.fileSystemRetryConfig = fileSystemRetryConfig;
            return this;
        }

        public Builder setLayoutVersion(Option<TimelineLayoutVersion> layoutVersion) {
            this.layoutVersion = layoutVersion;
            return this;
        }

        public Builder setMetaserverConfig(Properties props) {
            this.metaserverConfig = new HoodieMetaserverConfig.Builder().fromProperties(props).build();
            return this;
        }

        public Builder setMetaserverConfig(Map<String, String> map) {
            Properties properties = new Properties();
            properties.putAll(map);
            return this.setMetaserverConfig(properties);
        }

        public HoodieTableMetaClient build() {
            ValidationUtils.checkArgument((this.conf != null || this.storage != null ? 1 : 0) != 0, (String)"Storage configuration or HoodieStorage needs to be set to init HoodieTableMetaClient");
            ValidationUtils.checkArgument((this.basePath != null ? 1 : 0) != 0, (String)"basePath needs to be set to init HoodieTableMetaClient");
            if (this.timeGeneratorConfig == null) {
                this.timeGeneratorConfig = HoodieTimeGeneratorConfig.newBuilder().withPath(this.basePath).build();
            }
            if (this.storage == null) {
                this.storage = HoodieTableMetaClient.getStorage(new StoragePath(this.basePath), this.conf, this.consistencyGuardConfig, this.fileSystemRetryConfig);
            }
            return HoodieTableMetaClient.newMetaClient(this.storage, this.basePath, this.loadActiveTimelineOnLoad, this.consistencyGuardConfig, (Option<TimelineLayoutVersion>)this.layoutVersion, this.timeGeneratorConfig, this.fileSystemRetryConfig, this.metaserverConfig);
        }
    }
}

