/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.PartitionPathEncodeUtils;
import org.apache.hudi.common.util.VisibleForTesting;

public class PartitionPathParser {
    public static final String DEPRECATED_DEFAULT_PARTITION_PATH = "default";
    public static final String DEFAULT_PARTITION_PATH = "__HIVE_DEFAULT_PARTITION__";
    private static final String EQUALS_SIGN = "=";
    private static final String DASH = "-";
    private static final String SLASH = "/";

    public Object[] getPartitionFieldVals(Option<String[]> partitionFields, String partitionPath, Schema writerSchema) {
        if (!partitionFields.isPresent()) {
            return new Object[0];
        }
        return PartitionPathParser.getPartitionValues((String[])partitionFields.get(), partitionPath, writerSchema);
    }

    private static Object[] getPartitionValues(String[] partitionFields, String partitionPath, Schema schema) {
        String[] parts = partitionPath.split(SLASH);
        int pathSegment = 0;
        boolean hasDateField = false;
        Object[] partitionValues = new Object[partitionFields.length];
        for (int i = 0; i < partitionFields.length; ++i) {
            String partitionField = partitionFields[i];
            Schema.Field field = schema.getField(partitionField);
            Schema fieldSchema = field == null ? Schema.create((Schema.Type)Schema.Type.STRING) : AvroSchemaUtils.getNonNullTypeFromUnion(field.schema());
            LogicalType logicalType = fieldSchema.getLogicalType();
            if (PartitionPathParser.isTimeBasedLogicalType(logicalType)) {
                if (hasDateField) {
                    throw new IllegalArgumentException("Only one date field based partition is supported");
                }
                hasDateField = true;
                int numDateDirs = parts.length - partitionFields.length + 1;
                partitionValues[i] = PartitionPathParser.inferDateValue(partitionPath, parts, pathSegment, numDateDirs, fieldSchema);
                pathSegment += numDateDirs;
                continue;
            }
            String segment = parts[pathSegment];
            String[] segmentParts = segment.split(EQUALS_SIGN);
            partitionValues[i] = PartitionPathParser.parseValue(segmentParts[segmentParts.length - 1], fieldSchema);
            ++pathSegment;
        }
        return partitionValues;
    }

    @VisibleForTesting
    static Object parseValue(String partitionValue, Schema fieldSchema) {
        if (partitionValue.equals(DEFAULT_PARTITION_PATH) || partitionValue.equals(DEPRECATED_DEFAULT_PARTITION_PATH)) {
            return null;
        }
        switch (fieldSchema.getType()) {
            case STRING: {
                return PartitionPathEncodeUtils.unescapePathName(partitionValue);
            }
            case INT: {
                return Integer.parseInt(partitionValue);
            }
            case LONG: {
                return Long.parseLong(partitionValue);
            }
            case FLOAT: {
                return Float.valueOf(Float.parseFloat(partitionValue));
            }
            case DOUBLE: {
                return Double.parseDouble(partitionValue);
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(partitionValue);
            }
            case BYTES: 
            case FIXED: {
                if (fieldSchema.getLogicalType() instanceof LogicalTypes.Decimal) {
                    return new BigDecimal(partitionValue);
                }
                return partitionValue.getBytes(StandardCharsets.UTF_8);
            }
        }
        throw new IllegalArgumentException("Unexpected type " + fieldSchema.getType());
    }

    private static Object inferDateValue(String partitionPath, String[] parts, int pathSegment, int numDateDirs, Schema fieldSchema) {
        LocalDateTime time;
        StringBuilder condensedPartitionValue = new StringBuilder();
        for (int i = 0; i < numDateDirs; ++i) {
            String partitionValue = parts[pathSegment + i];
            if (partitionValue.contains(EQUALS_SIGN)) {
                partitionValue = partitionValue.split(EQUALS_SIGN)[1];
            }
            if (partitionValue.contains(DASH)) {
                partitionValue = partitionValue.replace(DASH, "");
            }
            condensedPartitionValue.append(partitionValue.replace(SLASH, ""));
        }
        switch (condensedPartitionValue.length()) {
            case 4: {
                time = LocalDateTime.of(Integer.parseInt(condensedPartitionValue.substring(0, 4)), 1, 1, 0, 0);
                break;
            }
            case 6: {
                time = LocalDateTime.of(Integer.parseInt(condensedPartitionValue.substring(0, 4)), Integer.parseInt(condensedPartitionValue.substring(4, 6)), 1, 0, 0);
                break;
            }
            case 8: {
                time = LocalDateTime.of(Integer.parseInt(condensedPartitionValue.substring(0, 4)), Integer.parseInt(condensedPartitionValue.substring(4, 6)), Integer.parseInt(condensedPartitionValue.substring(6, 8)), 0, 0);
                break;
            }
            case 10: {
                time = LocalDateTime.of(Integer.parseInt(condensedPartitionValue.substring(0, 4)), Integer.parseInt(condensedPartitionValue.substring(4, 6)), Integer.parseInt(condensedPartitionValue.substring(6, 8)), Integer.parseInt(condensedPartitionValue.substring(8, 10)), 0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown date format for partition path: " + partitionPath);
            }
        }
        if (fieldSchema.getLogicalType() instanceof LogicalTypes.Date) {
            return Date.valueOf(time.toLocalDate());
        }
        return Timestamp.from(time.toInstant(ZoneOffset.UTC));
    }

    private static boolean isTimeBasedLogicalType(LogicalType logicalType) {
        return logicalType instanceof LogicalTypes.Date || logicalType instanceof LogicalTypes.TimestampMillis || logicalType instanceof LogicalTypes.TimestampMicros || logicalType instanceof LogicalTypes.TimeMillis || logicalType instanceof LogicalTypes.TimeMicros || logicalType instanceof LogicalTypes.LocalTimestampMicros || logicalType instanceof LogicalTypes.LocalTimestampMillis;
    }
}

