/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log;

import java.io.Closeable;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.BaseHoodieLogRecordReader;
import org.apache.hudi.common.table.log.FullKeySpec;
import org.apache.hudi.common.table.log.InstantRange;
import org.apache.hudi.common.table.log.KeySpec;
import org.apache.hudi.common.table.log.PrefixKeySpec;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.table.read.buffer.HoodieFileGroupRecordBuffer;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.expression.Expression;
import org.apache.hudi.expression.Predicate;
import org.apache.hudi.expression.Predicates;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieMergedLogRecordReader<T>
extends BaseHoodieLogRecordReader<T>
implements Iterable<BufferedRecord<T>>,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieMergedLogRecordReader.class);
    public final HoodieTimer timer = HoodieTimer.create();
    private long numMergedRecordsInLog;
    private long totalTimeTakenToReadAndMergeBlocks;

    private HoodieMergedLogRecordReader(HoodieReaderContext<T> readerContext, HoodieTableMetaClient metaClient, HoodieStorage storage, List<HoodieLogFile> logFiles, boolean reverseReader, int bufferSize, Option<InstantRange> instantRange, boolean withOperationField, boolean forceFullScan, Option<String> partitionName, Option<String> keyFieldOverride, boolean enableOptimizedLogBlocksScan, HoodieFileGroupRecordBuffer<T> recordBuffer, boolean allowInflightInstants) {
        super(readerContext, metaClient, storage, logFiles, reverseReader, bufferSize, instantRange, withOperationField, forceFullScan, partitionName, keyFieldOverride, enableOptimizedLogBlocksScan, recordBuffer, allowInflightInstants);
        if (forceFullScan) {
            this.performScan();
        }
    }

    public final void scan() {
        this.scan(false);
    }

    public final void scan(boolean skipProcessingBlocks) {
        if (this.forceFullScan) {
            return;
        }
        this.scanInternal((Option<KeySpec>)Option.empty(), skipProcessingBlocks);
    }

    private void performScan() {
        this.timer.startTimer();
        Option<KeySpec> keySpecOpt = HoodieMergedLogRecordReader.createKeySpec(this.readerContext.getKeyFilterOpt());
        this.scanInternal(keySpecOpt, false);
        this.totalTimeTakenToReadAndMergeBlocks = this.timer.endTimer();
        this.numMergedRecordsInLog = this.recordBuffer.size();
        LOG.info("Number of log files scanned => {}", (Object)this.logFiles.size());
        LOG.info("Number of entries in Map => {}", (Object)this.recordBuffer.size());
    }

    static Option<KeySpec> createKeySpec(Option<Predicate> filter) {
        if (filter.isEmpty()) {
            return Option.empty();
        }
        if (((Predicate)filter.get()).getOperator() == Expression.Operator.IN) {
            List<Expression> rightChildren = ((Predicates.In)filter.get()).getRightChildren();
            List<String> keyOrPrefixes = rightChildren.stream().map(e -> (String)e.eval(null)).collect(Collectors.toList());
            return Option.of((Object)new FullKeySpec(keyOrPrefixes));
        }
        if (((Predicate)filter.get()).getOperator() == Expression.Operator.STARTS_WITH) {
            List<Expression> rightChildren = ((Predicates.StringStartsWithAny)filter.get()).getRightChildren();
            List<String> keyOrPrefixes = rightChildren.stream().map(e -> (String)e.eval(null)).collect(Collectors.toList());
            return Option.of((Object)new PrefixKeySpec(keyOrPrefixes));
        }
        return Option.empty();
    }

    @Override
    public Iterator<BufferedRecord<T>> iterator() {
        return this.recordBuffer.getLogRecordIterator();
    }

    public Map<Serializable, BufferedRecord<T>> getRecords() {
        return this.recordBuffer.getLogRecords();
    }

    public long getNumMergedRecordsInLog() {
        return this.numMergedRecordsInLog;
    }

    public static <T> Builder<T> newBuilder() {
        return new Builder();
    }

    public long getTotalTimeTakenToReadAndMergeBlocks() {
        return this.totalTimeTakenToReadAndMergeBlocks;
    }

    @Override
    public void close() {
    }

    public static class Builder<T>
    extends BaseHoodieLogRecordReader.Builder<T> {
        private HoodieReaderContext<T> readerContext;
        private HoodieStorage storage;
        private List<HoodieLogFile> logFiles;
        private boolean reverseReader;
        private int bufferSize;
        private Long maxMemorySizeInBytes;
        private Option<InstantRange> instantRange = Option.empty();
        private String partitionName;
        private boolean withOperationField = false;
        private String keyFieldOverride;
        private boolean forceFullScan = true;
        private boolean enableOptimizedLogBlocksScan = false;
        private HoodieFileGroupRecordBuffer<T> recordBuffer;
        private boolean allowInflightInstants = false;
        private HoodieTableMetaClient metaClient;

        @Override
        public Builder<T> withHoodieReaderContext(HoodieReaderContext<T> readerContext) {
            this.readerContext = readerContext;
            return this;
        }

        @Override
        public Builder<T> withStorage(HoodieStorage storage) {
            this.storage = storage;
            return this;
        }

        @Override
        public Builder<T> withLogFiles(List<HoodieLogFile> hoodieLogFiles) {
            this.logFiles = hoodieLogFiles.stream().filter(l -> !l.isCDC()).collect(Collectors.toList());
            return this;
        }

        @Override
        public Builder<T> withReverseReader(boolean reverseReader) {
            this.reverseReader = reverseReader;
            return this;
        }

        @Override
        public Builder<T> withBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        @Override
        public Builder<T> withInstantRange(Option<InstantRange> instantRange) {
            this.instantRange = instantRange;
            return this;
        }

        @Override
        public Builder<T> withOperationField(boolean withOperationField) {
            this.withOperationField = withOperationField;
            return this;
        }

        @Override
        public Builder<T> withPartition(String partitionName) {
            this.partitionName = partitionName;
            return this;
        }

        @Override
        public Builder<T> withOptimizedLogBlocksScan(boolean enableOptimizedLogBlocksScan) {
            this.enableOptimizedLogBlocksScan = enableOptimizedLogBlocksScan;
            return this;
        }

        public Builder<T> withKeyFieldOverride(String keyFieldOverride) {
            this.keyFieldOverride = Objects.requireNonNull(keyFieldOverride);
            return this;
        }

        public Builder<T> withForceFullScan(boolean forceFullScan) {
            this.forceFullScan = forceFullScan;
            return this;
        }

        public Builder<T> withRecordBuffer(HoodieFileGroupRecordBuffer<T> recordBuffer) {
            this.recordBuffer = recordBuffer;
            return this;
        }

        public Builder<T> withAllowInflightInstants(boolean allowInflightInstants) {
            this.allowInflightInstants = allowInflightInstants;
            return this;
        }

        public Builder<T> withMetaClient(HoodieTableMetaClient metaClient) {
            this.metaClient = metaClient;
            return this;
        }

        @Override
        public HoodieMergedLogRecordReader<T> build() {
            ValidationUtils.checkArgument((this.recordBuffer != null ? 1 : 0) != 0, (String)"Record Buffer is null in Merged Log Record Reader");
            ValidationUtils.checkArgument((this.readerContext != null ? 1 : 0) != 0, (String)"Reader Context is null in Merged Log Record Reader");
            if (this.partitionName == null && CollectionUtils.nonEmpty(this.logFiles)) {
                this.partitionName = FSUtils.getRelativePartitionPath(new StoragePath(this.readerContext.getTablePath()), this.logFiles.get(0).getPath().getParent());
            }
            return new HoodieMergedLogRecordReader(this.readerContext, this.metaClient, this.storage, this.logFiles, this.reverseReader, this.bufferSize, this.instantRange, this.withOperationField, this.forceFullScan, Option.ofNullable((Object)this.partitionName), Option.ofNullable((Object)this.keyFieldOverride), this.enableOptimizedLogBlocksScan, this.recordBuffer, this.allowInflightInstants);
        }
    }
}

