/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log.block;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nonnull;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.hudi.avro.AvroSchemaCache;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.fs.SizeAwareDataInputStream;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.log.block.HoodieAvroDataBlockVersion;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.CloseableMappingIterator;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.io.SeekableDataInputStream;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.parquet.schema.AvroSchemaRepair;

public class HoodieAvroDataBlock
extends HoodieDataBlock {
    public HoodieAvroDataBlock(Supplier<SeekableDataInputStream> inputStreamSupplier, Option<byte[]> content, boolean readBlockLazily, HoodieLogBlock.HoodieLogBlockContentLocation logBlockContentLocation, Option<Schema> readerSchema, Map<HoodieLogBlock.HeaderMetadataType, String> header, Map<HoodieLogBlock.FooterMetadataType, String> footer, String keyField) {
        super(content, inputStreamSupplier, readBlockLazily, (Option<HoodieLogBlock.HoodieLogBlockContentLocation>)Option.of((Object)logBlockContentLocation), readerSchema, header, footer, keyField, false);
    }

    public HoodieAvroDataBlock(@Nonnull List<HoodieRecord> records, @Nonnull Map<HoodieLogBlock.HeaderMetadataType, String> header, @Nonnull String keyField) {
        super(records, header, new HashMap<HoodieLogBlock.FooterMetadataType, String>(), keyField);
    }

    @Override
    public HoodieLogBlock.HoodieLogBlockType getBlockType() {
        return HoodieLogBlock.HoodieLogBlockType.AVRO_DATA_BLOCK;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected ByteArrayOutputStream serializeRecords(List<HoodieRecord> records, HoodieStorage storage) throws IOException {
        Schema schema = AvroSchemaCache.intern(new Schema.Parser().parse(super.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.SCHEMA)));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (DataOutputStream output = new DataOutputStream(baos);){
            output.writeInt(HoodieLogBlock.version);
            output.writeInt(records.size());
            Properties props = this.initProperties(storage.getConf());
            for (HoodieRecord s : records) {
                try {
                    ByteArrayOutputStream data = s.getAvroBytes(schema, props);
                    output.writeInt(data.size());
                    data.writeTo(output);
                }
                catch (IOException e) {
                    throw new HoodieIOException("IOException converting HoodieAvroDataBlock to bytes", e);
                    return baos;
                }
            }
        }
    }

    @Override
    protected <T> ClosableIterator<HoodieRecord<T>> deserializeRecords(byte[] content, HoodieRecord.HoodieRecordType type) throws IOException {
        ValidationUtils.checkState((this.readerSchema != null ? 1 : 0) != 0, (String)"Reader's schema has to be non-null");
        ValidationUtils.checkArgument((type != HoodieRecord.HoodieRecordType.SPARK ? 1 : 0) != 0, (String)"Not support read avro to spark record");
        RecordIterator iterator = RecordIterator.getInstance(this, content, true);
        return new CloseableMappingIterator<IndexedRecord, HoodieRecord>(iterator, data -> new HoodieAvroIndexedRecord((IndexedRecord)data));
    }

    @Override
    protected <T> ClosableIterator<HoodieRecord<T>> deserializeRecords(SeekableDataInputStream inputStream, HoodieLogBlock.HoodieLogBlockContentLocation contentLocation, HoodieRecord.HoodieRecordType type, int bufferSize) throws IOException {
        StreamingRecordIterator iterator = StreamingRecordIterator.getInstance(this, inputStream, contentLocation, bufferSize);
        return new CloseableMappingIterator<IndexedRecord, HoodieRecord>(iterator, data -> new HoodieAvroIndexedRecord((IndexedRecord)data));
    }

    @Override
    protected <T> ClosableIterator<T> deserializeRecords(HoodieReaderContext<T> readerContext, byte[] content) throws IOException {
        ValidationUtils.checkState((this.readerSchema != null ? 1 : 0) != 0, (String)"Reader's schema has to be non-null");
        RecordIterator iterator = RecordIterator.getInstance(this, content, readerContext.enableLogicalTimestampFieldRepair());
        return new CloseableMappingIterator<IndexedRecord, Object>(iterator, data -> readerContext.getRecordContext().convertAvroRecord((IndexedRecord)data));
    }

    protected Properties initProperties(StorageConfiguration<?> storageConfig) {
        return CollectionUtils.emptyProps();
    }

    @Deprecated
    public HoodieAvroDataBlock(List<HoodieRecord> records, Schema schema) {
        super(records, Collections.singletonMap(HoodieLogBlock.HeaderMetadataType.SCHEMA, schema.toString()), new HashMap<HoodieLogBlock.FooterMetadataType, String>(), HoodieRecord.RECORD_KEY_METADATA_FIELD);
    }

    public static HoodieAvroDataBlock getBlock(byte[] content, Schema readerSchema) throws IOException {
        return HoodieAvroDataBlock.getBlock(content, readerSchema, InternalSchema.getEmptyInternalSchema());
    }

    @Deprecated
    public static HoodieAvroDataBlock getBlock(byte[] content, Schema readerSchema, InternalSchema internalSchema) throws IOException {
        SizeAwareDataInputStream dis = new SizeAwareDataInputStream(new DataInputStream(new ByteArrayInputStream(content)));
        int schemaLength = dis.readInt();
        byte[] compressedSchema = new byte[schemaLength];
        dis.readFully(compressedSchema, 0, schemaLength);
        Schema writerSchema = new Schema.Parser().parse(HoodieAvroDataBlock.decompress(compressedSchema));
        if (readerSchema == null) {
            readerSchema = writerSchema;
        }
        if (!internalSchema.isEmptySchema()) {
            readerSchema = writerSchema;
        }
        GenericDatumReader reader = new GenericDatumReader(writerSchema, readerSchema);
        int totalRecords = dis.readInt();
        ArrayList<HoodieRecord> records = new ArrayList<HoodieRecord>(totalRecords);
        for (int i = 0; i < totalRecords; ++i) {
            int recordLength = dis.readInt();
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(content, dis.getNumberOfBytesRead(), recordLength, null);
            IndexedRecord record = (IndexedRecord)reader.read(null, (Decoder)decoder);
            records.add(new HoodieAvroIndexedRecord(record));
            dis.skipBytes(recordLength);
        }
        dis.close();
        return new HoodieAvroDataBlock(records, readerSchema);
    }

    private static byte[] compress(String text) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (DeflaterOutputStream out = new DeflaterOutputStream(baos);){
            ((OutputStream)out).write(StringUtils.getUTF8Bytes((String)text));
        }
        catch (IOException e) {
            throw new HoodieIOException("IOException while compressing text " + text, e);
        }
        return baos.toByteArray();
    }

    private static String decompress(byte[] bytes) {
        InflaterInputStream in = new InflaterInputStream(new ByteArrayInputStream(bytes));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int len;
            byte[] buffer = new byte[8192];
            while ((len = ((InputStream)in).read(buffer)) > 0) {
                baos.write(buffer, 0, len);
            }
            return StringUtils.fromUTF8Bytes((byte[])baos.toByteArray());
        }
        catch (IOException e) {
            throw new HoodieIOException("IOException while decompressing text", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public byte[] getBytes(Schema schema) throws IOException {
        GenericDatumWriter writer = new GenericDatumWriter(schema);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (DataOutputStream output = new DataOutputStream(baos);){
            byte[] schemaContent = HoodieAvroDataBlock.compress(schema.toString());
            output.writeInt(schemaContent.length);
            output.write(schemaContent);
            ArrayList records = new ArrayList();
            try (ClosableIterator recordItr = this.getRecordIterator(HoodieRecord.HoodieRecordType.AVRO);){
                recordItr.forEachRemaining(records::add);
            }
            output.writeInt(records.size());
            Iterator itr = records.iterator();
            while (itr.hasNext()) {
                IndexedRecord s = ((HoodieAvroIndexedRecord)((HoodieRecord)itr.next()).toIndexedRecord(schema, new Properties()).get()).getData();
                ByteArrayOutputStream temp = new ByteArrayOutputStream();
                BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)temp, null);
                try {
                    writer.write((Object)s, (Encoder)encoder);
                    encoder.flush();
                    output.writeInt(temp.size());
                    temp.writeTo(output);
                    itr.remove();
                }
                catch (IOException e) {
                    throw new HoodieIOException("IOException converting HoodieAvroDataBlock to bytes", e);
                    return baos.toByteArray();
                }
            }
        }
    }

    private static class StreamingRecordIterator
    implements ClosableIterator<IndexedRecord> {
        private static final int RECORD_LENGTH_BYTES = 4;
        private static final int MIN_BUFFER_SIZE = 4;
        private final SeekableDataInputStream inputStream;
        private final GenericDatumReader<IndexedRecord> reader;
        private final ThreadLocal<BinaryDecoder> decoderCache = new ThreadLocal();
        private Option<Schema> promotedSchema = Option.empty();
        private int totalRecords = 0;
        private int readRecords = 0;
        private ByteBuffer buffer;

        private StreamingRecordIterator(Schema readerSchema, Schema writerSchema, SeekableDataInputStream inputStream, HoodieLogBlock.HoodieLogBlockContentLocation contentLocation, int bufferSize) throws IOException {
            Schema repairedWriterSchema;
            ValidationUtils.checkArgument((bufferSize > 0 ? 1 : 0) != 0, (String)"Buffer size must be greater than zero");
            bufferSize = Math.max(bufferSize, 4);
            this.inputStream = inputStream;
            this.inputStream.seek(contentLocation.getContentPositionInLogFile());
            int version = this.inputStream.readInt();
            if (new HoodieAvroDataBlockVersion(version).hasRecordCount()) {
                this.totalRecords = this.inputStream.readInt();
            }
            if (HoodieAvroUtils.recordNeedsRewriteForExtendedAvroTypePromotion(repairedWriterSchema = AvroSchemaRepair.repairLogicalTypes(writerSchema, readerSchema), readerSchema)) {
                this.reader = new GenericDatumReader(repairedWriterSchema, repairedWriterSchema);
                this.promotedSchema = Option.of((Object)readerSchema);
            } else {
                this.reader = new GenericDatumReader(repairedWriterSchema, readerSchema);
            }
            this.buffer = ByteBuffer.allocate(Math.min(bufferSize, Math.toIntExact(contentLocation.getBlockSize())));
            this.buffer.flip();
        }

        public static StreamingRecordIterator getInstance(HoodieAvroDataBlock dataBlock, SeekableDataInputStream inputStream, HoodieLogBlock.HoodieLogBlockContentLocation contentLocation, int bufferSize) throws IOException {
            return new StreamingRecordIterator(dataBlock.readerSchema, dataBlock.getSchemaFromHeader(), inputStream, contentLocation, bufferSize);
        }

        @Override
        public void close() {
            this.decoderCache.remove();
            this.buffer = null;
            try {
                this.inputStream.close();
            }
            catch (IOException ex) {
                throw new HoodieIOException("Failed to close input stream", ex);
            }
        }

        @Override
        public boolean hasNext() {
            return this.readRecords < this.totalRecords;
        }

        @Override
        public IndexedRecord next() {
            try {
                this.ensureBufferHasData(4);
                int recordLength = this.buffer.getInt();
                this.ensureBufferHasData(recordLength);
                BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(this.buffer.array(), this.buffer.position(), recordLength, this.decoderCache.get());
                this.decoderCache.set(decoder);
                IndexedRecord record = (IndexedRecord)this.reader.read(null, (Decoder)decoder);
                this.buffer.position(this.buffer.position() + recordLength);
                ++this.readRecords;
                if (this.promotedSchema.isPresent()) {
                    return HoodieAvroUtils.rewriteRecordWithNewSchema(record, (Schema)this.promotedSchema.get());
                }
                return record;
            }
            catch (IOException e) {
                throw new HoodieIOException("Unable to convert bytes to record", e);
            }
        }

        private void ensureBufferHasData(int dataLength) throws IOException {
            if (this.buffer.capacity() - this.buffer.position() < dataLength) {
                this.buffer.compact();
                this.buffer.flip();
            }
            if (this.buffer.capacity() - this.buffer.position() < dataLength) {
                ByteBuffer newBuffer = ByteBuffer.allocate(this.buffer.position() + dataLength);
                newBuffer.put(this.buffer);
                newBuffer.flip();
                this.buffer = newBuffer;
            }
            while (this.buffer.remaining() < dataLength) {
                boolean hasMoreData = this.fillBuffer();
                if (hasMoreData || this.buffer.remaining() >= dataLength) continue;
                throw new HoodieException("Unable to read enough data from the input stream to fill the buffer");
            }
        }

        private boolean fillBuffer() throws IOException {
            int bytesRead = this.inputStream.read(this.buffer.array(), this.buffer.limit(), this.buffer.capacity() - this.buffer.limit());
            if (bytesRead == -1) {
                return false;
            }
            this.buffer.limit(this.buffer.limit() + bytesRead);
            return true;
        }
    }

    private static class RecordIterator
    implements ClosableIterator<IndexedRecord> {
        private byte[] content;
        private final SizeAwareDataInputStream dis;
        private final GenericDatumReader<IndexedRecord> reader;
        private final ThreadLocal<BinaryDecoder> decoderCache = new ThreadLocal();
        private Option<Schema> promotedSchema = Option.empty();
        private int totalRecords = 0;
        private int readRecords = 0;

        private RecordIterator(Schema readerSchema, Schema writerSchema, byte[] content, boolean enableLogicalTimestampFieldRepair) throws IOException {
            Schema repairedWriterSchema;
            this.content = content;
            this.dis = new SizeAwareDataInputStream(new DataInputStream(new ByteArrayInputStream(this.content)));
            int version = this.dis.readInt();
            if (new HoodieAvroDataBlockVersion(version).hasRecordCount()) {
                this.totalRecords = this.dis.readInt();
            }
            Schema schema = repairedWriterSchema = enableLogicalTimestampFieldRepair ? AvroSchemaRepair.repairLogicalTypes(writerSchema, readerSchema) : writerSchema;
            if (HoodieAvroUtils.recordNeedsRewriteForExtendedAvroTypePromotion(repairedWriterSchema, readerSchema)) {
                this.reader = new GenericDatumReader(repairedWriterSchema, repairedWriterSchema);
                this.promotedSchema = Option.of((Object)readerSchema);
            } else {
                this.reader = new GenericDatumReader(repairedWriterSchema, readerSchema);
            }
        }

        public static RecordIterator getInstance(HoodieAvroDataBlock dataBlock, byte[] content, boolean enableLogicalTimestampFieldRepair) throws IOException {
            return new RecordIterator(dataBlock.readerSchema, dataBlock.getSchemaFromHeader(), content, enableLogicalTimestampFieldRepair);
        }

        @Override
        public void close() {
            try {
                this.dis.close();
                this.decoderCache.remove();
                this.content = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public boolean hasNext() {
            return this.readRecords < this.totalRecords;
        }

        @Override
        public IndexedRecord next() {
            try {
                int recordLength = this.dis.readInt();
                BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(this.content, this.dis.getNumberOfBytesRead(), recordLength, this.decoderCache.get());
                this.decoderCache.set(decoder);
                IndexedRecord record = (IndexedRecord)this.reader.read(null, (Decoder)decoder);
                this.dis.skipBytes(recordLength);
                ++this.readRecords;
                if (this.promotedSchema.isPresent()) {
                    return HoodieAvroUtils.rewriteRecordWithNewSchema(record, (Schema)this.promotedSchema.get());
                }
                return record;
            }
            catch (IOException e) {
                throw new HoodieIOException("Unable to convert bytes to record.", e);
            }
        }
    }
}

