/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log.block;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.TypeUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.CloseableMappingIterator;
import org.apache.hudi.io.SeekableDataInputStream;
import org.apache.hudi.io.storage.HoodieAvroHFileReaderImplBase;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.inline.InLineFSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieHFileDataBlock
extends HoodieDataBlock {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieHFileDataBlock.class);
    private final Option<String> compressionCodec;
    private final StoragePath pathForReader;

    public HoodieHFileDataBlock(Supplier<SeekableDataInputStream> inputStreamSupplier, Option<byte[]> content, boolean readBlockLazily, HoodieLogBlock.HoodieLogBlockContentLocation logBlockContentLocation, Option<Schema> readerSchema, Map<HoodieLogBlock.HeaderMetadataType, String> header, Map<HoodieLogBlock.FooterMetadataType, String> footer, boolean enablePointLookups, StoragePath pathForReader) {
        super(content, inputStreamSupplier, readBlockLazily, (Option<HoodieLogBlock.HoodieLogBlockContentLocation>)Option.of((Object)logBlockContentLocation), readerSchema, header, footer, "key", enablePointLookups);
        this.compressionCodec = Option.empty();
        this.pathForReader = pathForReader;
    }

    public HoodieHFileDataBlock(List<HoodieRecord> records, Map<HoodieLogBlock.HeaderMetadataType, String> header, String compressionCodec, StoragePath pathForReader) {
        super(records, header, new HashMap<HoodieLogBlock.FooterMetadataType, String>(), "key");
        this.compressionCodec = Option.of((Object)compressionCodec);
        this.pathForReader = pathForReader;
    }

    @Override
    public HoodieLogBlock.HoodieLogBlockType getBlockType() {
        return HoodieLogBlock.HoodieLogBlockType.HFILE_DATA_BLOCK;
    }

    @Override
    protected ByteArrayOutputStream serializeRecords(List<HoodieRecord> records, HoodieStorage storage) throws IOException {
        Schema writerSchema = new Schema.Parser().parse(super.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.SCHEMA));
        return HoodieIOFactory.getIOFactory(storage).getFileFormatUtils(HoodieFileFormat.HFILE).serializeRecordsToLogBlock(storage, records, writerSchema, this.getSchema(), this.getKeyFieldName(), Collections.singletonMap(HoodieStorageConfig.HFILE_COMPRESSION_ALGORITHM_NAME.key(), this.compressionCodec.get()));
    }

    @Override
    protected <T> ClosableIterator<HoodieRecord<T>> deserializeRecords(byte[] content, HoodieRecord.HoodieRecordType type) throws IOException {
        ValidationUtils.checkState((this.readerSchema != null ? 1 : 0) != 0, (String)"Reader's schema has to be non-null");
        StorageConfiguration storageConf = ((HoodieLogBlock.HoodieLogBlockContentLocation)this.getBlockContentLocation().get()).getStorage().getConf().getInline();
        HoodieStorage inlineStorage = ((HoodieLogBlock.HoodieLogBlockContentLocation)this.getBlockContentLocation().get()).getStorage().newInstance(this.pathForReader, storageConf);
        try (HoodieFileReader reader = HoodieIOFactory.getIOFactory(inlineStorage).getReaderFactory(HoodieRecord.HoodieRecordType.AVRO).getContentReader(ConfigUtils.DEFAULT_HUDI_CONFIG_FOR_READER, this.pathForReader, HoodieFileFormat.HFILE, inlineStorage, content, (Option<Schema>)Option.of((Object)this.getSchemaFromHeader()));){
            ClosableIterator closableIterator = (ClosableIterator)TypeUtils.unsafeCast(reader.getRecordIterator(this.readerSchema));
            return closableIterator;
        }
    }

    @Override
    protected <T> ClosableIterator<HoodieRecord<T>> deserializeRecords(SeekableDataInputStream inputStream, HoodieLogBlock.HoodieLogBlockContentLocation contentLocation, HoodieRecord.HoodieRecordType type, int bufferSize) throws IOException {
        throw new UnsupportedOperationException("Streaming deserialization is not supported for HoodieHFileDataBlock");
    }

    @Override
    protected <T> ClosableIterator<T> deserializeRecords(HoodieReaderContext<T> readerContext, byte[] content) throws IOException {
        ValidationUtils.checkState((this.readerSchema != null ? 1 : 0) != 0, (String)"Reader's schema has to be non-null");
        StorageConfiguration storageConf = ((HoodieLogBlock.HoodieLogBlockContentLocation)this.getBlockContentLocation().get()).getStorage().getConf().getInline();
        HoodieStorage inlineStorage = ((HoodieLogBlock.HoodieLogBlockContentLocation)this.getBlockContentLocation().get()).getStorage().newInstance(this.pathForReader, storageConf);
        try (HoodieAvroHFileReaderImplBase reader = (HoodieAvroHFileReaderImplBase)HoodieIOFactory.getIOFactory(inlineStorage).getReaderFactory(HoodieRecord.HoodieRecordType.AVRO).getContentReader(readerContext.getHoodieReaderConfig(), this.pathForReader, HoodieFileFormat.HFILE, inlineStorage, content, (Option<Schema>)Option.of((Object)this.getSchemaFromHeader()));){
            ClosableIterator closableIterator = (ClosableIterator)TypeUtils.unsafeCast(reader.getIndexedRecordIterator(this.readerSchema, this.readerSchema));
            return closableIterator;
        }
    }

    @Override
    protected <T> ClosableIterator<HoodieRecord<T>> lookupRecords(List<String> sortedKeys, boolean fullKey) throws IOException {
        HoodieLogBlock.HoodieLogBlockContentLocation blockContentLoc = (HoodieLogBlock.HoodieLogBlockContentLocation)this.getBlockContentLocation().get();
        StorageConfiguration inlineConf = ((HoodieLogBlock.HoodieLogBlockContentLocation)this.getBlockContentLocation().get()).getStorage().getConf().getInline();
        StoragePath inlinePath = InLineFSUtils.getInlineFilePath((StoragePath)blockContentLoc.getLogFile().getPath(), (String)blockContentLoc.getLogFile().getPath().toUri().getScheme(), (long)blockContentLoc.getContentPositionInLogFile(), (long)blockContentLoc.getBlockSize());
        HoodieStorage inlineStorage = ((HoodieLogBlock.HoodieLogBlockContentLocation)this.getBlockContentLocation().get()).getStorage().newInstance(inlinePath, inlineConf);
        try (HoodieAvroHFileReaderImplBase reader = (HoodieAvroHFileReaderImplBase)HoodieIOFactory.getIOFactory(inlineStorage).getReaderFactory(HoodieRecord.HoodieRecordType.AVRO).getFileReader(ConfigUtils.DEFAULT_HUDI_CONFIG_FOR_READER, inlinePath, HoodieFileFormat.HFILE, (Option<Schema>)Option.of((Object)this.getSchemaFromHeader()));){
            ClosableIterator recordIterator = fullKey ? reader.getRecordsByKeysIterator(sortedKeys, this.readerSchema) : reader.getRecordsByKeyPrefixIterator(sortedKeys, this.readerSchema);
            CloseableMappingIterator<HoodieRecord, HoodieRecord> closeableMappingIterator = new CloseableMappingIterator<HoodieRecord, HoodieRecord>(recordIterator, data -> data);
            return closeableMappingIterator;
        }
    }

    @Override
    protected <T> ClosableIterator<T> lookupEngineRecords(List<String> sortedKeys, boolean fullKey) throws IOException {
        HoodieLogBlock.HoodieLogBlockContentLocation blockContentLoc = (HoodieLogBlock.HoodieLogBlockContentLocation)this.getBlockContentLocation().get();
        StorageConfiguration inlineConf = ((HoodieLogBlock.HoodieLogBlockContentLocation)this.getBlockContentLocation().get()).getStorage().getConf().getInline();
        StoragePath inlinePath = InLineFSUtils.getInlineFilePath((StoragePath)blockContentLoc.getLogFile().getPath(), (String)blockContentLoc.getLogFile().getPath().toUri().getScheme(), (long)blockContentLoc.getContentPositionInLogFile(), (long)blockContentLoc.getBlockSize());
        HoodieStorage inlineStorage = blockContentLoc.getStorage().newInstance(inlinePath, inlineConf);
        try (HoodieAvroHFileReaderImplBase reader = (HoodieAvroHFileReaderImplBase)HoodieIOFactory.getIOFactory(inlineStorage).getReaderFactory(HoodieRecord.HoodieRecordType.AVRO).getFileReader(ConfigUtils.DEFAULT_HUDI_CONFIG_FOR_READER, inlinePath, HoodieFileFormat.HFILE, (Option<Schema>)Option.of((Object)this.getSchemaFromHeader()));){
            ClosableIterator closableIterator = fullKey ? reader.getEngineRecordsByKeysIterator(sortedKeys, this.readerSchema) : reader.getEngineRecordsByKeyPrefixIterator(sortedKeys, this.readerSchema);
            return closableIterator;
        }
    }
}

