/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import org.apache.hudi.common.engine.RecordContext;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.util.OrderingValues;

public class BufferedRecord<T>
implements Serializable {
    private String recordKey;
    private T record;
    private final Comparable orderingValue;
    private final Integer schemaId;
    @Nullable
    private HoodieOperation hoodieOperation;

    public BufferedRecord() {
        this(null, null, null, null, null);
    }

    public BufferedRecord(String recordKey, Comparable orderingValue, T record, Integer schemaId, @Nullable HoodieOperation hoodieOperation) {
        this.recordKey = recordKey;
        this.orderingValue = orderingValue;
        this.record = record;
        this.schemaId = schemaId;
        this.hoodieOperation = hoodieOperation;
    }

    public String getRecordKey() {
        return this.recordKey;
    }

    public Comparable getOrderingValue() {
        return this.orderingValue;
    }

    public T getRecord() {
        return this.record;
    }

    public Integer getSchemaId() {
        return this.schemaId;
    }

    public boolean isDelete() {
        return HoodieOperation.isDelete(this.hoodieOperation) || HoodieOperation.isUpdateBefore(this.hoodieOperation);
    }

    public boolean isEmpty() {
        return this.record == null;
    }

    public boolean isCommitTimeOrderingDelete() {
        return this.isDelete() && OrderingValues.isDefault(this.orderingValue);
    }

    public void setHoodieOperation(HoodieOperation hoodieOperation) {
        this.hoodieOperation = hoodieOperation;
    }

    public HoodieOperation getHoodieOperation() {
        return this.hoodieOperation;
    }

    public BufferedRecord<T> toBinary(RecordContext<T> recordContext) {
        if (this.record != null) {
            this.record = recordContext.seal(recordContext.toBinaryRow(recordContext.getSchemaFromBufferRecord(this), this.record));
        }
        return this;
    }

    public BufferedRecord<T> seal(RecordContext<T> recordContext) {
        if (this.record != null) {
            this.record = recordContext.seal(this.record);
        }
        return this;
    }

    public BufferedRecord<T> project(UnaryOperator<T> converter) {
        if (this.record != null) {
            this.record = converter.apply(this.record);
        }
        return this;
    }

    public BufferedRecord<T> replaceRecord(T record) {
        this.record = record;
        return this;
    }

    public BufferedRecord<T> replaceRecordKey(String recordKey) {
        this.recordKey = recordKey;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BufferedRecord that = (BufferedRecord)o;
        return Objects.equals(this.recordKey, that.recordKey) && Objects.equals(this.orderingValue, that.orderingValue) && Objects.equals(this.record, that.record) && Objects.equals(this.schemaId, that.schemaId) && this.hoodieOperation == that.hoodieOperation;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.recordKey, this.orderingValue, this.record, this.schemaId, this.hoodieOperation});
    }
}

