/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.util.List;
import org.apache.avro.Schema;
import org.apache.hudi.common.engine.RecordContext;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.table.read.BufferedRecords;
import org.apache.hudi.common.table.read.IteratorMode;

public interface BufferedRecordConverter<T> {
    public BufferedRecord<T> convert(T var1);

    public static <T> BufferedRecordConverter<T> createConverter(IteratorMode iteratorMode, final Schema readerSchema, final RecordContext<T> recordContext, final List<String> orderingFieldNames) {
        switch (iteratorMode) {
            case ENGINE_RECORD: {
                return new BufferedRecordConverter<T>(){
                    private final BufferedRecord<T> reusedBufferedRecord = new BufferedRecord();

                    @Override
                    public BufferedRecord<T> convert(T record) {
                        return this.reusedBufferedRecord.replaceRecord(record);
                    }
                };
            }
            case RECORD_KEY: {
                return new BufferedRecordConverter<T>(){
                    private final BufferedRecord<T> reusedBufferedRecord = new BufferedRecord();

                    @Override
                    public BufferedRecord<T> convert(T record) {
                        String recordKey = recordContext.getRecordKey(record, readerSchema);
                        return this.reusedBufferedRecord.replaceRecordKey(recordKey);
                    }
                };
            }
        }
        return new BufferedRecordConverter<T>(){

            @Override
            public BufferedRecord<T> convert(T record) {
                return BufferedRecords.fromEngineRecord(record, readerSchema, recordContext, orderingFieldNames, false);
            }
        };
    }
}

