/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.engine.RecordContext;
import org.apache.hudi.common.model.DeleteRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.table.PartialUpdateMode;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.table.read.BufferedRecordMerger;
import org.apache.hudi.common.table.read.BufferedRecords;
import org.apache.hudi.common.table.read.PartialUpdateHandler;
import org.apache.hudi.common.util.HoodieRecordUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.OrderingValues;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;

public class BufferedRecordMergerFactory {
    private BufferedRecordMergerFactory() {
    }

    public static <T> BufferedRecordMerger<T> create(HoodieReaderContext<T> readerContext, RecordMergeMode recordMergeMode, boolean enablePartialMerging, Option<HoodieRecordMerger> recordMerger, Option<String> payloadClass, Schema readerSchema, TypedProperties props, Option<PartialUpdateMode> partialUpdateModeOpt) {
        return BufferedRecordMergerFactory.create(readerContext, recordMergeMode, enablePartialMerging, recordMerger, readerSchema, (Option<Pair<String, String>>)payloadClass.map(p -> Pair.of(p, p)), props, partialUpdateModeOpt);
    }

    public static <T> BufferedRecordMerger<T> create(HoodieReaderContext<T> readerContext, RecordMergeMode recordMergeMode, boolean enablePartialMerging, Option<HoodieRecordMerger> recordMerger, Schema readerSchema, Option<Pair<String, String>> payloadClasses, TypedProperties props, Option<PartialUpdateMode> partialUpdateModeOpt) {
        if (enablePartialMerging) {
            BufferedRecordMerger<T> deleteRecordMerger = BufferedRecordMergerFactory.create(readerContext, recordMergeMode, false, recordMerger, readerSchema, payloadClasses, props, (Option<PartialUpdateMode>)Option.empty());
            return new PartialUpdateBufferedRecordMerger<T>(readerContext.getRecordContext(), recordMerger, deleteRecordMerger, readerSchema, props);
        }
        switch (recordMergeMode) {
            case COMMIT_TIME_ORDERING: {
                if (partialUpdateModeOpt.isEmpty()) {
                    return new CommitTimeRecordMerger();
                }
                return new CommitTimePartialRecordMerger<T>(readerContext.getRecordContext(), (PartialUpdateMode)((Object)partialUpdateModeOpt.get()), props);
            }
            case EVENT_TIME_ORDERING: {
                if (partialUpdateModeOpt.isEmpty()) {
                    return new EventTimeRecordMerger<T>(readerContext.getRecordContext());
                }
                return new EventTimePartialRecordMerger<T>(readerContext.getRecordContext(), (PartialUpdateMode)((Object)partialUpdateModeOpt.get()), props);
            }
        }
        if (payloadClasses.isPresent()) {
            if (((String)((Pair)payloadClasses.get()).getRight()).equals("org.apache.spark.sql.hudi.command.payload.ExpressionPayload")) {
                return new ExpressionPayloadRecordMerger<T>(readerContext.getRecordContext(), recordMerger, (String)((Pair)payloadClasses.get()).getRight(), readerSchema, props);
            }
            return new CustomPayloadRecordMerger<T>(readerContext.getRecordContext(), recordMerger, (String)((Pair)payloadClasses.get()).getLeft(), readerSchema, props);
        }
        return new CustomRecordMerger<T>(readerContext.getRecordContext(), recordMerger, readerSchema, props);
    }

    private static <T> Option<DeleteRecord> deltaMergeDeleteRecord(DeleteRecord deleteRecord, BufferedRecord<T> existingRecord, RecordContext<T> recordContext) {
        boolean chooseExisting;
        if (existingRecord == null) {
            return Option.of((Object)deleteRecord);
        }
        if (existingRecord.isCommitTimeOrderingDelete()) {
            return Option.empty();
        }
        Comparable existingOrderingVal = existingRecord.getOrderingValue();
        Comparable deleteOrderingVal = recordContext.convertOrderingValueToEngineType(deleteRecord.getOrderingValue());
        boolean bl = chooseExisting = !OrderingValues.isDefault(deleteOrderingVal) && OrderingValues.isSameClass(existingOrderingVal, deleteOrderingVal) && existingOrderingVal.compareTo(deleteOrderingVal) > 0;
        if (chooseExisting) {
            return Option.empty();
        }
        return Option.of((Object)deleteRecord);
    }

    private static <T> boolean shouldKeepNewerRecord(BufferedRecord<T> oldRecord, BufferedRecord<T> newRecord) {
        if (newRecord.isCommitTimeOrderingDelete() || oldRecord.isCommitTimeOrderingDelete()) {
            return true;
        }
        return newRecord.getOrderingValue().compareTo(oldRecord.getOrderingValue()) >= 0;
    }

    private static abstract class BaseCustomMerger<T>
    implements BufferedRecordMerger<T> {
        protected final RecordContext<T> recordContext;
        protected final HoodieRecordMerger recordMerger;
        protected final Schema readerSchema;
        protected final TypedProperties props;

        public BaseCustomMerger(RecordContext<T> recordContext, Option<HoodieRecordMerger> recordMerger, Schema readerSchema, TypedProperties props) {
            this.recordContext = recordContext;
            this.recordMerger = (HoodieRecordMerger)recordMerger.orElseThrow(() -> new IllegalArgumentException("RecordMerger must be present for custom merging"));
            this.readerSchema = readerSchema;
            this.props = props;
        }

        @Override
        public Option<BufferedRecord<T>> deltaMerge(BufferedRecord<T> newRecord, BufferedRecord<T> existingRecord) throws IOException {
            if (existingRecord == null) {
                return Option.of(newRecord);
            }
            return this.deltaMergeRecords(newRecord, existingRecord);
        }

        public abstract Option<BufferedRecord<T>> deltaMergeRecords(BufferedRecord<T> var1, BufferedRecord<T> var2) throws IOException;

        @Override
        public Option<DeleteRecord> deltaMerge(DeleteRecord deleteRecord, BufferedRecord<T> existingRecord) {
            BufferedRecord<T> deleteBufferedRecord = BufferedRecords.fromDeleteRecord(deleteRecord, this.recordContext);
            try {
                Option<BufferedRecord<T>> merged = this.deltaMerge(deleteBufferedRecord, existingRecord);
                return merged.isPresent() ? Option.of((Object)deleteRecord) : Option.empty();
            }
            catch (IOException e) {
                throw new HoodieIOException("Failed to process delete record", e);
            }
        }

        @Override
        public BufferedRecord<T> finalMerge(BufferedRecord<T> olderRecord, BufferedRecord<T> newerRecord) throws IOException {
            return this.recordMerger.merge(olderRecord, newerRecord, this.recordContext, this.props);
        }
    }

    private static class CustomPayloadRecordMerger<T>
    extends BaseCustomMerger<T> {
        protected final String payloadClass;

        public CustomPayloadRecordMerger(RecordContext<T> recordContext, Option<HoodieRecordMerger> recordMerger, String payloadClass, Schema readerSchema, TypedProperties props) {
            super(recordContext, recordMerger, readerSchema, props);
            this.payloadClass = payloadClass;
            props.setProperty("_hoodie.merger.payload.class", payloadClass);
        }

        @Override
        public Option<BufferedRecord<T>> deltaMergeRecords(BufferedRecord<T> newRecord, BufferedRecord<T> existingRecord) throws IOException {
            BufferedRecord mergedRecord = this.recordMerger.merge(existingRecord, newRecord, this.recordContext, this.props);
            if (mergedRecord.getRecord() != existingRecord.getRecord()) {
                return Option.of((Object)mergedRecord);
            }
            return Option.empty();
        }
    }

    private static class ExpressionPayloadRecordMerger<T>
    extends CustomPayloadRecordMerger<T> {
        private final HoodieRecordMerger deltaMerger;

        public ExpressionPayloadRecordMerger(RecordContext<T> recordContext, Option<HoodieRecordMerger> recordMerger, String incomingPayloadClass, Schema readerSchema, TypedProperties props) {
            super(recordContext, recordMerger, incomingPayloadClass, readerSchema, props);
            this.deltaMerger = HoodieRecordUtils.mergerToPreCombineMode((HoodieRecordMerger)recordMerger.get());
        }

        @Override
        public Option<BufferedRecord<T>> deltaMergeRecords(BufferedRecord<T> newRecord, BufferedRecord<T> existingRecord) throws IOException {
            BufferedRecord mergedRecord = this.deltaMerger.merge(existingRecord, newRecord, this.recordContext, this.props);
            if (mergedRecord.getRecord() != existingRecord.getRecord()) {
                return Option.of((Object)mergedRecord);
            }
            return Option.empty();
        }
    }

    private static class CustomRecordMerger<T>
    extends BaseCustomMerger<T> {
        public CustomRecordMerger(RecordContext<T> recordContext, Option<HoodieRecordMerger> recordMerger, Schema readerSchema, TypedProperties props) {
            super(recordContext, recordMerger, readerSchema, props);
        }

        @Override
        public Option<BufferedRecord<T>> deltaMergeRecords(BufferedRecord<T> newRecord, BufferedRecord<T> existingRecord) throws IOException {
            BufferedRecord mergedRecord = this.recordMerger.merge(existingRecord, newRecord, this.recordContext, this.props);
            if (mergedRecord.getRecord() != existingRecord.getRecord()) {
                return Option.of((Object)mergedRecord);
            }
            return Option.empty();
        }
    }

    private static class PartialUpdateBufferedRecordMerger<T>
    implements BufferedRecordMerger<T> {
        private final RecordContext<T> recordContext;
        private final Option<HoodieRecordMerger> recordMerger;
        private final BufferedRecordMerger<T> deleteRecordMerger;
        private final Schema readerSchema;
        private final TypedProperties props;

        public PartialUpdateBufferedRecordMerger(RecordContext<T> recordContext, Option<HoodieRecordMerger> recordMerger, BufferedRecordMerger<T> deleteRecordMerger, Schema readerSchema, TypedProperties props) {
            this.recordContext = recordContext;
            this.recordMerger = recordMerger;
            this.deleteRecordMerger = deleteRecordMerger;
            this.readerSchema = readerSchema;
            this.props = props;
        }

        @Override
        public Option<BufferedRecord<T>> deltaMerge(BufferedRecord<T> newRecord, BufferedRecord<T> existingRecord) throws IOException {
            if (existingRecord == null) {
                return Option.of(newRecord);
            }
            BufferedRecord<T> mergedRecord = ((HoodieRecordMerger)this.recordMerger.get()).partialMerge(existingRecord, newRecord, this.readerSchema, this.recordContext, this.props);
            if (mergedRecord.getRecord() != existingRecord.getRecord()) {
                return Option.of(mergedRecord);
            }
            return Option.empty();
        }

        @Override
        public Option<DeleteRecord> deltaMerge(DeleteRecord deleteRecord, BufferedRecord<T> existingRecord) {
            return this.deleteRecordMerger.deltaMerge(deleteRecord, existingRecord);
        }

        @Override
        public BufferedRecord<T> finalMerge(BufferedRecord<T> olderRecord, BufferedRecord<T> newerRecord) throws IOException {
            return ((HoodieRecordMerger)this.recordMerger.get()).partialMerge(olderRecord, newerRecord, this.readerSchema, this.recordContext, this.props);
        }
    }

    private static class EventTimePartialRecordMerger<T>
    extends EventTimeRecordMerger<T> {
        private final PartialUpdateHandler<T> partialUpdateHandler;
        private final RecordContext<T> recordContext;

        public EventTimePartialRecordMerger(RecordContext<T> recordContext, PartialUpdateMode partialUpdateMode, TypedProperties props) {
            super(recordContext);
            this.partialUpdateHandler = new PartialUpdateHandler<T>(recordContext, partialUpdateMode, props);
            this.recordContext = recordContext;
        }

        @Override
        public Option<BufferedRecord<T>> deltaMerge(BufferedRecord<T> newRecord, BufferedRecord<T> existingRecord) {
            if (existingRecord == null) {
                return Option.of(newRecord);
            }
            if (BufferedRecordMergerFactory.shouldKeepNewerRecord(existingRecord, newRecord)) {
                Schema newSchema = this.recordContext.getSchemaFromBufferRecord(newRecord);
                newRecord = this.partialUpdateHandler.partialMerge(newRecord, existingRecord, newSchema, this.recordContext.getSchemaFromBufferRecord(existingRecord), newSchema);
                return Option.of(newRecord);
            }
            Schema newSchema = this.recordContext.getSchemaFromBufferRecord(newRecord);
            existingRecord = this.partialUpdateHandler.partialMerge(existingRecord, newRecord, this.recordContext.getSchemaFromBufferRecord(existingRecord), newSchema, newSchema);
            return Option.of(existingRecord);
        }

        @Override
        public BufferedRecord<T> finalMerge(BufferedRecord<T> olderRecord, BufferedRecord<T> newerRecord) {
            if (newerRecord.isCommitTimeOrderingDelete()) {
                return newerRecord;
            }
            Comparable newOrderingValue = newerRecord.getOrderingValue();
            Comparable oldOrderingValue = olderRecord.getOrderingValue();
            Schema newSchema = this.recordContext.getSchemaFromBufferRecord(newerRecord);
            if (!olderRecord.isCommitTimeOrderingDelete() && oldOrderingValue.compareTo(newOrderingValue) > 0) {
                olderRecord = this.partialUpdateHandler.partialMerge(olderRecord, newerRecord, this.recordContext.getSchemaFromBufferRecord(olderRecord), newSchema, newSchema);
                return olderRecord;
            }
            newerRecord = this.partialUpdateHandler.partialMerge(newerRecord, olderRecord, newSchema, this.recordContext.getSchemaFromBufferRecord(olderRecord), newSchema);
            return newerRecord;
        }
    }

    private static class EventTimeRecordMerger<T>
    implements BufferedRecordMerger<T> {
        private final RecordContext<T> recordContext;

        public EventTimeRecordMerger(RecordContext<T> recordContext) {
            this.recordContext = recordContext;
        }

        @Override
        public Option<BufferedRecord<T>> deltaMerge(BufferedRecord<T> newRecord, BufferedRecord<T> existingRecord) {
            if (existingRecord == null || BufferedRecordMergerFactory.shouldKeepNewerRecord(existingRecord, newRecord)) {
                return Option.of(newRecord);
            }
            return Option.empty();
        }

        @Override
        public Option<DeleteRecord> deltaMerge(DeleteRecord deleteRecord, BufferedRecord<T> existingRecord) {
            return BufferedRecordMergerFactory.deltaMergeDeleteRecord(deleteRecord, existingRecord, this.recordContext);
        }

        @Override
        public BufferedRecord<T> finalMerge(BufferedRecord<T> olderRecord, BufferedRecord<T> newerRecord) {
            if (BufferedRecordMergerFactory.shouldKeepNewerRecord(olderRecord, newerRecord)) {
                return newerRecord;
            }
            return olderRecord;
        }
    }

    private static class CommitTimePartialRecordMerger<T>
    extends CommitTimeRecordMerger<T> {
        private final PartialUpdateHandler<T> partialUpdateHandler;
        private final RecordContext<T> recordContext;

        public CommitTimePartialRecordMerger(RecordContext<T> recordContext, PartialUpdateMode partialUpdateMode, TypedProperties props) {
            this.partialUpdateHandler = new PartialUpdateHandler<T>(recordContext, partialUpdateMode, props);
            this.recordContext = recordContext;
        }

        @Override
        public Option<BufferedRecord<T>> deltaMerge(BufferedRecord<T> newRecord, BufferedRecord<T> existingRecord) {
            if (existingRecord != null) {
                Schema newSchema = this.recordContext.getSchemaFromBufferRecord(newRecord);
                newRecord = this.partialUpdateHandler.partialMerge(newRecord, existingRecord, newSchema, this.recordContext.getSchemaFromBufferRecord(existingRecord), newSchema);
            }
            return Option.of(newRecord);
        }

        @Override
        public BufferedRecord<T> finalMerge(BufferedRecord<T> olderRecord, BufferedRecord<T> newerRecord) {
            Schema newSchema = this.recordContext.getSchemaFromBufferRecord(newerRecord);
            newerRecord = this.partialUpdateHandler.partialMerge(newerRecord, olderRecord, newSchema, this.recordContext.getSchemaFromBufferRecord(olderRecord), newSchema);
            return newerRecord;
        }
    }

    private static class CommitTimeRecordMerger<T>
    implements BufferedRecordMerger<T> {
        private CommitTimeRecordMerger() {
        }

        @Override
        public Option<BufferedRecord<T>> deltaMerge(BufferedRecord<T> newRecord, BufferedRecord<T> existingRecord) {
            return Option.of(newRecord);
        }

        @Override
        public Option<DeleteRecord> deltaMerge(DeleteRecord deleteRecord, BufferedRecord<T> existingRecord) {
            return Option.of((Object)deleteRecord);
        }

        @Override
        public BufferedRecord<T> finalMerge(BufferedRecord<T> olderRecord, BufferedRecord<T> newerRecord) {
            return newerRecord;
        }
    }
}

