/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.serialization.CustomSerializer;
import org.apache.hudi.common.serialization.RecordSerializer;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.util.SerializationUtils;

public class BufferedRecordSerializer<T>
implements CustomSerializer<BufferedRecord<T>> {
    private static final ThreadLocal<InternalSerializerInstance> SERIALIZER_REF = ThreadLocal.withInitial(InternalSerializerInstance::new);
    private final RecordSerializer<T> recordSerializer;

    public BufferedRecordSerializer(RecordSerializer<T> recordSerializer) {
        this.recordSerializer = recordSerializer;
    }

    @Override
    public byte[] serialize(BufferedRecord<T> record) throws IOException {
        return SERIALIZER_REF.get().serialize(record, this.recordSerializer);
    }

    @Override
    public BufferedRecord<T> deserialize(byte[] bytes) {
        return SERIALIZER_REF.get().deserialize(bytes, this.recordSerializer);
    }

    private static class InternalSerializerInstance {
        private static final int KRYO_SERIALIZER_INITIAL_BUFFER_SIZE = 0x100000;
        private final Kryo kryo;
        private final ByteArrayOutputStream baos;

        public InternalSerializerInstance() {
            SerializationUtils.KryoInstantiator kryoInstantiator = new SerializationUtils.KryoInstantiator();
            this.kryo = kryoInstantiator.newKryo();
            this.baos = new ByteArrayOutputStream(0x100000);
            this.kryo.setRegistrationRequired(false);
        }

        <T> byte[] serialize(BufferedRecord<T> record, RecordSerializer<T> recordSerializer) {
            this.kryo.reset();
            this.baos.reset();
            try (Output output = new Output((OutputStream)this.baos);){
                HoodieOperation operation;
                output.writeString(record.getRecordKey());
                boolean hasSchemaId = record.getSchemaId() != null;
                output.writeBoolean(hasSchemaId);
                if (hasSchemaId) {
                    output.writeVarInt(record.getSchemaId().intValue(), true);
                }
                output.writeByte((operation = record.getHoodieOperation()) == null ? (byte)-1 : (byte)operation.getValue());
                this.kryo.writeClassAndObject(output, (Object)record.getOrderingValue());
                byte[] recordBytes = record.getRecord() == null ? new byte[]{} : recordSerializer.serialize(record.getRecord());
                output.writeVarInt(recordBytes.length, true);
                output.writeBytes(recordBytes);
            }
            return this.baos.toByteArray();
        }

        <T> BufferedRecord<T> deserialize(byte[] bytes, RecordSerializer<T> recordSerializer) {
            try (Input input = new Input(bytes);){
                byte hoodieOperationValue;
                String recordKey = input.readString();
                boolean hasSchemaId = input.readBoolean();
                Integer schemaId = null;
                if (hasSchemaId) {
                    schemaId = input.readVarInt(true);
                }
                HoodieOperation operation = (hoodieOperationValue = input.readByte()) == -1 ? null : HoodieOperation.fromValue(hoodieOperationValue);
                Comparable orderingValue = (Comparable)this.kryo.readClassAndObject(input);
                int recordLength = input.readVarInt(true);
                Object record = recordLength == 0 ? null : (Object)recordSerializer.deserialize(input.readBytes(recordLength), schemaId);
                BufferedRecord<Object> bufferedRecord = new BufferedRecord<Object>(recordKey, orderingValue, record, schemaId, operation);
                return bufferedRecord;
            }
        }
    }
}

