/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.util.List;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.hudi.common.engine.RecordContext;
import org.apache.hudi.common.model.DeleteRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.table.read.DeleteContext;

public class BufferedRecords {
    public static <T> BufferedRecord<T> fromHoodieRecord(HoodieRecord record, Schema schema, RecordContext<T> recordContext, Properties props, String[] orderingFields, DeleteContext deleteContext) {
        boolean isDelete = record.isDelete(deleteContext, props);
        return BufferedRecords.fromHoodieRecord(record, schema, recordContext, props, orderingFields, isDelete);
    }

    public static <T> BufferedRecord<T> fromHoodieRecord(HoodieRecord record, Schema schema, RecordContext<T> recordContext, Properties props, String[] orderingFields, boolean isDelete) {
        HoodieKey hoodieKey = record.getKey();
        T data = recordContext.extractDataFromRecord(record, schema, props);
        String recordKey = hoodieKey == null ? recordContext.getRecordKey(data, schema) : hoodieKey.getRecordKey();
        Integer schemaId = recordContext.encodeAvroSchema(schema);
        Comparable<?> orderingValue = record.getOrderingValue(schema, props, orderingFields);
        return new BufferedRecord<T>(recordKey, orderingValue, data, schemaId, BufferedRecords.inferOperation(isDelete, record.getOperation()));
    }

    public static <T> BufferedRecord<T> fromEngineRecord(T record, Schema schema, RecordContext<T> recordContext, List<String> orderingFieldNames, boolean isDelete) {
        String recordKey = recordContext.getRecordKey(record, schema);
        return BufferedRecords.fromEngineRecord(record, recordKey, schema, recordContext, orderingFieldNames, isDelete ? HoodieOperation.DELETE : null);
    }

    public static <T> BufferedRecord<T> fromEngineRecord(T record, String recordKey, Schema schema, RecordContext<T> recordContext, List<String> orderingFieldNames, HoodieOperation hoodieOperation) {
        Integer schemaId = recordContext.encodeAvroSchema(schema);
        Comparable orderingValue = recordContext.getOrderingValue(record, schema, orderingFieldNames);
        return new BufferedRecord<T>(recordKey, orderingValue, record, schemaId, hoodieOperation);
    }

    public static <T> BufferedRecord<T> fromEngineRecord(T record, Schema schema, RecordContext<T> recordContext, String[] orderingFieldNames, String recordKey, boolean isDelete) {
        Integer schemaId = recordContext.encodeAvroSchema(schema);
        Comparable orderingValue = recordContext.getOrderingValue(record, schema, orderingFieldNames);
        return new BufferedRecord<T>(recordKey, orderingValue, record, schemaId, isDelete ? HoodieOperation.DELETE : null);
    }

    public static <T> BufferedRecord<T> fromEngineRecord(T record, Schema schema, RecordContext<T> recordContext, Comparable orderingValue, String recordKey, boolean isDelete) {
        Integer schemaId = recordContext.encodeAvroSchema(schema);
        return new BufferedRecord<T>(recordKey, orderingValue, record, schemaId, isDelete ? HoodieOperation.DELETE : null);
    }

    public static <T> BufferedRecord<T> fromDeleteRecord(DeleteRecord deleteRecord, RecordContext<T> recordContext) {
        return new BufferedRecord<Object>(deleteRecord.getRecordKey(), recordContext.getOrderingValue(deleteRecord), null, null, HoodieOperation.DELETE);
    }

    public static <T> BufferedRecord<T> createDelete(String recordKey, Comparable orderingValue) {
        return new BufferedRecord<Object>(recordKey, orderingValue, null, null, HoodieOperation.DELETE);
    }

    public static HoodieOperation inferOperation(boolean isDelete, HoodieOperation operation) {
        return isDelete ? (HoodieOperation.isUpdateBefore(operation) ? operation : HoodieOperation.DELETE) : operation;
    }
}

