/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.io.Serializable;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;

public class DeleteContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Option<Pair<String, String>> customDeleteMarkerKeyValue;
    private final boolean hasBuiltInDeleteField;
    private int hoodieOperationPos;
    private Schema readerSchema;

    public DeleteContext(Properties props, Schema tableSchema) {
        this.customDeleteMarkerKeyValue = DeleteContext.getCustomDeleteMarkerKeyValue(props);
        this.hasBuiltInDeleteField = DeleteContext.hasBuiltInDeleteField(tableSchema);
    }

    public static DeleteContext fromRecordSchema(Properties properties, Schema recordSchema) {
        DeleteContext deleteContext = new DeleteContext(properties, recordSchema);
        deleteContext.hoodieOperationPos = -1;
        deleteContext.readerSchema = recordSchema;
        return deleteContext;
    }

    private static Option<Pair<String, String>> getCustomDeleteMarkerKeyValue(Properties props) {
        Option customDeleteMarkerKeyValue;
        boolean deleteMarkerExists;
        String deleteKey = props.getProperty("hoodie.payload.delete.field");
        String deleteMarker = props.getProperty("hoodie.payload.delete.marker");
        boolean deleteKeyExists = !StringUtils.isNullOrEmpty((String)deleteKey);
        boolean bl = deleteMarkerExists = !StringUtils.isNullOrEmpty((String)deleteMarker);
        if (deleteKeyExists && deleteMarkerExists) {
            customDeleteMarkerKeyValue = Option.of(Pair.of(deleteKey, deleteMarker));
        } else if (!deleteKeyExists && !deleteMarkerExists) {
            customDeleteMarkerKeyValue = Option.empty();
        } else {
            throw new IllegalArgumentException("Either custom delete key or marker is not specified");
        }
        return customDeleteMarkerKeyValue;
    }

    private static boolean hasBuiltInDeleteField(Schema schema) {
        return schema.getType() != Schema.Type.NULL && schema.getField("_hoodie_is_deleted") != null;
    }

    private static int getHoodieOperationPos(Schema schema) {
        return (Integer)Option.ofNullable((Object)schema.getField(HoodieRecord.OPERATION_METADATA_FIELD)).map(Schema.Field::pos).orElse((Object)-1);
    }

    public Option<Pair<String, String>> getCustomDeleteMarkerKeyValue() {
        return this.customDeleteMarkerKeyValue;
    }

    public boolean hasBuiltInDeleteField() {
        return this.hasBuiltInDeleteField;
    }

    public int getHoodieOperationPos() {
        return this.hoodieOperationPos;
    }

    public DeleteContext withReaderSchema(Schema readerSchema) {
        this.readerSchema = readerSchema;
        this.hoodieOperationPos = DeleteContext.getHoodieOperationPos(readerSchema);
        return this;
    }

    public Schema getReaderSchema() {
        return this.readerSchema;
    }
}

