/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.hudi.avro.AvroSchemaCache;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.read.DeleteContext;
import org.apache.hudi.common.util.InternalSchemaCache;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.common.util.collection.Triple;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.action.InternalSchemaMerger;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.apache.hudi.storage.StoragePath;

public class FileGroupReaderSchemaHandler<T> {
    protected final Schema tableSchema;
    protected final Schema requestedSchema;
    protected final Schema requiredSchema;
    protected Schema schemaForUpdates;
    protected final InternalSchema internalSchema;
    protected final Option<InternalSchema> internalSchemaOpt;
    protected final HoodieTableConfig hoodieTableConfig;
    protected final HoodieReaderContext<T> readerContext;
    protected final TypedProperties properties;
    private final DeleteContext deleteContext;
    private final HoodieTableMetaClient metaClient;

    public FileGroupReaderSchemaHandler(HoodieReaderContext<T> readerContext, Schema tableSchema, Schema requestedSchema, Option<InternalSchema> internalSchemaOpt, TypedProperties properties, HoodieTableMetaClient metaClient) {
        this.properties = properties;
        this.readerContext = readerContext;
        this.tableSchema = tableSchema;
        this.requestedSchema = AvroSchemaCache.intern(requestedSchema);
        this.hoodieTableConfig = metaClient.getTableConfig();
        this.deleteContext = new DeleteContext(properties, tableSchema);
        this.schemaForUpdates = this.requiredSchema = AvroSchemaCache.intern(this.prepareRequiredSchema(this.deleteContext));
        this.internalSchema = this.pruneInternalSchema(this.requiredSchema, internalSchemaOpt);
        this.internalSchemaOpt = this.getInternalSchemaOpt(internalSchemaOpt);
        this.metaClient = metaClient;
    }

    public Schema getTableSchema() {
        return this.tableSchema;
    }

    public Schema getRequestedSchema() {
        return this.requestedSchema;
    }

    public Schema getRequiredSchema() {
        return this.requiredSchema;
    }

    public Schema getSchemaForUpdates() {
        return this.schemaForUpdates;
    }

    public void setSchemaForUpdates(Schema schema) {
        this.schemaForUpdates = schema;
    }

    public InternalSchema getInternalSchema() {
        return this.internalSchema;
    }

    public Option<InternalSchema> getInternalSchemaOpt() {
        return this.internalSchemaOpt;
    }

    public Option<UnaryOperator<T>> getOutputConverter() {
        if (!AvroSchemaUtils.areSchemasProjectionEquivalent(this.requiredSchema, this.requestedSchema)) {
            return Option.of(this.readerContext.getRecordContext().projectRecord(this.requiredSchema, this.requestedSchema));
        }
        return Option.empty();
    }

    public DeleteContext getDeleteContext() {
        return this.deleteContext;
    }

    public Pair<Schema, Map<String, String>> getRequiredSchemaForFileAndRenamedColumns(StoragePath path) {
        if (this.internalSchema.isEmptySchema()) {
            return Pair.of(this.requiredSchema, Collections.emptyMap());
        }
        long commitInstantTime = Long.parseLong(FSUtils.getCommitTime(path.getName()));
        InternalSchema fileSchema = InternalSchemaCache.searchSchemaAndCache(commitInstantTime, this.metaClient);
        Pair<InternalSchema, Map<String, String>> mergedInternalSchema = new InternalSchemaMerger(fileSchema, this.internalSchema, true, false, false).mergeSchemaGetRenamed();
        Schema mergedAvroSchema = AvroSchemaCache.intern(AvroInternalSchemaConverter.convert(mergedInternalSchema.getLeft(), this.requiredSchema.getFullName()));
        return Pair.of(mergedAvroSchema, mergedInternalSchema.getRight());
    }

    private InternalSchema pruneInternalSchema(Schema requiredSchema, Option<InternalSchema> internalSchemaOption) {
        if (!internalSchemaOption.isPresent()) {
            return InternalSchema.getEmptyInternalSchema();
        }
        InternalSchema notPruned = (InternalSchema)internalSchemaOption.get();
        if (notPruned == null || notPruned.isEmptySchema()) {
            return InternalSchema.getEmptyInternalSchema();
        }
        return this.doPruneInternalSchema(requiredSchema, notPruned);
    }

    protected Option<InternalSchema> getInternalSchemaOpt(Option<InternalSchema> internalSchemaOpt) {
        return internalSchemaOpt;
    }

    protected InternalSchema doPruneInternalSchema(Schema requiredSchema, InternalSchema internalSchema) {
        return AvroInternalSchemaConverter.pruneAvroSchemaToInternalSchema(requiredSchema, internalSchema);
    }

    @VisibleForTesting
    Schema generateRequiredSchema(DeleteContext deleteContext) {
        boolean hasInstantRange = this.readerContext.getInstantRange().isPresent();
        if (!this.readerContext.getHasLogFiles()) {
            if (hasInstantRange && !AvroSchemaUtils.findNestedField(this.requestedSchema, HoodieRecord.COMMIT_TIME_METADATA_FIELD).isPresent()) {
                ArrayList<Schema.Field> addedFields = new ArrayList<Schema.Field>();
                addedFields.add(FileGroupReaderSchemaHandler.getField(this.tableSchema, HoodieRecord.COMMIT_TIME_METADATA_FIELD));
                return AvroSchemaUtils.appendFieldsToSchemaDedupNested(this.requestedSchema, addedFields);
            }
            return this.requestedSchema;
        }
        if (this.hoodieTableConfig.getRecordMergeMode() == RecordMergeMode.CUSTOM && !((HoodieRecordMerger)this.readerContext.getRecordMerger().get()).isProjectionCompatible()) {
            return this.tableSchema;
        }
        ArrayList<Schema.Field> addedFields = new ArrayList<Schema.Field>();
        for (String field : FileGroupReaderSchemaHandler.getMandatoryFieldsForMerging(this.hoodieTableConfig, this.properties, this.tableSchema, this.readerContext.getRecordMerger(), deleteContext.hasBuiltInDeleteField(), deleteContext.getCustomDeleteMarkerKeyValue(), hasInstantRange)) {
            if (AvroSchemaUtils.findNestedField(this.requestedSchema, field).isPresent()) continue;
            addedFields.add(FileGroupReaderSchemaHandler.getField(this.tableSchema, field));
        }
        if (addedFields.isEmpty()) {
            return this.requestedSchema;
        }
        return AvroSchemaUtils.appendFieldsToSchemaDedupNested(this.requestedSchema, addedFields);
    }

    private static String[] getMandatoryFieldsForMerging(HoodieTableConfig cfg, TypedProperties props, Schema tableSchema, Option<HoodieRecordMerger> recordMerger, boolean hasBuiltInDelete, Option<Pair<String, String>> customDeleteMarkerKeyAndValue, boolean hasInstantRange) {
        RecordMergeMode mergeMode = cfg.getRecordMergeMode();
        if (cfg.getTableVersion().lesserThan(HoodieTableVersion.NINE)) {
            Triple<RecordMergeMode, String, String> mergingConfigs = HoodieTableConfig.inferMergingConfigsForPreV9Table(cfg.getRecordMergeMode(), cfg.getPayloadClass(), cfg.getRecordMergeStrategyId(), (String)cfg.getOrderingFieldsStr().orElse(null), cfg.getTableVersion());
            mergeMode = mergingConfigs.getLeft();
        }
        if (mergeMode == RecordMergeMode.CUSTOM) {
            return ((HoodieRecordMerger)recordMerger.get()).getMandatoryFieldsForMerging(tableSchema, cfg, props);
        }
        HashSet<Object> requiredFields = new HashSet<Object>();
        if (hasInstantRange) {
            requiredFields.add(HoodieRecord.COMMIT_TIME_METADATA_FIELD);
        }
        if (cfg.populateMetaFields()) {
            requiredFields.add(HoodieRecord.RECORD_KEY_METADATA_FIELD);
        } else {
            Option<String[]> fields = cfg.getRecordKeyFields();
            if (fields.isPresent()) {
                requiredFields.addAll(Arrays.asList((Object[])fields.get()));
            }
        }
        if (mergeMode == RecordMergeMode.EVENT_TIME_ORDERING) {
            List<String> preCombineFields = cfg.getOrderingFields();
            requiredFields.addAll(preCombineFields);
        }
        if (hasBuiltInDelete) {
            requiredFields.add("_hoodie_is_deleted");
        }
        if (customDeleteMarkerKeyAndValue.isPresent()) {
            requiredFields.add(((Pair)customDeleteMarkerKeyAndValue.get()).getLeft());
        }
        if (tableSchema.getField(HoodieRecord.OPERATION_METADATA_FIELD) != null) {
            requiredFields.add(HoodieRecord.OPERATION_METADATA_FIELD);
        }
        return requiredFields.toArray(new String[0]);
    }

    protected Schema prepareRequiredSchema(DeleteContext deleteContext) {
        Schema preReorderRequiredSchema = this.generateRequiredSchema(deleteContext);
        Pair<List<Schema.Field>, List<Schema.Field>> requiredFields = FileGroupReaderSchemaHandler.getDataAndMetaCols(preReorderRequiredSchema);
        this.readerContext.setNeedsBootstrapMerge(this.readerContext.getHasBootstrapBaseFile() && !requiredFields.getLeft().isEmpty() && !requiredFields.getRight().isEmpty());
        return this.readerContext.getNeedsBootstrapMerge() ? this.createSchemaFromFields(Stream.concat(requiredFields.getLeft().stream(), requiredFields.getRight().stream()).collect(Collectors.toList())) : preReorderRequiredSchema;
    }

    public Pair<List<Schema.Field>, List<Schema.Field>> getBootstrapRequiredFields() {
        return FileGroupReaderSchemaHandler.getDataAndMetaCols(this.requiredSchema);
    }

    public Pair<List<Schema.Field>, List<Schema.Field>> getBootstrapDataFields() {
        return FileGroupReaderSchemaHandler.getDataAndMetaCols(this.tableSchema);
    }

    @VisibleForTesting
    static Pair<List<Schema.Field>, List<Schema.Field>> getDataAndMetaCols(Schema schema) {
        Map<Boolean, List<Schema.Field>> fieldsByMeta = schema.getFields().stream().filter(f -> !Objects.equals(f.name(), "_tmp_metadata_row_index")).collect(Collectors.partitioningBy(f -> HoodieRecord.HOODIE_META_COLUMNS_WITH_OPERATION.contains(f.name())));
        return Pair.of(fieldsByMeta.getOrDefault(true, Collections.emptyList()), fieldsByMeta.getOrDefault(false, Collections.emptyList()));
    }

    public Schema createSchemaFromFields(List<Schema.Field> fields) {
        for (int i = 0; i < fields.size(); ++i) {
            Schema.Field curr = fields.get(i);
            fields.set(i, HoodieAvroUtils.createNewSchemaField(curr));
        }
        return AvroSchemaUtils.createNewSchemaFromFieldsWithReference(this.tableSchema, fields);
    }

    private static Schema.Field getField(Schema schema, String fieldName) {
        Option<Schema.Field> foundFieldOpt = AvroSchemaUtils.findNestedField(schema, fieldName);
        if (!foundFieldOpt.isPresent()) {
            throw new IllegalArgumentException("Field: " + fieldName + " does not exist in the table schema");
        }
        return (Schema.Field)foundFieldOpt.get();
    }
}

