/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.HoodieReaderConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.PartitionPathParser;
import org.apache.hudi.common.table.read.BaseFileUpdateCallback;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.table.read.BufferedRecordConverter;
import org.apache.hudi.common.table.read.FileGroupReaderSchemaHandler;
import org.apache.hudi.common.table.read.HoodieReadStats;
import org.apache.hudi.common.table.read.InputSplit;
import org.apache.hudi.common.table.read.IteratorMode;
import org.apache.hudi.common.table.read.ParquetRowIndexBasedSchemaHandler;
import org.apache.hudi.common.table.read.ReaderParameters;
import org.apache.hudi.common.table.read.buffer.FileGroupRecordBufferLoader;
import org.apache.hudi.common.table.read.buffer.HoodieFileGroupRecordBuffer;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Either;
import org.apache.hudi.common.util.HoodieRecordUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.CloseableMappingIterator;
import org.apache.hudi.common.util.collection.EmptyIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;

public final class HoodieFileGroupReader<T>
implements Closeable {
    private final HoodieReaderContext<T> readerContext;
    private final HoodieTableMetaClient metaClient;
    private final InputSplit inputSplit;
    private final Option<String[]> partitionPathFields;
    private final List<String> orderingFieldNames;
    private final HoodieStorage storage;
    private final TypedProperties props;
    private final ReaderParameters readerParameters;
    private final FileGroupRecordBufferLoader<T> recordBufferLoader;
    private HoodieFileGroupRecordBuffer<T> recordBuffer;
    private ClosableIterator<T> baseFileIterator;
    private final Option<UnaryOperator<T>> outputConverter;
    private final HoodieReadStats readStats;
    private final Option<BaseFileUpdateCallback<T>> fileGroupUpdateCallback;
    private List<String> validBlockInstants = Collections.emptyList();
    private BufferedRecordConverter<T> bufferedRecordConverter;

    private HoodieFileGroupReader(HoodieReaderContext<T> readerContext, HoodieStorage storage, String tablePath, String latestCommitTime, Schema dataSchema, Schema requestedSchema, Option<InternalSchema> internalSchemaOpt, HoodieTableMetaClient hoodieTableMetaClient, TypedProperties props, ReaderParameters readerParameters, InputSplit inputSplit, Option<BaseFileUpdateCallback<T>> updateCallback, FileGroupRecordBufferLoader<T> recordBufferLoader) {
        this.readerContext = readerContext;
        this.recordBufferLoader = recordBufferLoader;
        this.fileGroupUpdateCallback = updateCallback;
        this.metaClient = hoodieTableMetaClient;
        this.storage = storage;
        this.readerParameters = readerParameters;
        this.inputSplit = inputSplit;
        readerContext.setHasLogFiles(this.inputSplit.hasLogFiles());
        readerContext.getRecordContext().setPartitionPath(inputSplit.getPartitionPath());
        if (readerContext.getHasLogFiles() && inputSplit.getStart() != 0L) {
            throw new IllegalArgumentException("Filegroup reader is doing log file merge but not reading from the start of the base file");
        }
        HoodieTableConfig tableConfig = hoodieTableMetaClient.getTableConfig();
        this.props = ConfigUtils.getMergeProps(props, tableConfig);
        this.partitionPathFields = tableConfig.getPartitionFields();
        readerContext.initRecordMerger(props);
        readerContext.setTablePath(tablePath);
        readerContext.setLatestCommitTime(latestCommitTime);
        boolean isSkipMerge = ConfigUtils.getStringWithAltKeys((Properties)props, HoodieReaderConfig.MERGE_TYPE, true).equalsIgnoreCase("skip_merge");
        readerContext.setShouldMergeUseRecordPosition(readerParameters.useRecordPosition() && !isSkipMerge && readerContext.getHasLogFiles() && inputSplit.isParquetBaseFile());
        readerContext.setHasBootstrapBaseFile(inputSplit.getBaseFileOption().flatMap(HoodieBaseFile::getBootstrapBaseFile).isPresent());
        readerContext.setSchemaHandler(readerContext.getRecordContext().supportsParquetRowIndex() ? new ParquetRowIndexBasedSchemaHandler<T>(readerContext, dataSchema, requestedSchema, internalSchemaOpt, props, this.metaClient) : new FileGroupReaderSchemaHandler<T>(readerContext, dataSchema, requestedSchema, internalSchemaOpt, props, this.metaClient));
        this.outputConverter = readerContext.getSchemaHandler().getOutputConverter();
        this.orderingFieldNames = HoodieRecordUtils.getOrderingFieldNames(readerContext.getMergeMode(), hoodieTableMetaClient);
        this.readStats = new HoodieReadStats();
    }

    private void initRecordIterators() throws IOException {
        ClosableIterator<T> iter = this.makeBaseFileIterator();
        if (this.inputSplit.hasNoRecordsToMerge()) {
            this.baseFileIterator = new CloseableMappingIterator<Object, Object>(iter, rec -> this.readerContext.getRecordContext().seal(rec));
        } else {
            this.baseFileIterator = iter;
            Pair<HoodieFileGroupRecordBuffer<T>, List<String>> initializationResult = this.recordBufferLoader.getRecordBuffer(this.readerContext, this.storage, this.inputSplit, this.orderingFieldNames, this.metaClient, this.props, this.readerParameters, this.readStats, this.fileGroupUpdateCallback);
            this.recordBuffer = initializationResult.getLeft();
            this.validBlockInstants = initializationResult.getRight();
            this.recordBuffer.setBaseFileIterator(this.baseFileIterator);
        }
    }

    private ClosableIterator<T> makeBaseFileIterator() throws IOException {
        if (!this.inputSplit.getBaseFileOption().isPresent()) {
            return new EmptyIterator();
        }
        this.bufferedRecordConverter = BufferedRecordConverter.createConverter(this.readerContext.getIteratorMode(), this.readerContext.getSchemaHandler().getRequiredSchema(), this.readerContext.getRecordContext(), this.orderingFieldNames);
        HoodieBaseFile baseFile = (HoodieBaseFile)this.inputSplit.getBaseFileOption().get();
        if (baseFile.getBootstrapBaseFile().isPresent()) {
            return this.makeBootstrapBaseFileIterator(baseFile);
        }
        StoragePathInfo baseFileStoragePathInfo = baseFile.getPathInfo();
        ClosableIterator<T> recordIterator = baseFileStoragePathInfo != null ? this.readerContext.getFileRecordIterator(baseFileStoragePathInfo, this.inputSplit.getStart(), this.inputSplit.getLength(), this.readerContext.getSchemaHandler().getTableSchema(), this.readerContext.getSchemaHandler().getRequiredSchema(), this.storage) : this.readerContext.getFileRecordIterator(baseFile.getStoragePath(), this.inputSplit.getStart(), this.inputSplit.getLength(), this.readerContext.getSchemaHandler().getTableSchema(), this.readerContext.getSchemaHandler().getRequiredSchema(), this.storage);
        return this.readerContext.getInstantRange().isPresent() ? this.readerContext.applyInstantRangeFilter(recordIterator) : recordIterator;
    }

    private ClosableIterator<T> makeBootstrapBaseFileIterator(HoodieBaseFile baseFile) throws IOException {
        BaseFile dataFile = (BaseFile)baseFile.getBootstrapBaseFile().get();
        Pair<List<Schema.Field>, List<Schema.Field>> requiredFields = this.readerContext.getSchemaHandler().getBootstrapRequiredFields();
        Pair<List<Schema.Field>, List<Schema.Field>> allFields = this.readerContext.getSchemaHandler().getBootstrapDataFields();
        Option<Pair<ClosableIterator<T>, Schema>> dataFileIterator = this.makeBootstrapBaseFileIteratorHelper(requiredFields.getRight(), allFields.getRight(), dataFile);
        Option<Pair<ClosableIterator<T>, Schema>> skeletonFileIterator = this.makeBootstrapBaseFileIteratorHelper(requiredFields.getLeft(), allFields.getLeft(), baseFile);
        if (!dataFileIterator.isPresent() && !skeletonFileIterator.isPresent()) {
            throw new IllegalStateException("should not be here if only partition cols are required");
        }
        if (!dataFileIterator.isPresent()) {
            return (ClosableIterator)((Pair)skeletonFileIterator.get()).getLeft();
        }
        if (!skeletonFileIterator.isPresent()) {
            return (ClosableIterator)((Pair)dataFileIterator.get()).getLeft();
        }
        if (this.inputSplit.getStart() != 0L) {
            throw new IllegalArgumentException("Filegroup reader is doing bootstrap merge but we are not reading from the start of the base file");
        }
        PartitionPathParser partitionPathParser = new PartitionPathParser();
        Object[] partitionValues = partitionPathParser.getPartitionFieldVals(this.partitionPathFields, this.inputSplit.getPartitionPath(), this.readerContext.getSchemaHandler().getTableSchema());
        List partitionPathFieldsAndValues = (List)this.partitionPathFields.map(partitionFields -> {
            Schema dataSchema = (Schema)((Pair)dataFileIterator.get()).getRight();
            ArrayList<Pair<String, Comparable>> filterFieldsAndValues = new ArrayList<Pair<String, Comparable>>(((String[])partitionFields).length);
            for (int i = 0; i < ((String[])partitionFields).length; ++i) {
                String field = partitionFields[i];
                if (dataSchema.getField(field) == null) continue;
                filterFieldsAndValues.add(Pair.of(field, this.readerContext.getRecordContext().convertPartitionValueToEngineType((Comparable)partitionValues[i])));
            }
            return filterFieldsAndValues;
        }).orElseGet(Collections::emptyList);
        return this.readerContext.mergeBootstrapReaders((ClosableIterator)((Pair)skeletonFileIterator.get()).getLeft(), (Schema)((Pair)skeletonFileIterator.get()).getRight(), (ClosableIterator)((Pair)dataFileIterator.get()).getLeft(), (Schema)((Pair)dataFileIterator.get()).getRight(), partitionPathFieldsAndValues);
    }

    private Option<Pair<ClosableIterator<T>, Schema>> makeBootstrapBaseFileIteratorHelper(List<Schema.Field> requiredFields, List<Schema.Field> allFields, BaseFile file) throws IOException {
        if (requiredFields.isEmpty()) {
            return Option.empty();
        }
        Schema requiredSchema = this.readerContext.getSchemaHandler().createSchemaFromFields(requiredFields);
        StoragePathInfo fileStoragePathInfo = file.getPathInfo();
        if (fileStoragePathInfo != null) {
            return Option.of(Pair.of(this.readerContext.getFileRecordIterator(fileStoragePathInfo, 0L, file.getFileLen(), this.readerContext.getSchemaHandler().createSchemaFromFields(allFields), requiredSchema, this.storage), requiredSchema));
        }
        long fileLength = file.getFileLen() >= 0L ? file.getFileLen() : this.storage.getPathInfo(file.getStoragePath()).getLength();
        return Option.of(Pair.of(this.readerContext.getFileRecordIterator(file.getStoragePath(), 0L, fileLength, this.readerContext.getSchemaHandler().createSchemaFromFields(allFields), requiredSchema, this.storage), requiredSchema));
    }

    boolean hasNext() throws IOException {
        if (this.recordBuffer == null) {
            return this.baseFileIterator.hasNext();
        }
        return this.recordBuffer.hasNext();
    }

    public HoodieReadStats getStats() {
        return this.readStats;
    }

    BufferedRecord<T> next() {
        BufferedRecord<T> nextVal;
        BufferedRecord<T> bufferedRecord = nextVal = this.recordBuffer == null ? this.bufferedRecordConverter.convert(this.baseFileIterator.next()) : this.recordBuffer.next();
        if (this.outputConverter.isPresent()) {
            return nextVal.project((UnaryOperator)this.outputConverter.get());
        }
        return nextVal;
    }

    public List<String> getValidBlockInstants() {
        return this.validBlockInstants;
    }

    public void onWriteFailure(String recordKey) {
        this.fileGroupUpdateCallback.ifPresent(callback -> callback.onFailure(recordKey));
    }

    @Override
    public void close() throws IOException {
        if (this.baseFileIterator != null) {
            this.baseFileIterator.close();
        }
        if (this.recordBuffer != null) {
            this.recordBuffer.close();
        }
    }

    private ClosableIterator<BufferedRecord<T>> getBufferedRecordIterator(IteratorMode iteratorMode) throws IOException {
        this.readerContext.setIteratorMode(iteratorMode);
        this.initRecordIterators();
        return new HoodieFileGroupReaderIterator(this);
    }

    public ClosableIterator<BufferedRecord<T>> getClosableBufferedRecordIterator() throws IOException {
        return this.getBufferedRecordIterator(IteratorMode.HOODIE_RECORD);
    }

    public ClosableIterator<T> getClosableIterator() throws IOException {
        return new CloseableMappingIterator<BufferedRecord, Object>(this.getBufferedRecordIterator(IteratorMode.ENGINE_RECORD), BufferedRecord::getRecord);
    }

    public ClosableIterator<HoodieRecord<T>> getClosableHoodieRecordIterator() throws IOException {
        return new CloseableMappingIterator<BufferedRecord, HoodieRecord>(this.getBufferedRecordIterator(IteratorMode.HOODIE_RECORD), bufferedRecord -> this.readerContext.getRecordContext().constructFinalHoodieRecord((BufferedRecord<T>)bufferedRecord));
    }

    public ClosableIterator<String> getClosableKeyIterator() throws IOException {
        return new CloseableMappingIterator<BufferedRecord, String>(this.getBufferedRecordIterator(IteratorMode.RECORD_KEY), BufferedRecord::getRecordKey);
    }

    public ClosableIterator<BufferedRecord<T>> getLogRecordsOnly() throws IOException {
        this.initRecordIterators();
        return this.recordBuffer.getLogRecordIterator();
    }

    public static <T> Builder<T> newBuilder() {
        return new Builder();
    }

    public static class Builder<T> {
        private HoodieReaderContext<T> readerContext;
        private HoodieStorage storage;
        private String tablePath;
        private String latestCommitTime;
        private Schema dataSchema;
        private Schema requestedSchema;
        private Option<InternalSchema> internalSchemaOpt = Option.empty();
        private HoodieTableMetaClient hoodieTableMetaClient;
        private TypedProperties props;
        private Option<HoodieBaseFile> baseFileOption;
        private Stream<HoodieLogFile> logFiles;
        private String partitionPath;
        private long start = 0L;
        private long length = Long.MAX_VALUE;
        private Iterator<HoodieRecord> recordIterator;
        private boolean shouldUseRecordPosition = false;
        private boolean allowInflightInstants = false;
        private boolean emitDelete;
        private boolean sortOutput = false;
        private Boolean enableOptimizedLogBlockScan = false;
        private Option<BaseFileUpdateCallback<T>> fileGroupUpdateCallback = Option.empty();
        private FileGroupRecordBufferLoader<T> recordBufferLoader;

        public Builder<T> withReaderContext(HoodieReaderContext<T> readerContext) {
            this.readerContext = readerContext;
            return this;
        }

        public Builder<T> withLatestCommitTime(String latestCommitTime) {
            this.latestCommitTime = latestCommitTime;
            return this;
        }

        public Builder<T> withFileSlice(FileSlice fileSlice) {
            this.baseFileOption = fileSlice.getBaseFile();
            this.logFiles = fileSlice.getLogFiles();
            this.partitionPath = fileSlice.getPartitionPath();
            return this;
        }

        public Builder<T> withBaseFileOption(Option<HoodieBaseFile> baseFileOption) {
            this.baseFileOption = baseFileOption;
            return this;
        }

        public Builder<T> withLogFiles(Stream<HoodieLogFile> logFiles) {
            this.logFiles = logFiles;
            return this;
        }

        public Builder<T> withRecordIterator(Iterator<? extends HoodieRecord> recordIterator) {
            this.recordIterator = recordIterator;
            this.recordBufferLoader = FileGroupRecordBufferLoader.createStreamingRecordsBufferLoader();
            return this;
        }

        public Builder<T> withPartitionPath(String partitionPath) {
            this.partitionPath = partitionPath;
            return this;
        }

        public Builder<T> withDataSchema(Schema dataSchema) {
            this.dataSchema = dataSchema;
            return this;
        }

        public Builder<T> withRequestedSchema(Schema requestedSchema) {
            this.requestedSchema = requestedSchema;
            return this;
        }

        public Builder<T> withInternalSchema(Option<InternalSchema> internalSchemaOpt) {
            this.internalSchemaOpt = internalSchemaOpt;
            return this;
        }

        public Builder<T> withHoodieTableMetaClient(HoodieTableMetaClient hoodieTableMetaClient) {
            this.hoodieTableMetaClient = hoodieTableMetaClient;
            this.tablePath = hoodieTableMetaClient.getBasePath().toString();
            return this;
        }

        public Builder<T> withProps(TypedProperties props) {
            this.props = props;
            return this;
        }

        public Builder<T> withStart(long start) {
            this.start = start;
            return this;
        }

        public Builder<T> withLength(long length) {
            this.length = length;
            return this;
        }

        public Builder<T> withShouldUseRecordPosition(boolean shouldUseRecordPosition) {
            this.shouldUseRecordPosition = shouldUseRecordPosition;
            return this;
        }

        public Builder<T> withAllowInflightInstants(boolean allowInflightInstants) {
            this.allowInflightInstants = allowInflightInstants;
            return this;
        }

        public Builder<T> withEmitDelete(boolean emitDelete) {
            this.emitDelete = emitDelete;
            return this;
        }

        public Builder<T> withFileGroupUpdateCallback(Option<BaseFileUpdateCallback<T>> fileGroupUpdateCallback) {
            this.fileGroupUpdateCallback = fileGroupUpdateCallback;
            return this;
        }

        public Builder<T> withEnableOptimizedLogBlockScan(boolean enableOptimizedLogBlockScan) {
            this.enableOptimizedLogBlockScan = enableOptimizedLogBlockScan;
            return this;
        }

        public Builder<T> withSortOutput(boolean sortOutput) {
            this.sortOutput = sortOutput;
            return this;
        }

        public Builder<T> withRecordBufferLoader(FileGroupRecordBufferLoader<T> recordBufferLoader) {
            this.recordBufferLoader = recordBufferLoader;
            return this;
        }

        public HoodieFileGroupReader<T> build() {
            ValidationUtils.checkArgument((this.readerContext != null ? 1 : 0) != 0, (String)"Reader context is required");
            ValidationUtils.checkArgument((this.hoodieTableMetaClient != null ? 1 : 0) != 0, (String)"Hoodie table meta client is required");
            ValidationUtils.checkArgument((this.tablePath != null ? 1 : 0) != 0, (String)"Table path is required");
            this.storage = this.hoodieTableMetaClient.getStorage().newInstance(new StoragePath(this.tablePath), this.readerContext.getStorageConfiguration());
            ValidationUtils.checkArgument((this.storage != null ? 1 : 0) != 0, (String)"Storage is required");
            ValidationUtils.checkArgument((this.latestCommitTime != null ? 1 : 0) != 0, (String)"Latest commit time is required");
            ValidationUtils.checkArgument((this.dataSchema != null ? 1 : 0) != 0, (String)"Data schema is required");
            ValidationUtils.checkArgument((this.requestedSchema != null ? 1 : 0) != 0, (String)"Requested schema is required");
            ValidationUtils.checkArgument((this.props != null ? 1 : 0) != 0, (String)"Props is required");
            ValidationUtils.checkArgument((this.baseFileOption != null ? 1 : 0) != 0, (String)"Base file option is required");
            ValidationUtils.checkArgument((this.partitionPath != null ? 1 : 0) != 0, (String)"Partition path is required");
            if (this.enableOptimizedLogBlockScan == null) {
                this.enableOptimizedLogBlockScan = Boolean.valueOf(ConfigUtils.getRawValueWithAltKeys(this.props, HoodieReaderConfig.ENABLE_OPTIMIZED_LOG_BLOCKS_SCAN, true));
            }
            if (this.recordBufferLoader == null) {
                this.recordBufferLoader = FileGroupRecordBufferLoader.createDefault();
            }
            ReaderParameters readerParameters = ReaderParameters.builder().shouldUseRecordPosition(this.shouldUseRecordPosition).emitDeletes(this.emitDelete).sortOutputs(this.sortOutput).allowInflightInstants(this.allowInflightInstants).enableOptimizedLogBlockScan(this.enableOptimizedLogBlockScan).build();
            InputSplit inputSplit = new InputSplit(this.baseFileOption, this.recordIterator != null ? Either.right(this.recordIterator) : Either.left(this.logFiles == null ? Stream.empty() : this.logFiles), this.partitionPath, this.start, this.length);
            return new HoodieFileGroupReader(this.readerContext, this.storage, this.tablePath, this.latestCommitTime, this.dataSchema, this.requestedSchema, this.internalSchemaOpt, this.hoodieTableMetaClient, this.props, readerParameters, inputSplit, this.fileGroupUpdateCallback, this.recordBufferLoader);
        }
    }

    public static class HoodieFileGroupReaderIterator<T>
    implements ClosableIterator<BufferedRecord<T>> {
        private HoodieFileGroupReader<T> reader;

        public HoodieFileGroupReaderIterator(HoodieFileGroupReader<T> reader) {
            this.reader = reader;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.reader.hasNext();
            }
            catch (IOException e) {
                throw new HoodieIOException("Failed to read record", e);
            }
        }

        @Override
        public BufferedRecord<T> next() {
            return this.reader.next();
        }

        @Override
        public void close() {
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (IOException e) {
                    throw new HoodieIOException("Failed to close the reader", e);
                }
                finally {
                    this.reader = null;
                }
            }
        }
    }
}

