/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Either;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;

public class InputSplit {
    private final Option<HoodieBaseFile> baseFileOption;
    private final List<HoodieLogFile> logFiles;
    private final Option<Iterator<HoodieRecord>> recordIterator;
    private final String partitionPath;
    private final long start;
    private final long length;

    InputSplit(Option<HoodieBaseFile> baseFileOption, Either<Stream<HoodieLogFile>, Iterator<HoodieRecord>> recordsToMerge, String partitionPath, long start, long length) {
        this.baseFileOption = baseFileOption;
        if (recordsToMerge.isLeft()) {
            this.logFiles = recordsToMerge.asLeft().sorted(HoodieLogFile.getLogFileComparator()).filter(logFile -> !logFile.getFileName().endsWith(".cdc")).collect(Collectors.toList());
            this.recordIterator = Option.empty();
        } else {
            this.logFiles = Collections.emptyList();
            this.recordIterator = Option.of(recordsToMerge.asRight());
        }
        this.partitionPath = partitionPath;
        this.start = start;
        this.length = length;
    }

    public Option<HoodieBaseFile> getBaseFileOption() {
        return this.baseFileOption;
    }

    public List<HoodieLogFile> getLogFiles() {
        ValidationUtils.checkArgument((boolean)this.recordIterator.isEmpty(), (String)"Log files are not initialized");
        return this.logFiles;
    }

    public boolean hasLogFiles() {
        return !this.logFiles.isEmpty();
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public long getStart() {
        return this.start;
    }

    public long getLength() {
        return this.length;
    }

    public boolean isParquetBaseFile() {
        return (Boolean)this.baseFileOption.map(baseFile -> HoodieFileFormat.fromFileExtension(baseFile.getStoragePath().getFileExtension()) == HoodieFileFormat.PARQUET).orElse((Object)false);
    }

    public boolean hasNoRecordsToMerge() {
        return this.logFiles.isEmpty() && this.recordIterator.isEmpty();
    }

    public Iterator<HoodieRecord> getRecordIterator() {
        return (Iterator)this.recordIterator.orElseThrow(() -> new IllegalStateException("The record iterator has not been setup"));
    }
}

