/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.util.Collections;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.read.DeleteContext;
import org.apache.hudi.common.table.read.FileGroupReaderSchemaHandler;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.Types;
import org.apache.hudi.internal.schema.action.TableChanges;
import org.apache.hudi.internal.schema.utils.SchemaChangeUtils;

public class ParquetRowIndexBasedSchemaHandler<T>
extends FileGroupReaderSchemaHandler<T> {
    public ParquetRowIndexBasedSchemaHandler(HoodieReaderContext<T> readerContext, Schema dataSchema, Schema requestedSchema, Option<InternalSchema> internalSchemaOpt, TypedProperties properties, HoodieTableMetaClient metaClient) {
        super(readerContext, dataSchema, requestedSchema, internalSchemaOpt, properties, metaClient);
        if (!readerContext.getRecordContext().supportsParquetRowIndex()) {
            throw new IllegalStateException("Using " + this.getClass().getName() + " but context does not support parquet row index");
        }
    }

    @Override
    protected Schema prepareRequiredSchema(DeleteContext deleteContext) {
        Schema preMergeSchema = super.prepareRequiredSchema(deleteContext);
        return this.readerContext.getShouldMergeUseRecordPosition() ? ParquetRowIndexBasedSchemaHandler.addPositionalMergeCol(preMergeSchema) : preMergeSchema;
    }

    @Override
    protected Option<InternalSchema> getInternalSchemaOpt(Option<InternalSchema> internalSchemaOpt) {
        return internalSchemaOpt.map(ParquetRowIndexBasedSchemaHandler::addPositionalMergeCol);
    }

    @Override
    protected InternalSchema doPruneInternalSchema(Schema requiredSchema, InternalSchema internalSchema) {
        if (!this.readerContext.getShouldMergeUseRecordPosition()) {
            return super.doPruneInternalSchema(requiredSchema, internalSchema);
        }
        InternalSchema withRowIndex = ParquetRowIndexBasedSchemaHandler.addPositionalMergeCol(internalSchema);
        return super.doPruneInternalSchema(requiredSchema, withRowIndex);
    }

    private static InternalSchema addPositionalMergeCol(InternalSchema internalSchema) {
        TableChanges.ColumnAddChange addChange = TableChanges.ColumnAddChange.get(internalSchema);
        addChange.addColumns("", "_tmp_metadata_row_index", Types.LongType.get(), null);
        return SchemaChangeUtils.applyTableChanges2Schema(internalSchema, addChange);
    }

    @Override
    public Pair<List<Schema.Field>, List<Schema.Field>> getBootstrapRequiredFields() {
        Pair<List<Schema.Field>, List<Schema.Field>> dataAndMetaCols = super.getBootstrapRequiredFields();
        if (this.readerContext.getNeedsBootstrapMerge() || this.readerContext.getShouldMergeUseRecordPosition()) {
            if (!dataAndMetaCols.getLeft().isEmpty()) {
                dataAndMetaCols.getLeft().add(ParquetRowIndexBasedSchemaHandler.getPositionalMergeField());
            }
            if (!dataAndMetaCols.getRight().isEmpty()) {
                dataAndMetaCols.getRight().add(ParquetRowIndexBasedSchemaHandler.getPositionalMergeField());
            }
        }
        return dataAndMetaCols;
    }

    @VisibleForTesting
    static Schema addPositionalMergeCol(Schema input) {
        return AvroSchemaUtils.appendFieldsToSchemaDedupNested(input, Collections.singletonList(ParquetRowIndexBasedSchemaHandler.getPositionalMergeField()));
    }

    @VisibleForTesting
    static Schema.Field getPositionalMergeField() {
        return new Schema.Field("_tmp_metadata_row_index", Schema.create((Schema.Type)Schema.Type.LONG), "", (Object)-1L);
    }
}

